/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.tokenauth;

import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.automation.client.RemoteException;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.jaxrs.impl.HttpAutomationClient;
import org.nuxeo.ecm.automation.test.EmbeddedAutomationServerFeature;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.test.annotations.Granularity;
import org.nuxeo.ecm.core.test.annotations.RepositoryConfig;
import org.nuxeo.ecm.tokenauth.TokenAuthenticationCallback;
import org.nuxeo.ecm.tokenauth.TokenAuthenticationRepositoryInit;
import org.nuxeo.ecm.tokenauth.TokenAuthenticationServiceFeature;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.Jetty;
import org.nuxeo.runtime.test.runner.RuntimeHarness;

@RunWith(value=FeaturesRunner.class)
@Features(value={TokenAuthenticationServiceFeature.class, EmbeddedAutomationServerFeature.class})
@Deploy(value={"org.nuxeo.ecm.platform.login.token.test:OSGI-INF/test-token-authentication-anonymous-contrib.xml"})
@Jetty(port=18080)
@RepositoryConfig(init=TokenAuthenticationRepositoryInit.class, cleanup=Granularity.METHOD)
public class TestAnonymousTokenAuthenticator {
    @Inject
    protected RuntimeHarness harness;
    @Inject
    protected CoreSession session;
    @Inject
    protected HttpAutomationClient automationClient;

    @Test
    public void testAuthenticatorAsAnonymous() throws Exception {
        TokenAuthenticationCallback cb = new TokenAuthenticationCallback("Guest", "myFavoriteApp", "Ubuntu box 64 bits", "This is my personal Linux box", "rw");
        String token = cb.getRemoteToken(cb.getTokenParams());
        Assert.assertNotNull((Object)token);
        try {
            this.automationClient.getSession(token);
            Assert.fail((String)"Getting an Automation client session with a token as anonymous user should throw a RemoteException with HTTP 401 status code");
        }
        catch (RemoteException e) {
            Assert.assertEquals((long)401L, (long)e.getStatus());
        }
        this.harness.deployContrib("org.nuxeo.ecm.platform.login.token.test", "OSGI-INF/test-token-authentication-allow-anonymous-token-contrib.xml");
        Session clientSession = this.automationClient.getSession(token);
        Assert.assertEquals((Object)"Guest", (Object)clientSession.getLogin().getUsername());
        this.harness.undeployContrib("org.nuxeo.ecm.platform.login.token.test", "OSGI-INF/test-token-authentication-allow-anonymous-token-contrib.xml");
    }

    protected void setPermission(DocumentModel doc, ACE ace) {
        ACP acp = this.session.getACP(doc.getRef());
        ACL localACL = acp.getOrCreateACL("local");
        localACL.add(ace);
        this.session.setACP(doc.getRef(), acp, true);
        this.session.save();
    }
}

