/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.tokenauth;

import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.test.CoreFeature;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.tokenauth.TokenAuthenticationException;
import org.nuxeo.ecm.tokenauth.TokenAuthenticationServiceFeature;
import org.nuxeo.ecm.tokenauth.io.AuthenticationToken;
import org.nuxeo.ecm.tokenauth.service.TokenAuthenticationService;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;

@RunWith(value=FeaturesRunner.class)
@Features(value={TokenAuthenticationServiceFeature.class})
public class TestTokenAuthenticationService {
    private static final Log log = LogFactory.getLog(TestTokenAuthenticationService.class);
    @Inject
    protected TokenAuthenticationService tokenAuthenticationService;
    @Inject
    protected DirectoryService directoryService;
    @Inject
    protected CoreFeature coreFeature;

    @After
    public void cleanDirectories() throws Exception {
        try (Session tokenDirSession = this.directoryService.open("authTokens");){
            DocumentModelList entries = tokenDirSession.getEntries();
            for (DocumentModel entry : entries) {
                tokenDirSession.deleteEntry(entry);
            }
        }
    }

    @Test
    public void testAcquireToken() {
        try {
            this.tokenAuthenticationService.acquireToken("joe", "myFavoriteApp", null, null, null);
            Assert.fail((String)"Getting token should have failed since required parameters are missing.");
        }
        catch (TokenAuthenticationException e) {
            Assert.assertEquals((Object)"The following parameters are mandatory to get an authentication token: userName, applicationName, deviceId.", (Object)e.getMessage());
        }
        String token = this.tokenAuthenticationService.acquireToken("joe", "myFavoriteApp", "Ubuntu box 64 bits", "This is my personal box", "rw");
        Assert.assertNotNull((Object)token);
        try (Session directorySession = this.directoryService.open("authTokens");){
            DocumentModel tokenModel = directorySession.getEntry(token);
            Assert.assertNotNull((Object)tokenModel);
            Assert.assertEquals((Object)token, (Object)tokenModel.getPropertyValue("authtoken:token"));
            Assert.assertEquals((Object)"joe", (Object)tokenModel.getPropertyValue("authtoken:userName"));
            Assert.assertEquals((Object)"myFavoriteApp", (Object)tokenModel.getPropertyValue("authtoken:applicationName"));
            Assert.assertEquals((Object)"Ubuntu box 64 bits", (Object)tokenModel.getPropertyValue("authtoken:deviceId"));
            Assert.assertEquals((Object)"This is my personal box", (Object)tokenModel.getPropertyValue("authtoken:deviceDescription"));
            Assert.assertEquals((Object)"rw", (Object)tokenModel.getPropertyValue("authtoken:permission"));
            Assert.assertNotNull((Object)tokenModel.getPropertyValue("authtoken:creationDate"));
        }
        String sameToken = this.tokenAuthenticationService.acquireToken("joe", "myFavoriteApp", "Ubuntu box 64 bits", "This is my personal box", "rw");
        Assert.assertEquals((Object)token, (Object)sameToken);
        String otherToken = this.tokenAuthenticationService.acquireToken("jack", "myFavoriteApp", "Ubuntu box 64 bits", "This is my personal box", "rw");
        Assert.assertTrue((!otherToken.equals(token) ? 1 : 0) != 0);
    }

    @Test
    public void testGetToken() throws TokenAuthenticationException {
        Assert.assertNull((Object)this.tokenAuthenticationService.getToken("john", "myFavoriteApp", "Ubuntu box 64 bits"));
        this.tokenAuthenticationService.acquireToken("joe", "myFavoriteApp", "Ubuntu box 64 bits", "This is my personal box", "rw");
        Assert.assertNotNull((Object)this.tokenAuthenticationService.getToken("joe", "myFavoriteApp", "Ubuntu box 64 bits"));
    }

    @Test
    public void testGetUserName() throws TokenAuthenticationException {
        String token = "invalidToken";
        String userName = this.tokenAuthenticationService.getUserName(token);
        Assert.assertNull((Object)userName);
        token = this.tokenAuthenticationService.acquireToken("joe", "myFavoriteApp", "Ubuntu box 64 bits", "This is my personal box", "rw");
        userName = this.tokenAuthenticationService.getUserName(token);
        Assert.assertEquals((Object)"joe", (Object)userName);
    }

    @Test
    public void testRevokeToken() throws TokenAuthenticationException {
        this.tokenAuthenticationService.revokeToken("unexistingToken");
        String token = this.tokenAuthenticationService.acquireToken("joe", "myFavoriteApp", "Ubuntu box 64 bits", "This is my personal box", "rw");
        Assert.assertEquals((Object)"joe", (Object)this.tokenAuthenticationService.getUserName(token));
        this.tokenAuthenticationService.revokeToken(token);
        Assert.assertNull((Object)this.tokenAuthenticationService.getUserName(token));
    }

    @Test
    public void testGetTokenBindings() {
        Assert.assertEquals((long)0L, (long)this.tokenAuthenticationService.getTokenBindings("john").size());
        String token1 = this.tokenAuthenticationService.acquireToken("joe", "myFavoriteApp", "Ubuntu box 64 bits", "This is my personal Linux box", "rw");
        log.debug((Object)("token1 = " + token1));
        String token2 = this.tokenAuthenticationService.acquireToken("joe", "myFavoriteApp", "Windows box 32 bits", "This is my personal Windows box", "rw");
        log.debug((Object)("token2 = " + token2));
        String token3 = this.tokenAuthenticationService.acquireToken("joe", "nuxeoDrive", "Mac OSX VM", "This is my personal Mac box", "rw");
        log.debug((Object)("token3 = " + token3));
        DocumentModelList tokenBindings = this.tokenAuthenticationService.getTokenBindings("joe");
        Assert.assertEquals((long)3L, (long)tokenBindings.size());
        HashSet<AuthenticationToken> expectedTokenBindings = new HashSet<AuthenticationToken>();
        expectedTokenBindings.add(new AuthenticationToken(token1, "joe", "myFavoriteApp", "Ubuntu box 64 bits", "This is my personal Linux box", "rw"));
        expectedTokenBindings.add(new AuthenticationToken(token2, "joe", "myFavoriteApp", "Windows box 32 bits", "This is my personal Windows box", "rw"));
        expectedTokenBindings.add(new AuthenticationToken(token3, "joe", "nuxeoDrive", "Mac OSX VM", "This is my personal Mac box", "rw"));
        Assert.assertTrue((boolean)CollectionUtils.isEqualCollection(expectedTokenBindings, this.asAuthenticationTokens(tokenBindings)));
        for (DocumentModel tokenBinding : tokenBindings) {
            Assert.assertNotNull((Object)tokenBinding.getPropertyValue("authtoken:creationDate"));
        }
    }

    private List<AuthenticationToken> asAuthenticationTokens(DocumentModelList entries) {
        return entries.stream().map(this::asAuthenticationToken).collect(Collectors.toList());
    }

    private AuthenticationToken asAuthenticationToken(DocumentModel entry) {
        Map props = entry.getProperties("authtoken");
        AuthenticationToken token = new AuthenticationToken((String)props.get("token"), (String)props.get("userName"), (String)props.get("applicationName"), (String)props.get("deviceId"), (String)props.get("deviceDescription"), (String)props.get("permission"));
        token.setCreationDate((Calendar)props.get("creationDate"));
        return token;
    }
}

