/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.tokenauth;

import java.io.IOException;
import java.net.URI;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.util.URIUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.tokenauth.TokenAuthenticationJettyFeature;
import org.nuxeo.ecm.tokenauth.service.TokenAuthenticationService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.transaction.TransactionHelper;

@RunWith(value=FeaturesRunner.class)
@Features(value={TokenAuthenticationJettyFeature.class})
public class TestTokenAuthenticationServlet {
    protected void nextTransaction() {
        TransactionHelper.commitOrRollbackTransaction();
        TransactionHelper.startTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testServlet() throws Exception {
        HttpClient httpClient = new HttpClient();
        GetMethod getMethod = null;
        try {
            getMethod = new GetMethod("http://localhost:18080/authentication/token?applicationName=myFavoriteApp&deviceId=dead-beaf-cafe-babe&permission=rw");
            int status = this.executeGetMethod(httpClient, (HttpMethod)getMethod, "Administrator", "badPassword");
            Assert.assertEquals((long)404L, (long)status);
            getMethod = new GetMethod("http://localhost:18080/authentication/token?applicationName=myFavoriteApp");
            status = this.executeGetMethod(httpClient, (HttpMethod)getMethod, "Administrator", "Administrator");
            Assert.assertEquals((long)400L, (long)status);
            getMethod = new GetMethod("http://localhost:18080/authentication/token?applicationName=myFavoriteApp&revoke=true");
            status = this.executeGetMethod(httpClient, (HttpMethod)getMethod, "Administrator", "Administrator");
            Assert.assertEquals((long)400L, (long)status);
            String queryParams = URIUtil.encodeQuery((String)"applicationName=Nuxeo Drive&deviceId=dead-beaf-cafe-babe&permission=rw");
            URI uri = new URI("http", null, "localhost", 18080, "/authentication/token", queryParams, null);
            getMethod = new GetMethod(uri.toString());
            status = this.executeGetMethod(httpClient, (HttpMethod)getMethod, "Administrator", "Administrator");
            Assert.assertEquals((long)201L, (long)status);
            String token = getMethod.getResponseBodyAsString();
            Assert.assertNotNull((Object)token);
            Assert.assertNotNull((Object)this.getTokenAuthenticationService().getUserName(token));
            Assert.assertEquals((long)1L, (long)this.getTokenAuthenticationService().getTokenBindings("Administrator").size());
            status = httpClient.executeMethod((HttpMethod)getMethod);
            Assert.assertEquals((long)201L, (long)status);
            String existingToken = getMethod.getResponseBodyAsString();
            Assert.assertEquals((Object)token, (Object)existingToken);
            getMethod = new GetMethod("http://localhost:18080/authentication/token?applicationName=nonExistingApp&deviceId=dead-beaf-cafe-babe&revoke=true");
            status = this.executeGetMethod(httpClient, (HttpMethod)getMethod, "Administrator", "Administrator");
            Assert.assertEquals((long)400L, (long)status);
            String response = getMethod.getResponseBodyAsString();
            Assert.assertEquals((Object)String.format("No token found for userName %s, applicationName %s and deviceId %s; nothing to do.", "Administrator", "nonExistingApp", "dead-beaf-cafe-babe"), (Object)response);
            queryParams = URIUtil.encodeQuery((String)"applicationName=Nuxeo Drive&deviceId=dead-beaf-cafe-babe&revoke=true");
            uri = new URI("http", null, "localhost", 18080, "/authentication/token", queryParams, null);
            getMethod = new GetMethod(uri.toString());
            status = this.executeGetMethod(httpClient, (HttpMethod)getMethod, "Administrator", "Administrator");
            Assert.assertEquals((long)202L, (long)status);
            response = getMethod.getResponseBodyAsString();
            Assert.assertEquals((Object)String.format("Token revoked for userName %s, applicationName %s and deviceId %s.", "Administrator", "Nuxeo Drive", "dead-beaf-cafe-babe"), (Object)response);
            this.nextTransaction();
            Assert.assertNull((Object)this.getTokenAuthenticationService().getUserName(token));
            Assert.assertTrue((boolean)this.getTokenAuthenticationService().getTokenBindings("Administrator").isEmpty());
        }
        finally {
            getMethod.releaseConnection();
        }
    }

    protected final int executeGetMethod(HttpClient httpClient, HttpMethod httpMethod, String userName, String password) throws HttpException, IOException {
        String authString = userName + ":" + password;
        String basicAuthHeader = "Basic " + new String(Base64.encodeBase64((byte[])authString.getBytes()));
        httpMethod.setRequestHeader("Authorization", basicAuthHeader);
        return httpClient.executeMethod(httpMethod);
    }

    protected TokenAuthenticationService getTokenAuthenticationService() {
        return (TokenAuthenticationService)Framework.getLocalService(TokenAuthenticationService.class);
    }
}

