/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.tokenauth;

import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.automation.client.RemoteException;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.TokenCallback;
import org.nuxeo.ecm.automation.client.jaxrs.impl.HttpAutomationClient;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.test.EmbeddedAutomationServerFeature;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.test.annotations.Granularity;
import org.nuxeo.ecm.core.test.annotations.RepositoryConfig;
import org.nuxeo.ecm.tokenauth.TokenAuthenticationCallback;
import org.nuxeo.ecm.tokenauth.TokenAuthenticationRepositoryInit;
import org.nuxeo.ecm.tokenauth.TokenAuthenticationServiceFeature;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.Jetty;

@RunWith(value=FeaturesRunner.class)
@Features(value={TokenAuthenticationServiceFeature.class, EmbeddedAutomationServerFeature.class})
@Jetty(port=18080)
@RepositoryConfig(init=TokenAuthenticationRepositoryInit.class, cleanup=Granularity.METHOD)
public class TestTokenAuthenticator {
    @Inject
    protected CoreSession session;
    @Inject
    protected HttpAutomationClient automationClient;

    @Test
    public void testAuthenticator() throws Exception {
        try {
            this.automationClient.getSession("badToken");
            Assert.fail((String)"Getting an Automation client session with a bad token should throw a RemoteException with HTTP 401 status code");
        }
        catch (RemoteException e) {
            Assert.assertEquals((long)401L, (long)e.getStatus());
        }
        TokenAuthenticationCallback cb = new TokenAuthenticationCallback("Administrator", "myFavoriteApp", "Ubuntu box 64 bits", "This is my personal Linux box", "rw");
        Assert.assertNull((Object)cb.getLocalToken());
        Session clientSession = this.automationClient.getSession((TokenCallback)cb);
        Assert.assertNotNull((Object)cb.getLocalToken());
        Assert.assertEquals((Object)"Administrator", (Object)clientSession.getLogin().getUsername());
        String testDocId = this.session.getDocument((DocumentRef)new PathRef(TokenAuthenticationRepositoryInit.getTestDocPath())).getId();
        Document testDoc = (Document)clientSession.newRequest("Repository.GetDocument").setHeader("X-NXDocumentProperties", "dublincore").set("value", (Object)testDocId).execute();
        Assert.assertNotNull((Object)testDoc);
        Assert.assertEquals((Object)"My test doc", (Object)testDoc.getTitle());
        Assert.assertEquals((Object)"For test purpose.", (Object)testDoc.getString("dc:description"));
        clientSession = this.automationClient.getSession((TokenCallback)cb);
        Assert.assertEquals((Object)"Administrator", (Object)clientSession.getLogin().getUsername());
    }
}

