/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.tokenauth;

import java.util.HashMap;
import java.util.Map;
import org.nuxeo.ecm.automation.client.TokenCallback;
import org.nuxeo.ecm.tokenauth.TokenAuthenticationException;
import org.nuxeo.ecm.tokenauth.service.TokenAuthenticationService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class TokenAuthenticationCallback
implements TokenCallback {
    protected static final String USERNAME_KEY = "userName";
    protected static final String APPLICATION_NAME_KEY = "applicationName";
    protected static final String DEVICE_ID_KEY = "deviceId";
    protected static final String DEVICE_DESCRIPTION_KEY = "deviceDescription";
    protected static final String PERMISSION_KEY = "permission";
    protected String token;
    protected String userName;
    protected String applicationName;
    protected String deviceId;
    protected String deviceDescription;
    protected String permission;

    public TokenAuthenticationCallback(String userName, String applicationName, String deviceId, String deviceDescription, String permission) {
        this.userName = userName;
        this.applicationName = applicationName;
        this.deviceId = deviceId;
        this.deviceDescription = deviceDescription;
        this.permission = permission;
    }

    public String getLocalToken() {
        return this.token;
    }

    public String getRemoteToken(Map<String, String> tokenParams) {
        String userName = tokenParams.get(USERNAME_KEY);
        String applicationName = tokenParams.get(APPLICATION_NAME_KEY);
        String deviceId = tokenParams.get(DEVICE_ID_KEY);
        String deviceDescription = tokenParams.get(DEVICE_DESCRIPTION_KEY);
        String permission = tokenParams.get(PERMISSION_KEY);
        try {
            TokenAuthenticationService tokenAuthenticationService = (TokenAuthenticationService)Framework.getLocalService(TokenAuthenticationService.class);
            String remoteToken = tokenAuthenticationService.acquireToken(userName, applicationName, deviceId, deviceDescription, permission);
            if (TransactionHelper.isTransactionActiveOrMarkedRollback()) {
                TransactionHelper.commitOrRollbackTransaction();
                TransactionHelper.startTransaction();
            }
            return remoteToken;
        }
        catch (TokenAuthenticationException e) {
            e.addInfo("Error while trying to get remote token");
            throw e;
        }
    }

    public Map<String, String> getTokenParams() {
        HashMap<String, String> tokenParams = new HashMap<String, String>();
        tokenParams.put(USERNAME_KEY, this.userName);
        tokenParams.put(APPLICATION_NAME_KEY, this.applicationName);
        tokenParams.put(DEVICE_ID_KEY, this.deviceId);
        tokenParams.put(DEVICE_DESCRIPTION_KEY, this.deviceDescription);
        tokenParams.put(PERMISSION_KEY, this.permission);
        return tokenParams;
    }

    public void saveToken(String token) {
        this.token = token;
    }
}

