/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.tokenauth;

import java.io.File;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.nuxeo.ecm.core.test.JettyTransactionalFeature;
import org.nuxeo.ecm.tokenauth.TokenAuthenticationJettyConfig;
import org.nuxeo.ecm.tokenauth.TokenAuthenticationServiceFeature;
import org.nuxeo.runtime.test.WorkingDirectoryConfigurator;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.Jetty;
import org.nuxeo.runtime.test.runner.RuntimeFeature;
import org.nuxeo.runtime.test.runner.RuntimeHarness;
import org.nuxeo.runtime.test.runner.SimpleFeature;

@Features(value={TokenAuthenticationServiceFeature.class, JettyTransactionalFeature.class})
@Jetty(port=18080)
@TokenAuthenticationJettyConfig(webappDescriptorPath="web.xml")
@Deploy(value={"org.nuxeo.ecm.platform.login", "org.nuxeo.ecm.platform.web.common:OSGI-INF/authentication-framework.xml", "org.nuxeo.ecm.platform.login.token.test:OSGI-INF/test-token-authentication-runtime-server-contrib.xml"})
public class TokenAuthenticationJettyFeature
extends SimpleFeature
implements WorkingDirectoryConfigurator {
    protected URL webappDescriptorPath;

    public void initialize(FeaturesRunner runner) throws Exception {
        TokenAuthenticationJettyConfig tokenAuthenticationConfig = (TokenAuthenticationJettyConfig)runner.getConfig(TokenAuthenticationJettyConfig.class);
        this.webappDescriptorPath = runner.getTargetTestClass().getClassLoader().getResource(tokenAuthenticationConfig.webappDescriptorPath());
        ((RuntimeFeature)runner.getFeature(RuntimeFeature.class)).getHarness().addWorkingDirectoryConfigurator((WorkingDirectoryConfigurator)this);
    }

    public void configure(RuntimeHarness harness, File workingDir) throws Exception {
        File webappDir = new File(workingDir, "web/root.war/WEB-INF");
        webappDir.mkdirs();
        FileUtils.copyURLToFile((URL)this.webappDescriptorPath, (File)new File(webappDir, "web.xml"));
    }
}

