/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.service;

import java.security.Principal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.nuxeo.drive.service.FileSystemChangeSummary;
import org.nuxeo.drive.service.FileSystemItemChange;
import org.nuxeo.drive.service.NuxeoDriveManager;
import org.nuxeo.drive.service.impl.RootDefinitionsHelper;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.event.EventServiceAdmin;
import org.nuxeo.ecm.core.test.CoreFeature;
import org.nuxeo.ecm.core.test.TransactionalFeature;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.FeaturesRunner;

@RunWith(value=FeaturesRunner.class)
@Deploy(value={"org.nuxeo.ecm.platform.userworkspace.types", "org.nuxeo.ecm.platform.userworkspace.core", "org.nuxeo.drive.core", "org.nuxeo.ecm.platform.collections.core", "org.nuxeo.ecm.core.io", "org.nuxeo.ecm.core.cache", "org.nuxeo.drive.core.test:OSGI-INF/test-nuxeodrive-types-contrib.xml", "org.nuxeo.drive.core.test:OSGI-INF/test-nuxeodrive-sync-root-cache-contrib.xml"})
public class AbstractChangeFinderTestCase {
    @Inject
    protected CoreSession session;
    @Inject
    protected NuxeoDriveManager nuxeoDriveManager;
    @Inject
    protected CoreFeature coreFeature;
    @Inject
    protected DirectoryService directoryService;
    @Inject
    protected EventServiceAdmin eventServiceAdmin;
    @Inject
    protected WorkManager workManager;
    protected long lastEventLogId;
    protected String lastSyncActiveRootDefinitions;
    protected DocumentModel folder1;
    protected DocumentModel folder2;
    protected DocumentModel folder3;
    protected CoreSession user1Session;
    @Inject
    TransactionalFeature txFeature;

    @Before
    public void init() throws Exception {
        this.eventServiceAdmin.setListenerEnabledFlag("nuxeoDriveFileSystemDeletionListener", true);
        this.lastEventLogId = 0L;
        this.lastSyncActiveRootDefinitions = "";
        Framework.getProperties().put("org.nuxeo.drive.document.change.limit", "10");
        try (Session userDir = this.directoryService.open("userDirectory");){
            HashMap<String, Object> user1 = new HashMap<String, Object>();
            user1.put("username", "user1");
            user1.put("groups", Arrays.asList("members"));
            userDir.createEntry(user1);
        }
        this.user1Session = this.coreFeature.openCoreSession("user1");
        this.commitAndWaitForAsyncCompletion();
        this.folder1 = this.session.createDocument(this.session.createDocumentModel("/", "folder1", "Folder"));
        this.folder2 = this.session.createDocument(this.session.createDocumentModel("/", "folder2", "Folder"));
        this.folder3 = this.session.createDocument(this.session.createDocumentModel("/", "folder3", "Folder"));
        this.setPermissions(this.folder1, new ACE("user1", "ReadWrite"));
        this.setPermissions(this.folder2, new ACE("user1", "ReadWrite"));
        this.commitAndWaitForAsyncCompletion();
    }

    @After
    public void tearDown() throws Exception {
        if (this.user1Session != null) {
            this.user1Session.close();
        }
        try (Session usersDir = this.directoryService.open("userDirectory");){
            usersDir.deleteEntry("user1");
        }
        this.eventServiceAdmin.setListenerEnabledFlag("nuxeoDriveFileSystemDeletionListener", false);
    }

    protected List<FileSystemItemChange> getChanges(Principal principal) throws InterruptedException {
        return this.getChangeSummary(principal).getFileSystemChanges();
    }

    protected List<FileSystemItemChange> getChanges() throws InterruptedException {
        return this.getChanges(this.session.getPrincipal());
    }

    protected FileSystemChangeSummary getChangeSummary(Principal principal) throws InterruptedException {
        Map lastSyncActiveRootRefs = RootDefinitionsHelper.parseRootDefinitions((String)this.lastSyncActiveRootDefinitions);
        FileSystemChangeSummary changeSummary = this.nuxeoDriveManager.getChangeSummaryIntegerBounds(principal, lastSyncActiveRootRefs, this.lastEventLogId);
        Assert.assertNotNull((Object)changeSummary);
        this.lastEventLogId = changeSummary.getUpperBound();
        this.lastSyncActiveRootDefinitions = changeSummary.getActiveSynchronizationRootDefinitions();
        return changeSummary;
    }

    protected void commitAndWaitForAsyncCompletion() throws Exception {
        this.txFeature.nextTransaction();
    }

    protected void waitForAsyncCompletion() throws Exception {
        this.txFeature.nextTransaction(20L, TimeUnit.SECONDS);
    }

    protected void setPermissions(DocumentModel doc, ACE ... aces) throws Exception {
        ACP acp = this.session.getACP(doc.getRef());
        ACL localACL = acp.getOrCreateACL("local");
        for (int i = 0; i < aces.length; ++i) {
            localACL.add(i, (Object)aces[i]);
        }
        this.session.setACP(doc.getRef(), acp, true);
        this.commitAndWaitForAsyncCompletion();
    }

    protected Set<SimpleFileSystemItemChange> toSimpleFileSystemItemChanges(List<FileSystemItemChange> changes) {
        HashSet<SimpleFileSystemItemChange> simpleChanges = new HashSet<SimpleFileSystemItemChange>();
        for (FileSystemItemChange change : changes) {
            simpleChanges.add(this.toSimpleFileSystemItemChange(change));
        }
        return simpleChanges;
    }

    protected SimpleFileSystemItemChange toSimpleFileSystemItemChange(FileSystemItemChange change) {
        SimpleFileSystemItemChange simpleChange = new SimpleFileSystemItemChange(change.getDocUuid(), change.getEventId(), change.getRepositoryId(), change.getFileSystemItemId(), change.getFileSystemItemName());
        IdRef changeDocRef = new IdRef(change.getDocUuid());
        if (this.session.exists((DocumentRef)changeDocRef)) {
            simpleChange.setLifeCycleState(this.session.getDocument((DocumentRef)changeDocRef).getCurrentLifeCycleState());
        }
        return simpleChange;
    }

    protected final class SimpleFileSystemItemChange {
        protected String docId;
        protected String eventName;
        protected String repositoryId;
        protected String lifeCycleState;
        protected String fileSystemItemId;
        protected String fileSystemItemName;

        public SimpleFileSystemItemChange(String docId, String eventName) {
            this(docId, eventName, null);
        }

        public SimpleFileSystemItemChange(String docId, String eventName, String repositoryId) {
            this(docId, eventName, repositoryId, null);
        }

        public SimpleFileSystemItemChange(String docId, String eventName, String repositoryId, String fileSystemItemId) {
            this(docId, eventName, repositoryId, fileSystemItemId, null);
        }

        public SimpleFileSystemItemChange(String docId, String eventName, String repositoryId, String fileSystemItemId, String fileSystemItemName) {
            this.docId = docId;
            this.eventName = eventName;
            this.repositoryId = repositoryId;
            this.fileSystemItemId = fileSystemItemId;
            this.fileSystemItemName = fileSystemItemName;
        }

        public String getDocId() {
            return this.docId;
        }

        public String getEventName() {
            return this.eventName;
        }

        public String getRepositoryId() {
            return this.repositoryId;
        }

        public String getLifeCycleState() {
            return this.lifeCycleState;
        }

        public String getFileSystemItemId() {
            return this.fileSystemItemId;
        }

        public String getFileSystemItemName() {
            return this.fileSystemItemName;
        }

        public void setLifeCycleState(String lifeCycleState) {
            this.lifeCycleState = lifeCycleState;
        }

        public int hashCode() {
            int hash = 17;
            hash = hash * 37 + this.docId.hashCode();
            return hash * 37 + this.eventName.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SimpleFileSystemItemChange)) {
                return false;
            }
            SimpleFileSystemItemChange other = (SimpleFileSystemItemChange)obj;
            boolean isEqual = this.docId.equals(other.getDocId()) && this.eventName.equals(other.getEventName());
            return !(!isEqual || this.repositoryId != null && other.getRepositoryId() != null && !this.repositoryId.equals(other.getRepositoryId()) || this.lifeCycleState != null && other.getLifeCycleState() != null && !this.lifeCycleState.equals(other.getLifeCycleState()) || this.fileSystemItemId != null && other.getFileSystemItemId() != null && !this.fileSystemItemId.equals(other.getFileSystemItemId()) || this.fileSystemItemName != null && other.getFileSystemItemName() != null && !this.fileSystemItemName.equals(other.getFileSystemItemName()));
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("(");
            sb.append(this.docId);
            sb.append(", ");
            sb.append(this.eventName);
            if (this.repositoryId != null) {
                sb.append(", ");
                sb.append(this.repositoryId);
            }
            if (this.lifeCycleState != null) {
                sb.append(", ");
                sb.append(this.lifeCycleState);
            }
            if (this.fileSystemItemId != null) {
                sb.append(", ");
                sb.append(this.fileSystemItemId);
            }
            if (this.fileSystemItemName != null) {
                sb.append(", ");
                sb.append(this.fileSystemItemName);
            }
            sb.append(")");
            return sb.toString();
        }
    }
}

