/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.service;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Test;
import org.nuxeo.drive.service.AbstractChangeFinderTestCase;
import org.nuxeo.drive.service.FileSystemItemChange;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.runtime.test.runner.Deploy;

@Deploy(value={"org.nuxeo.drive.core.test:OSGI-INF/test-nuxeodrive-clustering-enabled-repo-contrib.xml"})
public class AuditChangeFinderClusteringEnabledTestSuite
extends AbstractChangeFinderTestCase {
    private static final Log log = LogFactory.getLog(AuditChangeFinderClusteringEnabledTestSuite.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClusteringEnabled() throws Exception {
        DocumentModel file2;
        HashSet<AbstractChangeFinderTestCase.SimpleFileSystemItemChange> expectedChanges;
        DocumentModel file1;
        List<FileSystemItemChange> changes;
        try {
            changes = this.getChanges();
            Assert.assertNotNull(changes);
            Assert.assertTrue((boolean)changes.isEmpty());
            log.trace((Object)"Register a sync root and create a document inside it");
            this.nuxeoDriveManager.registerSynchronizationRoot(this.session.getPrincipal(), this.folder1, this.session);
            file1 = this.session.createDocumentModel("/folder1", "file1", "File");
            file1.setPropertyValue("file:content", (Serializable)new StringBlob("The file content"));
            file1 = this.session.createDocument(file1);
        }
        finally {
            this.commitAndWaitForAsyncCompletion();
        }
        try {
            changes = this.getChanges();
            Assert.assertTrue((boolean)changes.isEmpty());
            Thread.sleep(3000L);
            changes = this.getChanges();
            Assert.assertTrue((changes.size() >= 2 ? 1 : 0) != 0);
            expectedChanges = new HashSet<AbstractChangeFinderTestCase.SimpleFileSystemItemChange>();
            expectedChanges.add(new AbstractChangeFinderTestCase.SimpleFileSystemItemChange(this, file1.getId(), "documentCreated", "test", "defaultFileSystemItemFactory#test#" + file1.getId(), "file1"));
            expectedChanges.add(new AbstractChangeFinderTestCase.SimpleFileSystemItemChange(this, this.folder1.getId(), "rootRegistered", "test", "defaultSyncRootFolderItemFactory#test#" + this.folder1.getId(), "folder1"));
            expectedChanges.add(new AbstractChangeFinderTestCase.SimpleFileSystemItemChange(this, this.folder1.getId(), "documentCreated", "test", "defaultSyncRootFolderItemFactory#test#" + this.folder1.getId(), "folder1"));
            Assert.assertTrue((boolean)CollectionUtils.isSubCollection(this.toSimpleFileSystemItemChanges(changes), expectedChanges));
            log.trace((Object)"Update existing document and create a new one");
            file1.setPropertyValue("dc:description", (Serializable)((Object)"Upated description"));
            this.session.saveDocument(file1);
            file2 = this.session.createDocumentModel("/folder1", "file2", "File");
            file2.setPropertyValue("file:content", (Serializable)new StringBlob("The second file content"));
            file2 = this.session.createDocument(file2);
        }
        finally {
            this.commitAndWaitForAsyncCompletion();
        }
        changes = this.getChanges();
        Assert.assertTrue((boolean)changes.isEmpty());
        Thread.sleep(3000L);
        changes = this.getChanges();
        Assert.assertEquals((long)2L, (long)changes.size());
        expectedChanges = new HashSet();
        expectedChanges.add(new AbstractChangeFinderTestCase.SimpleFileSystemItemChange(this, file2.getId(), "documentCreated", "test", "defaultFileSystemItemFactory#test#" + file2.getId(), "file2"));
        expectedChanges.add(new AbstractChangeFinderTestCase.SimpleFileSystemItemChange(this, file1.getId(), "documentModified", "test", "defaultFileSystemItemFactory#test#" + file1.getId(), "file1"));
        Assert.assertTrue((boolean)CollectionUtils.isEqualCollection(expectedChanges, this.toSimpleFileSystemItemChanges(changes)));
    }
}

