/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.service;

import java.io.Serializable;
import java.security.Principal;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Test;
import org.nuxeo.drive.service.AbstractChangeFinderTestCase;
import org.nuxeo.drive.service.FileSystemChangeSummary;
import org.nuxeo.drive.service.FileSystemItemChange;
import org.nuxeo.ecm.collections.api.CollectionManager;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.VersioningOption;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.platform.usermanager.NuxeoPrincipalImpl;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.test.runner.Deploy;

@Deploy(value={"org.nuxeo.ecm.platform.web.common"})
public class AuditChangeFinderTestSuite
extends AbstractChangeFinderTestCase {
    private static final Log log = LogFactory.getLog(AuditChangeFinderTestSuite.class);
    @Inject
    protected CollectionManager collectionManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFindChanges() throws Exception {
        DocumentModel docToVersion;
        DocumentModel copiedDoc;
        DocumentModel docToCopy;
        HashSet<AbstractChangeFinderTestCase.SimpleFileSystemItemChange> expectedChanges;
        DocumentModel doc3;
        DocumentModel doc2;
        DocumentModel doc1;
        List<FileSystemItemChange> changes;
        this.commitAndWaitForAsyncCompletion();
        try {
            changes = this.getChanges();
            Assert.assertNotNull(changes);
            Assert.assertTrue((boolean)changes.isEmpty());
            log.trace((Object)"Sync roots for Administrator");
            this.nuxeoDriveManager.registerSynchronizationRoot(this.session.getPrincipal(), this.folder1, this.session);
            this.nuxeoDriveManager.registerSynchronizationRoot(this.session.getPrincipal(), this.folder2, this.session);
        }
        finally {
            this.commitAndWaitForAsyncCompletion();
        }
        try {
            changes = this.getChanges();
            Assert.assertEquals((long)2L, (long)changes.size());
            log.trace((Object)"Create 3 documents, only 2 in sync roots");
            doc1 = this.session.createDocumentModel("/folder1", "doc1", "File");
            doc1.setPropertyValue("file:content", (Serializable)new StringBlob("The content of file 1."));
            doc1 = this.session.createDocument(doc1);
            doc2 = this.session.createDocumentModel("/folder2", "doc2", "File");
            doc2.setPropertyValue("file:content", (Serializable)new StringBlob("The content of file 2."));
            doc2 = this.session.createDocument(doc2);
            doc3 = this.session.createDocumentModel("/folder3", "doc3", "File");
            doc3.setPropertyValue("file:content", (Serializable)new StringBlob("The content of file 3."));
            doc3 = this.session.createDocument(doc3);
        }
        finally {
            this.commitAndWaitForAsyncCompletion();
        }
        try {
            changes = this.getChanges();
            Assert.assertEquals((long)2L, (long)changes.size());
            expectedChanges = new HashSet<AbstractChangeFinderTestCase.SimpleFileSystemItemChange>();
            expectedChanges.add(new AbstractChangeFinderTestCase.SimpleFileSystemItemChange(this, doc2.getId(), "documentCreated", "test"));
            expectedChanges.add(new AbstractChangeFinderTestCase.SimpleFileSystemItemChange(this, doc1.getId(), "documentCreated", "test"));
            Assert.assertTrue((boolean)CollectionUtils.isEqualCollection(expectedChanges, this.toSimpleFileSystemItemChanges(changes)));
            changes = this.getChanges();
            Assert.assertTrue((boolean)changes.isEmpty());
            log.trace((Object)"Update both synchronized documents and unsynchronize a root");
            doc1.setPropertyValue("file:content", (Serializable)new StringBlob("The content of file 1, updated."));
            this.session.saveDocument(doc1);
            doc2.setPropertyValue("file:content", (Serializable)new StringBlob("The content of file 2, updated."));
            this.session.saveDocument(doc2);
            this.nuxeoDriveManager.unregisterSynchronizationRoot(this.session.getPrincipal(), this.folder2, this.session);
        }
        finally {
            this.commitAndWaitForAsyncCompletion();
        }
        try {
            changes = this.getChanges();
            Assert.assertEquals((long)2L, (long)changes.size());
            expectedChanges = new HashSet();
            expectedChanges.add(new AbstractChangeFinderTestCase.SimpleFileSystemItemChange(this, this.folder2.getId(), "deleted", "test"));
            expectedChanges.add(new AbstractChangeFinderTestCase.SimpleFileSystemItemChange(this, doc1.getId(), "documentModified", "test"));
            Assert.assertTrue((boolean)CollectionUtils.isEqualCollection(expectedChanges, this.toSimpleFileSystemItemChanges(changes)));
            log.trace((Object)"Delete a document with a lifecycle transition (trash)");
            this.session.followTransition(doc1.getRef(), "delete");
        }
        finally {
            this.commitAndWaitForAsyncCompletion();
        }
        try {
            changes = this.getChanges();
            Assert.assertEquals((long)1L, (long)changes.size());
            Assert.assertEquals((Object)new AbstractChangeFinderTestCase.SimpleFileSystemItemChange(this, doc1.getId(), "deleted", "test", "test#" + doc1.getId()), (Object)this.toSimpleFileSystemItemChange(changes.get(0)));
            log.trace((Object)"Restore a deleted document and move a document in a newly synchronized root");
            this.session.followTransition(doc1.getRef(), "undelete");
            this.session.move(doc3.getRef(), this.folder2.getRef(), null);
            this.nuxeoDriveManager.registerSynchronizationRoot(this.session.getPrincipal(), this.folder2, this.session);
        }
        finally {
            this.commitAndWaitForAsyncCompletion();
        }
        try {
            changes = this.getChanges();
            Assert.assertEquals((long)3L, (long)changes.size());
            expectedChanges = new HashSet();
            expectedChanges.add(new AbstractChangeFinderTestCase.SimpleFileSystemItemChange(this, this.folder2.getId(), "rootRegistered", "test", "defaultSyncRootFolderItemFactory#test#" + this.folder2.getId()));
            expectedChanges.add(new AbstractChangeFinderTestCase.SimpleFileSystemItemChange(this, doc3.getId(), "documentMoved", "test"));
            expectedChanges.add(new AbstractChangeFinderTestCase.SimpleFileSystemItemChange(this, doc1.getId(), "lifecycle_transition_event", "test"));
            Assert.assertTrue((boolean)CollectionUtils.isEqualCollection(expectedChanges, this.toSimpleFileSystemItemChanges(changes)));
            log.trace((Object)"Physical deletion without triggering the delete transition first");
            this.session.removeDocument(doc3.getRef());
        }
        finally {
            this.commitAndWaitForAsyncCompletion();
        }
        try {
            changes = this.getChanges();
            Assert.assertEquals((long)1L, (long)changes.size());
            Assert.assertEquals((Object)new AbstractChangeFinderTestCase.SimpleFileSystemItemChange(this, doc3.getId(), "deleted", "test", "test#" + doc3.getId()), (Object)this.toSimpleFileSystemItemChange(changes.get(0)));
            log.trace((Object)"Create a doc and copy it from a sync root to another one");
            docToCopy = this.session.createDocumentModel("/folder1", "docToCopy", "File");
            docToCopy.setPropertyValue("file:content", (Serializable)new StringBlob("The content of file to copy."));
            docToCopy = this.session.createDocument(docToCopy);
            copiedDoc = this.session.copy(docToCopy.getRef(), this.folder2.getRef(), null, new CoreSession.CopyOption[0]);
        }
        finally {
            this.commitAndWaitForAsyncCompletion();
        }
        try {
            changes = this.getChanges();
            Assert.assertEquals((long)2L, (long)changes.size());
            expectedChanges = new HashSet();
            expectedChanges.add(new AbstractChangeFinderTestCase.SimpleFileSystemItemChange(this, copiedDoc.getId(), "documentCreatedByCopy", "test", "defaultFileSystemItemFactory#test#" + copiedDoc.getId(), "docToCopy"));
            expectedChanges.add(new AbstractChangeFinderTestCase.SimpleFileSystemItemChange(this, docToCopy.getId(), "documentCreated", "test", "defaultFileSystemItemFactory#test#" + docToCopy.getId(), "docToCopy"));
            Assert.assertTrue((boolean)CollectionUtils.isEqualCollection(expectedChanges, this.toSimpleFileSystemItemChanges(changes)));
            log.trace((Object)"Remove file from a document, mapped to a fake deletion from the client's point of view");
            doc1.setPropertyValue("file:content", null);
            this.session.saveDocument(doc1);
        }
        finally {
            this.commitAndWaitForAsyncCompletion();
        }
        try {
            changes = this.getChanges();
            Assert.assertEquals((long)1L, (long)changes.size());
            Assert.assertEquals((Object)new AbstractChangeFinderTestCase.SimpleFileSystemItemChange(this, doc1.getId(), "deleted", "test"), (Object)this.toSimpleFileSystemItemChange(changes.get(0)));
            log.trace((Object)"Move a doc from a sync root to another sync root");
            this.session.move(copiedDoc.getRef(), this.folder1.getRef(), null);
        }
        finally {
            this.commitAndWaitForAsyncCompletion();
        }
        try {
            changes = this.getChanges();
            Assert.assertEquals((long)1L, (long)changes.size());
            Assert.assertEquals((Object)new AbstractChangeFinderTestCase.SimpleFileSystemItemChange(this, copiedDoc.getId(), "documentMoved", "test"), (Object)this.toSimpleFileSystemItemChange(changes.get(0)));
            log.trace((Object)"Move a doc from a sync root to a non synchronized folder");
            this.session.move(copiedDoc.getRef(), this.folder3.getRef(), null);
        }
        finally {
            this.commitAndWaitForAsyncCompletion();
        }
        try {
            changes = this.getChanges();
            Assert.assertEquals((long)1L, (long)changes.size());
            Assert.assertEquals((Object)new AbstractChangeFinderTestCase.SimpleFileSystemItemChange(this, copiedDoc.getId(), "deleted", "test"), (Object)this.toSimpleFileSystemItemChange(changes.get(0)));
            log.trace((Object)"Create a doc, create a version of it, update doc and restore the version");
            docToVersion = this.session.createDocumentModel("/folder1", "docToVersion", "File");
            docToVersion.setPropertyValue("file:content", (Serializable)new StringBlob("The content of file to version."));
            docToVersion = this.session.createDocument(docToVersion);
            docToVersion.putContextData("VersioningOption", (Serializable)VersioningOption.MAJOR);
            this.session.saveDocument(docToVersion);
            docToVersion.setPropertyValue("file:content", (Serializable)new StringBlob("Updated content of the versioned file."));
            this.session.saveDocument(docToVersion);
            List versions = this.session.getVersions(docToVersion.getRef());
            Assert.assertEquals((long)1L, (long)versions.size());
            DocumentModel version = (DocumentModel)versions.get(0);
            this.session.restoreToVersion(docToVersion.getRef(), version.getRef());
        }
        finally {
            this.commitAndWaitForAsyncCompletion();
        }
        try {
            changes = this.getChanges();
            Assert.assertEquals((long)4L, (long)changes.size());
            expectedChanges = new HashSet();
            expectedChanges.add(new AbstractChangeFinderTestCase.SimpleFileSystemItemChange(this, docToVersion.getId(), "documentRestored"));
            expectedChanges.add(new AbstractChangeFinderTestCase.SimpleFileSystemItemChange(this, docToVersion.getId(), "documentModified"));
            expectedChanges.add(new AbstractChangeFinderTestCase.SimpleFileSystemItemChange(this, docToVersion.getId(), "documentCreated"));
            Assert.assertTrue((boolean)CollectionUtils.isEqualCollection(expectedChanges, this.toSimpleFileSystemItemChanges(changes)));
            log.trace((Object)"Too many changes");
            this.session.followTransition(doc1.getRef(), "delete");
            this.session.followTransition(doc2.getRef(), "delete");
        }
        finally {
            this.commitAndWaitForAsyncCompletion();
        }
        Framework.getProperties().put("org.nuxeo.drive.document.change.limit", "1");
        FileSystemChangeSummary changeSummary = this.getChangeSummary(this.session.getPrincipal());
        Assert.assertEquals((Object)true, (Object)changeSummary.getHasTooManyChanges());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFindSecurityChanges() throws Exception {
        HashSet<AbstractChangeFinderTestCase.SimpleFileSystemItemChange> expectedChanges;
        DocumentModel subFolder;
        List<FileSystemItemChange> changes;
        try {
            changes = this.getChanges();
            Assert.assertTrue((boolean)changes.isEmpty());
            subFolder = this.user1Session.createDocumentModel("/folder1", "subFolder", "Folder");
            subFolder = this.user1Session.createDocument(subFolder);
            this.nuxeoDriveManager.registerSynchronizationRoot(this.user1Session.getPrincipal(), this.folder1, this.user1Session);
            this.nuxeoDriveManager.registerSynchronizationRoot(this.user1Session.getPrincipal(), this.folder2, this.user1Session);
        }
        finally {
            this.commitAndWaitForAsyncCompletion();
        }
        try {
            changes = this.getChanges(this.user1Session.getPrincipal());
            Assert.assertEquals((long)3L, (long)changes.size());
            this.setPermissions(subFolder, new ACE("Administrator", "Everything"), ACE.BLOCK);
            this.setPermissions(this.folder2, new ACE("Administrator", "Everything"), ACE.BLOCK);
        }
        finally {
            this.commitAndWaitForAsyncCompletion();
        }
        try {
            changes = this.getChanges(this.user1Session.getPrincipal());
            Assert.assertEquals((long)2L, (long)changes.size());
            expectedChanges = new HashSet<AbstractChangeFinderTestCase.SimpleFileSystemItemChange>();
            expectedChanges.add(new AbstractChangeFinderTestCase.SimpleFileSystemItemChange(this, this.folder2.getId(), "securityUpdated", "test", "test#" + this.folder2.getId(), "folder2"));
            expectedChanges.add(new AbstractChangeFinderTestCase.SimpleFileSystemItemChange(this, subFolder.getId(), "securityUpdated", "test", "test#" + subFolder.getId(), "subFolder"));
            Assert.assertTrue((boolean)CollectionUtils.isEqualCollection(expectedChanges, this.toSimpleFileSystemItemChanges(changes)));
            for (FileSystemItemChange change : changes) {
                Assert.assertNull((Object)change.getFileSystemItem());
            }
            this.setPermissions(subFolder, new ACE("user1", "Read"));
            this.setPermissions(this.folder2, new ACE("user1", "Read"));
        }
        finally {
            this.commitAndWaitForAsyncCompletion();
        }
        changes = this.getChanges(this.user1Session.getPrincipal());
        Assert.assertEquals((long)2L, (long)changes.size());
        expectedChanges = new HashSet();
        expectedChanges.add(new AbstractChangeFinderTestCase.SimpleFileSystemItemChange(this, this.folder2.getId(), "securityUpdated", "test", "defaultSyncRootFolderItemFactory#test#" + this.folder2.getId(), "folder2"));
        expectedChanges.add(new AbstractChangeFinderTestCase.SimpleFileSystemItemChange(this, subFolder.getId(), "securityUpdated", "test", "defaultFileSystemItemFactory#test#" + subFolder.getId(), "subFolder"));
        Assert.assertTrue((boolean)CollectionUtils.isEqualCollection(expectedChanges, this.toSimpleFileSystemItemChanges(changes)));
        for (FileSystemItemChange change : changes) {
            Assert.assertNotNull((Object)change.getFileSystemItem());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetChangeSummary() throws Exception {
        DocumentModel doc2;
        DocumentModel doc1;
        FileSystemChangeSummary changeSummary;
        NuxeoPrincipalImpl admin = new NuxeoPrincipalImpl("Administrator");
        try {
            changeSummary = this.getChangeSummary((Principal)admin);
            Assert.assertNotNull((Object)changeSummary);
            Assert.assertTrue((boolean)changeSummary.getFileSystemChanges().isEmpty());
            Assert.assertEquals((Object)Boolean.FALSE, (Object)changeSummary.getHasTooManyChanges());
            this.nuxeoDriveManager.registerSynchronizationRoot((Principal)admin, this.folder1, this.session);
            this.nuxeoDriveManager.registerSynchronizationRoot((Principal)admin, this.folder2, this.session);
        }
        finally {
            this.commitAndWaitForAsyncCompletion();
        }
        try {
            changeSummary = this.getChangeSummary((Principal)admin);
            Assert.assertEquals((long)2L, (long)changeSummary.getFileSystemChanges().size());
            Assert.assertEquals((Object)Boolean.FALSE, (Object)changeSummary.getHasTooManyChanges());
        }
        finally {
            this.commitAndWaitForAsyncCompletion();
        }
        try {
            doc1 = this.session.createDocumentModel("/folder1", "doc1", "File");
            doc1.setPropertyValue("file:content", (Serializable)new StringBlob("The content of file 1."));
            doc1 = this.session.createDocument(doc1);
            doc2 = this.session.createDocumentModel("/folder2", "doc2", "File");
            doc2.setPropertyValue("file:content", (Serializable)new StringBlob("The content of file 2."));
            doc2 = this.session.createDocument(doc2);
            this.session.createDocument(this.session.createDocumentModel("/folder3", "doc3", "File"));
        }
        finally {
            this.commitAndWaitForAsyncCompletion();
        }
        try {
            changeSummary = this.getChangeSummary((Principal)admin);
            List changes = changeSummary.getFileSystemChanges();
            Assert.assertEquals((long)2L, (long)changes.size());
            HashSet<AbstractChangeFinderTestCase.SimpleFileSystemItemChange> expectedChanges = new HashSet<AbstractChangeFinderTestCase.SimpleFileSystemItemChange>();
            AbstractChangeFinderTestCase.SimpleFileSystemItemChange simpleChange = new AbstractChangeFinderTestCase.SimpleFileSystemItemChange(this, doc2.getId(), "documentCreated", "test");
            simpleChange.setLifeCycleState("project");
            expectedChanges.add(simpleChange);
            simpleChange = new AbstractChangeFinderTestCase.SimpleFileSystemItemChange(this, doc1.getId(), "documentCreated", "test");
            simpleChange.setLifeCycleState("project");
            expectedChanges.add(simpleChange);
            Assert.assertTrue((boolean)CollectionUtils.isEqualCollection(expectedChanges, this.toSimpleFileSystemItemChanges(changes)));
            Assert.assertEquals((Object)Boolean.FALSE, (Object)changeSummary.getHasTooManyChanges());
            this.session.createDocument(this.session.createDocumentModel("/folder1", "notSynchronizableDoc", "NotSynchronizable"));
        }
        finally {
            this.commitAndWaitForAsyncCompletion();
        }
        try {
            changeSummary = this.getChangeSummary((Principal)admin);
            Assert.assertTrue((boolean)changeSummary.getFileSystemChanges().isEmpty());
            Assert.assertEquals((Object)Boolean.FALSE, (Object)changeSummary.getHasTooManyChanges());
            DocumentModel doc3 = this.session.createDocumentModel("/folder1", "doc3", "File");
            doc3.setPropertyValue("file:content", (Serializable)new StringBlob("The content of file 3."));
            doc3 = this.session.createDocument(doc3);
            DocumentModel doc4 = this.session.createDocumentModel("/folder1", "doc4", "File");
            doc4.setPropertyValue("file:content", (Serializable)new StringBlob("The content of file 4."));
            doc4 = this.session.createDocument(doc4);
            DocumentModel doc5 = this.session.createDocumentModel("/folder2", "doc5", "File");
            doc5.setPropertyValue("file:content", (Serializable)new StringBlob("The content of file 5."));
            doc5 = this.session.createDocument(doc5);
        }
        finally {
            this.commitAndWaitForAsyncCompletion();
        }
        try {
            changeSummary = this.getChangeSummary((Principal)admin);
            Assert.assertEquals((Object)Boolean.FALSE, (Object)changeSummary.getHasTooManyChanges());
            Assert.assertEquals((long)3L, (long)changeSummary.getFileSystemChanges().size());
            changeSummary = this.getChangeSummary((Principal)admin);
            Assert.assertTrue((boolean)changeSummary.getFileSystemChanges().isEmpty());
            Assert.assertEquals((Object)Boolean.FALSE, (Object)changeSummary.getHasTooManyChanges());
            this.session.followTransition(doc1.getRef(), "delete");
            this.session.followTransition(doc2.getRef(), "delete");
        }
        finally {
            this.commitAndWaitForAsyncCompletion();
        }
        Framework.getProperties().put("org.nuxeo.drive.document.change.limit", "1");
        changeSummary = this.getChangeSummary((Principal)admin);
        Assert.assertTrue((boolean)changeSummary.getFileSystemChanges().isEmpty());
        Assert.assertEquals((Object)Boolean.TRUE, (Object)changeSummary.getHasTooManyChanges());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetChangeSummaryOnRootDocuments() throws Exception {
        List changes;
        FileSystemChangeSummary changeSummary;
        Set activeRootRefs;
        NuxeoPrincipalImpl admin = new NuxeoPrincipalImpl("Administrator");
        NuxeoPrincipalImpl otherUser = new NuxeoPrincipalImpl("some-other-user");
        try {
            activeRootRefs = this.nuxeoDriveManager.getSynchronizationRootReferences(this.session);
            Assert.assertNotNull((Object)activeRootRefs);
            Assert.assertTrue((boolean)activeRootRefs.isEmpty());
            changeSummary = this.getChangeSummary((Principal)admin);
            Assert.assertNotNull((Object)changeSummary);
            Assert.assertTrue((boolean)changeSummary.getFileSystemChanges().isEmpty());
            Assert.assertEquals((Object)Boolean.FALSE, (Object)changeSummary.getHasTooManyChanges());
            this.nuxeoDriveManager.registerSynchronizationRoot((Principal)otherUser, this.folder1, this.session);
        }
        finally {
            this.commitAndWaitForAsyncCompletion();
        }
        try {
            activeRootRefs = this.nuxeoDriveManager.getSynchronizationRootReferences(this.session);
            Assert.assertNotNull((Object)activeRootRefs);
            Assert.assertTrue((boolean)activeRootRefs.isEmpty());
            changeSummary = this.getChangeSummary((Principal)admin);
            Assert.assertNotNull((Object)changeSummary);
            Assert.assertTrue((boolean)changeSummary.getFileSystemChanges().isEmpty());
            Assert.assertFalse((boolean)changeSummary.getHasTooManyChanges());
            this.nuxeoDriveManager.registerSynchronizationRoot((Principal)admin, this.folder1, this.session);
        }
        finally {
            this.commitAndWaitForAsyncCompletion();
        }
        try {
            activeRootRefs = this.nuxeoDriveManager.getSynchronizationRootReferences(this.session);
            Assert.assertNotNull((Object)activeRootRefs);
            Assert.assertEquals((long)1L, (long)activeRootRefs.size());
            Assert.assertEquals((Object)this.folder1.getRef(), activeRootRefs.iterator().next());
            changeSummary = this.getChangeSummary((Principal)admin);
            Assert.assertNotNull((Object)changeSummary);
            changes = changeSummary.getFileSystemChanges();
            Assert.assertEquals((long)1L, (long)changes.size());
            Assert.assertEquals((Object)new AbstractChangeFinderTestCase.SimpleFileSystemItemChange(this, this.folder1.getId(), "rootRegistered", "test", "defaultSyncRootFolderItemFactory#test#" + this.folder1.getId()), (Object)this.toSimpleFileSystemItemChange((FileSystemItemChange)changes.get(0)));
            this.nuxeoDriveManager.unregisterSynchronizationRoot((Principal)admin, this.folder1, this.session);
        }
        finally {
            this.commitAndWaitForAsyncCompletion();
        }
        try {
            activeRootRefs = this.nuxeoDriveManager.getSynchronizationRootReferences(this.session);
            Assert.assertNotNull((Object)activeRootRefs);
            Assert.assertTrue((boolean)activeRootRefs.isEmpty());
            changeSummary = this.getChangeSummary((Principal)admin);
            changes = changeSummary.getFileSystemChanges();
            Assert.assertEquals((long)1L, (long)changes.size());
            Assert.assertEquals((Object)new AbstractChangeFinderTestCase.SimpleFileSystemItemChange(this, this.folder1.getId(), "deleted", "test", "test#" + this.folder1.getId()), (Object)this.toSimpleFileSystemItemChange((FileSystemItemChange)changes.get(0)));
            this.nuxeoDriveManager.registerSynchronizationRoot((Principal)admin, this.folder1, this.session);
        }
        finally {
            this.commitAndWaitForAsyncCompletion();
        }
        try {
            activeRootRefs = this.nuxeoDriveManager.getSynchronizationRootReferences(this.session);
            Assert.assertNotNull((Object)activeRootRefs);
            Assert.assertEquals((long)activeRootRefs.size(), (long)1L);
            changeSummary = this.getChangeSummary((Principal)admin);
            changes = changeSummary.getFileSystemChanges();
            Assert.assertEquals((long)1L, (long)changes.size());
            Assert.assertEquals((Object)new AbstractChangeFinderTestCase.SimpleFileSystemItemChange(this, this.folder1.getId(), "rootRegistered", "test", "defaultSyncRootFolderItemFactory#test#" + this.folder1.getId()), (Object)this.toSimpleFileSystemItemChange((FileSystemItemChange)changes.get(0)));
            this.session.followTransition(this.folder1.getRef(), "delete");
        }
        finally {
            this.commitAndWaitForAsyncCompletion();
        }
        try {
            activeRootRefs = this.nuxeoDriveManager.getSynchronizationRootReferences(this.session);
            Assert.assertNotNull((Object)activeRootRefs);
            Assert.assertTrue((boolean)activeRootRefs.isEmpty());
            activeRootRefs = this.nuxeoDriveManager.getSynchronizationRootReferences(this.session);
            Assert.assertNotNull((Object)activeRootRefs);
            Assert.assertTrue((boolean)activeRootRefs.isEmpty());
            changeSummary = this.getChangeSummary((Principal)admin);
            changes = changeSummary.getFileSystemChanges();
            Assert.assertEquals((long)1L, (long)changes.size());
            Assert.assertEquals((Object)new AbstractChangeFinderTestCase.SimpleFileSystemItemChange(this, this.folder1.getId(), "deleted", "test", "test#" + this.folder1.getId()), (Object)this.toSimpleFileSystemItemChange((FileSystemItemChange)changes.get(0)));
        }
        finally {
            this.commitAndWaitForAsyncCompletion();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSyncUnsyncRootsAsAnotherUser() throws Exception {
        HashSet<AbstractChangeFinderTestCase.SimpleFileSystemItemChange> expectedChanges;
        Set activeRootRefs;
        List<FileSystemItemChange> changes;
        Principal user1Principal = this.user1Session.getPrincipal();
        try {
            changes = this.getChanges(user1Principal);
            Assert.assertNotNull(changes);
            Assert.assertTrue((boolean)changes.isEmpty());
            this.nuxeoDriveManager.registerSynchronizationRoot(user1Principal, this.folder1, this.session);
            this.nuxeoDriveManager.registerSynchronizationRoot(user1Principal, this.folder2, this.session);
        }
        finally {
            this.commitAndWaitForAsyncCompletion();
        }
        try {
            activeRootRefs = this.nuxeoDriveManager.getSynchronizationRootReferences(this.user1Session);
            Assert.assertNotNull((Object)activeRootRefs);
            Assert.assertEquals((long)2L, (long)activeRootRefs.size());
            Assert.assertTrue((boolean)activeRootRefs.contains(this.folder1.getRef()));
            Assert.assertTrue((boolean)activeRootRefs.contains(this.folder2.getRef()));
            changes = this.getChanges(user1Principal);
            Assert.assertEquals((long)2L, (long)changes.size());
            expectedChanges = new HashSet<AbstractChangeFinderTestCase.SimpleFileSystemItemChange>();
            expectedChanges.add(new AbstractChangeFinderTestCase.SimpleFileSystemItemChange(this, this.folder2.getId(), "rootRegistered", "test", "defaultSyncRootFolderItemFactory#test#" + this.folder2.getId(), "folder2"));
            expectedChanges.add(new AbstractChangeFinderTestCase.SimpleFileSystemItemChange(this, this.folder1.getId(), "rootRegistered", "test", "defaultSyncRootFolderItemFactory#test#" + this.folder1.getId(), "folder1"));
            Assert.assertTrue((boolean)CollectionUtils.isEqualCollection(expectedChanges, this.toSimpleFileSystemItemChanges(changes)));
            for (FileSystemItemChange change : changes) {
                Assert.assertNotNull((Object)change.getFileSystemItem());
            }
            this.nuxeoDriveManager.unregisterSynchronizationRoot(user1Principal, this.folder1, this.session);
            this.nuxeoDriveManager.unregisterSynchronizationRoot(user1Principal, this.folder2, this.session);
        }
        finally {
            this.commitAndWaitForAsyncCompletion();
        }
        try {
            activeRootRefs = this.nuxeoDriveManager.getSynchronizationRootReferences(this.user1Session);
            Assert.assertNotNull((Object)activeRootRefs);
            Assert.assertTrue((boolean)activeRootRefs.isEmpty());
            changes = this.getChanges(user1Principal);
            Assert.assertEquals((long)2L, (long)changes.size());
            expectedChanges = new HashSet();
            expectedChanges.add(new AbstractChangeFinderTestCase.SimpleFileSystemItemChange(this, this.folder2.getId(), "deleted", "test", "test#" + this.folder2.getId(), "folder2"));
            expectedChanges.add(new AbstractChangeFinderTestCase.SimpleFileSystemItemChange(this, this.folder1.getId(), "deleted", "test", "test#" + this.folder1.getId(), "folder1"));
            Assert.assertTrue((boolean)CollectionUtils.isEqualCollection(expectedChanges, this.toSimpleFileSystemItemChanges(changes)));
            for (FileSystemItemChange change : changes) {
                Assert.assertNull((Object)change.getFileSystemItem());
            }
        }
        finally {
            this.commitAndWaitForAsyncCompletion();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRegisterSyncRootAndUpdate() throws Exception {
        List<FileSystemItemChange> changes;
        try {
            this.nuxeoDriveManager.registerSynchronizationRoot(this.session.getPrincipal(), this.folder1, this.session);
            this.folder1.setPropertyValue("dc:title", (Serializable)((Object)"folder1 updated"));
            this.session.saveDocument(this.folder1);
        }
        finally {
            this.commitAndWaitForAsyncCompletion();
        }
        try {
            changes = this.getChanges();
            Assert.assertEquals((long)3L, (long)changes.size());
            HashSet<AbstractChangeFinderTestCase.SimpleFileSystemItemChange> expectedChanges = new HashSet<AbstractChangeFinderTestCase.SimpleFileSystemItemChange>();
            expectedChanges.add(new AbstractChangeFinderTestCase.SimpleFileSystemItemChange(this, this.folder1.getId(), "documentModified"));
            expectedChanges.add(new AbstractChangeFinderTestCase.SimpleFileSystemItemChange(this, this.folder1.getId(), "rootRegistered"));
            expectedChanges.add(new AbstractChangeFinderTestCase.SimpleFileSystemItemChange(this, this.folder1.getId(), "documentCreated"));
            Assert.assertTrue((boolean)CollectionUtils.isEqualCollection(expectedChanges, this.toSimpleFileSystemItemChanges(changes)));
            this.nuxeoDriveManager.unregisterSynchronizationRoot(this.session.getPrincipal(), this.folder1, this.session);
            this.folder1.setPropertyValue("dc:title", (Serializable)((Object)"folder1 updated twice"));
            this.session.saveDocument(this.folder1);
        }
        finally {
            this.commitAndWaitForAsyncCompletion();
        }
        try {
            changes = this.getChanges();
            Assert.assertEquals((long)1L, (long)changes.size());
            Assert.assertEquals((Object)new AbstractChangeFinderTestCase.SimpleFileSystemItemChange(this, this.folder1.getId(), "deleted"), (Object)this.toSimpleFileSystemItemChange(changes.get(0)));
        }
        finally {
            this.commitAndWaitForAsyncCompletion();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMoveToOtherUsersSyncRoot() throws Exception {
        List<FileSystemItemChange> changes;
        DocumentModel subFolder;
        try {
            subFolder = this.session.createDocument(this.session.createDocumentModel(this.folder1.getPathAsString(), "subFolder", "Folder"));
            this.nuxeoDriveManager.registerSynchronizationRoot(this.user1Session.getPrincipal(), this.folder1, this.user1Session);
            this.nuxeoDriveManager.registerSynchronizationRoot(this.session.getPrincipal(), this.folder2, this.session);
        }
        finally {
            this.commitAndWaitForAsyncCompletion();
        }
        try {
            changes = this.getChanges(this.user1Session.getPrincipal());
            Assert.assertEquals((long)3L, (long)changes.size());
            HashSet<AbstractChangeFinderTestCase.SimpleFileSystemItemChange> expectedChanges = new HashSet<AbstractChangeFinderTestCase.SimpleFileSystemItemChange>();
            expectedChanges.add(new AbstractChangeFinderTestCase.SimpleFileSystemItemChange(this, this.folder1.getId(), "rootRegistered"));
            expectedChanges.add(new AbstractChangeFinderTestCase.SimpleFileSystemItemChange(this, subFolder.getId(), "documentCreated"));
            expectedChanges.add(new AbstractChangeFinderTestCase.SimpleFileSystemItemChange(this, this.folder1.getId(), "documentCreated"));
            Assert.assertTrue((boolean)CollectionUtils.isEqualCollection(expectedChanges, this.toSimpleFileSystemItemChanges(changes)));
            this.session.move(subFolder.getRef(), this.folder2.getRef(), null);
        }
        finally {
            this.commitAndWaitForAsyncCompletion();
        }
        try {
            changes = this.getChanges(this.user1Session.getPrincipal());
            Assert.assertEquals((long)1L, (long)changes.size());
            Assert.assertEquals((Object)new AbstractChangeFinderTestCase.SimpleFileSystemItemChange(this, subFolder.getId(), "deleted"), (Object)this.toSimpleFileSystemItemChange(changes.get(0)));
        }
        finally {
            this.commitAndWaitForAsyncCompletion();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCollectionEvents() throws Exception {
        DocumentModel doc3;
        AbstractCollection expectedChanges;
        List<FileSystemItemChange> changes;
        DocumentModel locallyEditedCollection;
        DocumentModel doc2;
        DocumentModel doc1;
        try {
            log.trace((Object)"Create 2 test docs and them to the 'Locally Edited' collection");
            doc1 = this.session.createDocumentModel(this.folder1.getPathAsString(), "doc1", "File");
            doc1.setPropertyValue("file:content", (Serializable)new StringBlob("File content."));
            doc1 = this.session.createDocument(doc1);
            doc2 = this.session.createDocumentModel(this.folder1.getPathAsString(), "doc2", "File");
            doc2.setPropertyValue("file:content", (Serializable)new StringBlob("File content."));
            doc2 = this.session.createDocument(doc2);
            this.nuxeoDriveManager.addToLocallyEditedCollection(this.session, doc1);
            this.nuxeoDriveManager.addToLocallyEditedCollection(this.session, doc2);
            DocumentModel userCollections = this.collectionManager.getUserDefaultCollections(this.folder1, this.session);
            PathRef locallyEditedCollectionRef = new PathRef(userCollections.getPath().toString(), "Locally Edited");
            locallyEditedCollection = this.session.getDocument((DocumentRef)locallyEditedCollectionRef);
            doc1 = this.session.getDocument(doc1.getRef());
            doc2 = this.session.getDocument(doc2.getRef());
        }
        finally {
            this.commitAndWaitForAsyncCompletion();
        }
        try {
            changes = this.getChanges(this.session.getPrincipal());
            Assert.assertEquals((long)8L, (long)changes.size());
            expectedChanges = new HashSet<AbstractChangeFinderTestCase.SimpleFileSystemItemChange>();
            expectedChanges.add(new AbstractChangeFinderTestCase.SimpleFileSystemItemChange(this, doc2.getId(), "addedToCollection"));
            expectedChanges.add(new AbstractChangeFinderTestCase.SimpleFileSystemItemChange(this, locallyEditedCollection.getId(), "documentModified"));
            expectedChanges.add(new AbstractChangeFinderTestCase.SimpleFileSystemItemChange(this, locallyEditedCollection.getId(), "rootRegistered"));
            expectedChanges.add(new AbstractChangeFinderTestCase.SimpleFileSystemItemChange(this, doc1.getId(), "addedToCollection"));
            expectedChanges.add(new AbstractChangeFinderTestCase.SimpleFileSystemItemChange(this, locallyEditedCollection.getId(), "documentCreated"));
            expectedChanges.add(new AbstractChangeFinderTestCase.SimpleFileSystemItemChange(this, doc2.getId(), "documentCreated"));
            expectedChanges.add(new AbstractChangeFinderTestCase.SimpleFileSystemItemChange(this, doc1.getId(), "documentCreated"));
            Assert.assertTrue((boolean)CollectionUtils.isEqualCollection(expectedChanges, this.toSimpleFileSystemItemChanges(changes)));
            log.trace((Object)"Update doc1 member of the 'Locally Edited' collection");
            doc1.setPropertyValue("file:content", (Serializable)new StringBlob("Updated file content."));
            this.session.saveDocument(doc1);
        }
        finally {
            this.commitAndWaitForAsyncCompletion();
        }
        try {
            changes = this.getChanges(this.session.getPrincipal());
            Assert.assertEquals((long)1L, (long)changes.size());
            Assert.assertEquals((Object)new AbstractChangeFinderTestCase.SimpleFileSystemItemChange(this, doc1.getId(), "documentModified"), (Object)this.toSimpleFileSystemItemChange(changes.get(0)));
            log.trace((Object)"Remove doc1 from the 'Locally Edited' collection, delete doc2 and add doc 3 to the collection");
            this.collectionManager.removeFromCollection(locallyEditedCollection, doc1, this.session);
            doc2.followTransition("delete");
            doc3 = this.session.createDocumentModel(this.folder1.getPathAsString(), "doc3", "File");
            doc3.setPropertyValue("file:content", (Serializable)new StringBlob("File content."));
            doc3 = this.session.createDocument(doc3);
            this.collectionManager.addToCollection(locallyEditedCollection, doc3, this.session);
        }
        finally {
            this.commitAndWaitForAsyncCompletion();
        }
        try {
            changes = this.getChanges(this.session.getPrincipal());
            Assert.assertEquals((long)6L, (long)changes.size());
            expectedChanges = new ArrayList();
            expectedChanges.add((AbstractChangeFinderTestCase.SimpleFileSystemItemChange)new AbstractChangeFinderTestCase.SimpleFileSystemItemChange(this, doc3.getId(), "addedToCollection"));
            expectedChanges.add(new AbstractChangeFinderTestCase.SimpleFileSystemItemChange(this, locallyEditedCollection.getId(), "documentModified"));
            expectedChanges.add(new AbstractChangeFinderTestCase.SimpleFileSystemItemChange(this, doc3.getId(), "documentCreated"));
            expectedChanges.add(new AbstractChangeFinderTestCase.SimpleFileSystemItemChange(this, doc2.getId(), "deleted"));
            expectedChanges.add(new AbstractChangeFinderTestCase.SimpleFileSystemItemChange(this, doc1.getId(), "deleted"));
            Assert.assertTrue((boolean)CollectionUtils.isEqualCollection((Collection)expectedChanges, this.toSimpleFileSystemItemChanges(changes)));
            log.trace((Object)"Unregister the 'Locally Edited' collection as a sync root");
            this.nuxeoDriveManager.unregisterSynchronizationRoot(this.session.getPrincipal(), locallyEditedCollection, this.session);
        }
        finally {
            this.commitAndWaitForAsyncCompletion();
        }
        try {
            changes = this.getChanges(this.session.getPrincipal());
            Assert.assertEquals((long)1L, (long)changes.size());
            Assert.assertEquals((Object)new AbstractChangeFinderTestCase.SimpleFileSystemItemChange(this, locallyEditedCollection.getId(), "deleted"), (Object)this.toSimpleFileSystemItemChange(changes.get(0)));
            log.trace((Object)"Register the 'Locally Edited' collection back as a sync root");
            this.nuxeoDriveManager.registerSynchronizationRoot(this.session.getPrincipal(), locallyEditedCollection, this.session);
        }
        finally {
            this.commitAndWaitForAsyncCompletion();
        }
        try {
            changes = this.getChanges(this.session.getPrincipal());
            Assert.assertEquals((long)1L, (long)changes.size());
            Assert.assertEquals((Object)new AbstractChangeFinderTestCase.SimpleFileSystemItemChange(this, locallyEditedCollection.getId(), "rootRegistered"), (Object)this.toSimpleFileSystemItemChange(changes.get(0)));
            log.trace((Object)"Delete the 'Locally Edited' collection");
            locallyEditedCollection.followTransition("delete");
        }
        finally {
            this.commitAndWaitForAsyncCompletion();
        }
        try {
            changes = this.getChanges(this.session.getPrincipal());
            Assert.assertEquals((long)1L, (long)changes.size());
            Assert.assertEquals((Object)new AbstractChangeFinderTestCase.SimpleFileSystemItemChange(this, locallyEditedCollection.getId(), "deleted"), (Object)this.toSimpleFileSystemItemChange(changes.get(0)));
        }
        finally {
            this.commitAndWaitForAsyncCompletion();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRegisterParentSyncRoot() throws Exception {
        List<FileSystemItemChange> changes;
        DocumentModel subFolder;
        try {
            subFolder = this.session.createDocument(this.session.createDocumentModel(this.folder1.getPathAsString(), "subFolder", "Folder"));
            this.nuxeoDriveManager.registerSynchronizationRoot(this.session.getPrincipal(), subFolder, this.session);
        }
        finally {
            this.commitAndWaitForAsyncCompletion();
        }
        try {
            changes = this.getChanges(this.session.getPrincipal());
            Assert.assertEquals((long)2L, (long)changes.size());
            this.nuxeoDriveManager.registerSynchronizationRoot(this.session.getPrincipal(), this.folder1, this.session);
        }
        finally {
            this.commitAndWaitForAsyncCompletion();
        }
        try {
            changes = this.getChanges(this.session.getPrincipal());
            Assert.assertEquals((long)2L, (long)changes.size());
            HashSet<AbstractChangeFinderTestCase.SimpleFileSystemItemChange> expectedChanges = new HashSet<AbstractChangeFinderTestCase.SimpleFileSystemItemChange>();
            expectedChanges.add(new AbstractChangeFinderTestCase.SimpleFileSystemItemChange(this, this.folder1.getId(), "rootRegistered", "test", "defaultSyncRootFolderItemFactory#test#" + this.folder1.getId(), "folder1"));
            expectedChanges.add(new AbstractChangeFinderTestCase.SimpleFileSystemItemChange(this, subFolder.getId(), "deleted", "test", "test#" + subFolder.getId(), "subFolder"));
            Assert.assertTrue((boolean)CollectionUtils.isEqualCollection(expectedChanges, this.toSimpleFileSystemItemChanges(changes)));
        }
        finally {
            this.commitAndWaitForAsyncCompletion();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSection() throws Exception {
        DocumentModel proxy2;
        DocumentModel proxy1;
        DocumentModel doc1;
        HashSet<AbstractChangeFinderTestCase.SimpleFileSystemItemChange> expectedChanges;
        List<FileSystemItemChange> changes;
        DocumentModel section;
        try {
            section = this.session.createDocument(this.session.createDocumentModel("/", "sectionSyncRoot", "Section"));
            this.nuxeoDriveManager.registerSynchronizationRoot(this.session.getPrincipal(), section, this.session);
        }
        finally {
            this.commitAndWaitForAsyncCompletion();
        }
        try {
            changes = this.getChanges(this.session.getPrincipal());
            Assert.assertEquals((long)2L, (long)changes.size());
            expectedChanges = new HashSet<AbstractChangeFinderTestCase.SimpleFileSystemItemChange>();
            expectedChanges.add(new AbstractChangeFinderTestCase.SimpleFileSystemItemChange(this, section.getId(), "rootRegistered", "test", "defaultSyncRootFolderItemFactory#test#" + section.getId(), "sectionSyncRoot"));
            expectedChanges.add(new AbstractChangeFinderTestCase.SimpleFileSystemItemChange(this, section.getId(), "documentCreated", "test", "defaultSyncRootFolderItemFactory#test#" + section.getId(), "sectionSyncRoot"));
            Assert.assertTrue((boolean)CollectionUtils.isEqualCollection(expectedChanges, this.toSimpleFileSystemItemChanges(changes)));
            doc1 = this.session.createDocumentModel("/folder1", "doc1", "File");
            doc1.setPropertyValue("file:content", (Serializable)new StringBlob("The content of file 1."));
            doc1 = this.session.createDocument(doc1);
            proxy1 = this.session.publishDocument(doc1, section);
            DocumentModel doc2 = this.session.createDocumentModel("/folder1", "doc2", "File");
            doc2.setPropertyValue("file:content", (Serializable)new StringBlob("The content of file 2."));
            doc2 = this.session.createDocument(doc2);
            proxy2 = this.session.publishDocument(doc2, section);
        }
        finally {
            this.commitAndWaitForAsyncCompletion();
        }
        try {
            changes = this.getChanges();
            Assert.assertEquals((long)4L, (long)changes.size());
            expectedChanges = new HashSet();
            expectedChanges.add(new AbstractChangeFinderTestCase.SimpleFileSystemItemChange(this, proxy2.getId(), "documentProxyPublished", "test", "defaultFileSystemItemFactory#test#" + proxy2.getId(), "doc2"));
            expectedChanges.add(new AbstractChangeFinderTestCase.SimpleFileSystemItemChange(this, proxy2.getId(), "documentCreated", "test", "defaultFileSystemItemFactory#test#" + proxy2.getId(), "doc2"));
            expectedChanges.add(new AbstractChangeFinderTestCase.SimpleFileSystemItemChange(this, proxy1.getId(), "documentProxyPublished", "test", "defaultFileSystemItemFactory#test#" + proxy1.getId(), "doc1"));
            expectedChanges.add(new AbstractChangeFinderTestCase.SimpleFileSystemItemChange(this, proxy1.getId(), "documentCreated", "test", "defaultFileSystemItemFactory#test#" + proxy1.getId(), "doc1"));
            Assert.assertTrue((boolean)CollectionUtils.isEqualCollection(expectedChanges, this.toSimpleFileSystemItemChanges(changes)));
            doc1.setPropertyValue("file:content", (Serializable)new StringBlob("The updated content of file 1."));
            this.session.saveDocument(doc1);
            this.session.publishDocument(doc1, section);
        }
        finally {
            this.commitAndWaitForAsyncCompletion();
        }
        try {
            changes = this.getChanges();
            Assert.assertEquals((long)1L, (long)changes.size());
            Assert.assertEquals((Object)new AbstractChangeFinderTestCase.SimpleFileSystemItemChange(this, proxy1.getId(), "documentProxyPublished", "test", "defaultFileSystemItemFactory#test#" + proxy1.getId(), "doc1"), (Object)this.toSimpleFileSystemItemChange(changes.get(0)));
        }
        finally {
            this.commitAndWaitForAsyncCompletion();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLockUnlock() throws Exception {
        List<FileSystemItemChange> changes;
        DocumentModel doc;
        try {
            log.trace((Object)"Register a sync root and create a document inside it");
            this.nuxeoDriveManager.registerSynchronizationRoot(this.session.getPrincipal(), this.folder1, this.session);
            doc = this.session.createDocumentModel("/folder1", "doc", "File");
            doc.setPropertyValue("file:content", (Serializable)new StringBlob("The file content"));
            doc = this.session.createDocument(doc);
        }
        finally {
            this.commitAndWaitForAsyncCompletion();
        }
        try {
            changes = this.getChanges(this.session.getPrincipal());
            Assert.assertEquals((long)3L, (long)changes.size());
            log.trace((Object)"Lock doc");
            this.session.setLock(doc.getRef());
        }
        finally {
            this.commitAndWaitForAsyncCompletion();
        }
        try {
            changes = this.getChanges();
            Assert.assertEquals((long)1L, (long)changes.size());
            Assert.assertEquals((Object)new AbstractChangeFinderTestCase.SimpleFileSystemItemChange(this, doc.getId(), "documentLocked", "test", "defaultFileSystemItemFactory#test#" + doc.getId(), "doc"), (Object)this.toSimpleFileSystemItemChange(changes.get(0)));
            log.trace((Object)"Unlock doc");
            this.session.removeLock(doc.getRef());
        }
        finally {
            this.commitAndWaitForAsyncCompletion();
        }
        try {
            changes = this.getChanges();
            Assert.assertEquals((long)1L, (long)changes.size());
            Assert.assertEquals((Object)new AbstractChangeFinderTestCase.SimpleFileSystemItemChange(this, doc.getId(), "documentUnlocked", "test", "defaultFileSystemItemFactory#test#" + doc.getId(), "doc"), (Object)this.toSimpleFileSystemItemChange(changes.get(0)));
        }
        finally {
            this.commitAndWaitForAsyncCompletion();
        }
    }
}

