/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.service;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.drive.service.FileSystemItemAdapterService;
import org.nuxeo.drive.service.NuxeoDriveManager;
import org.nuxeo.drive.service.SynchronizationRoots;
import org.nuxeo.ecm.collections.api.CollectionManager;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.event.EventServiceAdmin;
import org.nuxeo.ecm.core.test.CoreFeature;
import org.nuxeo.ecm.core.test.DefaultRepositoryInit;
import org.nuxeo.ecm.core.test.annotations.RepositoryConfig;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.platform.test.PlatformFeature;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.platform.userworkspace.api.UserWorkspaceService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;

@RunWith(value=FeaturesRunner.class)
@Features(value={PlatformFeature.class})
@RepositoryConfig(init=DefaultRepositoryInit.class)
@Deploy(value={"org.nuxeo.ecm.platform.userworkspace.types", "org.nuxeo.ecm.platform.userworkspace.api", "org.nuxeo.ecm.platform.userworkspace.core", "org.nuxeo.drive.core", "org.nuxeo.ecm.platform.collections.core", "org.nuxeo.ecm.platform.web.common", "org.nuxeo.ecm.core.cache", "org.nuxeo.drive.core.test:OSGI-INF/test-nuxeodrive-sync-root-cache-contrib.xml"})
public class TestNuxeoDriveManager {
    private static final Log log = LogFactory.getLog(TestNuxeoDriveManager.class);
    @Inject
    CoreSession session;
    @Inject
    CoreFeature coreFeature;
    @Inject
    NuxeoDriveManager nuxeoDriveManager;
    @Inject
    FileSystemItemAdapterService fileSystemItemAdapterService;
    @Inject
    DirectoryService directoryService;
    @Inject
    UserManager userManager;
    @Inject
    UserWorkspaceService userWorkspaceService;
    @Inject
    EventServiceAdmin eventServiceAdmin;
    protected CoreSession user1Session;
    protected CoreSession user2Session;
    protected DocumentRef user1Workspace;
    protected DocumentRef user2Workspace;
    protected DocumentModel workspace_1;
    protected DocumentModel workspace_2;
    protected DocumentModel folder_1_1;
    protected DocumentModel folder_2_1;

    @Before
    public void createUserSessionsAndFolders() throws Exception {
        try (Session userDir = this.directoryService.open("userDirectory");){
            if (userDir.getEntry("user1") != null) {
                userDir.deleteEntry("user1");
            }
            HashMap<String, Object> user1 = new HashMap<String, Object>();
            user1.put("username", "user1");
            user1.put("groups", Arrays.asList("members"));
            userDir.createEntry(user1);
            if (userDir.getEntry("user2") != null) {
                userDir.deleteEntry("user2");
            }
            HashMap<String, Object> user2 = new HashMap<String, Object>();
            user2.put("username", "user2");
            user2.put("groups", Arrays.asList("members"));
            userDir.createEntry(user2);
        }
        this.workspace_1 = this.session.createDocument(this.session.createDocumentModel("/default-domain/workspaces", "workspace-1", "Workspace"));
        this.folder_1_1 = this.session.createDocument(this.session.createDocumentModel("/default-domain/workspaces/workspace-1", "folder-1-1", "Folder"));
        this.workspace_2 = this.session.createDocument(this.session.createDocumentModel("/default-domain/workspaces", "workspace-2", "Workspace"));
        this.folder_2_1 = this.session.createDocument(this.session.createDocumentModel("/default-domain/workspaces/workspace-2", "folder-2-1", "Folder"));
        this.setPermissions(this.workspace_1, new ACE("members", "Read"));
        this.setPermissions(this.workspace_2, new ACE("members", "ReadWrite"));
        this.user1Session = this.coreFeature.openCoreSession(this.userManager.getPrincipal("user1"));
        this.user2Session = this.coreFeature.openCoreSession(this.userManager.getPrincipal("user2"));
        this.user1Workspace = this.userWorkspaceService.getCurrentUserPersonalWorkspace(this.user1Session, this.user1Session.getDocument((DocumentRef)new PathRef("/default-domain"))).getRef();
        this.user2Workspace = this.userWorkspaceService.getCurrentUserPersonalWorkspace(this.user2Session, this.user2Session.getDocument((DocumentRef)new PathRef("/default-domain"))).getRef();
    }

    @After
    public void closeSessionsAndDeleteUsers() throws Exception {
        if (this.user1Session != null) {
            this.user1Session.close();
        }
        if (this.user2Session != null) {
            this.user2Session.close();
        }
        try (Session usersDir = this.directoryService.open("userDirectory");){
            usersDir.deleteEntry("user1");
            usersDir.deleteEntry("user2");
        }
        this.nuxeoDriveManager.handleFolderDeletion((IdRef)this.doc("/").getRef());
    }

    @Test
    public void testGetSynchronizationRoots() throws Exception {
        this.nuxeoDriveManager.registerSynchronizationRoot(this.user1Session.getPrincipal(), this.user1Session.getDocument(this.user1Workspace), this.user1Session);
        this.nuxeoDriveManager.registerSynchronizationRoot(this.user1Session.getPrincipal(), this.doc(this.user1Session, "/default-domain/workspaces/workspace-2"), this.user1Session);
        Set rootRefs = this.nuxeoDriveManager.getSynchronizationRootReferences(this.user1Session);
        Assert.assertEquals((long)2L, (long)rootRefs.size());
        Assert.assertTrue((boolean)rootRefs.contains(this.user1Workspace));
        Assert.assertTrue((boolean)rootRefs.contains(new IdRef(this.user1Session.getDocument((DocumentRef)new PathRef("/default-domain/workspaces/workspace-2")).getId())));
        Map synRootMap = this.nuxeoDriveManager.getSynchronizationRoots(this.user1Session.getPrincipal());
        Set rootPaths = ((SynchronizationRoots)synRootMap.get((Object)this.session.getRepositoryName())).paths;
        Assert.assertEquals((long)2L, (long)rootPaths.size());
        Assert.assertTrue((boolean)rootPaths.contains("/default-domain/UserWorkspaces/user1"));
        Assert.assertTrue((boolean)rootPaths.contains("/default-domain/workspaces/workspace-2"));
    }

    @Test
    public void testSynchronizeRootMultiUsers() throws Exception {
        Principal user1 = this.user1Session.getPrincipal();
        Principal user2 = this.user2Session.getPrincipal();
        this.checkRootsCount(user1, 0);
        this.checkRootsCount(user2, 0);
        this.nuxeoDriveManager.registerSynchronizationRoot(this.user1Session.getPrincipal(), this.user1Session.getDocument(this.user1Workspace), this.user1Session);
        this.checkRootsCount(user1, 1);
        this.checkRootsCount(user2, 0);
        this.nuxeoDriveManager.registerSynchronizationRoot(this.user2Session.getPrincipal(), this.user2Session.getDocument(this.user2Workspace), this.user2Session);
        this.checkRootsCount(user1, 1);
        this.checkRootsCount(user2, 1);
        this.nuxeoDriveManager.registerSynchronizationRoot(this.user1Session.getPrincipal(), this.doc(this.user1Session, "/default-domain/workspaces/workspace-2"), this.user1Session);
        this.checkRootsCount(user1, 2);
        this.checkRootsCount(user2, 1);
        this.nuxeoDriveManager.registerSynchronizationRoot(this.user2Session.getPrincipal(), this.doc(this.user2Session, "/default-domain/workspaces/workspace-2/folder-2-1"), this.user2Session);
        this.checkRootsCount(user1, 2);
        this.checkRootsCount(user2, 2);
        this.nuxeoDriveManager.unregisterSynchronizationRoot(this.user1Session.getPrincipal(), this.doc(this.user1Session, "/default-domain/workspaces/workspace-2"), this.user1Session);
        this.checkRootsCount(user1, 1);
        this.checkRootsCount(user2, 2);
        this.nuxeoDriveManager.registerSynchronizationRoot(this.user1Session.getPrincipal(), this.doc(this.user1Session, "/default-domain/workspaces/workspace-2/folder-2-1"), this.user1Session);
        this.checkRootsCount(user1, 2);
        this.checkRootsCount(user2, 2);
        this.nuxeoDriveManager.unregisterSynchronizationRoot(this.user2Session.getPrincipal(), this.doc("/default-domain/workspaces/workspace-2"), this.user2Session);
        this.checkRootsCount(user1, 2);
        this.checkRootsCount(user2, 2);
        this.nuxeoDriveManager.unregisterSynchronizationRoot(this.user1Session.getPrincipal(), this.session.getDocument(this.user1Workspace), this.user1Session);
        this.checkRootsCount(user1, 1);
        this.checkRootsCount(user2, 2);
        this.nuxeoDriveManager.unregisterSynchronizationRoot(this.user1Session.getPrincipal(), this.doc("/default-domain/workspaces/workspace-2/folder-2-1"), this.user1Session);
        this.checkRootsCount(user1, 0);
        this.checkRootsCount(user2, 2);
        this.nuxeoDriveManager.registerSynchronizationRoot(this.user1Session.getPrincipal(), this.doc("/default-domain/workspaces/workspace-2/folder-2-1"), this.user1Session);
        this.checkRootsCount(user1, 1);
        this.checkRootsCount(user2, 2);
    }

    @Test
    public void testSynchronizationRootDeletion() throws Exception {
        this.eventServiceAdmin.setListenerEnabledFlag("bulkLifeCycleChangeListener", false);
        Principal user1 = this.user1Session.getPrincipal();
        Principal user2 = this.user2Session.getPrincipal();
        this.checkRootsCount(user1, 0);
        this.checkRootsCount(user2, 0);
        this.nuxeoDriveManager.registerSynchronizationRoot(user1, this.doc(this.user1Session, "/default-domain/workspaces/workspace-2"), this.user1Session);
        this.nuxeoDriveManager.registerSynchronizationRoot(user2, this.doc(this.user1Session, "/default-domain/workspaces/workspace-2/folder-2-1"), this.user1Session);
        this.checkRootsCount(user1, 1);
        this.checkRootsCount(user2, 1);
        this.session.followTransition(this.doc("/default-domain/workspaces/workspace-2/folder-2-1").getRef(), "delete");
        this.session.save();
        this.checkRootsCount(user1, 1);
        this.checkRootsCount(user2, 0);
        this.session.removeDocument(this.doc("/default-domain").getRef());
        this.session.save();
        this.checkRootsCount(user1, 0);
        this.checkRootsCount(user2, 0);
    }

    @Test
    public void testSyncRootChild() {
        Assert.assertFalse((boolean)this.isUserSubscribed("user1", this.folder_2_1));
        this.nuxeoDriveManager.registerSynchronizationRoot(this.user1Session.getPrincipal(), this.folder_2_1, this.user1Session);
        Assert.assertTrue((boolean)this.isUserSubscribed("user1", this.folder_2_1));
        this.nuxeoDriveManager.registerSynchronizationRoot(this.user1Session.getPrincipal(), this.workspace_2, this.user1Session);
        this.folder_2_1 = this.user1Session.getDocument((DocumentRef)new PathRef("/default-domain/workspaces/workspace-2/folder-2-1"));
        Assert.assertTrue((boolean)this.isUserSubscribed("user1", this.workspace_2));
        Assert.assertFalse((boolean)this.isUserSubscribed("user1", this.folder_2_1));
        this.nuxeoDriveManager.registerSynchronizationRoot(this.user1Session.getPrincipal(), this.folder_2_1, this.user1Session);
        this.folder_2_1 = this.user1Session.getDocument((DocumentRef)new PathRef("/default-domain/workspaces/workspace-2/folder-2-1"));
        Assert.assertFalse((boolean)this.isUserSubscribed("user1", this.folder_2_1));
    }

    @Test
    public void testSyncRootChildWhenBlockingInheritance() {
        DocumentModel folder_2_1_1 = this.session.createDocument(this.session.createDocumentModel("/default-domain/workspaces/workspace-2/folder-2-1", "folder_2-1-1", "Folder"));
        this.nuxeoDriveManager.registerSynchronizationRoot(this.user1Session.getPrincipal(), this.workspace_2, this.user1Session);
        this.folder_2_1 = this.session.getDocument((DocumentRef)new PathRef("/default-domain/workspaces/workspace-2/folder-2-1"));
        Assert.assertTrue((boolean)this.isUserSubscribed("user1", this.workspace_2));
        Assert.assertFalse((boolean)this.isUserSubscribed("user1", this.folder_2_1));
        Assert.assertFalse((boolean)this.isUserSubscribed("user1", folder_2_1_1));
        ACP acp = this.folder_2_1.getACP();
        ACL localACL = acp.getOrCreateACL("local");
        ArrayList<ACE> aceList = new ArrayList<ACE>();
        aceList.addAll(Arrays.asList(localACL.getACEs()));
        localACL.clear();
        aceList.add(new ACE("Everyone", "Everything", false));
        localACL.addAll(aceList);
        this.folder_2_1.setACP(acp, true);
        this.folder_2_1 = this.session.saveDocument(this.folder_2_1);
        Assert.assertFalse((boolean)this.session.hasPermission((Principal)((UserManager)Framework.getLocalService(UserManager.class)).getPrincipal("user1"), folder_2_1_1.getRef(), "ReadWrite"));
        acp = folder_2_1_1.getACP();
        localACL = acp.getOrCreateACL("local");
        localACL.add(new ACE("user1", "ReadWrite", true));
        folder_2_1_1.setACP(acp, true);
        folder_2_1_1 = this.session.saveDocument(folder_2_1_1);
        Assert.assertTrue((boolean)this.session.hasPermission((Principal)((UserManager)Framework.getLocalService(UserManager.class)).getPrincipal("user1"), folder_2_1_1.getRef(), "ReadWrite"));
        this.nuxeoDriveManager.registerSynchronizationRoot(this.user1Session.getPrincipal(), folder_2_1_1, this.user1Session);
        Assert.assertTrue((boolean)this.isUserSubscribed("user1", this.workspace_2));
        Assert.assertFalse((boolean)this.isUserSubscribed("user1", this.folder_2_1));
        Assert.assertTrue((boolean)this.isUserSubscribed("user1", folder_2_1_1));
        Principal user1 = this.user1Session.getPrincipal();
        this.checkRootsCount(user1, 2);
    }

    @Test
    public void testSyncRootCacheInvalidation() {
        Principal user1Principal = this.user1Session.getPrincipal();
        HashSet<String> expectedSyncRootPaths = new HashSet<String>();
        this.checkRoots(user1Principal, 0, expectedSyncRootPaths);
        this.nuxeoDriveManager.registerSynchronizationRoot(user1Principal, this.workspace_1, this.user1Session);
        this.nuxeoDriveManager.registerSynchronizationRoot(user1Principal, this.workspace_2, this.user1Session);
        expectedSyncRootPaths.add("/default-domain/workspaces/workspace-1");
        expectedSyncRootPaths.add("/default-domain/workspaces/workspace-2");
        this.checkRoots(user1Principal, 2, expectedSyncRootPaths);
        this.session.followTransition(this.workspace_2.getRef(), "delete");
        this.session.save();
        expectedSyncRootPaths.remove("/default-domain/workspaces/workspace-2");
        this.checkRoots(user1Principal, 1, expectedSyncRootPaths);
        this.session.followTransition(this.workspace_2.getRef(), "undelete");
        this.session.save();
        expectedSyncRootPaths.add("/default-domain/workspaces/workspace-2");
        this.checkRoots(user1Principal, 2, expectedSyncRootPaths);
        this.setPermissions(this.workspace_2, new ACE("Administrator", "Everything"), ACE.BLOCK);
        expectedSyncRootPaths.remove("/default-domain/workspaces/workspace-2");
        this.checkRoots(user1Principal, 1, expectedSyncRootPaths);
        this.resetPermissions(this.workspace_2);
        expectedSyncRootPaths.add("/default-domain/workspaces/workspace-2");
        this.checkRoots(user1Principal, 2, expectedSyncRootPaths);
        this.session.removeDocument(this.workspace_2.getRef());
        expectedSyncRootPaths.remove("/default-domain/workspaces/workspace-2");
        this.checkRoots(user1Principal, 1, expectedSyncRootPaths);
        this.nuxeoDriveManager.unregisterSynchronizationRoot(user1Principal, this.workspace_1, this.user1Session);
        expectedSyncRootPaths.remove("/default-domain/workspaces/workspace-1");
        this.checkRoots(user1Principal, 0, expectedSyncRootPaths);
    }

    @Test
    public void testSyncRootsWithPathInclusion() {
        Principal user1Principal = this.user1Session.getPrincipal();
        DocumentModel folder = this.session.createDocument(this.session.createDocumentModel("/default-domain/workspaces", "folder", "Folder"));
        DocumentModel folder1 = this.session.createDocument(this.session.createDocumentModel("/default-domain/workspaces", "folder1", "Folder"));
        this.setPermissions(folder, new ACE("members", "ReadWrite"));
        this.setPermissions(folder1, new ACE("members", "ReadWrite"));
        this.nuxeoDriveManager.registerSynchronizationRoot(user1Principal, folder, this.user1Session);
        this.nuxeoDriveManager.registerSynchronizationRoot(user1Principal, folder1, this.user1Session);
        Set syncRootrefs = this.nuxeoDriveManager.getSynchronizationRootReferences(this.user1Session);
        Assert.assertEquals((long)2L, (long)syncRootrefs.size());
        Assert.assertTrue((boolean)syncRootrefs.contains(folder.getRef()));
        Assert.assertTrue((boolean)syncRootrefs.contains(folder1.getRef()));
    }

    @Test
    public void testAddToLocallyEditedCollection() {
        DocumentModel doc1 = this.session.createDocument(this.session.createDocumentModel(this.workspace_1.getPathAsString(), "driveEditFile1", "File"));
        this.nuxeoDriveManager.addToLocallyEditedCollection(this.session, doc1);
        CollectionManager cm = (CollectionManager)Framework.getService(CollectionManager.class);
        DocumentModel userCollections = cm.getUserDefaultCollections(doc1, this.session);
        PathRef locallyEditedCollectionRef = new PathRef(userCollections.getPath().toString(), "Locally Edited");
        Assert.assertTrue((boolean)this.session.exists((DocumentRef)locallyEditedCollectionRef));
        DocumentModel locallyEditedCollection = this.session.getDocument((DocumentRef)locallyEditedCollectionRef);
        Assert.assertTrue((boolean)cm.isCollection(locallyEditedCollection));
        doc1 = this.session.getDocument(doc1.getRef());
        Assert.assertTrue((boolean)cm.isInCollection(locallyEditedCollection, doc1, this.session));
        Assert.assertTrue((boolean)this.nuxeoDriveManager.isSynchronizationRoot(this.session.getPrincipal(), locallyEditedCollection));
        DocumentModel doc2 = this.session.createDocument(this.session.createDocumentModel(this.workspace_1.getPathAsString(), "driveEditFile2", "File"));
        this.nuxeoDriveManager.addToLocallyEditedCollection(this.session, doc2);
        doc2 = this.session.getDocument(doc2.getRef());
        Assert.assertTrue((boolean)cm.isInCollection(locallyEditedCollection, doc2, this.session));
        this.nuxeoDriveManager.unregisterSynchronizationRoot(this.session.getPrincipal(), locallyEditedCollection, this.session);
        DocumentModel doc3 = this.session.createDocument(this.session.createDocumentModel(this.workspace_1.getPathAsString(), "driveEditFile3", "File"));
        this.nuxeoDriveManager.addToLocallyEditedCollection(this.session, doc3);
        doc3 = this.session.getDocument(doc3.getRef());
        Assert.assertTrue((boolean)cm.isInCollection(locallyEditedCollection, doc3, this.session));
        Assert.assertTrue((boolean)this.nuxeoDriveManager.isSynchronizationRoot(this.session.getPrincipal(), locallyEditedCollection));
    }

    @Test
    public void testChildRootRegistration() {
        log.trace((Object)"Register a folder as a sync root");
        this.nuxeoDriveManager.registerSynchronizationRoot(this.session.getPrincipal(), this.folder_1_1, this.session);
        Assert.assertTrue((boolean)this.nuxeoDriveManager.isSynchronizationRoot(this.session.getPrincipal(), this.folder_1_1));
        log.trace((Object)"Create 'Locally Edited' collection and register it as a sync root");
        CollectionManager cm = (CollectionManager)Framework.getService(CollectionManager.class);
        DocumentModel locallyEditedCollection = cm.createCollection(this.session, "Locally Edited", "Locally Edited collection", this.workspace_1.getPathAsString());
        this.nuxeoDriveManager.registerSynchronizationRoot(this.session.getPrincipal(), locallyEditedCollection, this.session);
        Assert.assertTrue((boolean)this.nuxeoDriveManager.isSynchronizationRoot(this.session.getPrincipal(), locallyEditedCollection));
        log.trace((Object)"Register a parent as a sync root, should unregister children sync roots, except for 'Locally Edited'");
        this.nuxeoDriveManager.registerSynchronizationRoot(this.session.getPrincipal(), this.workspace_1, this.session);
        Assert.assertFalse((boolean)this.nuxeoDriveManager.isSynchronizationRoot(this.session.getPrincipal(), this.folder_1_1));
        Assert.assertTrue((boolean)this.nuxeoDriveManager.isSynchronizationRoot(this.session.getPrincipal(), locallyEditedCollection));
        log.trace((Object)"Register child folder as a sync root, should have no effect");
        this.nuxeoDriveManager.registerSynchronizationRoot(this.session.getPrincipal(), this.folder_1_1, this.session);
        Assert.assertFalse((boolean)this.nuxeoDriveManager.isSynchronizationRoot(this.session.getPrincipal(), this.folder_1_1));
        log.trace((Object)"Unregister 'Locally Edited' collection");
        this.nuxeoDriveManager.unregisterSynchronizationRoot(this.session.getPrincipal(), locallyEditedCollection, this.session);
        Assert.assertFalse((boolean)this.nuxeoDriveManager.isSynchronizationRoot(this.session.getPrincipal(), locallyEditedCollection));
        log.trace((Object)"Register 'Locally Edited' collection as a sync root, should be registered");
        this.nuxeoDriveManager.registerSynchronizationRoot(this.session.getPrincipal(), locallyEditedCollection, this.session);
        Assert.assertTrue((boolean)this.nuxeoDriveManager.isSynchronizationRoot(this.session.getPrincipal(), locallyEditedCollection));
    }

    @Test
    public void testOtherUsersSyncRootFSItemId() {
        log.trace((Object)"Register a workspace as a sync root for user1");
        this.nuxeoDriveManager.registerSynchronizationRoot(this.user1Session.getPrincipal(), this.workspace_2, this.user1Session);
        log.trace((Object)"Create a test folder in sync root");
        DocumentModel testFolder = this.user1Session.createDocument(this.user1Session.createDocumentModel(this.workspace_2.getPathAsString(), "testFolder", "Folder"));
        log.trace((Object)"Register test folder as a sync root for user2");
        this.nuxeoDriveManager.registerSynchronizationRoot(this.user2Session.getPrincipal(), testFolder, this.user2Session);
        log.trace((Object)"Check FileSystemItem id for user1");
        Assert.assertEquals((Object)("defaultFileSystemItemFactory#test#" + testFolder.getId()), (Object)this.fileSystemItemAdapterService.getFileSystemItem(testFolder).getId());
        log.trace((Object)"Check FileSystemItem id for user2");
        DocumentModel testFolderUser2 = this.user2Session.getDocument(testFolder.getRef());
        Assert.assertEquals((Object)("defaultSyncRootFolderItemFactory#test#" + testFolderUser2.getId()), (Object)this.fileSystemItemAdapterService.getFileSystemItem(testFolderUser2).getId());
        log.trace((Object)"Check FileSystemItem id for user1 relaxing sync root constraint");
        String fsItemIdUser1 = this.fileSystemItemAdapterService.getFileSystemItem(testFolder, false, true).getId();
        Assert.assertEquals((Object)("test#" + testFolder.getId()), (Object)fsItemIdUser1);
        log.trace((Object)"Check FileSystemItem id for user2 relaxing sync root constraint");
        String fsItemIdUser2 = this.fileSystemItemAdapterService.getFileSystemItem(testFolderUser2, false, true).getId();
        Assert.assertEquals((Object)fsItemIdUser1, (Object)fsItemIdUser2);
    }

    @Test
    public void testSectionRegistration() {
        log.trace((Object)"Create a Section and register it as a synchronization root for user1");
        DocumentModel section = this.session.createDocument(this.session.createDocumentModel("/", "section", "Section"));
        this.nuxeoDriveManager.registerSynchronizationRoot(this.user1Session.getPrincipal(), section, this.user1Session);
        Assert.assertTrue((boolean)this.isUserSubscribed("user1", section));
    }

    protected DocumentModel doc(String path) {
        return this.doc(this.session, path);
    }

    protected DocumentModel doc(CoreSession session, String path) {
        return session.getDocument((DocumentRef)new PathRef(path));
    }

    protected void checkRootsCount(Principal principal, int expectedCount) {
        Assert.assertEquals((long)expectedCount, (long)((SynchronizationRoots)this.nuxeoDriveManager.getSynchronizationRoots((Principal)principal).get((Object)this.session.getRepositoryName())).refs.size());
    }

    protected void checkRoots(Principal principal, int expectedCount, Set<String> expectedRootPaths) {
        Map syncRoots = this.nuxeoDriveManager.getSynchronizationRoots(principal);
        Set syncRootPaths = ((SynchronizationRoots)syncRoots.get((Object)this.session.getRepositoryName())).paths;
        Assert.assertEquals((long)expectedCount, (long)syncRootPaths.size());
        for (String syncRootPath : expectedRootPaths) {
            Assert.assertTrue((boolean)syncRootPaths.contains(syncRootPath));
        }
    }

    protected boolean isUserSubscribed(String userName, DocumentModel container) {
        if (!container.hasFacet("DriveSynchronized")) {
            return false;
        }
        List subscriptions = (List)((Object)container.getPropertyValue("drv:subscriptions"));
        if (subscriptions == null) {
            return false;
        }
        for (Map subscription : subscriptions) {
            if (!userName.equals(subscription.get("username")) || !((Boolean)subscription.get("enabled")).booleanValue()) continue;
            return true;
        }
        return false;
    }

    protected void setPermissions(DocumentModel doc, ACE ... aces) {
        ACP acp = this.session.getACP(doc.getRef());
        ACL localACL = acp.getOrCreateACL("local");
        for (int i = 0; i < aces.length; ++i) {
            localACL.add(i, (Object)aces[i]);
        }
        this.session.setACP(doc.getRef(), acp, true);
        this.session.save();
    }

    protected void resetPermissions(DocumentModel doc) {
        ACP acp = this.session.getACP(doc.getRef());
        acp.getOrCreateACL("local").clear();
        this.session.setACP(doc.getRef(), acp, true);
        this.session.save();
    }
}

