/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.service.adapter;

import java.io.Serializable;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.drive.adapter.FileItem;
import org.nuxeo.drive.adapter.FileSystemItem;
import org.nuxeo.drive.adapter.FolderItem;
import org.nuxeo.drive.adapter.impl.CollectionSyncRootFolderItem;
import org.nuxeo.drive.service.FileSystemItemAdapterService;
import org.nuxeo.drive.service.FileSystemItemFactory;
import org.nuxeo.drive.service.NuxeoDriveManager;
import org.nuxeo.drive.service.impl.FileSystemItemAdapterServiceImpl;
import org.nuxeo.ecm.collections.api.CollectionManager;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.core.test.CoreFeature;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;

@RunWith(value=FeaturesRunner.class)
@Features(value={CoreFeature.class})
@Deploy(value={"org.nuxeo.drive.core", "org.nuxeo.ecm.platform.collections.core", "org.nuxeo.ecm.platform.query.api", "org.nuxeo.ecm.core.io", "org.nuxeo.ecm.core.cache", "org.nuxeo.drive.core.test:OSGI-INF/test-nuxeodrive-sync-root-cache-contrib.xml"})
public class TestCollectionSyncRootFolderItemFactory {
    private static final Log log = LogFactory.getLog(TestCollectionSyncRootFolderItemFactory.class);
    private static final String DEFAULT_FILE_SYSTEM_ITEM_ID_PREFIX = "defaultFileSystemItemFactory#test#";
    private static final String COLLECTION_SYNC_ROOT_ITEM_ID_PREFIX = "collectionSyncRootFolderItemFactory#test#";
    @Inject
    protected CoreSession session;
    @Inject
    protected CollectionManager collectionManager;
    @Inject
    protected NuxeoDriveManager nuxeoDriveManager;
    @Inject
    protected FileSystemItemAdapterService fileSystemItemAdapterService;

    @Test
    public void testFactory() throws Exception {
        FileSystemItemFactory collectionSyncRootFolderItemFactory = ((FileSystemItemAdapterServiceImpl)this.fileSystemItemAdapterService).getFileSystemItemFactory("collectionSyncRootFolderItemFactory");
        DocumentModel collection = this.collectionManager.createCollection(this.session, "testCollection", "Test collection.", "/");
        DocumentModel doc1 = this.session.createDocumentModel("/", "doc1", "File");
        doc1.setPropertyValue("dc:title", (Serializable)((Object)"doc1"));
        doc1.setPropertyValue("file:content", (Serializable)new StringBlob("Content of file 1."));
        doc1 = this.session.createDocument(doc1);
        this.collectionManager.addToCollection(collection, doc1, this.session);
        DocumentModel doc2 = this.session.createDocumentModel("/", "doc2", "File");
        doc2.setPropertyValue("dc:title", (Serializable)((Object)"doc2"));
        doc2.setPropertyValue("file:content", (Serializable)new StringBlob("Content of file 2."));
        doc2 = this.session.createDocument(doc2);
        this.collectionManager.addToCollection(collection, doc2, this.session);
        log.trace((Object)"Check document that is not a Collection");
        Assert.assertFalse((boolean)collectionSyncRootFolderItemFactory.isFileSystemItem(this.session.getRootDocument()));
        log.trace((Object)"Check Collection not registered as a sync root");
        Assert.assertFalse((boolean)collectionSyncRootFolderItemFactory.isFileSystemItem(collection));
        log.trace((Object)"Check Collection registered as a sync root");
        this.nuxeoDriveManager.registerSynchronizationRoot(this.session.getPrincipal(), collection, this.session);
        Assert.assertTrue((boolean)collectionSyncRootFolderItemFactory.isFileSystemItem(collection));
        log.trace((Object)"Adapt test collection as a FileSystemItem");
        FileSystemItem fsItem = collectionSyncRootFolderItemFactory.getFileSystemItem(collection);
        Assert.assertNotNull((Object)fsItem);
        Assert.assertTrue((boolean)(fsItem instanceof CollectionSyncRootFolderItem));
        log.trace((Object)"Check children");
        FolderItem collectionFSItem = (FolderItem)fsItem;
        List collectionChildren = collectionFSItem.getChildren();
        Assert.assertEquals((long)2L, (long)collectionChildren.size());
        FileSystemItem child1 = (FileSystemItem)collectionChildren.get(0);
        Assert.assertTrue((boolean)(child1 instanceof FileItem));
        Assert.assertEquals((Object)(DEFAULT_FILE_SYSTEM_ITEM_ID_PREFIX + doc1.getId()), (Object)child1.getId());
        Assert.assertEquals((Object)(COLLECTION_SYNC_ROOT_ITEM_ID_PREFIX + collection.getId()), (Object)child1.getParentId());
        Assert.assertEquals((Object)"doc1", (Object)child1.getName());
        FileSystemItem child2 = (FileSystemItem)collectionChildren.get(1);
        Assert.assertTrue((boolean)(child2 instanceof FileItem));
        Assert.assertEquals((Object)(DEFAULT_FILE_SYSTEM_ITEM_ID_PREFIX + doc2.getId()), (Object)child2.getId());
        Assert.assertEquals((Object)(COLLECTION_SYNC_ROOT_ITEM_ID_PREFIX + collection.getId()), (Object)child2.getParentId());
        Assert.assertEquals((Object)"doc2", (Object)child2.getName());
        log.trace((Object)"Check FolderItem#getCanScrollDescendants");
        Assert.assertFalse((boolean)collectionFSItem.getCanScrollDescendants());
        log.trace((Object)"Check descendants");
        try {
            collectionFSItem.scrollDescendants(null, 10, 1000L);
            Assert.fail((String)"Should not be able to scroll through the descendants of a CollectionSyncRootFolderItem.");
        }
        catch (UnsupportedOperationException e) {
            Assert.assertEquals((Object)"Cannot scroll through the descendants of a collection sync root folder item, please call getChildren() instead.", (Object)e.getMessage());
        }
        log.trace((Object)"Check FolderItem#getCanCreateChild");
        Assert.assertFalse((boolean)collectionFSItem.getCanCreateChild());
        log.trace((Object)"Check FolderItem#createFile");
        try {
            collectionFSItem.createFile((Blob)new StringBlob("Child file content."));
            Assert.fail((String)"Should not be able to create a file in a CollectionSyncRootFolderItem.");
        }
        catch (UnsupportedOperationException e) {
            Assert.assertEquals((Object)"Cannot create a file in a collection synchronization root.", (Object)e.getMessage());
        }
        log.trace((Object)"Check FolderItem#createFolder");
        try {
            collectionFSItem.createFolder("Child folder");
            Assert.fail((String)"Should not be able to create a folder in a CollectionSyncRootFolderItem.");
        }
        catch (UnsupportedOperationException e) {
            Assert.assertEquals((Object)"Cannot create a folder in a collection synchronization root.", (Object)e.getMessage());
        }
        log.trace((Object)"Test AbstractDocumentBackedFileSystemItem#delete");
        child1.delete();
        Assert.assertTrue((!doc1.getCurrentLifeCycleState().equals("deleted") ? 1 : 0) != 0);
        Assert.assertFalse((boolean)this.collectionManager.isInCollection(collection, doc1, this.session));
    }
}

