/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.service.adapter;

import java.io.Serializable;
import java.security.Principal;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.drive.adapter.FileItem;
import org.nuxeo.drive.adapter.FileSystemItem;
import org.nuxeo.drive.adapter.FolderItem;
import org.nuxeo.drive.adapter.RootlessItemException;
import org.nuxeo.drive.adapter.ScrollFileSystemItemList;
import org.nuxeo.drive.adapter.impl.FileSystemItemHelper;
import org.nuxeo.drive.service.FileSystemItemAdapterService;
import org.nuxeo.drive.service.FileSystemItemFactory;
import org.nuxeo.drive.service.NuxeoDriveManager;
import org.nuxeo.drive.service.VersioningFileSystemItemFactory;
import org.nuxeo.drive.service.impl.FileSystemItemAdapterServiceImpl;
import org.nuxeo.ecm.collections.api.CollectionManager;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.Lock;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.VersioningOption;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.test.CoreFeature;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.reload.ReloadService;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.LocalDeploy;
import org.nuxeo.runtime.test.runner.RuntimeHarness;
import org.nuxeo.runtime.transaction.TransactionHelper;

@RunWith(value=FeaturesRunner.class)
@Features(value={CoreFeature.class})
@Deploy(value={"org.nuxeo.drive.core", "org.nuxeo.ecm.platform.dublincore", "org.nuxeo.ecm.platform.query.api", "org.nuxeo.ecm.platform.filemanager.core", "org.nuxeo.ecm.platform.types.core", "org.nuxeo.ecm.core.io", "org.nuxeo.ecm.platform.collections.core", "org.nuxeo.ecm.webapp.base:OSGI-INF/ecm-types-contrib.xml", "org.nuxeo.runtime.reload", "org.nuxeo.ecm.core.cache", "org.nuxeo.drive.core.test:OSGI-INF/test-nuxeodrive-sync-root-cache-contrib.xml", "org.nuxeo.drive.core.test:OSGI-INF/test-nuxeodrive-descendants-scrolling-cache-contrib.xml"})
@LocalDeploy(value={"org.nuxeo.drive.core:OSGI-INF/test-nuxeodrive-types-contrib.xml"})
public class TestDefaultFileSystemItemFactory {
    private static final Log log = LogFactory.getLog(TestDefaultFileSystemItemFactory.class);
    private static final String DEFAULT_FILE_SYSTEM_ITEM_ID_PREFIX = "defaultFileSystemItemFactory#test#";
    private static final String DEFAULT_SYNC_ROOT_ITEM_ID_PREFIX = "defaultSyncRootFolderItemFactory#test#";
    private static final int VERSIONING_DELAY = 3000;
    @Inject
    protected RuntimeHarness harness;
    @Inject
    protected CoreFeature coreFeature;
    @Inject
    protected CoreSession session;
    @Inject
    protected FileSystemItemAdapterService fileSystemItemAdapterService;
    @Inject
    protected NuxeoDriveManager nuxeoDriveManager;
    @Inject
    protected CollectionManager collectionManager;
    protected Principal principal;
    protected String syncRootItemId;
    protected DocumentModel syncRootFolder;
    protected DocumentModel file;
    protected DocumentModel note;
    protected DocumentModel custom;
    protected DocumentModel folder;
    protected DocumentModel folderishFile;
    protected DocumentModel notAFileSystemItem;
    protected VersioningFileSystemItemFactory defaultFileSystemItemFactory;

    protected void maybeSleepToNextSecond() {
        this.coreFeature.getStorageConfiguration().maybeSleepToNextSecond();
    }

    @Before
    public void createTestDocs() throws Exception {
        this.principal = this.session.getPrincipal();
        this.syncRootFolder = this.session.createDocumentModel("/", "syncRoot", "Folder");
        this.syncRootFolder = this.session.createDocument(this.syncRootFolder);
        this.nuxeoDriveManager.registerSynchronizationRoot(this.principal, this.syncRootFolder, this.session);
        this.syncRootItemId = DEFAULT_SYNC_ROOT_ITEM_ID_PREFIX + this.syncRootFolder.getId();
        this.file = this.session.createDocumentModel(this.syncRootFolder.getPathAsString(), "aFile", "File");
        StringBlob blob = new StringBlob("Content of Joe's file.");
        blob.setFilename("Joe.odt");
        this.file.setPropertyValue("file:content", (Serializable)blob);
        this.file = this.session.createDocument(this.file);
        this.note = this.session.createDocumentModel(this.syncRootFolder.getPathAsString(), "aNote", "Note");
        this.note.setPropertyValue("note:note", (Serializable)((Object)"Content of Bob's note."));
        this.note = this.session.createDocument(this.note);
        this.custom = this.session.createDocumentModel(this.syncRootFolder.getPathAsString(), "aCustomDoc", "Custom");
        blob = new StringBlob("Content of Bonnie's file.");
        blob.setFilename("Bonnie's file.odt");
        this.custom.setPropertyValue("file:content", (Serializable)blob);
        this.custom = this.session.createDocument(this.custom);
        this.folder = this.session.createDocumentModel(this.syncRootFolder.getPathAsString(), "aFolder", "Folder");
        this.folder.setPropertyValue("dc:title", (Serializable)((Object)"Jack's folder"));
        this.folder = this.session.createDocument(this.folder);
        this.folderishFile = this.session.createDocumentModel(this.syncRootFolder.getPathAsString(), "aFolderishFile", "FolderishFile");
        this.folderishFile.setPropertyValue("dc:title", (Serializable)((Object)"Sarah's folderish file"));
        this.folderishFile = this.session.createDocument(this.folderishFile);
        this.notAFileSystemItem = this.session.createDocumentModel(this.syncRootFolder.getPathAsString(), "notAFileSystemItem", "NotSynchronizable");
        this.notAFileSystemItem = this.session.createDocument(this.notAFileSystemItem);
        this.session.save();
        this.defaultFileSystemItemFactory = (VersioningFileSystemItemFactory)((FileSystemItemAdapterServiceImpl)this.fileSystemItemAdapterService).getFileSystemItemFactory("defaultFileSystemItemFactory");
        Assert.assertTrue((boolean)(this.defaultFileSystemItemFactory instanceof VersioningFileSystemItemFactory));
        this.defaultFileSystemItemFactory.setVersioningDelay(3.0);
        Assert.assertEquals((double)3.0, (double)this.defaultFileSystemItemFactory.getVersioningDelay(), (double)0.01);
        Assert.assertEquals((Object)VersioningOption.MINOR, (Object)this.defaultFileSystemItemFactory.getVersioningOption());
    }

    @Test
    public void testGetFileSystemItem() throws Exception {
        Assert.assertTrue((boolean)this.defaultFileSystemItemFactory.isFileSystemItem(this.file));
        FileSystemItem fsItem = this.defaultFileSystemItemFactory.getFileSystemItem(this.file);
        Assert.assertNotNull((Object)fsItem);
        Assert.assertTrue((boolean)(fsItem instanceof FileItem));
        Assert.assertEquals((Object)(DEFAULT_FILE_SYSTEM_ITEM_ID_PREFIX + this.file.getId()), (Object)fsItem.getId());
        Assert.assertEquals((Object)this.syncRootItemId, (Object)fsItem.getParentId());
        Assert.assertEquals((Object)"Joe.odt", (Object)fsItem.getName());
        Assert.assertFalse((boolean)fsItem.isFolder());
        Assert.assertEquals((Object)"Administrator", (Object)fsItem.getCreator());
        Assert.assertEquals((Object)"Administrator", (Object)fsItem.getLastContributor());
        Blob fileItemBlob = ((FileItem)fsItem).getBlob();
        Assert.assertEquals((Object)"Joe.odt", (Object)fileItemBlob.getFilename());
        Assert.assertEquals((Object)"Content of Joe's file.", (Object)fileItemBlob.getString());
        Assert.assertTrue((boolean)this.defaultFileSystemItemFactory.isFileSystemItem(this.note));
        fsItem = this.defaultFileSystemItemFactory.getFileSystemItem(this.note);
        Assert.assertNotNull((Object)fsItem);
        Assert.assertTrue((boolean)(fsItem instanceof FileItem));
        Assert.assertEquals((Object)(DEFAULT_FILE_SYSTEM_ITEM_ID_PREFIX + this.note.getId()), (Object)fsItem.getId());
        Assert.assertEquals((Object)this.syncRootItemId, (Object)fsItem.getParentId());
        Assert.assertEquals((Object)"aNote.txt", (Object)fsItem.getName());
        Assert.assertFalse((boolean)fsItem.isFolder());
        Assert.assertEquals((Object)"Administrator", (Object)fsItem.getCreator());
        Assert.assertEquals((Object)"Administrator", (Object)fsItem.getLastContributor());
        fileItemBlob = ((FileItem)fsItem).getBlob();
        Assert.assertEquals((Object)"aNote.txt", (Object)fileItemBlob.getFilename());
        Assert.assertEquals((Object)"Content of Bob's note.", (Object)fileItemBlob.getString());
        Assert.assertTrue((boolean)this.defaultFileSystemItemFactory.isFileSystemItem(this.custom));
        fsItem = this.defaultFileSystemItemFactory.getFileSystemItem(this.custom);
        Assert.assertNotNull((Object)fsItem);
        Assert.assertTrue((boolean)(fsItem instanceof FileItem));
        Assert.assertEquals((Object)(DEFAULT_FILE_SYSTEM_ITEM_ID_PREFIX + this.custom.getId()), (Object)fsItem.getId());
        Assert.assertEquals((Object)this.syncRootItemId, (Object)fsItem.getParentId());
        Assert.assertEquals((Object)"Bonnie's file.odt", (Object)fsItem.getName());
        Assert.assertFalse((boolean)fsItem.isFolder());
        Assert.assertEquals((Object)"Administrator", (Object)fsItem.getCreator());
        Assert.assertEquals((Object)"Administrator", (Object)fsItem.getLastContributor());
        fileItemBlob = ((FileItem)fsItem).getBlob();
        Assert.assertEquals((Object)"Bonnie's file.odt", (Object)fileItemBlob.getFilename());
        Assert.assertEquals((Object)"Content of Bonnie's file.", (Object)fileItemBlob.getString());
        this.file.setPropertyValue("file:content", null);
        this.file = this.session.saveDocument(this.file);
        Assert.assertFalse((boolean)this.defaultFileSystemItemFactory.isFileSystemItem(this.file));
        fsItem = this.defaultFileSystemItemFactory.getFileSystemItem(this.file);
        Assert.assertNull((Object)fsItem);
        this.custom.followTransition("delete");
        Assert.assertFalse((boolean)this.defaultFileSystemItemFactory.isFileSystemItem(this.custom));
        Assert.assertNull((Object)this.defaultFileSystemItemFactory.getFileSystemItem(this.custom));
        Assert.assertTrue((boolean)this.defaultFileSystemItemFactory.isFileSystemItem(this.custom, true));
        fsItem = this.defaultFileSystemItemFactory.getFileSystemItem(this.custom, true);
        Assert.assertNotNull((Object)fsItem);
        Assert.assertEquals((Object)(DEFAULT_FILE_SYSTEM_ITEM_ID_PREFIX + this.custom.getId()), (Object)fsItem.getId());
        Assert.assertEquals((Object)"Bonnie's file.odt", (Object)fsItem.getName());
        DocumentRef versionRef = this.session.checkIn(this.note.getRef(), VersioningOption.MINOR, null);
        DocumentModel version = this.session.getDocument(versionRef);
        Assert.assertFalse((boolean)this.defaultFileSystemItemFactory.isFileSystemItem(version));
        DocumentModel proxy = this.session.createProxy(this.note.getRef(), this.folder.getRef());
        Assert.assertTrue((boolean)this.defaultFileSystemItemFactory.isFileSystemItem(proxy));
        this.note.addFacet("HiddenInNavigation");
        Assert.assertFalse((boolean)this.defaultFileSystemItemFactory.isFileSystemItem(this.note));
        this.note.removeFacet("HiddenInNavigation");
        Assert.assertTrue((boolean)this.defaultFileSystemItemFactory.isFileSystemItem(this.folder));
        fsItem = this.defaultFileSystemItemFactory.getFileSystemItem(this.folder);
        Assert.assertNotNull((Object)fsItem);
        Assert.assertTrue((boolean)(fsItem instanceof FolderItem));
        Assert.assertEquals((Object)(DEFAULT_FILE_SYSTEM_ITEM_ID_PREFIX + this.folder.getId()), (Object)fsItem.getId());
        Assert.assertEquals((Object)this.syncRootItemId, (Object)fsItem.getParentId());
        Assert.assertEquals((Object)"Jack's folder", (Object)fsItem.getName());
        Assert.assertTrue((boolean)fsItem.isFolder());
        Assert.assertEquals((Object)"Administrator", (Object)fsItem.getCreator());
        Assert.assertEquals((Object)"Administrator", (Object)fsItem.getLastContributor());
        FolderItem folderItem = (FolderItem)fsItem;
        List children = folderItem.getChildren();
        Assert.assertNotNull((Object)children);
        Assert.assertEquals((long)0L, (long)children.size());
        Assert.assertTrue((boolean)folderItem.getCanScrollDescendants());
        ScrollFileSystemItemList descendants = folderItem.scrollDescendants(null, 10, 1000L);
        Assert.assertNotNull((Object)descendants);
        Assert.assertNotNull((Object)descendants.getScrollId());
        Assert.assertEquals((long)0L, (long)descendants.size());
        Assert.assertTrue((boolean)this.defaultFileSystemItemFactory.isFileSystemItem(this.folderishFile));
        fsItem = this.defaultFileSystemItemFactory.getFileSystemItem(this.folderishFile);
        Assert.assertNotNull((Object)fsItem);
        Assert.assertTrue((boolean)(fsItem instanceof FolderItem));
        Assert.assertEquals((Object)(DEFAULT_FILE_SYSTEM_ITEM_ID_PREFIX + this.folderishFile.getId()), (Object)fsItem.getId());
        Assert.assertEquals((Object)this.syncRootItemId, (Object)fsItem.getParentId());
        Assert.assertEquals((Object)"Sarah's folderish file", (Object)fsItem.getName());
        Assert.assertTrue((boolean)fsItem.isFolder());
        Assert.assertEquals((Object)"Administrator", (Object)fsItem.getCreator());
        Assert.assertEquals((Object)"Administrator", (Object)fsItem.getLastContributor());
        Assert.assertFalse((boolean)this.defaultFileSystemItemFactory.isFileSystemItem(this.notAFileSystemItem));
        fsItem = this.defaultFileSystemItemFactory.getFileSystemItem(this.notAFileSystemItem);
        Assert.assertNull((Object)fsItem);
        FolderItem syncRootSystemItem = (FolderItem)this.fileSystemItemAdapterService.getFileSystemItemFactoryForId(this.syncRootItemId).getFileSystemItemById(this.syncRootItemId, this.principal);
        fsItem = this.defaultFileSystemItemFactory.getFileSystemItem(this.note, syncRootSystemItem);
        Assert.assertEquals((Object)this.syncRootItemId, (Object)fsItem.getParentId());
        fsItem = this.defaultFileSystemItemFactory.getFileSystemItem(this.note, null);
        Assert.assertNull((Object)fsItem.getParentId());
        fsItem = this.defaultFileSystemItemFactory.getFileSystemItem(this.note);
        Assert.assertTrue((boolean)fsItem.getCanRename());
        Assert.assertTrue((boolean)fsItem.getCanDelete());
        DocumentModel rootDoc = this.session.getRootDocument();
        this.setPermission(rootDoc, "joe", "Read", true);
        try (CoreSession joeSession = this.coreFeature.openCoreSession("joe");){
            this.nuxeoDriveManager.registerSynchronizationRoot(joeSession.getPrincipal(), this.syncRootFolder, this.session);
        }
        TransactionHelper.commitOrRollbackTransaction();
        TransactionHelper.startTransaction();
        joeSession = this.coreFeature.openCoreSession("joe");
        var12_12 = null;
        try {
            this.note = joeSession.getDocument(this.note.getRef());
            fsItem = this.defaultFileSystemItemFactory.getFileSystemItem(this.note);
            Assert.assertFalse((boolean)fsItem.getCanRename());
            Assert.assertFalse((boolean)fsItem.getCanDelete());
            this.setPermission(rootDoc, "joe", "Write", true);
            fsItem = this.defaultFileSystemItemFactory.getFileSystemItem(this.note);
            Assert.assertTrue((boolean)fsItem.getCanRename());
            Assert.assertTrue((boolean)fsItem.getCanDelete());
        }
        catch (Throwable throwable) {
            var12_12 = throwable;
            throw throwable;
        }
        finally {
            if (joeSession != null) {
                if (var12_12 != null) {
                    try {
                        joeSession.close();
                    }
                    catch (Throwable throwable) {
                        var12_12.addSuppressed(throwable);
                    }
                } else {
                    joeSession.close();
                }
            }
        }
        this.resetPermissions(rootDoc, "joe");
    }

    @Test
    @LocalDeploy(value={"org.nuxeo.drive.core:OSGI-INF/test-nuxeodrive-permissions-contrib.xml"})
    public void testPermissionCheckOptimized() {
        this.setPermission(this.syncRootFolder, "joe", "Read", true);
        try (CoreSession joeSession = this.coreFeature.openCoreSession("joe");){
            log.trace((Object)"Register the sync root for Joe's account");
            this.nuxeoDriveManager.registerSynchronizationRoot(joeSession.getPrincipal(), this.syncRootFolder, joeSession);
            this.folder = joeSession.getDocument(this.folder.getRef());
            log.trace((Object)"Check canDelete/canCreateChild flags on folder for user joe with Read granted on parent folder");
            FolderItem folderItem = (FolderItem)this.defaultFileSystemItemFactory.getFileSystemItem(this.folder);
            Assert.assertFalse((boolean)folderItem.getCanDelete());
            Assert.assertFalse((boolean)folderItem.getCanCreateChild());
            log.trace((Object)"Check canDelete/canCreateChild flags on folder for user joe with Write granted on folder, AddChildren not granted on folder and RemoveChildren not granted on parent folder");
            this.setPermission(this.folder, "joe", "Write", true);
            folderItem = (FolderItem)this.defaultFileSystemItemFactory.getFileSystemItem(this.folder);
            Assert.assertTrue((boolean)folderItem.getCanDelete());
            Assert.assertTrue((boolean)folderItem.getCanCreateChild());
            log.trace((Object)"Check canDelete flag on folder for user joe with Write (thus RemoveChildren) granted on parent folder");
            this.setPermission(this.syncRootFolder, "joe", "Write", true);
            folderItem = (FolderItem)this.defaultFileSystemItemFactory.getFileSystemItem(this.folder);
            Assert.assertTrue((boolean)folderItem.getCanDelete());
            log.trace((Object)"Check canCreateChild flag on folder for user joe with AddChildren granted on folder");
            this.setPermission(this.folder, "joe", "AddChildren", true);
            folderItem = (FolderItem)this.defaultFileSystemItemFactory.getFileSystemItem(this.folder);
            Assert.assertTrue((boolean)folderItem.getCanCreateChild());
        }
        this.resetPermissions(this.folder, "joe");
        this.resetPermissions(this.syncRootFolder, "joe");
    }

    @Test
    @LocalDeploy(value={"org.nuxeo.drive.core:OSGI-INF/test-nuxeodrive-permissions-contrib.xml", "org.nuxeo.drive.core:OSGI-INF/test-nuxeodrive-permission-check-not-optimized-contrib.xml"})
    public void testPermissionCheckNotOptimized() {
        this.setPermission(this.syncRootFolder, "joe", "Read", true);
        try (CoreSession joeSession = this.coreFeature.openCoreSession("joe");){
            log.trace((Object)"Register the sync root for Joe's account");
            this.nuxeoDriveManager.registerSynchronizationRoot(joeSession.getPrincipal(), this.syncRootFolder, joeSession);
            this.folder = joeSession.getDocument(this.folder.getRef());
            log.trace((Object)"Check canDelete/canCreateChild flags on folder for user joe with Read granted on parent folder");
            FolderItem folderItem = (FolderItem)this.defaultFileSystemItemFactory.getFileSystemItem(this.folder);
            Assert.assertFalse((boolean)folderItem.getCanDelete());
            Assert.assertFalse((boolean)folderItem.getCanCreateChild());
            log.trace((Object)"Check canDelete/canCreateChild flags on folder for user joe with Write granted on folder, AddChildren not granted on folder and RemoveChildren not granted on parent folder");
            this.setPermission(this.folder, "joe", "Write", true);
            folderItem = (FolderItem)this.defaultFileSystemItemFactory.getFileSystemItem(this.folder);
            Assert.assertFalse((boolean)folderItem.getCanDelete());
            Assert.assertFalse((boolean)folderItem.getCanCreateChild());
            log.trace((Object)"Check canDelete flag on folder for user joe with Write (thus RemoveChildren) granted on parent folder");
            this.setPermission(this.syncRootFolder, "joe", "Write", true);
            folderItem = (FolderItem)this.defaultFileSystemItemFactory.getFileSystemItem(this.folder);
            Assert.assertTrue((boolean)folderItem.getCanDelete());
            Assert.assertFalse((boolean)folderItem.getCanCreateChild());
            log.trace((Object)"Check canCreateChild flag on folder for user joe with AddChildren granted on folder");
            this.setPermission(this.folder, "joe", "AddChildren", true);
            folderItem = (FolderItem)this.defaultFileSystemItemFactory.getFileSystemItem(this.folder);
            Assert.assertTrue((boolean)folderItem.getCanCreateChild());
        }
        this.resetPermissions(this.folder, "joe");
        this.resetPermissions(this.syncRootFolder, "joe");
    }

    @Test
    public void testExists() throws Exception {
        try {
            this.defaultFileSystemItemFactory.exists("badId", this.principal);
            Assert.fail((String)"Should not be able to check existence for bad id.");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"FileSystemItem id badId cannot be handled by factory named defaultFileSystemItemFactory. Should match the 'fileSystemItemFactoryName#repositoryName#docId' pattern.", (Object)e.getMessage());
        }
        Assert.assertFalse((boolean)this.defaultFileSystemItemFactory.exists("defaultFileSystemItemFactory#test#nonExistentDocId", this.principal));
        Assert.assertTrue((boolean)this.defaultFileSystemItemFactory.exists(DEFAULT_FILE_SYSTEM_ITEM_ID_PREFIX + this.file.getId(), this.principal));
        Assert.assertTrue((boolean)this.defaultFileSystemItemFactory.exists(DEFAULT_FILE_SYSTEM_ITEM_ID_PREFIX + this.note.getId(), this.principal));
        Assert.assertFalse((boolean)this.defaultFileSystemItemFactory.exists(DEFAULT_FILE_SYSTEM_ITEM_ID_PREFIX + this.notAFileSystemItem.getId(), this.principal));
        this.file.followTransition("delete");
        Assert.assertFalse((boolean)this.defaultFileSystemItemFactory.exists(DEFAULT_FILE_SYSTEM_ITEM_ID_PREFIX + this.file.getId(), this.principal));
    }

    @Test
    public void testGetFileSystemItemById() throws Exception {
        Assert.assertNull((Object)this.defaultFileSystemItemFactory.getFileSystemItemById("defaultFileSystemItemFactory#test#nonExistentDocId", this.principal));
        this.file.setPropertyValue("file:content", null);
        this.file = this.session.saveDocument(this.file);
        this.session.save();
        FileSystemItem fsItem = this.defaultFileSystemItemFactory.getFileSystemItemById(DEFAULT_FILE_SYSTEM_ITEM_ID_PREFIX + this.file.getId(), this.principal);
        Assert.assertNull((Object)fsItem);
        fsItem = this.defaultFileSystemItemFactory.getFileSystemItemById(DEFAULT_FILE_SYSTEM_ITEM_ID_PREFIX + this.note.getId(), this.principal);
        Assert.assertNotNull((Object)fsItem);
        Assert.assertTrue((boolean)(fsItem instanceof FileItem));
        Assert.assertEquals((Object)(DEFAULT_FILE_SYSTEM_ITEM_ID_PREFIX + this.note.getId()), (Object)fsItem.getId());
        Assert.assertEquals((Object)this.syncRootItemId, (Object)fsItem.getParentId());
        Assert.assertEquals((Object)"aNote.txt", (Object)fsItem.getName());
        Assert.assertFalse((boolean)fsItem.isFolder());
        Blob fileItemBlob = ((FileItem)fsItem).getBlob();
        Assert.assertEquals((Object)"aNote.txt", (Object)fileItemBlob.getFilename());
        Assert.assertEquals((Object)"Content of Bob's note.", (Object)fileItemBlob.getString());
        fsItem = this.defaultFileSystemItemFactory.getFileSystemItemById(DEFAULT_FILE_SYSTEM_ITEM_ID_PREFIX + this.folder.getId(), this.principal);
        Assert.assertNotNull((Object)fsItem);
        Assert.assertTrue((boolean)(fsItem instanceof FolderItem));
        Assert.assertEquals((Object)(DEFAULT_FILE_SYSTEM_ITEM_ID_PREFIX + this.folder.getId()), (Object)fsItem.getId());
        Assert.assertEquals((Object)this.syncRootItemId, (Object)fsItem.getParentId());
        Assert.assertEquals((Object)"Jack's folder", (Object)fsItem.getName());
        Assert.assertTrue((boolean)fsItem.isFolder());
        FolderItem folderItem = (FolderItem)fsItem;
        Assert.assertTrue((boolean)folderItem.getChildren().isEmpty());
        Assert.assertTrue((boolean)folderItem.getCanScrollDescendants());
        Assert.assertTrue((boolean)folderItem.scrollDescendants(null, 10, 1000L).isEmpty());
        fsItem = this.defaultFileSystemItemFactory.getFileSystemItemById(DEFAULT_FILE_SYSTEM_ITEM_ID_PREFIX + this.notAFileSystemItem.getId(), this.principal);
        Assert.assertNull((Object)fsItem);
        this.custom.followTransition("delete");
        fsItem = this.defaultFileSystemItemFactory.getFileSystemItemById(DEFAULT_FILE_SYSTEM_ITEM_ID_PREFIX + this.custom.getId(), this.principal);
        Assert.assertNull((Object)fsItem);
        fsItem = this.defaultFileSystemItemFactory.getFileSystemItemById(DEFAULT_FILE_SYSTEM_ITEM_ID_PREFIX + this.note.getId(), this.syncRootItemId, this.principal);
        Assert.assertTrue((boolean)(fsItem instanceof FileItem));
        Assert.assertEquals((Object)(DEFAULT_FILE_SYSTEM_ITEM_ID_PREFIX + this.note.getId()), (Object)fsItem.getId());
        Assert.assertEquals((Object)this.syncRootItemId, (Object)fsItem.getParentId());
    }

    @Test
    public void testFileItem() throws Exception {
        FileItem fileItem = (FileItem)this.defaultFileSystemItemFactory.getFileSystemItem(this.file);
        String downloadURL = fileItem.getDownloadURL();
        Assert.assertEquals((Object)("nxfile/test/" + this.file.getId() + "/blobholder:0/Joe.odt"), (Object)downloadURL);
        Assert.assertEquals((Object)"MD5", (Object)fileItem.getDigestAlgorithm());
        FileItem noteItem = (FileItem)this.defaultFileSystemItemFactory.getFileSystemItem(this.note);
        Assert.assertEquals((Object)"MD5", (Object)noteItem.getDigestAlgorithm());
        Assert.assertEquals((Object)((BlobHolder)this.file.getAdapter(BlobHolder.class)).getBlob().getDigest(), (Object)fileItem.getDigest());
        String noteDigest = FileSystemItemHelper.getMD5Digest((Blob)((BlobHolder)this.note.getAdapter(BlobHolder.class)).getBlob());
        Assert.assertEquals((Object)noteDigest, (Object)noteItem.getDigest());
        Assert.assertEquals((Object)((BlobHolder)this.custom.getAdapter(BlobHolder.class)).getBlob().getDigest(), (Object)((FileItem)this.defaultFileSystemItemFactory.getFileSystemItem(this.custom)).getDigest());
        Assert.assertTrue((boolean)fileItem.getCanUpdate());
        DocumentModel rootDoc = this.session.getRootDocument();
        this.setPermission(rootDoc, "joe", "Read", true);
        try (CoreSession joeSession = this.coreFeature.openCoreSession("joe");){
            this.nuxeoDriveManager.registerSynchronizationRoot(joeSession.getPrincipal(), this.syncRootFolder, this.session);
        }
        TransactionHelper.commitOrRollbackTransaction();
        TransactionHelper.startTransaction();
        joeSession = this.coreFeature.openCoreSession("joe");
        var7_7 = null;
        try {
            this.file = joeSession.getDocument(this.file.getRef());
            fileItem = (FileItem)this.defaultFileSystemItemFactory.getFileSystemItem(this.file);
            Assert.assertFalse((boolean)fileItem.getCanUpdate());
            this.setPermission(rootDoc, "joe", "Write", true);
            fileItem = (FileItem)this.defaultFileSystemItemFactory.getFileSystemItem(this.file);
            Assert.assertTrue((boolean)fileItem.getCanUpdate());
            this.file = this.session.getDocument(this.file.getRef());
            fileItem = (FileItem)this.defaultFileSystemItemFactory.getFileSystemItem(this.file);
            Blob fileItemBlob = fileItem.getBlob();
            Assert.assertEquals((Object)"Joe.odt", (Object)fileItemBlob.getFilename());
            Assert.assertEquals((Object)"Content of Joe's file.", (Object)fileItemBlob.getString());
            this.assertVersion("0.0", this.file);
            StringBlob newBlob = new StringBlob("This is a new file.");
            newBlob.setFilename("New blob.txt");
            fileItem.setBlob((Blob)newBlob);
            this.file = this.session.getDocument(this.file.getRef());
            Blob updatedBlob = (Blob)this.file.getPropertyValue("file:content");
            Assert.assertEquals((Object)"New blob.txt", (Object)updatedBlob.getFilename());
            Assert.assertEquals((Object)"This is a new file.", (Object)updatedBlob.getString());
            this.assertVersion("0.0", this.file);
            Thread.sleep(3000L);
            newBlob.setFilename("File name modified.txt");
            fileItem.setBlob((Blob)newBlob);
            this.file = this.session.getDocument(this.file.getRef());
            updatedBlob = (Blob)this.file.getPropertyValue("file:content");
            Assert.assertEquals((Object)"File name modified.txt", (Object)updatedBlob.getFilename());
            this.assertVersion("0.1", this.file);
            List fileVersions = this.session.getVersions(this.file.getRef());
            Assert.assertEquals((long)1L, (long)fileVersions.size());
            DocumentModel lastFileVersion = (DocumentModel)fileVersions.get(0);
            Blob versionedBlob = (Blob)lastFileVersion.getPropertyValue("file:content");
            Assert.assertEquals((Object)"New blob.txt", (Object)versionedBlob.getFilename());
            this.maybeSleepToNextSecond();
            this.file = joeSession.getDocument(this.file.getRef());
            fileItem = (FileItem)this.defaultFileSystemItemFactory.getFileSystemItem(this.file);
            newBlob.setFilename("File name modified by Joe.txt");
            fileItem.setBlob((Blob)newBlob);
            this.file = this.session.getDocument(this.file.getRef());
            updatedBlob = (Blob)this.file.getPropertyValue("file:content");
            Assert.assertEquals((Object)"File name modified by Joe.txt", (Object)updatedBlob.getFilename());
            this.assertVersion("0.2", this.file);
            fileVersions = this.session.getVersions(this.file.getRef());
            Assert.assertEquals((long)2L, (long)fileVersions.size());
            lastFileVersion = (DocumentModel)fileVersions.get(1);
            versionedBlob = (Blob)lastFileVersion.getPropertyValue("file:content");
            Assert.assertEquals((Object)"File name modified.txt", (Object)versionedBlob.getFilename());
            this.file.setPropertyValue("file:filename", (Serializable)((Object)"newTitle"));
            this.session.saveDocument(this.file);
            fileItem = (FileItem)this.defaultFileSystemItemFactory.getFileSystemItem(this.file);
            fileItem.rename("Renamed file.txt");
            this.file = this.session.getDocument(this.file.getRef());
            updatedBlob = (Blob)this.file.getPropertyValue("file:content");
            Assert.assertEquals((Object)"Renamed file.txt", (Object)updatedBlob.getFilename());
            this.assertVersion("0.2", this.file);
            Thread.sleep(3000L);
            fileItem.rename("Renamed again.txt");
            this.file = this.session.getDocument(this.file.getRef());
            updatedBlob = (Blob)this.file.getPropertyValue("file:content");
            Assert.assertEquals((Object)"Renamed again.txt", (Object)updatedBlob.getFilename());
            this.assertVersion("0.3", this.file);
            fileVersions = this.session.getVersions(this.file.getRef());
            Assert.assertEquals((long)3L, (long)fileVersions.size());
            lastFileVersion = (DocumentModel)fileVersions.get(2);
            updatedBlob = (Blob)lastFileVersion.getPropertyValue("file:content");
            Assert.assertEquals((Object)"Renamed file.txt", (Object)updatedBlob.getFilename());
            this.maybeSleepToNextSecond();
            this.file = joeSession.getDocument(this.file.getRef());
            fileItem = (FileItem)this.defaultFileSystemItemFactory.getFileSystemItem(this.file);
            fileItem.rename("File renamed by Joe.txt");
            this.file = this.session.getDocument(this.file.getRef());
            updatedBlob = (Blob)this.file.getPropertyValue("file:content");
            Assert.assertEquals((Object)"File renamed by Joe.txt", (Object)updatedBlob.getFilename());
            this.assertVersion("0.4", this.file);
            fileVersions = this.session.getVersions(this.file.getRef());
            Assert.assertEquals((long)4L, (long)fileVersions.size());
            lastFileVersion = (DocumentModel)fileVersions.get(3);
            updatedBlob = (Blob)lastFileVersion.getPropertyValue("file:content");
            Assert.assertEquals((Object)"Renamed again.txt", (Object)updatedBlob.getFilename());
        }
        catch (Throwable throwable) {
            var7_7 = throwable;
            throw throwable;
        }
        finally {
            if (joeSession != null) {
                if (var7_7 != null) {
                    try {
                        joeSession.close();
                    }
                    catch (Throwable throwable) {
                        var7_7.addSuppressed(throwable);
                    }
                } else {
                    joeSession.close();
                }
            }
        }
        this.resetPermissions(rootDoc, "joe");
    }

    @Test
    public void testFolderItem() throws Exception {
        ScrollFileSystemItemList descendantsBatch;
        FolderItem folderItem = (FolderItem)this.defaultFileSystemItemFactory.getFileSystemItem(this.folder);
        Assert.assertTrue((boolean)folderItem.getCanCreateChild());
        DocumentModel rootDoc = this.session.getRootDocument();
        this.setPermission(rootDoc, "joe", "Read", true);
        TransactionHelper.commitOrRollbackTransaction();
        TransactionHelper.startTransaction();
        try (CoreSession joeSession = this.coreFeature.openCoreSession("joe");){
            this.folder = joeSession.getDocument(this.folder.getRef());
            try {
                this.defaultFileSystemItemFactory.getFileSystemItem(this.folder);
                Assert.fail((String)"Should have raised RootlessItemException as ");
            }
            catch (RootlessItemException rootlessItemException) {
                // empty catch block
            }
            this.nuxeoDriveManager.registerSynchronizationRoot(joeSession.getPrincipal(), this.syncRootFolder, this.session);
            folderItem = (FolderItem)this.defaultFileSystemItemFactory.getFileSystemItem(this.folder);
            Assert.assertFalse((boolean)folderItem.getCanCreateChild());
            this.setPermission(rootDoc, "joe", "Write", true);
            folderItem = (FolderItem)this.defaultFileSystemItemFactory.getFileSystemItem(this.folder);
            Assert.assertTrue((boolean)folderItem.getCanCreateChild());
        }
        this.resetPermissions(rootDoc, "joe");
        this.folder = this.session.getDocument(this.folder.getRef());
        folderItem = (FolderItem)this.defaultFileSystemItemFactory.getFileSystemItem(this.folder);
        StringBlob childBlob = new StringBlob("This is the Note child.");
        childBlob.setFilename("Note child.txt");
        folderItem.createFile((Blob)childBlob);
        childBlob = new StringBlob("This is the File child.");
        childBlob.setFilename("File child.odt");
        childBlob.setMimeType("application/vnd.oasis.opendocument.text");
        folderItem.createFile((Blob)childBlob);
        folderItem.createFolder("Sub-folder");
        DocumentModelList children = this.session.query(String.format("select * from Document where ecm:parentId = '%s' order by ecm:primaryType asc", this.folder.getId()));
        Assert.assertEquals((long)3L, (long)children.size());
        DocumentModel file = (DocumentModel)children.get(0);
        Assert.assertEquals((Object)"File", (Object)file.getType());
        Assert.assertEquals((Object)"File child.odt", (Object)file.getTitle());
        childBlob = (Blob)file.getPropertyValue("file:content");
        Assert.assertEquals((Object)"File child.odt", (Object)childBlob.getFilename());
        Assert.assertEquals((Object)"This is the File child.", (Object)childBlob.getString());
        DocumentModel subFolder = (DocumentModel)children.get(1);
        Assert.assertEquals((Object)"Folder", (Object)subFolder.getType());
        Assert.assertEquals((Object)"Sub-folder", (Object)subFolder.getTitle());
        DocumentModel note = (DocumentModel)children.get(2);
        Assert.assertEquals((Object)"Note", (Object)note.getType());
        Assert.assertEquals((Object)"Note child.txt", (Object)note.getTitle());
        childBlob = ((BlobHolder)note.getAdapter(BlobHolder.class)).getBlob();
        Assert.assertEquals((Object)"Note child.txt", (Object)childBlob.getFilename());
        Assert.assertEquals((Object)"This is the Note child.", (Object)childBlob.getString());
        DocumentModel adaptableChild = this.session.createDocumentModel("/syncRoot/aFolder", "adaptableChild", "File");
        StringBlob adaptableChildBlob = new StringBlob("Content of another file.");
        adaptableChildBlob.setFilename("Another file.odt");
        adaptableChild.setPropertyValue("file:content", (Serializable)adaptableChildBlob);
        adaptableChild = this.session.createDocument(adaptableChild);
        this.session.createDocument(this.session.createDocumentModel("/syncRoot/aFolder", "notAdaptableChild", "NotSynchronizable"));
        this.session.save();
        List folderChildren = folderItem.getChildren();
        Assert.assertEquals((long)4L, (long)folderChildren.size());
        boolean ordered = this.coreFeature.getStorageConfiguration().hasSubSecondResolution();
        this.checkChildren(folderChildren, this.folder.getId(), note.getId(), file.getId(), subFolder.getId(), adaptableChild.getId(), ordered);
        Assert.assertTrue((boolean)folderItem.getCanScrollDescendants());
        ScrollFileSystemItemList folderDescendants = folderItem.scrollDescendants(null, 10, 1000L);
        Assert.assertNotNull((Object)folderDescendants.getScrollId());
        Assert.assertEquals((long)4L, (long)folderDescendants.size());
        this.checkChildren((List<FileSystemItem>)folderDescendants, this.folder.getId(), note.getId(), file.getId(), subFolder.getId(), adaptableChild.getId(), false);
        folderDescendants.clear();
        int batchSize = 2;
        String scrollId = null;
        while (!(descendantsBatch = folderItem.scrollDescendants(scrollId, batchSize, 1000L)).isEmpty()) {
            Assert.assertTrue((descendantsBatch.size() > 0 ? 1 : 0) != 0);
            scrollId = descendantsBatch.getScrollId();
            folderDescendants.addAll((Collection)descendantsBatch);
        }
        Assert.assertEquals((long)4L, (long)folderDescendants.size());
        this.checkChildren((List<FileSystemItem>)folderDescendants, this.folder.getId(), note.getId(), file.getId(), subFolder.getId(), adaptableChild.getId(), false);
        try {
            folderItem.scrollDescendants(null, 10000, 1000L);
            Assert.fail((String)"Should not be able to scroll through more descendants than the maximum batch size allowed.");
        }
        catch (NuxeoException e) {
            log.trace((Object)e);
        }
    }

    @Test
    public void testSection() {
        DocumentModel section = this.session.createDocument(this.session.createDocumentModel("/", "sectionSyncRoot", "Section"));
        this.nuxeoDriveManager.registerSynchronizationRoot(this.principal, section, this.session);
        FileSystemItemFactory defaultSyncRootFolderItemFactory = ((FileSystemItemAdapterServiceImpl)this.fileSystemItemAdapterService).getFileSystemItemFactory("defaultSyncRootFolderItemFactory");
        FolderItem sectionItem = (FolderItem)defaultSyncRootFolderItemFactory.getFileSystemItem(section);
        Assert.assertNotNull((Object)sectionItem);
        Assert.assertFalse((boolean)sectionItem.getCanCreateChild());
        Assert.assertFalse((boolean)sectionItem.getCanRename());
        Assert.assertTrue((boolean)sectionItem.getCanDelete());
        this.session.publishDocument(this.file, section);
        this.session.publishDocument(this.note, section);
        this.session.save();
        List children = sectionItem.getChildren();
        Assert.assertEquals((long)2L, (long)children.size());
        FileSystemItem child = (FileSystemItem)children.get(0);
        Assert.assertFalse((boolean)child.getCanRename());
        Assert.assertFalse((boolean)child.getCanDelete());
    }

    @Test
    public void testLockedDocument() {
        this.setPermission(this.syncRootFolder, "joe", "ReadWrite", true);
        this.setPermission(this.syncRootFolder, "jack", "ReadWrite", true);
        try (CoreSession joeSession = this.coreFeature.openCoreSession("joe");){
            this.nuxeoDriveManager.registerSynchronizationRoot(joeSession.getPrincipal(), this.syncRootFolder, joeSession);
            DocumentModel joeFile = joeSession.getDocument(this.file.getRef());
            log.trace((Object)"Check readonly flags on an unlocked document");
            FileSystemItem fsItem = this.defaultFileSystemItemFactory.getFileSystemItem(joeFile);
            Assert.assertTrue((boolean)fsItem.getCanRename());
            Assert.assertTrue((boolean)fsItem.getCanDelete());
            Assert.assertTrue((boolean)((FileItem)fsItem).getCanUpdate());
            Assert.assertNull((Object)fsItem.getLockInfo());
            log.trace((Object)"Check readonly flags on an document locked by the current user");
            joeSession.setLock(joeFile.getRef());
            joeFile = joeSession.getDocument(this.file.getRef());
            fsItem = this.defaultFileSystemItemFactory.getFileSystemItem(joeFile);
            Assert.assertTrue((boolean)fsItem.getCanRename());
            Assert.assertTrue((boolean)fsItem.getCanDelete());
            Assert.assertTrue((boolean)((FileItem)fsItem).getCanUpdate());
            Lock lockInfo = fsItem.getLockInfo();
            Assert.assertNotNull((Object)lockInfo);
            Assert.assertEquals((Object)"joe", (Object)lockInfo.getOwner());
            Assert.assertNotNull((Object)lockInfo.getCreated());
            FileSystemItemFactory defaultSyncRootFolderItemFactory = ((FileSystemItemAdapterServiceImpl)this.fileSystemItemAdapterService).getFileSystemItemFactory("defaultSyncRootFolderItemFactory");
            FolderItem syncRootFolderItem = (FolderItem)defaultSyncRootFolderItemFactory.getFileSystemItem(this.syncRootFolder);
            List children = syncRootFolderItem.getChildren();
            Assert.assertEquals((long)5L, (long)children.size());
            for (FileSystemItem child : children) {
                Assert.assertNull((Object)child.getLockInfo());
            }
            children = syncRootFolderItem.scrollDescendants(null, 10, 1000L);
            Assert.assertEquals((long)5L, (long)children.size());
            for (FileSystemItem child : children) {
                Assert.assertNull((Object)child.getLockInfo());
            }
            try (CoreSession jackSession = this.coreFeature.openCoreSession("jack");){
                this.nuxeoDriveManager.registerSynchronizationRoot(jackSession.getPrincipal(), this.syncRootFolder, jackSession);
                DocumentModel jackFile = jackSession.getDocument(this.file.getRef());
                log.trace((Object)"Check readonly flags for a non administrator on a document locked by another user");
                fsItem = this.defaultFileSystemItemFactory.getFileSystemItem(jackFile);
                Assert.assertFalse((boolean)fsItem.getCanRename());
                Assert.assertFalse((boolean)fsItem.getCanDelete());
                Assert.assertFalse((boolean)((FileItem)fsItem).getCanUpdate());
                lockInfo = fsItem.getLockInfo();
                Assert.assertNotNull((Object)lockInfo);
                Assert.assertEquals((Object)"joe", (Object)lockInfo.getOwner());
                Assert.assertNotNull((Object)lockInfo.getCreated());
                log.trace((Object)"Check readonly flags for an administrator on a document locked by another user");
                fsItem = this.defaultFileSystemItemFactory.getFileSystemItem(this.file);
                Assert.assertTrue((boolean)fsItem.getCanRename());
                Assert.assertTrue((boolean)fsItem.getCanDelete());
                Assert.assertTrue((boolean)((FileItem)fsItem).getCanUpdate());
                lockInfo = fsItem.getLockInfo();
                Assert.assertNotNull((Object)lockInfo);
                Assert.assertEquals((Object)"joe", (Object)lockInfo.getOwner());
                Assert.assertNotNull((Object)lockInfo.getCreated());
                log.trace((Object)"Check readonly flags for a non administrator on an unlocked document");
                joeSession.removeLock(joeFile.getRef());
                jackFile = jackSession.getDocument(this.file.getRef());
                fsItem = this.defaultFileSystemItemFactory.getFileSystemItem(jackFile);
                Assert.assertTrue((boolean)fsItem.getCanRename());
                Assert.assertTrue((boolean)fsItem.getCanDelete());
                Assert.assertTrue((boolean)((FileItem)fsItem).getCanUpdate());
                Assert.assertNull((Object)fsItem.getLockInfo());
            }
        }
        this.resetPermissions(this.syncRootFolder, "jack");
        this.resetPermissions(this.syncRootFolder, "joe");
    }

    @Test
    public void testFolderItemChildrenPageProviderOverride() throws Exception {
        this.nuxeoDriveManager.registerSynchronizationRoot(this.session.getPrincipal(), this.syncRootFolder, this.session);
        FileSystemItemFactory defaultSyncRootFolderItemFactory = ((FileSystemItemAdapterServiceImpl)this.fileSystemItemAdapterService).getFileSystemItemFactory("defaultSyncRootFolderItemFactory");
        FolderItem syncRootFolderItem = (FolderItem)defaultSyncRootFolderItemFactory.getFileSystemItem(this.syncRootFolder);
        Assert.assertEquals((long)5L, (long)syncRootFolderItem.getChildren().size());
        this.harness.deployContrib("org.nuxeo.drive.core.test", "OSGI-INF/test-nuxeodrive-pageproviders-contrib-override.xml");
        this.reload();
        Assert.assertEquals((long)2L, (long)syncRootFolderItem.getChildren().size());
        this.harness.undeployContrib("org.nuxeo.drive.core.test", "OSGI-INF/test-nuxeodrive-pageproviders-contrib-override.xml");
        this.reload();
    }

    @Test
    public void testCollectionMembership() {
        DocumentModel doc = this.session.createDocumentModel(this.session.getRootDocument().getPathAsString(), "testDoc", "File");
        StringBlob blob = new StringBlob("Content of Joe's file.");
        blob.setFilename("Joe.odt");
        doc.setPropertyValue("file:content", (Serializable)blob);
        doc = this.session.createDocument(doc);
        log.trace((Object)"Try to adapt a document not member of any collection");
        try {
            this.defaultFileSystemItemFactory.getFileSystemItem(doc);
            Assert.fail((String)"Trying to adapt doc as a FileSystemItem should throw a RootlessItemException");
        }
        catch (RootlessItemException e) {
            log.trace((Object)e);
        }
        log.trace((Object)"Try to adapt a document member of a non sync root collection");
        DocumentModel nonSyncrootCollection = this.collectionManager.createCollection(this.session, "Non sync root collection", "", this.session.getRootDocument().getPathAsString());
        this.collectionManager.addToCollection(nonSyncrootCollection, doc, this.session);
        doc = this.session.getDocument(doc.getRef());
        try {
            this.defaultFileSystemItemFactory.getFileSystemItem(doc);
            Assert.fail((String)"Trying to adapt doc as a FileSystemItem should throw a RootlessItemException");
        }
        catch (RootlessItemException e) {
            log.trace((Object)e);
        }
        log.trace((Object)"Adapt a document member of a non sync root colllection and a sync root collection");
        DocumentModel syncRootCollection = this.collectionManager.createCollection(this.session, "Sync root collection", "", this.session.getRootDocument().getPathAsString());
        this.nuxeoDriveManager.registerSynchronizationRoot(this.principal, syncRootCollection, this.session);
        this.collectionManager.addToCollection(syncRootCollection, doc, this.session);
        doc = this.session.getDocument(doc.getRef());
        FileSystemItem fsItem = this.defaultFileSystemItemFactory.getFileSystemItem(doc);
        Assert.assertNotNull((Object)fsItem);
        log.trace((Object)"Adapt a document member of a sync root collection only");
        this.collectionManager.removeFromCollection(nonSyncrootCollection, doc, this.session);
        doc = this.session.getDocument(doc.getRef());
        Assert.assertEquals((Object)fsItem, (Object)this.defaultFileSystemItemFactory.getFileSystemItem(doc));
    }

    protected void setPermission(DocumentModel doc, String userName, String permission, boolean isGranted) {
        ACP acp = this.session.getACP(doc.getRef());
        ACL localACL = acp.getOrCreateACL("local");
        localACL.add(new ACE(userName, permission, isGranted));
        this.session.setACP(doc.getRef(), acp, true);
        this.session.save();
    }

    protected void resetPermissions(DocumentModel doc, String userName) {
        ACP acp = this.session.getACP(doc.getRef());
        ACL localACL = acp.getOrCreateACL("local");
        Iterator localACLIt = localACL.iterator();
        while (localACLIt.hasNext()) {
            ACE ace = (ACE)localACLIt.next();
            if (!userName.equals(ace.getUsername())) continue;
            localACLIt.remove();
        }
        this.session.setACP(doc.getRef(), acp, true);
        this.session.save();
    }

    protected void assertVersion(String expected, DocumentModel doc) throws Exception {
        Assert.assertEquals((Object)expected, (Object)(this.getMajor(doc) + "." + this.getMinor(doc)));
    }

    protected long getMajor(DocumentModel doc) {
        return this.getVersion(doc, "uid:major_version");
    }

    protected long getMinor(DocumentModel doc) {
        return this.getVersion(doc, "uid:minor_version");
    }

    protected long getVersion(DocumentModel doc, String prop) {
        Serializable propVal = doc.getPropertyValue(prop);
        if (propVal == null || !(propVal instanceof Long)) {
            return -1L;
        }
        return (Long)propVal;
    }

    protected void checkChildren(List<FileSystemItem> folderChildren, String folderId, String noteId, String fileId, String subFolderId, String otherFileId, boolean ordered) throws Exception {
        boolean isNoteFound = false;
        boolean isFileFound = false;
        boolean isSubFolderFound = false;
        boolean isOtherFileFound = false;
        int childrenCount = 0;
        for (FileSystemItem fsItem : folderChildren) {
            Blob fileItemBlob;
            if (!isNoteFound && (DEFAULT_FILE_SYSTEM_ITEM_ID_PREFIX + noteId).equals(fsItem.getId())) {
                if (ordered && (!ordered || childrenCount != 0)) continue;
                Assert.assertTrue((boolean)(fsItem instanceof FileItem));
                Assert.assertEquals((Object)(DEFAULT_FILE_SYSTEM_ITEM_ID_PREFIX + folderId), (Object)fsItem.getParentId());
                Assert.assertEquals((Object)"Note child.txt", (Object)fsItem.getName());
                Assert.assertFalse((boolean)fsItem.isFolder());
                fileItemBlob = ((FileItem)fsItem).getBlob();
                Assert.assertEquals((Object)"Note child.txt", (Object)fileItemBlob.getFilename());
                Assert.assertEquals((Object)"This is the Note child.", (Object)fileItemBlob.getString());
                isNoteFound = true;
                ++childrenCount;
                continue;
            }
            if (!isFileFound && (DEFAULT_FILE_SYSTEM_ITEM_ID_PREFIX + fileId).equals(fsItem.getId())) {
                if (ordered && (!ordered || childrenCount != true)) continue;
                Assert.assertTrue((boolean)(fsItem instanceof FileItem));
                Assert.assertEquals((Object)(DEFAULT_FILE_SYSTEM_ITEM_ID_PREFIX + folderId), (Object)fsItem.getParentId());
                Assert.assertEquals((Object)"File child.odt", (Object)fsItem.getName());
                Assert.assertFalse((boolean)fsItem.isFolder());
                fileItemBlob = ((FileItem)fsItem).getBlob();
                Assert.assertEquals((Object)"File child.odt", (Object)fileItemBlob.getFilename());
                Assert.assertEquals((Object)"This is the File child.", (Object)fileItemBlob.getString());
                isFileFound = true;
                ++childrenCount;
                continue;
            }
            if (!isSubFolderFound && (DEFAULT_FILE_SYSTEM_ITEM_ID_PREFIX + subFolderId).equals(fsItem.getId())) {
                if (ordered && (!ordered || childrenCount != 2)) continue;
                Assert.assertTrue((boolean)(fsItem instanceof FolderItem));
                Assert.assertEquals((Object)(DEFAULT_FILE_SYSTEM_ITEM_ID_PREFIX + folderId), (Object)fsItem.getParentId());
                Assert.assertEquals((Object)"Sub-folder", (Object)fsItem.getName());
                Assert.assertTrue((boolean)fsItem.isFolder());
                FolderItem folderItem = (FolderItem)fsItem;
                List childFolderChildren = folderItem.getChildren();
                Assert.assertNotNull((Object)childFolderChildren);
                Assert.assertEquals((long)0L, (long)childFolderChildren.size());
                Assert.assertTrue((boolean)folderItem.getCanScrollDescendants());
                ScrollFileSystemItemList childFolderDescendants = folderItem.scrollDescendants(null, 10, 1000L);
                Assert.assertNotNull((Object)childFolderDescendants);
                Assert.assertNotNull((Object)childFolderDescendants.getScrollId());
                Assert.assertEquals((long)0L, (long)childFolderDescendants.size());
                isSubFolderFound = true;
                ++childrenCount;
                continue;
            }
            if (!isOtherFileFound && (DEFAULT_FILE_SYSTEM_ITEM_ID_PREFIX + otherFileId).equals(fsItem.getId())) {
                if (ordered && (!ordered || childrenCount != 3)) continue;
                Assert.assertTrue((boolean)(fsItem instanceof FileItem));
                Assert.assertEquals((Object)(DEFAULT_FILE_SYSTEM_ITEM_ID_PREFIX + folderId), (Object)fsItem.getParentId());
                Assert.assertEquals((Object)"Another file.odt", (Object)fsItem.getName());
                Assert.assertFalse((boolean)fsItem.isFolder());
                fileItemBlob = ((FileItem)fsItem).getBlob();
                Assert.assertEquals((Object)"Another file.odt", (Object)fileItemBlob.getFilename());
                Assert.assertEquals((Object)"Content of another file.", (Object)fileItemBlob.getString());
                isOtherFileFound = true;
                ++childrenCount;
                continue;
            }
            Assert.fail((String)String.format("FileSystemItem %s doesn't match any expected.", fsItem.getId()));
        }
    }

    void reload() {
        Properties lastProps = Framework.getProperties();
        try {
            ((ReloadService)Framework.getLocalService(ReloadService.class)).reload();
        }
        finally {
            Framework.getProperties().putAll((Map<?, ?>)lastProps);
        }
    }
}

