/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.service.adapter;

import java.io.Serializable;
import java.security.Principal;
import java.util.List;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.drive.adapter.FileSystemItem;
import org.nuxeo.drive.adapter.FolderItem;
import org.nuxeo.drive.adapter.impl.DefaultSyncRootFolderItem;
import org.nuxeo.drive.adapter.impl.DefaultTopLevelFolderItem;
import org.nuxeo.drive.service.FileSystemItemAdapterService;
import org.nuxeo.drive.service.NuxeoDriveManager;
import org.nuxeo.drive.service.TopLevelFolderItemFactory;
import org.nuxeo.drive.service.impl.DefaultTopLevelFolderItemFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.impl.DocumentModelImpl;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.platform.test.PlatformFeature;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;

@RunWith(value=FeaturesRunner.class)
@Features(value={PlatformFeature.class})
@Deploy(value={"org.nuxeo.drive.core", "org.nuxeo.ecm.platform.query.api", "org.nuxeo.ecm.core.io", "org.nuxeo.ecm.core.cache", "org.nuxeo.drive.core.test:OSGI-INF/test-nuxeodrive-sync-root-cache-contrib.xml"})
public class TestDefaultTopLevelFolderItemFactory {
    @Inject
    protected CoreSession session;
    @Inject
    protected FileSystemItemAdapterService fileSystemItemAdapterService;
    @Inject
    protected NuxeoDriveManager nuxeoDriveManager;
    protected DocumentModel syncRoot1;
    protected DocumentModel syncRoot2;
    protected TopLevelFolderItemFactory defaultTopLevelFolderItemFactory;

    @Before
    public void createTestDocs() throws Exception {
        this.syncRoot1 = this.session.createDocument(this.session.createDocumentModel("/", "syncRoot1", "Folder"));
        this.syncRoot2 = this.session.createDocument(this.session.createDocumentModel("/", "syncRoot2", "Folder"));
        Principal administrator = this.session.getPrincipal();
        this.nuxeoDriveManager.registerSynchronizationRoot(administrator, this.syncRoot1, this.session);
        this.nuxeoDriveManager.registerSynchronizationRoot(administrator, this.syncRoot2, this.session);
        DocumentModel syncRoot1Child = this.session.createDocumentModel("/syncRoot1", "syncRoot1Child", "File");
        StringBlob blob = new StringBlob("Content of Joe's file.");
        blob.setFilename("Joe.odt");
        syncRoot1Child.setPropertyValue("file:content", (Serializable)blob);
        syncRoot1Child = this.session.createDocument(syncRoot1Child);
        this.session.save();
        this.defaultTopLevelFolderItemFactory = this.fileSystemItemAdapterService.getTopLevelFolderItemFactory();
        Assert.assertTrue((boolean)(this.defaultTopLevelFolderItemFactory instanceof DefaultTopLevelFolderItemFactory));
        Assert.assertEquals((Object)"Nuxeo Drive", (Object)this.defaultTopLevelFolderItemFactory.getFolderName());
    }

    @Test
    public void testFactory() throws Exception {
        FolderItem topLevelFolderItem = this.defaultTopLevelFolderItemFactory.getTopLevelFolderItem(this.session.getPrincipal());
        Assert.assertNotNull((Object)topLevelFolderItem);
        Assert.assertTrue((boolean)(topLevelFolderItem instanceof DefaultTopLevelFolderItem));
        Assert.assertTrue((boolean)topLevelFolderItem.getId().endsWith("DefaultTopLevelFolderItemFactory#"));
        Assert.assertTrue((boolean)topLevelFolderItem.getPath().endsWith("DefaultTopLevelFolderItemFactory#"));
        Assert.assertTrue((boolean)topLevelFolderItem.getPath().startsWith("/"));
        Assert.assertNull((Object)topLevelFolderItem.getParentId());
        Assert.assertEquals((Object)"Nuxeo Drive", (Object)topLevelFolderItem.getName());
        Assert.assertTrue((boolean)topLevelFolderItem.isFolder());
        Assert.assertEquals((Object)"system", (Object)topLevelFolderItem.getCreator());
        Assert.assertEquals((Object)"system", (Object)topLevelFolderItem.getLastContributor());
        Assert.assertFalse((boolean)topLevelFolderItem.getCanRename());
        try {
            topLevelFolderItem.rename("newName");
            Assert.fail((String)"Should not be able to rename the default top level folder item.");
        }
        catch (UnsupportedOperationException e) {
            Assert.assertEquals((Object)"Cannot rename a virtual folder item.", (Object)e.getMessage());
        }
        Assert.assertFalse((boolean)topLevelFolderItem.getCanDelete());
        try {
            topLevelFolderItem.delete();
            Assert.fail((String)"Should not be able to delete the default top level folder item.");
        }
        catch (UnsupportedOperationException e) {
            Assert.assertEquals((Object)"Cannot delete a virtual folder item.", (Object)e.getMessage());
        }
        Assert.assertFalse((boolean)topLevelFolderItem.canMove(null));
        try {
            topLevelFolderItem.move(null);
            Assert.fail((String)"Should not be able to move the default top level folder item.");
        }
        catch (UnsupportedOperationException e) {
            Assert.assertEquals((Object)"Cannot move a virtual folder item.", (Object)e.getMessage());
        }
        List children = topLevelFolderItem.getChildren();
        Assert.assertNotNull((Object)children);
        Assert.assertEquals((long)2L, (long)children.size());
        Assert.assertFalse((boolean)topLevelFolderItem.getCanScrollDescendants());
        try {
            topLevelFolderItem.scrollDescendants(null, 10, 1000L);
            Assert.fail((String)"Should not be able to scroll through the descendants of the default top level folder item.");
        }
        catch (UnsupportedOperationException e) {
            Assert.assertEquals((Object)"Cannot scroll through the descendants of a virtual folder item, please call getChildren() instead.", (Object)e.getMessage());
        }
        Assert.assertFalse((boolean)topLevelFolderItem.getCanCreateChild());
        for (FileSystemItem child : children) {
            Assert.assertEquals((Object)(topLevelFolderItem.getPath() + '/' + child.getId()), (Object)child.getPath());
        }
        try {
            topLevelFolderItem.createFile((Blob)new StringBlob("Child file content."));
            Assert.fail((String)"Should not be able to create a file in the default top level folder item.");
        }
        catch (UnsupportedOperationException e) {
            Assert.assertEquals((Object)"Cannot create a file in a virtual folder item.", (Object)e.getMessage());
        }
        try {
            topLevelFolderItem.createFolder("subFolder");
            Assert.fail((String)"Should not be able to create a folder in the default top level folder item.");
        }
        catch (UnsupportedOperationException e) {
            Assert.assertEquals((Object)"Cannot create a folder in a virtual folder item.", (Object)e.getMessage());
        }
        Assert.assertEquals((Object)topLevelFolderItem, (Object)this.defaultTopLevelFolderItemFactory.getVirtualFolderItem(this.session.getPrincipal()));
    }

    @Test
    public void testTopLevelFolderItemChildren() {
        FolderItem topLevelFolderItem = this.defaultTopLevelFolderItemFactory.getTopLevelFolderItem(this.session.getPrincipal());
        List children = topLevelFolderItem.getChildren();
        Assert.assertNotNull((Object)children);
        Assert.assertEquals((long)2L, (long)children.size());
        FileSystemItem firstRootAsFsItem = (FileSystemItem)children.get(0);
        Assert.assertTrue((boolean)(firstRootAsFsItem instanceof DefaultSyncRootFolderItem));
        Assert.assertEquals((Object)("defaultSyncRootFolderItemFactory#test#" + this.syncRoot1.getId()), (Object)firstRootAsFsItem.getId());
        Assert.assertTrue((boolean)firstRootAsFsItem.getParentId().endsWith("DefaultTopLevelFolderItemFactory#"));
        Assert.assertEquals((Object)"syncRoot1", (Object)firstRootAsFsItem.getName());
        Assert.assertTrue((boolean)firstRootAsFsItem.isFolder());
        Assert.assertEquals((Object)"Administrator", (Object)firstRootAsFsItem.getCreator());
        Assert.assertEquals((Object)"Administrator", (Object)firstRootAsFsItem.getLastContributor());
        Assert.assertTrue((boolean)firstRootAsFsItem.getCanRename());
        firstRootAsFsItem.rename("newName");
        Assert.assertEquals((Object)"newName", (Object)firstRootAsFsItem.getName());
        Assert.assertTrue((boolean)(firstRootAsFsItem instanceof FolderItem));
        FolderItem firstRootAsFolderItem = (FolderItem)firstRootAsFsItem;
        List childFsItemChildren = firstRootAsFolderItem.getChildren();
        Assert.assertNotNull((Object)childFsItemChildren);
        Assert.assertEquals((long)1L, (long)childFsItemChildren.size());
        Assert.assertTrue((boolean)firstRootAsFolderItem.getCanCreateChild());
        FileSystemItem secondRootAsFsItem = (FileSystemItem)children.get(1);
        Assert.assertTrue((boolean)(secondRootAsFsItem instanceof DefaultSyncRootFolderItem));
        Assert.assertEquals((Object)("defaultSyncRootFolderItemFactory#test#" + this.syncRoot2.getId()), (Object)secondRootAsFsItem.getId());
        Assert.assertTrue((boolean)secondRootAsFsItem.getParentId().endsWith("DefaultTopLevelFolderItemFactory#"));
        Assert.assertEquals((Object)"syncRoot2", (Object)secondRootAsFsItem.getName());
        Assert.assertTrue((boolean)firstRootAsFsItem.getCanDelete());
        firstRootAsFsItem.delete();
        Assert.assertFalse((boolean)this.nuxeoDriveManager.getSynchronizationRootReferences(this.session).contains(new IdRef(this.syncRoot1.getId())));
        Assert.assertFalse((boolean)firstRootAsFsItem.canMove(null));
        try {
            firstRootAsFsItem.move(null);
            Assert.fail((String)"Should not be able to move a synchronization root folder item.");
        }
        catch (UnsupportedOperationException e) {
            Assert.assertEquals((Object)"Cannot move a synchronization root folder item.", (Object)e.getMessage());
        }
    }

    @Test
    public void testFileSystemItemFactory() {
        Assert.assertEquals((Object)"org.nuxeo.drive.service.impl.DefaultTopLevelFolderItemFactory", (Object)this.defaultTopLevelFolderItemFactory.getName());
        this.defaultTopLevelFolderItemFactory.setName("testName");
        Assert.assertEquals((Object)"testName", (Object)this.defaultTopLevelFolderItemFactory.getName());
        this.defaultTopLevelFolderItemFactory.setName("org.nuxeo.drive.service.impl.DefaultTopLevelFolderItemFactory");
        DocumentModelImpl fakeDoc = new DocumentModelImpl("File");
        Assert.assertFalse((boolean)this.defaultTopLevelFolderItemFactory.isFileSystemItem((DocumentModel)fakeDoc));
        Assert.assertNull((Object)this.defaultTopLevelFolderItemFactory.getFileSystemItem((DocumentModel)fakeDoc));
        Assert.assertTrue((boolean)this.defaultTopLevelFolderItemFactory.canHandleFileSystemItemId("org.nuxeo.drive.service.impl.DefaultTopLevelFolderItemFactory#"));
        Assert.assertFalse((boolean)this.defaultTopLevelFolderItemFactory.canHandleFileSystemItemId("org.nuxeo.drive.service.impl.DefaultFileSystemItemFactory#"));
        Assert.assertTrue((boolean)this.defaultTopLevelFolderItemFactory.exists("org.nuxeo.drive.service.impl.DefaultTopLevelFolderItemFactory#", this.session.getPrincipal()));
        try {
            this.defaultTopLevelFolderItemFactory.exists("testId", this.session.getPrincipal());
            Assert.fail((String)"Should be unsupported.");
        }
        catch (UnsupportedOperationException e) {
            Assert.assertEquals((Object)"Cannot check if a file system item exists for an id that cannot be handled from factory org.nuxeo.drive.service.impl.DefaultTopLevelFolderItemFactory.", (Object)e.getMessage());
        }
        FileSystemItem topLevelFolderItem = this.defaultTopLevelFolderItemFactory.getFileSystemItemById("org.nuxeo.drive.service.impl.DefaultTopLevelFolderItemFactory#", this.session.getPrincipal());
        Assert.assertNotNull((Object)topLevelFolderItem);
        Assert.assertTrue((boolean)(topLevelFolderItem instanceof DefaultTopLevelFolderItem));
        Assert.assertNull((Object)topLevelFolderItem.getParentId());
        Assert.assertEquals((Object)"Nuxeo Drive", (Object)topLevelFolderItem.getName());
        try {
            this.defaultTopLevelFolderItemFactory.getFileSystemItemById("testId", this.session.getPrincipal());
            Assert.fail((String)"Should be unsupported.");
        }
        catch (UnsupportedOperationException e) {
            Assert.assertEquals((Object)"Cannot get the file system item for an id that cannot be handled from factory org.nuxeo.drive.service.impl.DefaultTopLevelFolderItemFactory.", (Object)e.getMessage());
        }
        topLevelFolderItem = this.defaultTopLevelFolderItemFactory.getFileSystemItemById("org.nuxeo.drive.service.impl.DefaultTopLevelFolderItemFactory#", null, this.session.getPrincipal());
        Assert.assertTrue((boolean)(topLevelFolderItem instanceof DefaultTopLevelFolderItem));
    }
}

