/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.service.adapter;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.drive.adapter.FileItem;
import org.nuxeo.drive.adapter.FileSystemItem;
import org.nuxeo.drive.adapter.FolderItem;
import org.nuxeo.drive.adapter.NuxeoDriveContribException;
import org.nuxeo.drive.service.FileSystemItemAdapterService;
import org.nuxeo.drive.service.FileSystemItemFactory;
import org.nuxeo.drive.service.NuxeoDriveManager;
import org.nuxeo.drive.service.TopLevelFolderItemFactory;
import org.nuxeo.drive.service.VersioningFileSystemItemFactory;
import org.nuxeo.drive.service.VirtualFolderItemFactory;
import org.nuxeo.drive.service.adapter.DummyFileItem;
import org.nuxeo.drive.service.adapter.DummyFileItemFactory;
import org.nuxeo.drive.service.adapter.DummyFolderItem;
import org.nuxeo.drive.service.adapter.DummyFolderItemFactory;
import org.nuxeo.drive.service.adapter.DummyTopLevelFolderItemFactory;
import org.nuxeo.drive.service.impl.DefaultFileSystemItemFactory;
import org.nuxeo.drive.service.impl.DefaultSyncRootFolderItemFactory;
import org.nuxeo.drive.service.impl.DefaultTopLevelFolderItemFactory;
import org.nuxeo.drive.service.impl.FileSystemItemAdapterServiceImpl;
import org.nuxeo.drive.service.impl.FileSystemItemFactoryDescriptor;
import org.nuxeo.drive.service.impl.FileSystemItemFactoryWrapper;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.VersioningOption;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.core.test.CoreFeature;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.reload.ReloadService;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.LocalDeploy;
import org.nuxeo.runtime.test.runner.RuntimeHarness;

@RunWith(value=FeaturesRunner.class)
@Features(value={CoreFeature.class})
@Deploy(value={"org.nuxeo.drive.core", "org.nuxeo.ecm.core.io", "org.nuxeo.runtime.reload", "org.nuxeo.ecm.core.cache", "org.nuxeo.drive.core.test:OSGI-INF/test-nuxeodrive-sync-root-cache-contrib.xml"})
@LocalDeploy(value={"org.nuxeo.drive.core:OSGI-INF/test-nuxeodrive-types-contrib.xml", "org.nuxeo.drive.core:OSGI-INF/test-nuxeodrive-adapter-service-contrib.xml"})
public class TestFileSystemItemAdapterService {
    @Inject
    protected CoreSession session;
    @Inject
    protected FileSystemItemAdapterService fileSystemItemAdapterService;
    @Inject
    protected RuntimeHarness harness;
    protected String syncRootItemId;
    protected FolderItem syncRootItem;
    protected DocumentModel file;
    protected DocumentModel folder;
    protected DocumentModel custom;
    protected DocumentModel syncRootFolder;

    @Before
    public void registerRootAndCreateSomeDocs() throws Exception {
        this.syncRootFolder = this.session.createDocumentModel("/", "syncRoot", "Folder");
        this.syncRootFolder = this.session.createDocument(this.syncRootFolder);
        NuxeoDriveManager driveManager = (NuxeoDriveManager)Framework.getLocalService(NuxeoDriveManager.class);
        driveManager.registerSynchronizationRoot(this.session.getPrincipal(), this.syncRootFolder, this.session);
        this.syncRootItem = (FolderItem)this.fileSystemItemAdapterService.getFileSystemItem(this.syncRootFolder);
        this.syncRootItemId = this.syncRootItem.getId();
        this.file = this.session.createDocumentModel(this.syncRootFolder.getPathAsString(), "aFile", "File");
        this.file.setPropertyValue("dc:creator", (Serializable)((Object)"Joe"));
        this.file.setPropertyValue("dc:lastContributor", (Serializable)((Object)"Joe"));
        StringBlob blob = new StringBlob("Content of Joe's file.");
        blob.setFilename("Joe's file.txt");
        this.file.setPropertyValue("file:content", (Serializable)blob);
        this.file = this.session.createDocument(this.file);
        this.folder = this.session.createDocumentModel(this.syncRootFolder.getPathAsString(), "aFolder", "Folder");
        this.folder.setPropertyValue("dc:title", (Serializable)((Object)"Jack's folder"));
        this.folder.setPropertyValue("dc:creator", (Serializable)((Object)"Jack"));
        this.folder.setPropertyValue("dc:lastContributor", (Serializable)((Object)"Jack"));
        this.folder = this.session.createDocument(this.folder);
        this.custom = this.session.createDocumentModel(this.syncRootFolder.getPathAsString(), "aCustom", "Custom");
        this.custom.setPropertyValue("dc:creator", (Serializable)((Object)"Bonnie"));
        this.custom.setPropertyValue("dc:lastContributor", (Serializable)((Object)"Bonnie"));
        blob = new StringBlob("Content of the custom document's blob.");
        blob.setFilename("Bonnie's file.txt");
        this.custom.setPropertyValue("file:content", (Serializable)blob);
        this.custom = this.session.createDocument(this.custom);
        this.session.save();
    }

    @Test
    public void testService() throws Exception {
        Map fileSystemItemFactoryDescs = ((FileSystemItemAdapterServiceImpl)this.fileSystemItemAdapterService).getFileSystemItemFactoryDescriptors();
        Assert.assertNotNull((Object)fileSystemItemFactoryDescs);
        Assert.assertEquals((long)12L, (long)fileSystemItemFactoryDescs.size());
        FileSystemItemFactoryDescriptor desc = (FileSystemItemFactoryDescriptor)fileSystemItemFactoryDescs.get("defaultSyncRootFolderItemFactory");
        Assert.assertNotNull((Object)desc);
        Assert.assertEquals((long)10L, (long)desc.getOrder());
        Assert.assertEquals((Object)"defaultSyncRootFolderItemFactory", (Object)desc.getName());
        Assert.assertNull((Object)desc.getDocType());
        Assert.assertEquals((Object)"DriveSynchronized", (Object)desc.getFacet());
        FileSystemItemFactory factory = desc.getFactory();
        Assert.assertTrue((boolean)(factory instanceof DefaultSyncRootFolderItemFactory));
        desc = (FileSystemItemFactoryDescriptor)fileSystemItemFactoryDescs.get("dummyDocTypeFactory");
        Assert.assertNotNull((Object)desc);
        Assert.assertEquals((long)20L, (long)desc.getOrder());
        Assert.assertEquals((Object)"dummyDocTypeFactory", (Object)desc.getName());
        Assert.assertEquals((Object)"File", (Object)desc.getDocType());
        Assert.assertNull((Object)desc.getFacet());
        factory = desc.getFactory();
        Assert.assertTrue((boolean)(factory instanceof DummyFileItemFactory));
        Assert.assertTrue((boolean)(factory instanceof VersioningFileSystemItemFactory));
        Assert.assertEquals((double)2.0, (double)((VersioningFileSystemItemFactory)factory).getVersioningDelay(), (double)0.01);
        Assert.assertEquals((Object)VersioningOption.MINOR, (Object)((VersioningFileSystemItemFactory)factory).getVersioningOption());
        desc = (FileSystemItemFactoryDescriptor)fileSystemItemFactoryDescs.get("dummyFacetFactory");
        Assert.assertNotNull((Object)desc);
        Assert.assertEquals((long)30L, (long)desc.getOrder());
        Assert.assertEquals((Object)"dummyFacetFactory", (Object)desc.getName());
        Assert.assertNull((Object)desc.getDocType());
        Assert.assertEquals((Object)"Folderish", (Object)desc.getFacet());
        factory = desc.getFactory();
        Assert.assertTrue((boolean)(factory instanceof DummyFolderItemFactory));
        desc = (FileSystemItemFactoryDescriptor)fileSystemItemFactoryDescs.get("defaultFileSystemItemFactory");
        Assert.assertNotNull((Object)desc);
        Assert.assertEquals((long)50L, (long)desc.getOrder());
        Assert.assertEquals((Object)"defaultFileSystemItemFactory", (Object)desc.getName());
        Assert.assertNull((Object)desc.getDocType());
        Assert.assertNull((Object)desc.getFacet());
        factory = desc.getFactory();
        Assert.assertTrue((boolean)(factory instanceof DefaultFileSystemItemFactory));
        Assert.assertTrue((boolean)(factory instanceof VersioningFileSystemItemFactory));
        Assert.assertEquals((double)3600.0, (double)((VersioningFileSystemItemFactory)factory).getVersioningDelay(), (double)0.01);
        Assert.assertEquals((Object)VersioningOption.MINOR, (Object)((VersioningFileSystemItemFactory)factory).getVersioningOption());
        desc = (FileSystemItemFactoryDescriptor)fileSystemItemFactoryDescs.get("dummyVirtualFolderItemFactory");
        Assert.assertNotNull((Object)desc);
        Assert.assertEquals((long)100L, (long)desc.getOrder());
        Assert.assertEquals((Object)"dummyVirtualFolderItemFactory", (Object)desc.getName());
        Assert.assertNull((Object)desc.getDocType());
        Assert.assertNull((Object)desc.getFacet());
        factory = desc.getFactory();
        Assert.assertTrue((boolean)(factory instanceof VirtualFolderItemFactory));
        Assert.assertEquals((Object)"Dummy Folder", (Object)((VirtualFolderItemFactory)factory).getFolderName());
        desc = (FileSystemItemFactoryDescriptor)fileSystemItemFactoryDescs.get("nullMergeTestFactory");
        Assert.assertNotNull((Object)desc);
        Assert.assertEquals((long)200L, (long)desc.getOrder());
        Assert.assertEquals((Object)"nullMergeTestFactory", (Object)desc.getName());
        Assert.assertEquals((Object)"Note", (Object)desc.getDocType());
        Assert.assertNull((Object)desc.getFacet());
        factory = desc.getFactory();
        Assert.assertTrue((boolean)(factory instanceof DummyFileItemFactory));
        List fileSystemItemFactories = ((FileSystemItemAdapterServiceImpl)this.fileSystemItemAdapterService).getFileSystemItemFactories();
        Assert.assertNotNull((Object)fileSystemItemFactories);
        Assert.assertEquals((long)7L, (long)fileSystemItemFactories.size());
        FileSystemItemFactoryWrapper factoryWrapper = (FileSystemItemFactoryWrapper)fileSystemItemFactories.get(0);
        Assert.assertNotNull((Object)factoryWrapper);
        Assert.assertNull((Object)factoryWrapper.getDocType());
        Assert.assertEquals((Object)"Collection", (Object)factoryWrapper.getFacet());
        Assert.assertTrue((boolean)factoryWrapper.getFactory().getClass().getName().endsWith("CollectionSyncRootFolderItemFactory"));
        factoryWrapper = (FileSystemItemFactoryWrapper)fileSystemItemFactories.get(1);
        Assert.assertNotNull((Object)factoryWrapper);
        Assert.assertNull((Object)factoryWrapper.getDocType());
        Assert.assertEquals((Object)"DriveSynchronized", (Object)factoryWrapper.getFacet());
        Assert.assertTrue((boolean)factoryWrapper.getFactory().getClass().getName().endsWith("DefaultSyncRootFolderItemFactory"));
        factoryWrapper = (FileSystemItemFactoryWrapper)fileSystemItemFactories.get(2);
        Assert.assertNotNull((Object)factoryWrapper);
        Assert.assertEquals((Object)"File", (Object)factoryWrapper.getDocType());
        Assert.assertNull((Object)factoryWrapper.getFacet());
        Assert.assertTrue((boolean)factoryWrapper.getFactory().getClass().getName().endsWith("DummyFileItemFactory"));
        factoryWrapper = (FileSystemItemFactoryWrapper)fileSystemItemFactories.get(3);
        Assert.assertNotNull((Object)factoryWrapper);
        Assert.assertNull((Object)factoryWrapper.getDocType());
        Assert.assertEquals((Object)"Folderish", (Object)factoryWrapper.getFacet());
        Assert.assertTrue((boolean)factoryWrapper.getFactory().getClass().getName().endsWith("DummyFolderItemFactory"));
        factoryWrapper = (FileSystemItemFactoryWrapper)fileSystemItemFactories.get(4);
        Assert.assertNotNull((Object)factoryWrapper);
        Assert.assertNull((Object)factoryWrapper.getDocType());
        Assert.assertNull((Object)factoryWrapper.getFacet());
        Assert.assertTrue((boolean)factoryWrapper.getFactory().getClass().getName().endsWith("DefaultFileSystemItemFactory"));
        factoryWrapper = (FileSystemItemFactoryWrapper)fileSystemItemFactories.get(5);
        Assert.assertNotNull((Object)factoryWrapper);
        Assert.assertNull((Object)factoryWrapper.getDocType());
        Assert.assertNull((Object)factoryWrapper.getFacet());
        Assert.assertTrue((boolean)factoryWrapper.getFactory().getClass().getName().endsWith("DummyVirtualFolderItemFactory"));
        factoryWrapper = (FileSystemItemFactoryWrapper)fileSystemItemFactories.get(6);
        Assert.assertNotNull((Object)factoryWrapper);
        Assert.assertEquals((Object)"Note", (Object)factoryWrapper.getDocType());
        Assert.assertNull((Object)factoryWrapper.getFacet());
        Assert.assertTrue((boolean)factoryWrapper.getFactory().getClass().getName().endsWith("DummyFileItemFactory"));
        FileSystemItem fsItem = this.fileSystemItemAdapterService.getFileSystemItem(this.file);
        Assert.assertNotNull((Object)fsItem);
        Assert.assertTrue((boolean)(fsItem instanceof DummyFileItem));
        Assert.assertEquals((Object)("dummyDocTypeFactory#test#" + this.file.getId()), (Object)fsItem.getId());
        Assert.assertEquals((Object)this.syncRootItemId, (Object)fsItem.getParentId());
        Assert.assertEquals((Object)("Dummy file with id " + this.file.getId()), (Object)fsItem.getName());
        Assert.assertFalse((boolean)fsItem.isFolder());
        Assert.assertEquals((Object)"Joe", (Object)fsItem.getCreator());
        Assert.assertEquals((Object)"Joe", (Object)fsItem.getLastContributor());
        fsItem = this.fileSystemItemAdapterService.getFileSystemItem(this.folder);
        Assert.assertNotNull((Object)fsItem);
        Assert.assertTrue((boolean)(fsItem instanceof DummyFolderItem));
        Assert.assertTrue((boolean)((FolderItem)fsItem).getCanCreateChild());
        Assert.assertEquals((Object)("dummyFacetFactory#test#" + this.folder.getId()), (Object)fsItem.getId());
        Assert.assertEquals((Object)this.syncRootItemId, (Object)fsItem.getParentId());
        Assert.assertEquals((Object)("Dummy folder with id " + this.folder.getId()), (Object)fsItem.getName());
        Assert.assertTrue((boolean)fsItem.isFolder());
        Assert.assertEquals((Object)"Jack", (Object)fsItem.getCreator());
        Assert.assertEquals((Object)"Jack", (Object)fsItem.getLastContributor());
        fsItem = this.fileSystemItemAdapterService.getFileSystemItem(this.custom);
        Assert.assertNotNull((Object)fsItem);
        Assert.assertTrue((boolean)(fsItem instanceof FileItem));
        Assert.assertEquals((Object)("defaultFileSystemItemFactory#test#" + this.custom.getId()), (Object)fsItem.getId());
        Assert.assertEquals((Object)("/org.nuxeo.drive.service.impl.DefaultTopLevelFolderItemFactory#/" + this.syncRootItemId + "/" + fsItem.getId()), (Object)fsItem.getPath());
        Assert.assertEquals((Object)this.syncRootItemId, (Object)fsItem.getParentId());
        Assert.assertEquals((Object)"Bonnie's file.txt", (Object)fsItem.getName());
        Assert.assertFalse((boolean)fsItem.isFolder());
        Assert.assertEquals((Object)"Bonnie", (Object)fsItem.getCreator());
        Assert.assertEquals((Object)"Bonnie", (Object)fsItem.getLastContributor());
        Blob fileFsItemBlob = ((FileItem)fsItem).getBlob();
        Assert.assertEquals((Object)"Bonnie's file.txt", (Object)fileFsItemBlob.getFilename());
        Assert.assertEquals((Object)"Content of the custom document's blob.", (Object)fileFsItemBlob.getString());
        fsItem = this.fileSystemItemAdapterService.getFileSystemItem(this.custom, false, true);
        Assert.assertNotNull((Object)fsItem);
        Assert.assertEquals((Object)("test#" + this.custom.getId()), (Object)fsItem.getId());
        fsItem = this.fileSystemItemAdapterService.getFileSystemItem(this.file, this.syncRootItem);
        Assert.assertNotNull((Object)fsItem);
        Assert.assertEquals((Object)this.syncRootItemId, (Object)fsItem.getParentId());
        String fsItemId = "defaultFileSystemItemFactory#test#someId";
        FileSystemItemFactory fsItemFactory = this.fileSystemItemAdapterService.getFileSystemItemFactoryForId(fsItemId);
        Assert.assertNotNull((Object)fsItemFactory);
        Assert.assertEquals((Object)"defaultFileSystemItemFactory", (Object)fsItemFactory.getName());
        Assert.assertTrue((boolean)fsItemFactory.getClass().getName().endsWith("DefaultFileSystemItemFactory"));
        Assert.assertTrue((boolean)fsItemFactory.canHandleFileSystemItemId(fsItemId));
        fsItemId = "org.nuxeo.drive.service.impl.DefaultTopLevelFolderItemFactory#";
        fsItemFactory = this.fileSystemItemAdapterService.getFileSystemItemFactoryForId(fsItemId);
        Assert.assertNotNull((Object)fsItemFactory);
        Assert.assertTrue((boolean)fsItemFactory.getName().endsWith("DefaultTopLevelFolderItemFactory"));
        Assert.assertTrue((boolean)fsItemFactory.getClass().getName().endsWith("DefaultTopLevelFolderItemFactory"));
        Assert.assertTrue((boolean)fsItemFactory.canHandleFileSystemItemId(fsItemId));
        fsItemId = "dummyDocTypeFactory#test#someId";
        try {
            this.fileSystemItemAdapterService.getFileSystemItemFactoryForId(fsItemId);
            Assert.fail((String)"No fileSystemItemFactory should be found FileSystemItem id.");
        }
        catch (NuxeoDriveContribException e) {
            Assert.assertEquals((Object)"No fileSystemItemFactory found for FileSystemItem with id dummyDocTypeFactory#test#someId. Please check the contributions to the following extension point: <extension target=\"org.nuxeo.drive.service.FileSystemItemAdapterService\" point=\"fileSystemItemFactory\"> and make sure there is at least one defining a FileSystemItemFactory class for which the #canHandleFileSystemItemId(String id) method returns true.", (Object)e.getMessage());
        }
        fsItemId = "nonParsableId";
        try {
            this.fileSystemItemAdapterService.getFileSystemItemFactoryForId(fsItemId);
            Assert.fail((String)"No fileSystemItemFactory should be found for FileSystemItem id.");
        }
        catch (NuxeoDriveContribException e) {
            Assert.assertEquals((Object)"No fileSystemItemFactory found for FileSystemItem with id nonParsableId. Please check the contributions to the following extension point: <extension target=\"org.nuxeo.drive.service.FileSystemItemAdapterService\" point=\"fileSystemItemFactory\"> and make sure there is at least one defining a FileSystemItemFactory class for which the #canHandleFileSystemItemId(String id) method returns true.", (Object)e.getMessage());
        }
        fsItemId = "nonExistentFactoryName#test#someId";
        try {
            this.fileSystemItemAdapterService.getFileSystemItemFactoryForId(fsItemId);
            Assert.fail((String)"No fileSystemItemFactory should be found for FileSystemItem id.");
        }
        catch (NuxeoDriveContribException e) {
            Assert.assertEquals((Object)"No fileSystemItemFactory found for FileSystemItem with id nonExistentFactoryName#test#someId. Please check the contributions to the following extension point: <extension target=\"org.nuxeo.drive.service.FileSystemItemAdapterService\" point=\"fileSystemItemFactory\"> and make sure there is at least one defining a FileSystemItemFactory class for which the #canHandleFileSystemItemId(String id) method returns true.", (Object)e.getMessage());
        }
        TopLevelFolderItemFactory topLevelFactory = this.fileSystemItemAdapterService.getTopLevelFolderItemFactory();
        Assert.assertNotNull((Object)topLevelFactory);
        Assert.assertTrue((boolean)topLevelFactory.getClass().getName().endsWith("DefaultTopLevelFolderItemFactory"));
        Assert.assertTrue((boolean)(topLevelFactory instanceof DefaultTopLevelFolderItemFactory));
        try {
            this.fileSystemItemAdapterService.getVirtualFolderItemFactory("nonExistentFactory");
            Assert.fail((String)"No VirtualFolderItemFactory should be found for factory name.");
        }
        catch (NuxeoDriveContribException e) {
            Assert.assertEquals((Object)"No factory named nonExistentFactory. Please check the contributions to the following extension point: <extension target=\"org.nuxeo.drive.service.FileSystemItemAdapterService\" point=\"fileSystemItemFactory\">.", (Object)e.getMessage());
        }
        try {
            this.fileSystemItemAdapterService.getVirtualFolderItemFactory("defaultFileSystemItemFactory");
            Assert.fail((String)"No VirtualFolderItemFactory should be found for factory name.");
        }
        catch (NuxeoDriveContribException e) {
            Assert.assertEquals((Object)"Factory class org.nuxeo.drive.service.impl.DefaultFileSystemItemFactory for factory defaultFileSystemItemFactory is not a VirtualFolderItemFactory.", (Object)e.getMessage());
        }
        VirtualFolderItemFactory virtualFolderItemFactory = this.fileSystemItemAdapterService.getVirtualFolderItemFactory("dummyVirtualFolderItemFactory");
        Assert.assertNotNull((Object)virtualFolderItemFactory);
        Assert.assertTrue((boolean)virtualFolderItemFactory.getClass().getName().endsWith("DummyVirtualFolderItemFactory"));
        Set activeFactories = this.fileSystemItemAdapterService.getActiveFileSystemItemFactories();
        Assert.assertEquals((long)7L, (long)activeFactories.size());
        Assert.assertTrue((boolean)activeFactories.contains("collectionSyncRootFolderItemFactory"));
        Assert.assertTrue((boolean)activeFactories.contains("defaultSyncRootFolderItemFactory"));
        Assert.assertTrue((boolean)activeFactories.contains("defaultFileSystemItemFactory"));
        Assert.assertTrue((boolean)activeFactories.contains("dummyDocTypeFactory"));
        Assert.assertTrue((boolean)activeFactories.contains("dummyFacetFactory"));
        Assert.assertTrue((boolean)activeFactories.contains("dummyVirtualFolderItemFactory"));
        Assert.assertTrue((boolean)activeFactories.contains("nullMergeTestFactory"));
    }

    @Test
    public void testContribOverride() throws Exception {
        this.harness.deployContrib("org.nuxeo.drive.core.test", "OSGI-INF/test-nuxeodrive-adapter-service-contrib-override.xml");
        this.reload();
        this.syncRootItem = (FolderItem)this.fileSystemItemAdapterService.getFileSystemItem(this.syncRootFolder);
        this.syncRootItemId = this.syncRootItem.getId();
        Map fileSystemItemFactoryDescs = ((FileSystemItemAdapterServiceImpl)this.fileSystemItemAdapterService).getFileSystemItemFactoryDescriptors();
        Assert.assertNotNull((Object)fileSystemItemFactoryDescs);
        Assert.assertEquals((long)12L, (long)fileSystemItemFactoryDescs.size());
        FileSystemItemFactoryDescriptor desc = (FileSystemItemFactoryDescriptor)fileSystemItemFactoryDescs.get("defaultSyncRootFolderItemFactory");
        Assert.assertNotNull((Object)desc);
        Assert.assertEquals((long)10L, (long)desc.getOrder());
        Assert.assertEquals((Object)"defaultSyncRootFolderItemFactory", (Object)desc.getName());
        Assert.assertNull((Object)desc.getDocType());
        Assert.assertEquals((Object)"DriveSynchronized", (Object)desc.getFacet());
        FileSystemItemFactory factory = desc.getFactory();
        Assert.assertTrue((boolean)(factory instanceof DefaultSyncRootFolderItemFactory));
        desc = (FileSystemItemFactoryDescriptor)fileSystemItemFactoryDescs.get("defaultFileSystemItemFactory");
        Assert.assertNotNull((Object)desc);
        Assert.assertEquals((long)50L, (long)desc.getOrder());
        Assert.assertEquals((Object)"defaultFileSystemItemFactory", (Object)desc.getName());
        Assert.assertNull((Object)desc.getDocType());
        Assert.assertNull((Object)desc.getFacet());
        factory = desc.getFactory();
        Assert.assertTrue((boolean)(factory instanceof DefaultFileSystemItemFactory));
        desc = (FileSystemItemFactoryDescriptor)fileSystemItemFactoryDescs.get("dummyFacetFactory");
        Assert.assertNotNull((Object)desc);
        Assert.assertEquals((long)20L, (long)desc.getOrder());
        Assert.assertEquals((Object)"dummyFacetFactory", (Object)desc.getName());
        Assert.assertNull((Object)desc.getDocType());
        Assert.assertEquals((Object)"Folderish", (Object)desc.getFacet());
        factory = desc.getFactory();
        Assert.assertTrue((boolean)(factory instanceof DefaultFileSystemItemFactory));
        desc = (FileSystemItemFactoryDescriptor)fileSystemItemFactoryDescs.get("dummyDocTypeFactory");
        Assert.assertNotNull((Object)desc);
        Assert.assertEquals((long)30L, (long)desc.getOrder());
        Assert.assertEquals((Object)"dummyDocTypeFactory", (Object)desc.getName());
        Assert.assertEquals((Object)"File", (Object)desc.getDocType());
        Assert.assertNull((Object)desc.getFacet());
        factory = desc.getFactory();
        Assert.assertTrue((boolean)(factory instanceof DefaultFileSystemItemFactory));
        Assert.assertTrue((boolean)(factory instanceof VersioningFileSystemItemFactory));
        Assert.assertEquals((double)60.0, (double)((VersioningFileSystemItemFactory)factory).getVersioningDelay(), (double)0.01);
        Assert.assertEquals((Object)VersioningOption.MAJOR, (Object)((VersioningFileSystemItemFactory)factory).getVersioningOption());
        desc = (FileSystemItemFactoryDescriptor)fileSystemItemFactoryDescs.get("dummyVirtualFolderItemFactory");
        Assert.assertNotNull((Object)desc);
        desc = (FileSystemItemFactoryDescriptor)fileSystemItemFactoryDescs.get("nullMergeTestFactory");
        Assert.assertNotNull((Object)desc);
        Assert.assertEquals((long)200L, (long)desc.getOrder());
        Assert.assertEquals((Object)"nullMergeTestFactory", (Object)desc.getName());
        Assert.assertEquals((Object)"Note", (Object)desc.getDocType());
        Assert.assertNull((Object)desc.getFacet());
        factory = desc.getFactory();
        Assert.assertTrue((boolean)(factory instanceof DummyFileItemFactory));
        List fileSystemItemFactories = ((FileSystemItemAdapterServiceImpl)this.fileSystemItemAdapterService).getFileSystemItemFactories();
        Assert.assertNotNull((Object)fileSystemItemFactories);
        Assert.assertEquals((long)6L, (long)fileSystemItemFactories.size());
        FileSystemItemFactoryWrapper factoryWrapper = (FileSystemItemFactoryWrapper)fileSystemItemFactories.get(0);
        Assert.assertNotNull((Object)factoryWrapper);
        Assert.assertNull((Object)factoryWrapper.getDocType());
        Assert.assertEquals((Object)"Collection", (Object)factoryWrapper.getFacet());
        Assert.assertTrue((boolean)factoryWrapper.getFactory().getClass().getName().endsWith("CollectionSyncRootFolderItemFactory"));
        factoryWrapper = (FileSystemItemFactoryWrapper)fileSystemItemFactories.get(1);
        Assert.assertNotNull((Object)factoryWrapper);
        Assert.assertNull((Object)factoryWrapper.getDocType());
        Assert.assertEquals((Object)"DriveSynchronized", (Object)factoryWrapper.getFacet());
        Assert.assertTrue((boolean)factoryWrapper.getFactory().getClass().getName().endsWith("DefaultSyncRootFolderItemFactory"));
        factoryWrapper = (FileSystemItemFactoryWrapper)fileSystemItemFactories.get(2);
        Assert.assertNotNull((Object)factoryWrapper);
        Assert.assertNull((Object)factoryWrapper.getDocType());
        Assert.assertEquals((Object)"Folderish", (Object)factoryWrapper.getFacet());
        Assert.assertTrue((boolean)factoryWrapper.getFactory().getClass().getName().endsWith("DefaultFileSystemItemFactory"));
        factoryWrapper = (FileSystemItemFactoryWrapper)fileSystemItemFactories.get(3);
        Assert.assertNotNull((Object)factoryWrapper);
        Assert.assertEquals((Object)"File", (Object)factoryWrapper.getDocType());
        Assert.assertNull((Object)factoryWrapper.getFacet());
        Assert.assertTrue((boolean)factoryWrapper.getFactory().getClass().getName().endsWith("DefaultFileSystemItemFactory"));
        factoryWrapper = (FileSystemItemFactoryWrapper)fileSystemItemFactories.get(4);
        Assert.assertNotNull((Object)factoryWrapper);
        factoryWrapper = (FileSystemItemFactoryWrapper)fileSystemItemFactories.get(5);
        Assert.assertNotNull((Object)factoryWrapper);
        Assert.assertEquals((Object)"Note", (Object)factoryWrapper.getDocType());
        Assert.assertNull((Object)factoryWrapper.getFacet());
        Assert.assertTrue((boolean)factoryWrapper.getFactory().getClass().getName().endsWith("DummyFileItemFactory"));
        this.file.setPropertyValue("file:content", null);
        this.session.saveDocument(this.file);
        FileSystemItem fsItem = this.fileSystemItemAdapterService.getFileSystemItem(this.file);
        Assert.assertNull((Object)fsItem);
        fsItem = this.fileSystemItemAdapterService.getFileSystemItem(this.folder);
        Assert.assertNotNull((Object)fsItem);
        Assert.assertTrue((boolean)(fsItem instanceof FolderItem));
        Assert.assertTrue((boolean)((FolderItem)fsItem).getCanCreateChild());
        Assert.assertEquals((Object)("dummyFacetFactory#test#" + this.folder.getId()), (Object)fsItem.getId());
        Assert.assertEquals((Object)this.syncRootItemId, (Object)fsItem.getParentId());
        Assert.assertEquals((Object)"Jack's folder", (Object)fsItem.getName());
        Assert.assertTrue((boolean)fsItem.isFolder());
        Assert.assertEquals((Object)"Jack", (Object)fsItem.getCreator());
        Assert.assertEquals((Object)"Jack", (Object)fsItem.getLastContributor());
        fsItem = this.fileSystemItemAdapterService.getFileSystemItem(this.custom);
        Assert.assertNull((Object)fsItem);
        fsItem = this.fileSystemItemAdapterService.getFileSystemItem(this.folder, this.syncRootItem);
        Assert.assertNotNull((Object)fsItem);
        Assert.assertEquals((Object)this.syncRootItemId, (Object)fsItem.getParentId());
        String fsItemId = "defaultFileSystemItemFactory#test#someId";
        try {
            this.fileSystemItemAdapterService.getFileSystemItemFactoryForId(fsItemId);
            Assert.fail((String)"No fileSystemItemFactory should be found for FileSystemItem id.");
        }
        catch (NuxeoDriveContribException e) {
            Assert.assertEquals((Object)"No fileSystemItemFactory found for FileSystemItem with id defaultFileSystemItemFactory#test#someId. Please check the contributions to the following extension point: <extension target=\"org.nuxeo.drive.service.FileSystemItemAdapterService\" point=\"fileSystemItemFactory\"> and make sure there is at least one defining a FileSystemItemFactory class for which the #canHandleFileSystemItemId(String id) method returns true.", (Object)e.getMessage());
        }
        fsItemId = "dummyDocTypeFactory#test#someId";
        FileSystemItemFactory fsItemFactory = this.fileSystemItemAdapterService.getFileSystemItemFactoryForId(fsItemId);
        Assert.assertNotNull((Object)fsItemFactory);
        Assert.assertEquals((Object)"dummyDocTypeFactory", (Object)fsItemFactory.getName());
        Assert.assertTrue((boolean)fsItemFactory.getClass().getName().endsWith("DefaultFileSystemItemFactory"));
        Assert.assertTrue((boolean)fsItemFactory.canHandleFileSystemItemId(fsItemId));
        fsItemId = "dummyFacetFactory#test#someId";
        fsItemFactory = this.fileSystemItemAdapterService.getFileSystemItemFactoryForId(fsItemId);
        Assert.assertNotNull((Object)fsItemFactory);
        Assert.assertEquals((Object)"dummyFacetFactory", (Object)fsItemFactory.getName());
        Assert.assertTrue((boolean)fsItemFactory.getClass().getName().endsWith("DefaultFileSystemItemFactory"));
        Assert.assertTrue((boolean)fsItemFactory.canHandleFileSystemItemId(fsItemId));
        fsItemId = "org.nuxeo.drive.service.adapter.DummyTopLevelFolderItemFactory#";
        fsItemFactory = this.fileSystemItemAdapterService.getFileSystemItemFactoryForId(fsItemId);
        Assert.assertNotNull((Object)fsItemFactory);
        Assert.assertTrue((boolean)fsItemFactory.getName().endsWith("DummyTopLevelFolderItemFactory"));
        Assert.assertTrue((boolean)fsItemFactory.getClass().getName().endsWith("DummyTopLevelFolderItemFactory"));
        Assert.assertTrue((boolean)fsItemFactory.canHandleFileSystemItemId(fsItemId));
        TopLevelFolderItemFactory topLevelFactory = this.fileSystemItemAdapterService.getTopLevelFolderItemFactory();
        Assert.assertNotNull((Object)topLevelFactory);
        Assert.assertTrue((boolean)topLevelFactory.getClass().getName().endsWith("DummyTopLevelFolderItemFactory"));
        Assert.assertTrue((boolean)(topLevelFactory instanceof DummyTopLevelFolderItemFactory));
        Set activeFactories = this.fileSystemItemAdapterService.getActiveFileSystemItemFactories();
        Assert.assertEquals((long)6L, (long)activeFactories.size());
        Assert.assertTrue((boolean)activeFactories.contains("collectionSyncRootFolderItemFactory"));
        Assert.assertTrue((boolean)activeFactories.contains("defaultSyncRootFolderItemFactory"));
        Assert.assertTrue((boolean)activeFactories.contains("dummyDocTypeFactory"));
        Assert.assertTrue((boolean)activeFactories.contains("dummyFacetFactory"));
        Assert.assertTrue((boolean)activeFactories.contains("dummyVirtualFolderItemFactory"));
        Assert.assertTrue((boolean)activeFactories.contains("nullMergeTestFactory"));
        this.harness.undeployContrib("org.nuxeo.drive.core.test", "OSGI-INF/test-nuxeodrive-adapter-service-contrib-override.xml");
        this.reload();
    }

    void reload() {
        Properties lastProps = Framework.getProperties();
        try {
            ((ReloadService)Framework.getLocalService(ReloadService.class)).reload();
        }
        finally {
            Framework.getProperties().putAll((Map<?, ?>)lastProps);
        }
    }
}

