/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.service.adapter;

import java.io.Serializable;
import java.security.Principal;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.drive.adapter.FileItem;
import org.nuxeo.drive.adapter.FileSystemItem;
import org.nuxeo.drive.adapter.FolderItem;
import org.nuxeo.drive.adapter.ScrollFileSystemItemList;
import org.nuxeo.drive.adapter.impl.DefaultSyncRootFolderItem;
import org.nuxeo.drive.service.FileSystemItemManager;
import org.nuxeo.drive.service.NuxeoDriveManager;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.test.CoreFeature;
import org.nuxeo.ecm.platform.test.PlatformFeature;
import org.nuxeo.ecm.platform.usermanager.NuxeoPrincipalImpl;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.LocalDeploy;
import org.nuxeo.runtime.transaction.TransactionHelper;

@RunWith(value=FeaturesRunner.class)
@Features(value={PlatformFeature.class})
@Deploy(value={"org.nuxeo.drive.core", "org.nuxeo.ecm.platform.dublincore", "org.nuxeo.ecm.platform.query.api", "org.nuxeo.ecm.platform.filemanager.core", "org.nuxeo.ecm.platform.types.core", "org.nuxeo.ecm.core.io", "org.nuxeo.ecm.core.cache", "org.nuxeo.ecm.webapp.base:OSGI-INF/ecm-types-contrib.xml", "org.nuxeo.drive.core.test:OSGI-INF/test-nuxeodrive-sync-root-cache-contrib.xml", "org.nuxeo.drive.core.test:OSGI-INF/test-nuxeodrive-descendants-scrolling-cache-contrib.xml"})
@LocalDeploy(value={"org.nuxeo.drive.core:OSGI-INF/test-nuxeodrive-types-contrib.xml"})
public class TestFileSystemItemManagerService {
    private static final String DEFAULT_FILE_SYSTEM_ITEM_ID_PREFIX = "defaultFileSystemItemFactory#test#";
    private static final String DEFAULT_SYNC_ROOT_ITEM_ID_PREFIX = "defaultSyncRootFolderItemFactory#test#";
    @Inject
    protected CoreFeature coreFeature;
    @Inject
    protected CoreSession session;
    @Inject
    protected FileSystemItemManager fileSystemItemManagerService;
    @Inject
    protected NuxeoDriveManager nuxeoDriveManager;
    protected Principal principal;
    protected DocumentModel syncRoot1;
    protected DocumentModel syncRoot2;
    protected DocumentModel folder;
    protected DocumentModel file;
    protected DocumentModel note;
    protected DocumentModel custom;
    protected DocumentModel folderishFile;
    protected DocumentModel notAFileSystemItem;
    protected DocumentModel subFolder;

    @Before
    public void createTestDocs() throws Exception {
        this.principal = this.session.getPrincipal();
        this.syncRoot1 = this.session.createDocument(this.session.createDocumentModel("/", "syncRoot1", "Folder"));
        this.syncRoot2 = this.session.createDocument(this.session.createDocumentModel("/", "syncRoot2", "Folder"));
        Principal administrator = this.session.getPrincipal();
        this.nuxeoDriveManager.registerSynchronizationRoot(administrator, this.syncRoot1, this.session);
        this.nuxeoDriveManager.registerSynchronizationRoot(administrator, this.syncRoot2, this.session);
        this.folder = this.session.createDocumentModel(this.syncRoot1.getPathAsString(), "aFolder", "Folder");
        this.folder.setPropertyValue("dc:title", (Serializable)((Object)"Jack's folder"));
        this.folder = this.session.createDocument(this.folder);
        this.file = this.session.createDocumentModel(this.folder.getPathAsString(), "aFile", "File");
        StringBlob blob = new StringBlob("Content of Joe's file.");
        blob.setFilename("Joe.odt");
        this.file.setPropertyValue("file:content", (Serializable)blob);
        this.file = this.session.createDocument(this.file);
        this.note = this.session.createDocumentModel(this.folder.getPathAsString(), "aNote", "Note");
        this.note.setPropertyValue("note:note", (Serializable)((Object)"Content of Bob's note."));
        this.note = this.session.createDocument(this.note);
        this.custom = this.session.createDocumentModel(this.folder.getPathAsString(), "aCustomDoc", "Custom");
        blob = new StringBlob("Content of Bonnie's file.");
        blob.setFilename("Bonnie's file.odt");
        this.custom.setPropertyValue("file:content", (Serializable)blob);
        this.custom = this.session.createDocument(this.custom);
        this.folderishFile = this.session.createDocumentModel(this.folder.getPathAsString(), "aFolderishFile", "FolderishFile");
        this.folderishFile.setPropertyValue("dc:title", (Serializable)((Object)"Sarah's folderish file"));
        this.folderishFile = this.session.createDocument(this.folderishFile);
        this.notAFileSystemItem = this.session.createDocumentModel(this.folder.getPathAsString(), "notAFileSystemItem", "NotSynchronizable");
        this.notAFileSystemItem = this.session.createDocument(this.notAFileSystemItem);
        this.subFolder = this.session.createDocumentModel(this.folder.getPathAsString(), "aSubFolder", "Folder");
        this.subFolder.setPropertyValue("dc:title", (Serializable)((Object)"Tony's sub folder"));
        this.subFolder = this.session.createDocument(this.subFolder);
        this.session.save();
    }

    @Test
    public void testReadOperations() throws Exception {
        ScrollFileSystemItemList descendantsBatch;
        List topLevelChildren = this.fileSystemItemManagerService.getTopLevelFolder(this.principal).getChildren();
        Assert.assertNotNull((Object)topLevelChildren);
        Assert.assertEquals((long)2L, (long)topLevelChildren.size());
        FileSystemItem childFsItem = (FileSystemItem)topLevelChildren.get(0);
        Assert.assertTrue((boolean)(childFsItem instanceof DefaultSyncRootFolderItem));
        Assert.assertEquals((Object)(DEFAULT_SYNC_ROOT_ITEM_ID_PREFIX + this.syncRoot1.getId()), (Object)childFsItem.getId());
        Assert.assertTrue((boolean)childFsItem.getParentId().endsWith("DefaultTopLevelFolderItemFactory#"));
        Assert.assertEquals((Object)"syncRoot1", (Object)childFsItem.getName());
        childFsItem = (FileSystemItem)topLevelChildren.get(1);
        Assert.assertTrue((boolean)(childFsItem instanceof DefaultSyncRootFolderItem));
        Assert.assertEquals((Object)(DEFAULT_SYNC_ROOT_ITEM_ID_PREFIX + this.syncRoot2.getId()), (Object)childFsItem.getId());
        Assert.assertTrue((boolean)childFsItem.getParentId().endsWith("DefaultTopLevelFolderItemFactory#"));
        Assert.assertEquals((Object)"syncRoot2", (Object)childFsItem.getName());
        Assert.assertFalse((boolean)this.fileSystemItemManagerService.exists("defaultFileSystemItemFactory#test#nonExistentId", this.principal));
        Assert.assertTrue((boolean)this.fileSystemItemManagerService.exists(DEFAULT_FILE_SYSTEM_ITEM_ID_PREFIX + this.file.getId(), this.principal));
        Assert.assertFalse((boolean)this.fileSystemItemManagerService.exists(DEFAULT_FILE_SYSTEM_ITEM_ID_PREFIX + this.notAFileSystemItem.getId(), this.principal));
        this.custom.followTransition("delete");
        Assert.assertFalse((boolean)this.fileSystemItemManagerService.exists(DEFAULT_FILE_SYSTEM_ITEM_ID_PREFIX + this.custom.getId(), this.principal));
        FileSystemItem fsItem = this.fileSystemItemManagerService.getFileSystemItemById(DEFAULT_FILE_SYSTEM_ITEM_ID_PREFIX + this.folder.getId(), this.principal);
        Assert.assertNotNull((Object)fsItem);
        Assert.assertTrue((boolean)(fsItem instanceof FolderItem));
        Assert.assertEquals((Object)(DEFAULT_FILE_SYSTEM_ITEM_ID_PREFIX + this.folder.getId()), (Object)fsItem.getId());
        String expectedSyncRoot1Id = DEFAULT_SYNC_ROOT_ITEM_ID_PREFIX + this.syncRoot1.getId();
        Assert.assertEquals((Object)expectedSyncRoot1Id, (Object)fsItem.getParentId());
        Assert.assertEquals((Object)"Jack's folder", (Object)fsItem.getName());
        Assert.assertTrue((boolean)fsItem.isFolder());
        Assert.assertTrue((boolean)fsItem.getCanRename());
        Assert.assertTrue((boolean)fsItem.getCanDelete());
        Assert.assertTrue((boolean)((FolderItem)fsItem).getCanCreateChild());
        List children = ((FolderItem)fsItem).getChildren();
        Assert.assertNotNull((Object)children);
        Assert.assertEquals((long)4L, (long)children.size());
        fsItem = this.fileSystemItemManagerService.getFileSystemItemById(DEFAULT_FILE_SYSTEM_ITEM_ID_PREFIX + this.file.getId(), this.principal);
        Assert.assertNotNull((Object)fsItem);
        Assert.assertTrue((boolean)(fsItem instanceof FileItem));
        Assert.assertEquals((Object)(DEFAULT_FILE_SYSTEM_ITEM_ID_PREFIX + this.file.getId()), (Object)fsItem.getId());
        Assert.assertEquals((Object)(DEFAULT_FILE_SYSTEM_ITEM_ID_PREFIX + this.folder.getId()), (Object)fsItem.getParentId());
        Assert.assertEquals((Object)"Joe.odt", (Object)fsItem.getName());
        Assert.assertFalse((boolean)fsItem.isFolder());
        Assert.assertTrue((boolean)fsItem.getCanRename());
        Assert.assertTrue((boolean)fsItem.getCanDelete());
        FileItem fileFsItem = (FileItem)fsItem;
        Assert.assertTrue((boolean)fileFsItem.getCanUpdate());
        Assert.assertEquals((Object)("nxfile/test/" + this.file.getId() + "/blobholder:0/Joe.odt"), (Object)fileFsItem.getDownloadURL());
        Assert.assertEquals((Object)"MD5", (Object)fileFsItem.getDigestAlgorithm());
        Assert.assertEquals((Object)((BlobHolder)this.file.getAdapter(BlobHolder.class)).getBlob().getDigest(), (Object)fileFsItem.getDigest());
        Blob fileItemBlob = fileFsItem.getBlob();
        Assert.assertEquals((Object)"Joe.odt", (Object)fileItemBlob.getFilename());
        Assert.assertEquals((Object)"Content of Joe's file.", (Object)fileItemBlob.getString());
        fsItem = this.fileSystemItemManagerService.getFileSystemItemById(DEFAULT_FILE_SYSTEM_ITEM_ID_PREFIX + this.folderishFile.getId(), this.principal);
        Assert.assertNotNull((Object)fsItem);
        Assert.assertTrue((boolean)(fsItem instanceof FolderItem));
        Assert.assertEquals((Object)(DEFAULT_FILE_SYSTEM_ITEM_ID_PREFIX + this.folderishFile.getId()), (Object)fsItem.getId());
        Assert.assertEquals((Object)(DEFAULT_FILE_SYSTEM_ITEM_ID_PREFIX + this.folder.getId()), (Object)fsItem.getParentId());
        Assert.assertEquals((Object)"Sarah's folderish file", (Object)fsItem.getName());
        Assert.assertTrue((boolean)fsItem.isFolder());
        Assert.assertTrue((boolean)fsItem.getCanRename());
        Assert.assertTrue((boolean)fsItem.getCanDelete());
        Assert.assertTrue((boolean)((FolderItem)fsItem).getCanCreateChild());
        Assert.assertTrue((boolean)((FolderItem)fsItem).getChildren().isEmpty());
        fsItem = this.fileSystemItemManagerService.getFileSystemItemById(DEFAULT_FILE_SYSTEM_ITEM_ID_PREFIX + this.notAFileSystemItem.getId(), this.principal);
        Assert.assertNull((Object)fsItem);
        Assert.assertNull((Object)this.fileSystemItemManagerService.getFileSystemItemById(DEFAULT_FILE_SYSTEM_ITEM_ID_PREFIX + this.custom.getId(), this.principal));
        fsItem = this.fileSystemItemManagerService.getFileSystemItemById(DEFAULT_FILE_SYSTEM_ITEM_ID_PREFIX + this.subFolder.getId(), this.principal);
        Assert.assertNotNull((Object)fsItem);
        Assert.assertTrue((boolean)(fsItem instanceof FolderItem));
        Assert.assertEquals((Object)(DEFAULT_FILE_SYSTEM_ITEM_ID_PREFIX + this.subFolder.getId()), (Object)fsItem.getId());
        Assert.assertEquals((Object)(DEFAULT_FILE_SYSTEM_ITEM_ID_PREFIX + this.folder.getId()), (Object)fsItem.getParentId());
        Assert.assertEquals((Object)"Tony's sub folder", (Object)fsItem.getName());
        Assert.assertTrue((boolean)fsItem.isFolder());
        Assert.assertTrue((boolean)fsItem.getCanRename());
        Assert.assertTrue((boolean)fsItem.getCanDelete());
        Assert.assertTrue((boolean)((FolderItem)fsItem).getCanCreateChild());
        Assert.assertTrue((boolean)((FolderItem)fsItem).getChildren().isEmpty());
        fsItem = this.fileSystemItemManagerService.getFileSystemItemById(DEFAULT_FILE_SYSTEM_ITEM_ID_PREFIX + this.file.getId(), DEFAULT_FILE_SYSTEM_ITEM_ID_PREFIX + this.folder.getId(), this.principal);
        Assert.assertTrue((boolean)(fsItem instanceof FileItem));
        Assert.assertEquals((Object)(DEFAULT_FILE_SYSTEM_ITEM_ID_PREFIX + this.file.getId()), (Object)fsItem.getId());
        Assert.assertEquals((Object)(DEFAULT_FILE_SYSTEM_ITEM_ID_PREFIX + this.folder.getId()), (Object)fsItem.getParentId());
        this.session.save();
        children = this.fileSystemItemManagerService.getChildren(DEFAULT_FILE_SYSTEM_ITEM_ID_PREFIX + this.folder.getId(), this.principal);
        Assert.assertNotNull((Object)children);
        Assert.assertEquals((long)4L, (long)children.size());
        boolean ordered = this.coreFeature.getStorageConfiguration().hasSubSecondResolution();
        this.checkChildren(children, this.folder.getId(), this.file.getId(), this.note.getId(), this.folderishFile.getId(), this.subFolder.getId(), ordered);
        children = this.fileSystemItemManagerService.getChildren(DEFAULT_FILE_SYSTEM_ITEM_ID_PREFIX + this.subFolder.getId(), this.principal);
        Assert.assertTrue((boolean)children.isEmpty());
        this.session.save();
        FolderItem folderItem = (FolderItem)this.fileSystemItemManagerService.getFileSystemItemById(DEFAULT_FILE_SYSTEM_ITEM_ID_PREFIX + this.folder.getId(), this.principal);
        Assert.assertTrue((boolean)folderItem.getCanScrollDescendants());
        ScrollFileSystemItemList folderDescendants = this.fileSystemItemManagerService.scrollDescendants(DEFAULT_FILE_SYSTEM_ITEM_ID_PREFIX + this.folder.getId(), this.principal, null, 10, 1000L);
        Assert.assertNotNull((Object)folderDescendants);
        Assert.assertNotNull((Object)folderDescendants.getScrollId());
        Assert.assertEquals((long)4L, (long)folderDescendants.size());
        this.checkChildren((List<FileSystemItem>)folderDescendants, this.folder.getId(), this.file.getId(), this.note.getId(), this.folderishFile.getId(), this.subFolder.getId(), false);
        folderDescendants.clear();
        int batchSize = 2;
        String scrollId = null;
        while (!(descendantsBatch = folderItem.scrollDescendants(scrollId, batchSize, 1000L)).isEmpty()) {
            Assert.assertTrue((descendantsBatch.size() > 0 ? 1 : 0) != 0);
            scrollId = descendantsBatch.getScrollId();
            folderDescendants.addAll((Collection)descendantsBatch);
        }
        Assert.assertEquals((long)4L, (long)folderDescendants.size());
        this.checkChildren((List<FileSystemItem>)folderDescendants, this.folder.getId(), this.file.getId(), this.note.getId(), this.folderishFile.getId(), this.subFolder.getId(), false);
        folderDescendants = this.fileSystemItemManagerService.scrollDescendants(DEFAULT_FILE_SYSTEM_ITEM_ID_PREFIX + this.subFolder.getId(), this.principal, null, 10, 1000L);
        Assert.assertTrue((boolean)folderDescendants.isEmpty());
        String srcFsItemId = DEFAULT_FILE_SYSTEM_ITEM_ID_PREFIX + this.note.getId();
        String destFsItemId = DEFAULT_FILE_SYSTEM_ITEM_ID_PREFIX + this.file.getId();
        Assert.assertFalse((boolean)this.fileSystemItemManagerService.canMove(srcFsItemId, destFsItemId, this.principal));
        NuxeoPrincipalImpl joePrincipal = new NuxeoPrincipalImpl("joe");
        DocumentModel rootDoc = this.session.getRootDocument();
        this.setPermission(rootDoc, "joe", "Read", true);
        this.nuxeoDriveManager.registerSynchronizationRoot((Principal)joePrincipal, this.syncRoot1, this.session);
        TransactionHelper.commitOrRollbackTransaction();
        TransactionHelper.startTransaction();
        destFsItemId = DEFAULT_FILE_SYSTEM_ITEM_ID_PREFIX + this.subFolder.getId();
        Assert.assertFalse((boolean)this.fileSystemItemManagerService.canMove(srcFsItemId, destFsItemId, (Principal)joePrincipal));
        this.setPermission(this.folder, "joe", "Write", true);
        this.setPermission(this.subFolder, "joe", "Read", true);
        this.setPermission(this.subFolder, "Administrator", "Everything", true);
        this.setPermission(this.subFolder, "Everyone", "Everything", false);
        Assert.assertFalse((boolean)this.fileSystemItemManagerService.canMove(srcFsItemId, destFsItemId, (Principal)joePrincipal));
        this.resetPermissions(this.subFolder, "Everyone");
        this.resetPermissions(this.subFolder, "joe");
        this.setPermission(this.subFolder, "joe", "Write", true);
        Assert.assertTrue((boolean)this.fileSystemItemManagerService.canMove(srcFsItemId, destFsItemId, (Principal)joePrincipal));
        this.resetPermissions(rootDoc, "joe");
        this.resetPermissions(this.folder, "joe");
        this.resetPermissions(this.subFolder, "joe");
    }

    @Test
    public void testWriteOperations() throws Exception {
        try {
            this.fileSystemItemManagerService.createFolder(DEFAULT_FILE_SYSTEM_ITEM_ID_PREFIX + this.file.getId(), "A new folder", this.principal);
            Assert.fail((String)"Folder creation in a non folder item should fail.");
        }
        catch (NuxeoException e) {
            Assert.assertEquals((Object)String.format("Cannot create a folder in file system item with id %s because it is not a folder but is: DocumentBackedFileItem(id=\"%s\", name=\"Joe.odt\")", DEFAULT_FILE_SYSTEM_ITEM_ID_PREFIX + this.file.getId(), DEFAULT_FILE_SYSTEM_ITEM_ID_PREFIX + this.file.getId()), (Object)e.getMessage());
        }
        FolderItem newFolderItem = this.fileSystemItemManagerService.createFolder(DEFAULT_FILE_SYSTEM_ITEM_ID_PREFIX + this.folder.getId(), "A new folder", this.principal);
        Assert.assertNotNull((Object)newFolderItem);
        Assert.assertEquals((Object)(DEFAULT_FILE_SYSTEM_ITEM_ID_PREFIX + this.folder.getId()), (Object)newFolderItem.getParentId());
        Assert.assertEquals((Object)"A new folder", (Object)newFolderItem.getName());
        DocumentModelList folderChildren = this.session.query(String.format("select * from Document where ecm:parentId = '%s' and ecm:primaryType = 'Folder' order by dc:title asc", this.folder.getId()));
        DocumentModel newFolder = (DocumentModel)folderChildren.get(0);
        Assert.assertTrue((boolean)newFolder.isFolder());
        Assert.assertEquals((Object)"A new folder", (Object)newFolder.getTitle());
        Assert.assertEquals((long)6L, (long)this.fileSystemItemManagerService.getChildren(DEFAULT_FILE_SYSTEM_ITEM_ID_PREFIX + this.folder.getId(), this.principal).size());
        StringBlob blob = new StringBlob("Content of a new file.");
        blob.setFilename("New file.odt");
        blob.setMimeType("application/vnd.oasis.opendocument.text");
        FileItem fileItem = this.fileSystemItemManagerService.createFile(newFolderItem.getId(), (Blob)blob, this.principal);
        Assert.assertNotNull((Object)fileItem);
        Assert.assertEquals((Object)newFolderItem.getId(), (Object)fileItem.getParentId());
        Assert.assertEquals((Object)"New file.odt", (Object)fileItem.getName());
        folderChildren = this.session.query(String.format("select * from Document where ecm:parentId = '%s'", newFolder.getId()));
        Assert.assertEquals((long)1L, (long)folderChildren.size());
        DocumentModel newFile = (DocumentModel)folderChildren.get(0);
        Assert.assertEquals((Object)"File", (Object)newFile.getType());
        Assert.assertEquals((Object)"New file.odt", (Object)newFile.getTitle());
        Assert.assertEquals((Object)"/syncRoot1/aFolder/A new folder/New file.odt", (Object)newFile.getPathAsString());
        Blob newFileBlob = (Blob)newFile.getPropertyValue("file:content");
        Assert.assertEquals((Object)"New file.odt", (Object)newFileBlob.getFilename());
        Assert.assertEquals((Object)"Content of a new file.", (Object)newFileBlob.getString());
        Assert.assertEquals((Object)("nxfile/test/" + newFile.getId() + "/blobholder:0/New%20file.odt"), (Object)fileItem.getDownloadURL());
        Assert.assertEquals((Object)"MD5", (Object)fileItem.getDigestAlgorithm());
        Assert.assertEquals((Object)newFileBlob.getDigest(), (Object)fileItem.getDigest());
        Assert.assertEquals((long)1L, (long)this.fileSystemItemManagerService.getChildren(newFolderItem.getId(), this.principal).size());
        String fileItemId = fileItem.getId();
        String fileItemParentId = fileItem.getParentId();
        blob = new StringBlob("Modified content of an existing file.");
        fileItem = this.fileSystemItemManagerService.updateFile(fileItemId, (Blob)blob, this.principal);
        Assert.assertNotNull((Object)fileItem);
        Assert.assertEquals((Object)fileItemId, (Object)fileItem.getId());
        Assert.assertEquals((Object)fileItemParentId, (Object)fileItem.getParentId());
        Assert.assertEquals((Object)"New file.odt", (Object)fileItem.getName());
        folderChildren = this.session.query(String.format("select * from Document where ecm:parentId = '%s'", newFolder.getId()));
        Assert.assertEquals((long)1L, (long)folderChildren.size());
        DocumentModel updatedFile = (DocumentModel)folderChildren.get(0);
        Assert.assertEquals((Object)"File", (Object)updatedFile.getType());
        Assert.assertEquals((Object)"New file.odt", (Object)updatedFile.getTitle());
        Assert.assertEquals((Object)"/syncRoot1/aFolder/A new folder/New file.odt", (Object)updatedFile.getPathAsString());
        Blob updatedFileBlob = (Blob)updatedFile.getPropertyValue("file:content");
        Assert.assertEquals((Object)"New file.odt", (Object)updatedFileBlob.getFilename());
        Assert.assertEquals((Object)"Modified content of an existing file.", (Object)updatedFileBlob.getString());
        Assert.assertEquals((Object)("nxfile/test/" + updatedFile.getId() + "/blobholder:0/New%20file.odt"), (Object)fileItem.getDownloadURL());
        Assert.assertEquals((Object)"MD5", (Object)fileItem.getDigestAlgorithm());
        Assert.assertEquals((Object)updatedFileBlob.getDigest(), (Object)fileItem.getDigest());
        this.fileSystemItemManagerService.delete(DEFAULT_FILE_SYSTEM_ITEM_ID_PREFIX + updatedFile.getId(), this.principal);
        updatedFile = this.session.getDocument((DocumentRef)new IdRef(updatedFile.getId()));
        Assert.assertEquals((Object)"deleted", (Object)updatedFile.getCurrentLifeCycleState());
        Assert.assertTrue((boolean)this.fileSystemItemManagerService.getChildren(newFolderItem.getId(), this.principal).isEmpty());
        String fsItemId = DEFAULT_FILE_SYSTEM_ITEM_ID_PREFIX + this.folder.getId();
        FileSystemItem fsItem = this.fileSystemItemManagerService.rename(fsItemId, "Jack's folder has a new name", this.principal);
        Assert.assertEquals((Object)fsItemId, (Object)fsItem.getId());
        String expectedSyncRoot1Id = DEFAULT_SYNC_ROOT_ITEM_ID_PREFIX + this.syncRoot1.getId();
        Assert.assertEquals((Object)expectedSyncRoot1Id, (Object)fsItem.getParentId());
        Assert.assertEquals((Object)"Jack's folder has a new name", (Object)fsItem.getName());
        this.folder = this.session.getDocument(this.folder.getRef());
        Assert.assertEquals((Object)"Jack's folder has a new name", (Object)this.folder.getTitle());
        Assert.assertEquals((Object)"aFile", (Object)this.file.getTitle());
        Assert.assertEquals((Object)"Joe.odt", (Object)((Blob)this.file.getPropertyValue("file:content")).getFilename());
        fsItemId = DEFAULT_FILE_SYSTEM_ITEM_ID_PREFIX + this.file.getId();
        fsItem = this.fileSystemItemManagerService.rename(fsItemId, "File new name.odt", this.principal);
        Assert.assertEquals((Object)fsItemId, (Object)fsItem.getId());
        Assert.assertEquals((Object)(DEFAULT_FILE_SYSTEM_ITEM_ID_PREFIX + this.folder.getId()), (Object)fsItem.getParentId());
        Assert.assertEquals((Object)"File new name.odt", (Object)fsItem.getName());
        this.file = this.session.getDocument(this.file.getRef());
        Assert.assertEquals((Object)"aFile", (Object)this.file.getTitle());
        Blob fileBlob = (Blob)this.file.getPropertyValue("file:content");
        Assert.assertEquals((Object)"File new name.odt", (Object)fileBlob.getFilename());
        fileItem = (FileItem)fsItem;
        Assert.assertEquals((Object)("nxfile/test/" + this.file.getId() + "/blobholder:0/File%20new%20name.odt"), (Object)fileItem.getDownloadURL());
        Assert.assertEquals((Object)"MD5", (Object)fileItem.getDigestAlgorithm());
        Assert.assertEquals((Object)fileBlob.getDigest(), (Object)fileItem.getDigest());
        blob = new StringBlob("File for a doc with title == filename.");
        blob.setFilename("Title-filename equality.odt");
        blob.setMimeType("application/vnd.oasis.opendocument.text");
        fileItem = this.fileSystemItemManagerService.createFile(newFolderItem.getId(), (Blob)blob, this.principal);
        newFile = this.session.getDocument((DocumentRef)new PathRef("/syncRoot1/aFolder/A new folder/Title-filename equality."));
        Assert.assertEquals((Object)"Title-filename equality.odt", (Object)newFile.getTitle());
        Assert.assertEquals((Object)"Title-filename equality.odt", (Object)((Blob)newFile.getPropertyValue("file:content")).getFilename());
        fileItem = (FileItem)this.fileSystemItemManagerService.rename(DEFAULT_FILE_SYSTEM_ITEM_ID_PREFIX + newFile.getId(), "Renamed title-filename equality.odt", this.principal);
        Assert.assertEquals((Object)"Renamed title-filename equality.odt", (Object)fileItem.getName());
        newFile = this.session.getDocument(newFile.getRef());
        Assert.assertEquals((Object)"Renamed title-filename equality.odt", (Object)newFile.getTitle());
        newFileBlob = (Blob)newFile.getPropertyValue("file:content");
        Assert.assertEquals((Object)"Renamed title-filename equality.odt", (Object)newFileBlob.getFilename());
        Assert.assertEquals((Object)("nxfile/test/" + newFile.getId() + "/blobholder:0/Renamed%20title-filename%20equality.odt"), (Object)fileItem.getDownloadURL());
        Assert.assertEquals((Object)"MD5", (Object)fileItem.getDigestAlgorithm());
        Assert.assertEquals((Object)newFileBlob.getDigest(), (Object)fileItem.getDigest());
        String srcFsItemId = DEFAULT_FILE_SYSTEM_ITEM_ID_PREFIX + this.note.getId();
        String destFsItemId = DEFAULT_FILE_SYSTEM_ITEM_ID_PREFIX + this.file.getId();
        try {
            this.fileSystemItemManagerService.move(srcFsItemId, destFsItemId, this.principal);
            Assert.fail((String)"Move to a non folder item should fail.");
        }
        catch (NuxeoException e) {
            Assert.assertEquals((Object)String.format("Cannot move a file system item to file system item with id %s because it is not a folder.", DEFAULT_FILE_SYSTEM_ITEM_ID_PREFIX + this.file.getId()), (Object)e.getMessage());
        }
        destFsItemId = DEFAULT_FILE_SYSTEM_ITEM_ID_PREFIX + this.subFolder.getId();
        FileSystemItem movedFsItem = this.fileSystemItemManagerService.move(srcFsItemId, destFsItemId, this.principal);
        Assert.assertEquals((Object)srcFsItemId, (Object)movedFsItem.getId());
        Assert.assertEquals((Object)destFsItemId, (Object)movedFsItem.getParentId());
        Assert.assertEquals((Object)"aNote.txt", (Object)movedFsItem.getName());
        this.note = this.session.getDocument(this.note.getRef());
        Assert.assertEquals((Object)"/syncRoot1/aFolder/aSubFolder/aNote", (Object)this.note.getPathAsString());
        Assert.assertEquals((Object)"aNote", (Object)this.note.getTitle());
    }

    protected void setPermission(DocumentModel doc, String userName, String permission, boolean isGranted) {
        ACP acp = this.session.getACP(doc.getRef());
        ACL localACL = acp.getOrCreateACL("local");
        localACL.add(new ACE(userName, permission, isGranted));
        this.session.setACP(doc.getRef(), acp, true);
        this.session.save();
    }

    protected void resetPermissions(DocumentModel doc, String userName) {
        ACP acp = this.session.getACP(doc.getRef());
        ACL localACL = acp.getOrCreateACL("local");
        Iterator localACLIt = localACL.iterator();
        while (localACLIt.hasNext()) {
            ACE ace = (ACE)localACLIt.next();
            if (!userName.equals(ace.getUsername())) continue;
            localACLIt.remove();
        }
        this.session.setACP(doc.getRef(), acp, true);
        this.session.save();
    }

    protected void checkChildren(List<FileSystemItem> folderChildren, String folderId, String fileId, String noteId, String folderishFileId, String subFolderId, boolean ordered) throws Exception {
        boolean isFileFound = false;
        boolean isNoteFound = false;
        boolean isFolderishFileFound = false;
        boolean isSubFolderFound = false;
        int childrenCount = 0;
        for (FileSystemItem fsItem : folderChildren) {
            if (!isFileFound && (DEFAULT_FILE_SYSTEM_ITEM_ID_PREFIX + fileId).equals(fsItem.getId())) {
                if (ordered && (!ordered || childrenCount != 0)) continue;
                Assert.assertEquals((Object)(DEFAULT_FILE_SYSTEM_ITEM_ID_PREFIX + folderId), (Object)fsItem.getParentId());
                Assert.assertEquals((Object)"Joe.odt", (Object)fsItem.getName());
                Assert.assertFalse((boolean)fsItem.isFolder());
                isFileFound = true;
                ++childrenCount;
                continue;
            }
            if (!isNoteFound && (DEFAULT_FILE_SYSTEM_ITEM_ID_PREFIX + noteId).equals(fsItem.getId())) {
                if (ordered && (!ordered || childrenCount != true)) continue;
                Assert.assertEquals((Object)(DEFAULT_FILE_SYSTEM_ITEM_ID_PREFIX + folderId), (Object)fsItem.getParentId());
                Assert.assertEquals((Object)"aNote.txt", (Object)fsItem.getName());
                Assert.assertFalse((boolean)fsItem.isFolder());
                isNoteFound = true;
                ++childrenCount;
                continue;
            }
            if (!isFolderishFileFound && (DEFAULT_FILE_SYSTEM_ITEM_ID_PREFIX + folderishFileId).equals(fsItem.getId())) {
                if (ordered && (!ordered || childrenCount != 3)) continue;
                Assert.assertEquals((Object)(DEFAULT_FILE_SYSTEM_ITEM_ID_PREFIX + folderId), (Object)fsItem.getParentId());
                Assert.assertEquals((Object)"Sarah's folderish file", (Object)fsItem.getName());
                Assert.assertTrue((boolean)fsItem.isFolder());
                isFolderishFileFound = true;
                ++childrenCount;
                continue;
            }
            if (!isSubFolderFound && (DEFAULT_FILE_SYSTEM_ITEM_ID_PREFIX + subFolderId).equals(fsItem.getId())) {
                if (ordered && (!ordered || childrenCount != 4)) continue;
                Assert.assertEquals((Object)(DEFAULT_FILE_SYSTEM_ITEM_ID_PREFIX + folderId), (Object)fsItem.getParentId());
                Assert.assertEquals((Object)"Tony's sub folder", (Object)fsItem.getName());
                Assert.assertTrue((boolean)fsItem.isFolder());
                isSubFolderFound = true;
                ++childrenCount;
                continue;
            }
            Assert.fail((String)String.format("FileSystemItem %s doesn't match any expected.", fsItem.getId()));
        }
    }
}

