/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.drive.service.adapter;

import java.io.Serializable;
import java.security.Principal;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.drive.adapter.FileItem;
import org.nuxeo.drive.service.FileSystemItemAdapterService;
import org.nuxeo.drive.service.NuxeoDriveManager;
import org.nuxeo.drive.service.VersioningFileSystemItemFactory;
import org.nuxeo.drive.service.impl.FileSystemItemAdapterServiceImpl;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.VersioningOption;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.test.CoreFeature;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.config.ConfigurationService;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.LocalDeploy;
import org.nuxeo.runtime.transaction.TransactionHelper;

@RunWith(value=FeaturesRunner.class)
@Features(value={CoreFeature.class})
@Deploy(value={"org.nuxeo.drive.core", "org.nuxeo.ecm.platform.dublincore", "org.nuxeo.ecm.platform.query.api", "org.nuxeo.ecm.platform.filemanager.core", "org.nuxeo.ecm.platform.types.core", "org.nuxeo.ecm.core.io", "org.nuxeo.ecm.platform.collections.core", "org.nuxeo.ecm.webapp.base:OSGI-INF/ecm-types-contrib.xml", "org.nuxeo.runtime.reload", "org.nuxeo.ecm.core.cache", "org.nuxeo.drive.core.test:OSGI-INF/test-nuxeodrive-sync-root-cache-contrib.xml"})
@LocalDeploy(value={"org.nuxeo.drive.core:OSGI-INF/test-nuxeodrive-types-contrib.xml"})
public class TestVersioningFileSystemItemFactory {
    private static final int VERSIONING_DELAY = 1500;
    @Inject
    protected CoreFeature coreFeature;
    @Inject
    protected CoreSession session;
    @Inject
    protected FileSystemItemAdapterService fileSystemItemAdapterService;
    @Inject
    protected NuxeoDriveManager nuxeoDriveManager;
    protected Principal principal;
    protected DocumentModel syncRootFolder;
    protected DocumentModel file;
    protected VersioningFileSystemItemFactory customFileSystemItemFactory;

    protected void maybeSleepToNextSecond() {
        this.coreFeature.getStorageConfiguration().maybeSleepToNextSecond();
    }

    @Before
    public void createTestDocs() throws Exception {
        this.principal = this.session.getPrincipal();
        this.syncRootFolder = this.session.createDocumentModel("/", "syncRoot", "Folder");
        this.syncRootFolder = this.session.createDocument(this.syncRootFolder);
        this.nuxeoDriveManager.registerSynchronizationRoot(this.principal, this.syncRootFolder, this.session);
        this.file = this.session.createDocumentModel(this.syncRootFolder.getPathAsString(), "aFile", "File");
        StringBlob blob = new StringBlob("Content of Joe's file.");
        blob.setFilename("Joe.odt");
        this.file.setPropertyValue("file:content", (Serializable)blob);
        this.file = this.session.createDocument(this.file);
        this.session.save();
        this.customFileSystemItemFactory = (VersioningFileSystemItemFactory)((FileSystemItemAdapterServiceImpl)this.fileSystemItemAdapterService).getFileSystemItemFactory("defaultFileSystemItemFactory");
        Assert.assertTrue((boolean)(this.customFileSystemItemFactory instanceof VersioningFileSystemItemFactory));
        this.customFileSystemItemFactory.setVersioningDelay(1.5);
        Assert.assertEquals((double)1.5, (double)this.customFileSystemItemFactory.getVersioningDelay(), (double)0.01);
        this.customFileSystemItemFactory.setVersioningOption(VersioningOption.MAJOR);
        Assert.assertEquals((Object)VersioningOption.MAJOR, (Object)this.customFileSystemItemFactory.getVersioningOption());
    }

    @Test
    public void testDefaultConfiguration() throws Exception {
        FileItem fileItem = (FileItem)this.customFileSystemItemFactory.getFileSystemItem(this.file);
        DocumentModel rootDoc = this.session.getRootDocument();
        this.setPermission(rootDoc, "joe", "Read", true);
        try (CoreSession joeSession = this.coreFeature.openCoreSession("joe");){
            this.nuxeoDriveManager.registerSynchronizationRoot(joeSession.getPrincipal(), this.syncRootFolder, this.session);
        }
        TransactionHelper.commitOrRollbackTransaction();
        TransactionHelper.startTransaction();
        joeSession = this.coreFeature.openCoreSession("joe");
        var4_4 = null;
        try {
            this.file = joeSession.getDocument(this.file.getRef());
            fileItem = (FileItem)this.customFileSystemItemFactory.getFileSystemItem(this.file);
            Assert.assertFalse((boolean)fileItem.getCanUpdate());
            this.setPermission(rootDoc, "joe", "Write", true);
            fileItem = (FileItem)this.customFileSystemItemFactory.getFileSystemItem(this.file);
            Assert.assertTrue((boolean)fileItem.getCanUpdate());
            this.file = this.session.getDocument(this.file.getRef());
            fileItem = (FileItem)this.customFileSystemItemFactory.getFileSystemItem(this.file);
            Blob fileItemBlob = fileItem.getBlob();
            Assert.assertEquals((Object)"Joe.odt", (Object)fileItemBlob.getFilename());
            Assert.assertEquals((Object)"Content of Joe's file.", (Object)fileItemBlob.getString());
            Assert.assertEquals((Object)"0.0", (Object)this.file.getVersionLabel());
            StringBlob newBlob = new StringBlob("This is a new file.");
            newBlob.setFilename("New blob.txt");
            fileItem.setBlob((Blob)newBlob);
            this.file = this.session.getDocument(this.file.getRef());
            Blob updatedBlob = (Blob)this.file.getPropertyValue("file:content");
            Assert.assertEquals((Object)"New blob.txt", (Object)updatedBlob.getFilename());
            Assert.assertEquals((Object)"This is a new file.", (Object)updatedBlob.getString());
            Assert.assertEquals((Object)"0.0", (Object)this.file.getVersionLabel());
            Thread.sleep(1500L);
            newBlob.setFilename("File name modified.txt");
            fileItem.setBlob((Blob)newBlob);
            this.file = this.session.getDocument(this.file.getRef());
            updatedBlob = (Blob)this.file.getPropertyValue("file:content");
            Assert.assertEquals((Object)"File name modified.txt", (Object)updatedBlob.getFilename());
            Assert.assertEquals((Object)"1.0+", (Object)this.file.getVersionLabel());
            List fileVersions = this.session.getVersions(this.file.getRef());
            Assert.assertEquals((long)1L, (long)fileVersions.size());
            DocumentModel lastFileVersion = (DocumentModel)fileVersions.get(0);
            Blob versionedBlob = (Blob)lastFileVersion.getPropertyValue("file:content");
            Assert.assertEquals((Object)"New blob.txt", (Object)versionedBlob.getFilename());
            Thread.sleep(1500L);
            newBlob.setFilename("File name modified again.txt");
            fileItem.setBlob((Blob)newBlob);
            this.file = this.session.getDocument(this.file.getRef());
            updatedBlob = (Blob)this.file.getPropertyValue("file:content");
            Assert.assertEquals((Object)"File name modified again.txt", (Object)updatedBlob.getFilename());
            Assert.assertEquals((Object)"2.0+", (Object)this.file.getVersionLabel());
            fileVersions = this.session.getVersions(this.file.getRef());
            Assert.assertEquals((long)2L, (long)fileVersions.size());
            lastFileVersion = (DocumentModel)fileVersions.get(1);
            versionedBlob = (Blob)lastFileVersion.getPropertyValue("file:content");
            Assert.assertEquals((Object)"File name modified.txt", (Object)versionedBlob.getFilename());
            newBlob.setFilename("File name modified again as draft.txt");
            fileItem.setBlob((Blob)newBlob);
            this.file = this.session.getDocument(this.file.getRef());
            updatedBlob = (Blob)this.file.getPropertyValue("file:content");
            Assert.assertEquals((Object)"File name modified again as draft.txt", (Object)updatedBlob.getFilename());
            Assert.assertEquals((Object)"2.0+", (Object)this.file.getVersionLabel());
            fileVersions = this.session.getVersions(this.file.getRef());
            Assert.assertEquals((long)2L, (long)fileVersions.size());
            lastFileVersion = (DocumentModel)fileVersions.get(1);
            versionedBlob = (Blob)lastFileVersion.getPropertyValue("file:content");
            Assert.assertEquals((Object)"File name modified.txt", (Object)versionedBlob.getFilename());
            this.maybeSleepToNextSecond();
            this.file = joeSession.getDocument(this.file.getRef());
            fileItem = (FileItem)this.customFileSystemItemFactory.getFileSystemItem(this.file);
            newBlob.setFilename("File name modified by Joe.txt");
            fileItem.setBlob((Blob)newBlob);
            this.file = this.session.getDocument(this.file.getRef());
            updatedBlob = (Blob)this.file.getPropertyValue("file:content");
            Assert.assertEquals((Object)"File name modified by Joe.txt", (Object)updatedBlob.getFilename());
            Assert.assertEquals((Object)"3.0+", (Object)this.file.getVersionLabel());
            fileVersions = this.session.getVersions(this.file.getRef());
            Assert.assertEquals((long)3L, (long)fileVersions.size());
            lastFileVersion = (DocumentModel)fileVersions.get(2);
            versionedBlob = (Blob)lastFileVersion.getPropertyValue("file:content");
            Assert.assertEquals((Object)"File name modified again as draft.txt", (Object)versionedBlob.getFilename());
            Thread.sleep(1500L);
            this.maybeSleepToNextSecond();
            this.file = joeSession.getDocument(this.file.getRef());
            fileItem = (FileItem)this.customFileSystemItemFactory.getFileSystemItem(this.file);
            newBlob.setFilename("File name modified by Joe again.txt");
            fileItem.setBlob((Blob)newBlob);
            this.file = this.session.getDocument(this.file.getRef());
            updatedBlob = (Blob)this.file.getPropertyValue("file:content");
            Assert.assertEquals((Object)"File name modified by Joe again.txt", (Object)updatedBlob.getFilename());
            Assert.assertEquals((Object)"4.0+", (Object)this.file.getVersionLabel());
            fileVersions = this.session.getVersions(this.file.getRef());
            Assert.assertEquals((long)4L, (long)fileVersions.size());
            lastFileVersion = (DocumentModel)fileVersions.get(3);
            versionedBlob = (Blob)lastFileVersion.getPropertyValue("file:content");
            Assert.assertEquals((Object)"File name modified by Joe.txt", (Object)versionedBlob.getFilename());
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (joeSession != null) {
                if (var4_4 != null) {
                    try {
                        joeSession.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    joeSession.close();
                }
            }
        }
        this.resetPermissions(rootDoc, "joe");
    }

    @Test
    @LocalDeploy(value={"org.nuxeo.drive.core:OSGI-INF/test-nuxeodrive-configurationservice-contrib.xml"})
    public void testDriveForceVersionDisabled() throws Exception {
        ConfigurationService cs = (ConfigurationService)Framework.getLocalService(ConfigurationService.class);
        Assert.assertEquals((Object)"false", (Object)cs.getProperty("nuxeo.drive.force.versioning"));
        FileItem fileItem = (FileItem)this.customFileSystemItemFactory.getFileSystemItem(this.file);
        DocumentModel rootDoc = this.session.getRootDocument();
        this.setPermission(rootDoc, "joe", "Read", true);
        try (CoreSession joeSession = this.coreFeature.openCoreSession("joe");){
            this.nuxeoDriveManager.registerSynchronizationRoot(joeSession.getPrincipal(), this.syncRootFolder, this.session);
        }
        TransactionHelper.commitOrRollbackTransaction();
        TransactionHelper.startTransaction();
        joeSession = this.coreFeature.openCoreSession("joe");
        var5_5 = null;
        try {
            this.file = joeSession.getDocument(this.file.getRef());
            fileItem = (FileItem)this.customFileSystemItemFactory.getFileSystemItem(this.file);
            Assert.assertFalse((boolean)fileItem.getCanUpdate());
            this.setPermission(rootDoc, "joe", "Write", true);
            fileItem = (FileItem)this.customFileSystemItemFactory.getFileSystemItem(this.file);
            Assert.assertTrue((boolean)fileItem.getCanUpdate());
            this.file = this.session.getDocument(this.file.getRef());
            fileItem = (FileItem)this.customFileSystemItemFactory.getFileSystemItem(this.file);
            Blob fileItemBlob = fileItem.getBlob();
            Assert.assertEquals((Object)"Joe.odt", (Object)fileItemBlob.getFilename());
            Assert.assertEquals((Object)"Content of Joe's file.", (Object)fileItemBlob.getString());
            Assert.assertEquals((Object)"0.0", (Object)this.file.getVersionLabel());
            StringBlob newBlob = new StringBlob("This is a new file.");
            newBlob.setFilename("New blob.txt");
            fileItem.setBlob((Blob)newBlob);
            this.file = this.session.getDocument(this.file.getRef());
            Blob updatedBlob = (Blob)this.file.getPropertyValue("file:content");
            Assert.assertEquals((Object)"New blob.txt", (Object)updatedBlob.getFilename());
            Assert.assertEquals((Object)"This is a new file.", (Object)updatedBlob.getString());
            Assert.assertEquals((Object)"0.0", (Object)this.file.getVersionLabel());
            Thread.sleep(1500L);
            newBlob.setFilename("File name modified.txt");
            fileItem.setBlob((Blob)newBlob);
            this.file = this.session.getDocument(this.file.getRef());
            updatedBlob = (Blob)this.file.getPropertyValue("file:content");
            Assert.assertEquals((Object)"File name modified.txt", (Object)updatedBlob.getFilename());
            Assert.assertEquals((Object)"1.0+", (Object)this.file.getVersionLabel());
            List fileVersions = this.session.getVersions(this.file.getRef());
            Assert.assertEquals((long)1L, (long)fileVersions.size());
            DocumentModel lastFileVersion = (DocumentModel)fileVersions.get(0);
            Blob versionedBlob = (Blob)lastFileVersion.getPropertyValue("file:content");
            Assert.assertEquals((Object)"New blob.txt", (Object)versionedBlob.getFilename());
            Thread.sleep(1500L);
            newBlob.setFilename("File name modified again.txt");
            fileItem.setBlob((Blob)newBlob);
            this.file = this.session.getDocument(this.file.getRef());
            updatedBlob = (Blob)this.file.getPropertyValue("file:content");
            Assert.assertEquals((Object)"File name modified again.txt", (Object)updatedBlob.getFilename());
            Assert.assertEquals((Object)"2.0+", (Object)this.file.getVersionLabel());
            fileVersions = this.session.getVersions(this.file.getRef());
            Assert.assertEquals((long)2L, (long)fileVersions.size());
            lastFileVersion = (DocumentModel)fileVersions.get(1);
            versionedBlob = (Blob)lastFileVersion.getPropertyValue("file:content");
            Assert.assertEquals((Object)"File name modified.txt", (Object)versionedBlob.getFilename());
            newBlob.setFilename("File name modified again as draft.txt");
            fileItem.setBlob((Blob)newBlob);
            this.file = this.session.getDocument(this.file.getRef());
            updatedBlob = (Blob)this.file.getPropertyValue("file:content");
            Assert.assertEquals((Object)"File name modified again as draft.txt", (Object)updatedBlob.getFilename());
            Assert.assertEquals((Object)"2.0+", (Object)this.file.getVersionLabel());
            fileVersions = this.session.getVersions(this.file.getRef());
            Assert.assertEquals((long)2L, (long)fileVersions.size());
            lastFileVersion = (DocumentModel)fileVersions.get(1);
            versionedBlob = (Blob)lastFileVersion.getPropertyValue("file:content");
            Assert.assertEquals((Object)"File name modified.txt", (Object)versionedBlob.getFilename());
            this.maybeSleepToNextSecond();
            this.file = joeSession.getDocument(this.file.getRef());
            fileItem = (FileItem)this.customFileSystemItemFactory.getFileSystemItem(this.file);
            newBlob.setFilename("File name modified by Joe.txt");
            fileItem.setBlob((Blob)newBlob);
            this.file = this.session.getDocument(this.file.getRef());
            updatedBlob = (Blob)this.file.getPropertyValue("file:content");
            Assert.assertEquals((Object)"File name modified by Joe.txt", (Object)updatedBlob.getFilename());
            Assert.assertEquals((Object)"3.0+", (Object)this.file.getVersionLabel());
            fileVersions = this.session.getVersions(this.file.getRef());
            Assert.assertEquals((long)3L, (long)fileVersions.size());
            lastFileVersion = (DocumentModel)fileVersions.get(2);
            versionedBlob = (Blob)lastFileVersion.getPropertyValue("file:content");
            Assert.assertEquals((Object)"File name modified again as draft.txt", (Object)versionedBlob.getFilename());
            Thread.sleep(1500L);
            this.maybeSleepToNextSecond();
            this.file = joeSession.getDocument(this.file.getRef());
            fileItem = (FileItem)this.customFileSystemItemFactory.getFileSystemItem(this.file);
            newBlob.setFilename("File name modified by Joe again.txt");
            fileItem.setBlob((Blob)newBlob);
            this.file = this.session.getDocument(this.file.getRef());
            updatedBlob = (Blob)this.file.getPropertyValue("file:content");
            Assert.assertEquals((Object)"File name modified by Joe again.txt", (Object)updatedBlob.getFilename());
            Assert.assertEquals((Object)"4.0+", (Object)this.file.getVersionLabel());
            fileVersions = this.session.getVersions(this.file.getRef());
            Assert.assertEquals((long)4L, (long)fileVersions.size());
            lastFileVersion = (DocumentModel)fileVersions.get(3);
            versionedBlob = (Blob)lastFileVersion.getPropertyValue("file:content");
            Assert.assertEquals((Object)"File name modified by Joe.txt", (Object)versionedBlob.getFilename());
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (joeSession != null) {
                if (var5_5 != null) {
                    try {
                        joeSession.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    joeSession.close();
                }
            }
        }
        this.resetPermissions(rootDoc, "joe");
    }

    @Test
    @LocalDeploy(value={"org.nuxeo.drive.core:OSGI-INF/test-nuxeodrive-versioningrules-contrib.xml"})
    public void testAutomaticVersioning() throws Exception {
        FileItem fileItem = (FileItem)this.customFileSystemItemFactory.getFileSystemItem(this.file);
        DocumentModel rootDoc = this.session.getRootDocument();
        this.setPermission(rootDoc, "joe", "Read", true);
        try (CoreSession joeSession = this.coreFeature.openCoreSession("joe");){
            this.nuxeoDriveManager.registerSynchronizationRoot(joeSession.getPrincipal(), this.syncRootFolder, this.session);
        }
        TransactionHelper.commitOrRollbackTransaction();
        TransactionHelper.startTransaction();
        joeSession = this.coreFeature.openCoreSession("joe");
        var4_4 = null;
        try {
            this.file = joeSession.getDocument(this.file.getRef());
            fileItem = (FileItem)this.customFileSystemItemFactory.getFileSystemItem(this.file);
            Assert.assertFalse((boolean)fileItem.getCanUpdate());
            this.setPermission(rootDoc, "joe", "Write", true);
            fileItem = (FileItem)this.customFileSystemItemFactory.getFileSystemItem(this.file);
            Assert.assertTrue((boolean)fileItem.getCanUpdate());
            this.file = this.session.getDocument(this.file.getRef());
            fileItem = (FileItem)this.customFileSystemItemFactory.getFileSystemItem(this.file);
            Blob fileItemBlob = fileItem.getBlob();
            Assert.assertEquals((Object)"Joe.odt", (Object)fileItemBlob.getFilename());
            Assert.assertEquals((Object)"Content of Joe's file.", (Object)fileItemBlob.getString());
            Assert.assertEquals((Object)"0.0", (Object)this.file.getVersionLabel());
            StringBlob newBlob = new StringBlob("This is a new file.");
            newBlob.setFilename("New blob.txt");
            fileItem.setBlob((Blob)newBlob);
            this.file = this.session.getDocument(this.file.getRef());
            Blob updatedBlob = (Blob)this.file.getPropertyValue("file:content");
            Assert.assertEquals((Object)"New blob.txt", (Object)updatedBlob.getFilename());
            Assert.assertEquals((Object)"This is a new file.", (Object)updatedBlob.getString());
            Assert.assertEquals((Object)"0.0", (Object)this.file.getVersionLabel());
            Thread.sleep(1500L);
            newBlob.setFilename("File name modified.txt");
            fileItem.setBlob((Blob)newBlob);
            this.file = this.session.getDocument(this.file.getRef());
            updatedBlob = (Blob)this.file.getPropertyValue("file:content");
            Assert.assertEquals((Object)"File name modified.txt", (Object)updatedBlob.getFilename());
            Assert.assertEquals((Object)"1.1", (Object)this.file.getVersionLabel());
            List fileVersions = this.session.getVersions(this.file.getRef());
            Assert.assertEquals((long)2L, (long)fileVersions.size());
            DocumentModel lastMajorFileVersion = (DocumentModel)fileVersions.get(0);
            Blob versionedBlob = (Blob)lastMajorFileVersion.getPropertyValue("file:content");
            Assert.assertEquals((Object)"New blob.txt", (Object)versionedBlob.getFilename());
            DocumentModel lastFileVersion = (DocumentModel)fileVersions.get(1);
            versionedBlob = (Blob)lastFileVersion.getPropertyValue("file:content");
            Assert.assertEquals((Object)"File name modified.txt", (Object)versionedBlob.getFilename());
            Thread.sleep(1500L);
            newBlob.setFilename("File name modified again.txt");
            fileItem.setBlob((Blob)newBlob);
            this.file = this.session.getDocument(this.file.getRef());
            updatedBlob = (Blob)this.file.getPropertyValue("file:content");
            Assert.assertEquals((Object)"File name modified again.txt", (Object)updatedBlob.getFilename());
            Assert.assertEquals((Object)"1.2", (Object)this.file.getVersionLabel());
            fileVersions = this.session.getVersions(this.file.getRef());
            Assert.assertEquals((long)3L, (long)fileVersions.size());
            lastFileVersion = (DocumentModel)fileVersions.get(2);
            versionedBlob = (Blob)lastFileVersion.getPropertyValue("file:content");
            Assert.assertEquals((Object)"File name modified again.txt", (Object)versionedBlob.getFilename());
            newBlob.setFilename("File name modified again as new draft.txt");
            fileItem.setBlob((Blob)newBlob);
            this.file = this.session.getDocument(this.file.getRef());
            updatedBlob = (Blob)this.file.getPropertyValue("file:content");
            Assert.assertEquals((Object)"File name modified again as new draft.txt", (Object)updatedBlob.getFilename());
            Assert.assertEquals((Object)"1.2+", (Object)this.file.getVersionLabel());
            fileVersions = this.session.getVersions(this.file.getRef());
            Assert.assertEquals((long)3L, (long)fileVersions.size());
            lastFileVersion = (DocumentModel)fileVersions.get(2);
            versionedBlob = (Blob)lastFileVersion.getPropertyValue("file:content");
            Assert.assertEquals((Object)"File name modified again.txt", (Object)versionedBlob.getFilename());
            this.maybeSleepToNextSecond();
            this.file = joeSession.getDocument(this.file.getRef());
            fileItem = (FileItem)this.customFileSystemItemFactory.getFileSystemItem(this.file);
            newBlob.setFilename("File name modified by Joe.txt");
            fileItem.setBlob((Blob)newBlob);
            this.file = this.session.getDocument(this.file.getRef());
            updatedBlob = (Blob)this.file.getPropertyValue("file:content");
            Assert.assertEquals((Object)"File name modified by Joe.txt", (Object)updatedBlob.getFilename());
            Assert.assertEquals((Object)"2.1", (Object)this.file.getVersionLabel());
            fileVersions = this.session.getVersions(this.file.getRef());
            Assert.assertEquals((long)5L, (long)fileVersions.size());
            lastMajorFileVersion = (DocumentModel)fileVersions.get(3);
            versionedBlob = (Blob)lastMajorFileVersion.getPropertyValue("file:content");
            Assert.assertEquals((Object)"File name modified again as new draft.txt", (Object)versionedBlob.getFilename());
            lastFileVersion = (DocumentModel)fileVersions.get(4);
            versionedBlob = (Blob)lastFileVersion.getPropertyValue("file:content");
            Assert.assertEquals((Object)"File name modified by Joe.txt", (Object)versionedBlob.getFilename());
            Thread.sleep(1500L);
            this.maybeSleepToNextSecond();
            this.file = joeSession.getDocument(this.file.getRef());
            fileItem = (FileItem)this.customFileSystemItemFactory.getFileSystemItem(this.file);
            newBlob.setFilename("File name modified by Joe again.txt");
            fileItem.setBlob((Blob)newBlob);
            this.file = this.session.getDocument(this.file.getRef());
            updatedBlob = (Blob)this.file.getPropertyValue("file:content");
            Assert.assertEquals((Object)"File name modified by Joe again.txt", (Object)updatedBlob.getFilename());
            Assert.assertEquals((Object)"2.2", (Object)this.file.getVersionLabel());
            fileVersions = this.session.getVersions(this.file.getRef());
            Assert.assertEquals((long)6L, (long)fileVersions.size());
            lastFileVersion = (DocumentModel)fileVersions.get(5);
            versionedBlob = (Blob)lastFileVersion.getPropertyValue("file:content");
            Assert.assertEquals((Object)"File name modified by Joe again.txt", (Object)versionedBlob.getFilename());
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (joeSession != null) {
                if (var4_4 != null) {
                    try {
                        joeSession.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    joeSession.close();
                }
            }
        }
        this.resetPermissions(rootDoc, "joe");
    }

    @Test
    @LocalDeploy(value={"org.nuxeo.drive.core:OSGI-INF/test-nuxeodrive-versioningrules-contrib.xml", "org.nuxeo.drive.core:OSGI-INF/test-nuxeodrive-configurationservice-contrib.xml"})
    public void testAutomaticVersioningAndDriveForceVersionDisabled() throws Exception {
        ConfigurationService cs = (ConfigurationService)Framework.getLocalService(ConfigurationService.class);
        Assert.assertEquals((Object)"false", (Object)cs.getProperty("nuxeo.drive.force.versioning"));
        FileItem fileItem = (FileItem)this.customFileSystemItemFactory.getFileSystemItem(this.file);
        DocumentModel rootDoc = this.session.getRootDocument();
        this.setPermission(rootDoc, "joe", "Read", true);
        try (CoreSession joeSession = this.coreFeature.openCoreSession("joe");){
            this.nuxeoDriveManager.registerSynchronizationRoot(joeSession.getPrincipal(), this.syncRootFolder, this.session);
        }
        TransactionHelper.commitOrRollbackTransaction();
        TransactionHelper.startTransaction();
        joeSession = this.coreFeature.openCoreSession("joe");
        var5_5 = null;
        try {
            this.file = joeSession.getDocument(this.file.getRef());
            fileItem = (FileItem)this.customFileSystemItemFactory.getFileSystemItem(this.file);
            Assert.assertFalse((boolean)fileItem.getCanUpdate());
            this.setPermission(rootDoc, "joe", "Write", true);
            fileItem = (FileItem)this.customFileSystemItemFactory.getFileSystemItem(this.file);
            Assert.assertTrue((boolean)fileItem.getCanUpdate());
            this.file = this.session.getDocument(this.file.getRef());
            fileItem = (FileItem)this.customFileSystemItemFactory.getFileSystemItem(this.file);
            Blob fileItemBlob = fileItem.getBlob();
            Assert.assertEquals((Object)"Joe.odt", (Object)fileItemBlob.getFilename());
            Assert.assertEquals((Object)"Content of Joe's file.", (Object)fileItemBlob.getString());
            Assert.assertEquals((Object)"0.0", (Object)this.file.getVersionLabel());
            StringBlob newBlob = new StringBlob("This is a new file.");
            newBlob.setFilename("New blob.txt");
            fileItem.setBlob((Blob)newBlob);
            this.file = this.session.getDocument(this.file.getRef());
            Blob updatedBlob = (Blob)this.file.getPropertyValue("file:content");
            Assert.assertEquals((Object)"New blob.txt", (Object)updatedBlob.getFilename());
            Assert.assertEquals((Object)"This is a new file.", (Object)updatedBlob.getString());
            Assert.assertEquals((Object)"0.1", (Object)this.file.getVersionLabel());
            Thread.sleep(1500L);
            newBlob.setFilename("File name modified.txt");
            fileItem.setBlob((Blob)newBlob);
            this.file = this.session.getDocument(this.file.getRef());
            updatedBlob = (Blob)this.file.getPropertyValue("file:content");
            Assert.assertEquals((Object)"File name modified.txt", (Object)updatedBlob.getFilename());
            Assert.assertEquals((Object)"0.2", (Object)this.file.getVersionLabel());
            List fileVersions = this.session.getVersions(this.file.getRef());
            Assert.assertEquals((long)2L, (long)fileVersions.size());
            DocumentModel lastMajorFileVersion = (DocumentModel)fileVersions.get(0);
            Blob versionedBlob = (Blob)lastMajorFileVersion.getPropertyValue("file:content");
            Assert.assertEquals((Object)"New blob.txt", (Object)versionedBlob.getFilename());
            DocumentModel lastFileVersion = (DocumentModel)fileVersions.get(1);
            versionedBlob = (Blob)lastFileVersion.getPropertyValue("file:content");
            Assert.assertEquals((Object)"File name modified.txt", (Object)versionedBlob.getFilename());
            Thread.sleep(1500L);
            newBlob.setFilename("File name modified again.txt");
            fileItem.setBlob((Blob)newBlob);
            this.file = this.session.getDocument(this.file.getRef());
            updatedBlob = (Blob)this.file.getPropertyValue("file:content");
            Assert.assertEquals((Object)"File name modified again.txt", (Object)updatedBlob.getFilename());
            Assert.assertEquals((Object)"0.3", (Object)this.file.getVersionLabel());
            fileVersions = this.session.getVersions(this.file.getRef());
            Assert.assertEquals((long)3L, (long)fileVersions.size());
            lastFileVersion = (DocumentModel)fileVersions.get(2);
            versionedBlob = (Blob)lastFileVersion.getPropertyValue("file:content");
            Assert.assertEquals((Object)"File name modified again.txt", (Object)versionedBlob.getFilename());
            newBlob.setFilename("File name modified again as draft.txt");
            fileItem.setBlob((Blob)newBlob);
            this.file = this.session.getDocument(this.file.getRef());
            updatedBlob = (Blob)this.file.getPropertyValue("file:content");
            Assert.assertEquals((Object)"File name modified again as draft.txt", (Object)updatedBlob.getFilename());
            Assert.assertEquals((Object)"0.4", (Object)this.file.getVersionLabel());
            fileVersions = this.session.getVersions(this.file.getRef());
            Assert.assertEquals((long)4L, (long)fileVersions.size());
            lastFileVersion = (DocumentModel)fileVersions.get(3);
            versionedBlob = (Blob)lastFileVersion.getPropertyValue("file:content");
            Assert.assertEquals((Object)"File name modified again as draft.txt", (Object)versionedBlob.getFilename());
            this.maybeSleepToNextSecond();
            this.file = joeSession.getDocument(this.file.getRef());
            fileItem = (FileItem)this.customFileSystemItemFactory.getFileSystemItem(this.file);
            newBlob.setFilename("File name modified by Joe.txt");
            fileItem.setBlob((Blob)newBlob);
            this.file = this.session.getDocument(this.file.getRef());
            updatedBlob = (Blob)this.file.getPropertyValue("file:content");
            Assert.assertEquals((Object)"File name modified by Joe.txt", (Object)updatedBlob.getFilename());
            Assert.assertEquals((Object)"0.5", (Object)this.file.getVersionLabel());
            fileVersions = this.session.getVersions(this.file.getRef());
            Assert.assertEquals((long)5L, (long)fileVersions.size());
            lastFileVersion = (DocumentModel)fileVersions.get(4);
            versionedBlob = (Blob)lastFileVersion.getPropertyValue("file:content");
            Assert.assertEquals((Object)"File name modified by Joe.txt", (Object)versionedBlob.getFilename());
            Thread.sleep(1500L);
            this.maybeSleepToNextSecond();
            this.file = joeSession.getDocument(this.file.getRef());
            fileItem = (FileItem)this.customFileSystemItemFactory.getFileSystemItem(this.file);
            newBlob.setFilename("File name modified by Joe again.txt");
            fileItem.setBlob((Blob)newBlob);
            this.file = this.session.getDocument(this.file.getRef());
            updatedBlob = (Blob)this.file.getPropertyValue("file:content");
            Assert.assertEquals((Object)"File name modified by Joe again.txt", (Object)updatedBlob.getFilename());
            Assert.assertEquals((Object)"0.6", (Object)this.file.getVersionLabel());
            fileVersions = this.session.getVersions(this.file.getRef());
            Assert.assertEquals((long)6L, (long)fileVersions.size());
            lastFileVersion = (DocumentModel)fileVersions.get(5);
            versionedBlob = (Blob)lastFileVersion.getPropertyValue("file:content");
            Assert.assertEquals((Object)"File name modified by Joe again.txt", (Object)versionedBlob.getFilename());
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (joeSession != null) {
                if (var5_5 != null) {
                    try {
                        joeSession.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    joeSession.close();
                }
            }
        }
        this.resetPermissions(rootDoc, "joe");
    }

    protected void setPermission(DocumentModel doc, String userName, String permission, boolean isGranted) {
        ACP acp = this.session.getACP(doc.getRef());
        ACL localACL = acp.getOrCreateACL("local");
        localACL.add(new ACE(userName, permission, isGranted));
        this.session.setACP(doc.getRef(), acp, true);
        this.session.save();
    }

    protected void resetPermissions(DocumentModel doc, String userName) {
        ACP acp = this.session.getACP(doc.getRef());
        ACL localACL = acp.getOrCreateACL("local");
        Iterator localACLIt = localACL.iterator();
        while (localACLIt.hasNext()) {
            ACE ace = (ACE)localACLIt.next();
            if (!userName.equals(ace.getUsername())) continue;
            localACLIt.remove();
        }
        this.session.setACP(doc.getRef(), acp, true);
        this.session.save();
    }

    protected long getVersion(DocumentModel doc, String prop) {
        Serializable propVal = doc.getPropertyValue(prop);
        if (propVal == null || !(propVal instanceof Long)) {
            return -1L;
        }
        return (Long)propVal;
    }
}

