/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.automation.scripting.internals;

import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.automation.scripting.internals.ScriptingCache;
import org.nuxeo.automation.scripting.internals.ScriptingCacheClassFilter;
import org.nuxeo.runtime.api.Framework;

public class ScriptingFactory {
    private static final Log log = LogFactory.getLog(ScriptingFactory.class);
    protected ScriptEngineManager scriptEngineManager = new ScriptEngineManager();

    protected void install() {
        this.scriptEngineManager.registerEngineName("nx-nashorn", this.newFactory());
    }

    protected ScriptEngineFactory newFactory() {
        String version = Framework.getProperty((String)"java.version", (String)"1.8");
        if (version.contains("1.8")) {
            if (version.compareTo("1.8.0_25") < 0) {
                log.warn((Object)"Nashorn cache is not available. jdk8u25 is required to optimize Automation Javascript performances.");
                return new ScriptingCache(false);
            }
            if (version.compareTo("1.8.0_25") >= 0 && version.compareTo("1.8.0_40") < 0) {
                if (Boolean.valueOf(Framework.getProperty((String)"automation.scripting.precompile.enable", (String)"true")).booleanValue()) {
                    log.warn((Object)"Class Filter is not available. jdk8u40 is required to activate Automation Javascript imports security.");
                    return new ScriptingCache(true);
                }
                log.warn((Object)"Class Filter is not available. jdk8u40 is required to activate Automation Javascript imports security.");
                return new ScriptingCache(false);
            }
            if (version.compareTo("1.8.0_40") >= 0) {
                try {
                    if (Boolean.valueOf(Framework.getProperty((String)"automation.scripting.precompile.enable", (String)"true")).booleanValue()) {
                        return new ScriptingCacheClassFilter(true);
                    }
                    return new ScriptingCacheClassFilter(false);
                }
                catch (NoClassDefFoundError cause) {
                    log.warn((Object)"Class Filter is not available. jdk8u40 is required to activate Automation Javascript imports security.");
                    return new ScriptingCache(true);
                }
            }
        }
        log.warn((Object)"Cannot use Nashorn. jdk8 is required to activate Automation Javascript.");
        throw new UnsupportedOperationException();
    }
}

