/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.jtajca;

import javax.transaction.TransactionManager;
import org.apache.geronimo.connector.outbound.AbstractConnectionManager;
import org.apache.geronimo.connector.outbound.ConnectionHandleInterceptor;
import org.apache.geronimo.connector.outbound.ConnectionInterceptor;
import org.apache.geronimo.connector.outbound.ConnectionTrackingInterceptor;
import org.apache.geronimo.connector.outbound.MCFConnectionInterceptor;
import org.apache.geronimo.connector.outbound.SubjectInterceptor;
import org.apache.geronimo.connector.outbound.SubjectSource;
import org.apache.geronimo.connector.outbound.TCCLInterceptor;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.PartitionedPool;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.PoolingSupport;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.TransactionSupport;
import org.apache.geronimo.connector.outbound.connectiontracking.ConnectionTracker;
import org.apache.geronimo.transaction.manager.RecoverableTransactionManager;
import org.nuxeo.runtime.jtajca.NuxeoValidationSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NuxeoConnectionManager
extends AbstractConnectionManager {
    private static final long serialVersionUID = 1L;
    protected static final Logger log = LoggerFactory.getLogger(NuxeoConnectionManager.class);

    public NuxeoConnectionManager(NuxeoValidationSupport validationSupport, TransactionSupport transactionSupport, PoolingSupport pooling, SubjectSource subjectSource, ConnectionTracker connectionTracker, RecoverableTransactionManager transactionManager, String name, ClassLoader classLoader) {
        super((AbstractConnectionManager.Interceptors)new InterceptorsImpl(validationSupport, transactionSupport, pooling, subjectSource, name, connectionTracker, (TransactionManager)transactionManager, classLoader), transactionManager, name);
    }

    public void doStop() throws Exception {
        if (this.getConnectionCount() < this.getPartitionMinSize()) {
            Thread.sleep(10L);
        }
        super.doStop();
    }

    static class InterceptorsImpl
    implements AbstractConnectionManager.Interceptors {
        private final ConnectionInterceptor stack;
        private final ConnectionInterceptor recoveryStack;
        private final PoolingSupport poolingSupport;

        public InterceptorsImpl(NuxeoValidationSupport validationSupport, TransactionSupport transactionSupport, PoolingSupport pooling, SubjectSource subjectSource, String name, ConnectionTracker connectionTracker, TransactionManager transactionManager, ClassLoader classLoader) {
            MCFConnectionInterceptor tail;
            if (subjectSource == null && pooling instanceof PartitionedPool && ((PartitionedPool)pooling).isPartitionBySubject()) {
                throw new IllegalStateException("To use Subject in pooling, you need a SecurityDomain");
            }
            MCFConnectionInterceptor stack = tail = new MCFConnectionInterceptor();
            stack = transactionSupport.addXAResourceInsertionInterceptor((ConnectionInterceptor)stack, name);
            stack = pooling.addPoolingInterceptors((ConnectionInterceptor)stack);
            if (log.isTraceEnabled()) {
                log.trace("Connection Manager " + name + " installed pool " + stack);
            }
            this.poolingSupport = pooling;
            stack = transactionSupport.addTransactionInterceptors((ConnectionInterceptor)stack, transactionManager);
            if (subjectSource != null) {
                stack = new SubjectInterceptor((ConnectionInterceptor)stack, subjectSource);
            }
            this.recoveryStack = transactionSupport.isRecoverable() ? new TCCLInterceptor((ConnectionInterceptor)stack, classLoader) : null;
            stack = new ConnectionHandleInterceptor((ConnectionInterceptor)stack);
            stack = validationSupport.addTransactionInterceptor((ConnectionInterceptor)stack);
            stack = new TCCLInterceptor((ConnectionInterceptor)stack, classLoader);
            if (connectionTracker != null) {
                stack = new ConnectionTrackingInterceptor((ConnectionInterceptor)stack, name, connectionTracker);
            }
            tail.setStack((ConnectionInterceptor)stack);
            this.stack = stack;
            if (log.isDebugEnabled()) {
                StringBuilder s = new StringBuilder("ConnectionManager Interceptor stack;\n");
                stack.info(s);
                log.debug(s.toString());
            }
        }

        public ConnectionInterceptor getStack() {
            return this.stack;
        }

        public ConnectionInterceptor getRecoveryStack() {
            return this.recoveryStack;
        }

        public PoolingSupport getPoolingAttributes() {
            return this.poolingSupport;
        }
    }
}

