/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.test;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.platform.test.TranslationMessagesDiffer;
import org.nuxeo.ecm.platform.test.TranslationProperties;

public abstract class AbstractTranslationTestCase {
    private static final Log log = LogFactory.getLog(AbstractTranslationTestCase.class);

    protected InputStream getFromContext(String path) throws IOException {
        String file = FileUtils.getResourcePathFromContext((String)path);
        return new FileInputStream(file);
    }

    protected TranslationProperties extractProps(String path) throws IOException {
        InputStream in = this.getFromContext(path);
        return this.extractProps(in);
    }

    protected TranslationProperties extractProps(InputStream in) throws IOException {
        TranslationProperties props = new TranslationProperties();
        props.load(in);
        return props;
    }

    protected void checkFormat(String path) throws IOException {
        TranslationProperties p = this.extractProps(path);
        Assert.assertNotNull((Object)p);
        this.checkSingleLabels(path, p);
    }

    protected void checkSingleLabels(String path, TranslationProperties p) throws IOException {
        Set<String> single = p.getSingleLabels();
        if (single.size() > 0) {
            log.warn((Object)String.format("%s single translation keys in file at '%s'.", single.size(), path));
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Single keys: '%s'", single));
            }
        }
    }

    protected void checkDuplicates(String path, String ... allowed) throws IOException {
        TranslationProperties r = this.extractProps(path);
        if (allowed != null && allowed.length > 0) {
            Assert.assertEquals((String)String.format("Unexpected duplicates in file at '%s'", path), Arrays.asList(allowed), (Object)r.getDuplicates());
        } else {
            Assert.assertEquals((String)String.format("Duplicates in file at '%s': %s", path, r.getDuplicates().toString()), (long)0L, (long)r.getDuplicates().size());
        }
    }

    protected void checkDiff(String path1, String path2) throws IOException {
        TranslationProperties p1 = this.extractProps(path1);
        TranslationProperties p2 = this.extractProps(path2);
        TranslationMessagesDiffer diff = new TranslationMessagesDiffer(p1, p2);
        List<String> missing = diff.getMissingDestKeys();
        Assert.assertEquals((String)String.format("Missing translation keys in file at '%s' compared to '%s': %s", path2, path1, missing), (long)0L, (long)missing.size());
    }
}

