/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.JDBCUtils;
import org.nuxeo.ecm.core.blob.binary.BinaryManager;
import org.nuxeo.ecm.core.blob.binary.DefaultBinaryManager;
import org.nuxeo.ecm.core.storage.sql.DatabaseOracle;
import org.nuxeo.ecm.core.storage.sql.RepositoryDescriptor;
import org.nuxeo.runtime.RuntimeServiceEvent;
import org.nuxeo.runtime.RuntimeServiceListener;
import org.nuxeo.runtime.api.Framework;

public abstract class DatabaseHelper {
    private static final Log log = LogFactory.getLog(DatabaseHelper.class);
    public static final String DB_PROPERTY = "nuxeo.test.vcs.db";
    public static final String DB_DEFAULT = "H2";
    public static final String DEF_ID_TYPE = "varchar";
    private static final boolean SINGLEDS_DEFAULT = false;
    public static DatabaseHelper DATABASE;
    public static final String DB_CLASS_NAME_BASE = "org.nuxeo.ecm.core.storage.sql.Database";
    protected static final Class<? extends BinaryManager> defaultBinaryManager;
    public static final String DRIVER_PROPERTY = "nuxeo.test.vcs.driver";
    public static final String XA_DATASOURCE_PROPERTY = "nuxeo.test.vcs.xadatasource";
    public static final String URL_PROPERTY = "nuxeo.test.vcs.url";
    public static final String SERVER_PROPERTY = "nuxeo.test.vcs.server";
    public static final String PORT_PROPERTY = "nuxeo.test.vcs.port";
    public static final String DATABASE_PROPERTY = "nuxeo.test.vcs.database";
    public static final String USER_PROPERTY = "nuxeo.test.vcs.user";
    public static final String PASSWORD_PROPERTY = "nuxeo.test.vcs.password";
    public static final String ID_TYPE_PROPERTY = "nuxeo.test.vcs.idtype";
    public static final String SINGLEDS_PROPERTY = "nuxeo.test.vcs.singleds";
    protected Error owner;
    public static final String DEFAULT_DATABASE_NAME = "nuxeojunittests";
    public String databaseName = "nuxeojunittests";

    public static String setSystemProperty(String name, String def) {
        String value = System.getProperty(name);
        if (value == null || value.equals("") || value.equals("${" + name + "}")) {
            System.setProperty(name, def);
        }
        return value;
    }

    public static String setProperty(String name, String def) {
        String value = System.getProperty(name);
        if (value == null || value.equals("") || value.equals("${" + name + "}")) {
            value = def;
        }
        Framework.getProperties().setProperty(name, value);
        return value;
    }

    public void setDatabaseName(String name) {
        this.databaseName = name;
    }

    public static void setDatabaseForTests(String className) {
        try {
            DATABASE = (DatabaseHelper)Class.forName(className).newInstance();
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError("Database class not found: " + className);
        }
    }

    public static Connection getConnection(String url, String user, String password) throws SQLException {
        return JDBCUtils.getConnection((String)url, (String)user, (String)password);
    }

    public static void doOnAllTables(Connection connection, String catalog, String schemaPattern, String statement) throws SQLException {
        DatabaseMetaData metadata = connection.getMetaData();
        LinkedList<String> tableNames = new LinkedList<String>();
        HashSet<String> truncateFirst = new HashSet<String>();
        ResultSet rs = metadata.getTables(catalog, schemaPattern, "%", new String[]{"TABLE"});
        while (rs.next()) {
            String tableName = rs.getString("TABLE_NAME");
            if (tableName.indexOf(36) != -1 || tableName.toLowerCase().startsWith("trace_xe_") || "ACLR_USER_USERS".equals(tableName) || "ANCESTORS_ANCESTORS".equals(tableName)) continue;
            if ("ACLR_MODIFIED".equals(tableName) && DATABASE instanceof DatabaseOracle) {
                truncateFirst.add(tableName);
            }
            tableNames.add(tableName);
        }
        if (tableNames.remove("HIERARCHY")) {
            tableNames.add("HIERARCHY");
        }
        if (tableNames.remove("NXP_LOGS")) {
            tableNames.add("NXP_LOGS");
        }
        if (tableNames.remove("NXP_LOGS_EXTINFO")) {
            tableNames.add("NXP_LOGS_EXTINFO");
        }
        if (tableNames.remove("hierarchy")) {
            tableNames.add("hierarchy");
        }
        Statement st = connection.createStatement();
        for (String tableName : tableNames) {
            String sql;
            if (truncateFirst.contains(tableName)) {
                sql = String.format("TRUNCATE TABLE \"%s\"", tableName);
                DatabaseHelper.executeSql(st, sql);
            }
            sql = String.format(statement, tableName);
            DatabaseHelper.executeSql(st, sql);
        }
        st.close();
    }

    protected static void executeSql(Statement st, String sql) throws SQLException {
        log.trace((Object)("SQL: " + sql));
        st.execute(sql);
    }

    public void setUp() throws SQLException {
        this.setOwner();
        this.setDatabaseName(DEFAULT_DATABASE_NAME);
        DatabaseHelper.setBinaryManager(defaultBinaryManager, "");
        DatabaseHelper.setSingleDataSourceMode();
        Framework.addListener((RuntimeServiceListener)new RuntimeServiceListener(){

            public void handleEvent(RuntimeServiceEvent event) {
                if (3 == event.id) {
                    try {
                        DatabaseHelper.this.tearDown();
                    }
                    catch (SQLException cause) {
                        throw new AssertionError("Cannot teardown database", cause);
                    }
                }
            }
        });
    }

    protected void setOwner() {
        if (this.owner != null) {
            Error e = new Error("Second call to setUp() without tearDown()", this.owner);
            log.fatal((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
        this.owner = new Error("Database not released");
    }

    public void tearDown() throws SQLException {
        this.owner = null;
    }

    public static void setBinaryManager(Class<? extends BinaryManager> binaryManagerClass, String key) {
        DatabaseHelper.setProperty("nuxeo.test.vcs.binary-manager", binaryManagerClass.getName());
        DatabaseHelper.setProperty("nuxeo.test.vcs.binary-manager-key", key);
    }

    public abstract String getDeploymentContrib();

    public abstract RepositoryDescriptor getRepositoryDescriptor();

    public static void setSingleDataSourceMode() {
        if (Boolean.parseBoolean(System.getProperty(SINGLEDS_PROPERTY))) {
            String dataSourceName = "jdbc/NuxeoTestDS";
            Framework.getProperties().setProperty("nuxeo.db.singleDataSource", dataSourceName);
        }
    }

    public void sleepForFulltext() {
    }

    public void maybeSleepToNextSecond() {
        if (!this.hasSubSecondResolution()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public boolean hasSubSecondResolution() {
        return true;
    }

    public int getRecursiveRemovalDepthLimit() {
        return 0;
    }

    public boolean supportsClustering() {
        return false;
    }

    public boolean supportsMultipleFulltextIndexes() {
        return true;
    }

    public boolean supportsXA() {
        return true;
    }

    public boolean supportsSoftDelete() {
        return false;
    }

    public boolean supportsSequenceId() {
        return false;
    }

    public boolean supportsArrayColumns() {
        return false;
    }

    static {
        defaultBinaryManager = DefaultBinaryManager.class;
        DatabaseHelper.setSystemProperty(DB_PROPERTY, DB_DEFAULT);
        String className = System.getProperty(DB_PROPERTY);
        if (className.indexOf(46) < 0) {
            className = DB_CLASS_NAME_BASE + className;
        }
        DatabaseHelper.setDatabaseForTests(className);
    }
}

