/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;

public abstract class LockStepJob
implements Runnable {
    protected int n;
    protected CyclicBarrier barrier;
    protected Throwable throwable;

    public void initialize(int n, CyclicBarrier barrier) {
        this.n = n;
        this.barrier = barrier;
    }

    @Override
    public void run() {
        try {
            this.job();
        }
        catch (Throwable t) {
            this.throwable = t;
        }
    }

    public boolean thread(int which) throws Exception {
        this.barrier.await(30L, TimeUnit.SECONDS);
        return which == this.n;
    }

    public abstract void job() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void run(LockStepJob ... jobs) throws Exception {
        int n = jobs.length;
        CyclicBarrier barrier = new CyclicBarrier(n);
        for (int i = 0; i < n; ++i) {
            jobs[i].initialize(i + 1, barrier);
        }
        Thread[] threads = new Thread[n];
        try {
            int i;
            for (i = 0; i < n; ++i) {
                threads[i] = new Thread((Runnable)jobs[i], "test-" + (i + 1));
                threads[i].start();
            }
            for (i = 0; i < n; ++i) {
                threads[i].join();
                threads[i] = null;
            }
            RuntimeException exception = new RuntimeException("failed");
            for (int i2 = 0; i2 < n; ++i2) {
                Throwable t = jobs[i2].throwable;
                if (t == null) continue;
                exception.addSuppressed(t);
            }
            if (exception.getSuppressed().length > 0) {
                throw exception;
            }
        }
        finally {
            for (int i = 0; i < n; ++i) {
                if (threads[i] == null) continue;
                threads[i].interrupt();
            }
        }
    }
}

