/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.security;

import java.security.Principal;
import org.nuxeo.ecm.core.query.sql.model.Operand;
import org.nuxeo.ecm.core.query.sql.model.Operator;
import org.nuxeo.ecm.core.query.sql.model.Predicate;
import org.nuxeo.ecm.core.query.sql.model.Reference;
import org.nuxeo.ecm.core.query.sql.model.SQLQuery;
import org.nuxeo.ecm.core.query.sql.model.StringLiteral;
import org.nuxeo.ecm.core.query.sql.model.WhereClause;
import org.nuxeo.ecm.core.storage.sql.security.NoFileSecurityPolicy;

public class NoFile2SecurityPolicy
extends NoFileSecurityPolicy {
    public static final SQLQuery.Transformer NO_FILE_TRANSFORMER = new NoFileTransformer();

    @Override
    public boolean isExpressibleInQuery() {
        return true;
    }

    @Override
    public SQLQuery.Transformer getQueryTransformer() {
        return NO_FILE_TRANSFORMER;
    }

    public static class NoFileTransformer
    implements SQLQuery.Transformer {
        private static final long serialVersionUID = 1L;
        public static final Predicate NO_FILE = new Predicate((Operand)new Reference("ecm:primaryType"), Operator.NOTEQ, (Operand)new StringLiteral("File"));

        public SQLQuery transform(Principal principal, SQLQuery query) {
            WhereClause where = query.where;
            Predicate predicate = where == null || where.predicate == null ? NO_FILE : new Predicate((Operand)NO_FILE, Operator.AND, (Operand)where.predicate);
            SQLQuery newQuery = new SQLQuery(query.select, query.from, new WhereClause(predicate), query.groupBy, query.having, query.orderBy, query.limit, query.offset);
            return newQuery;
        }
    }
}

