/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.rendition.adapter;

import java.util.List;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.rendition.Renderable;
import org.nuxeo.ecm.platform.rendition.Rendition;
import org.nuxeo.ecm.platform.rendition.service.RenditionDefinition;
import org.nuxeo.ecm.platform.rendition.service.RenditionService;
import org.nuxeo.runtime.api.Framework;

public class RenderableDocument
implements Renderable {
    protected final DocumentModel doc;
    protected List<RenditionDefinition> defs = null;

    public RenderableDocument(DocumentModel doc) {
        this.doc = doc;
    }

    public List<RenditionDefinition> getAvailableRenditionDefinitions() {
        if (this.defs == null) {
            this.defs = ((RenditionService)Framework.getLocalService(RenditionService.class)).getAvailableRenditionDefinitions(this.doc);
        }
        return this.defs;
    }

    public Rendition getRenditionByName(String name) {
        for (RenditionDefinition def : this.getAvailableRenditionDefinitions()) {
            if (!def.getName().equals(name)) continue;
            return this.getRendition(def);
        }
        return null;
    }

    public Rendition getRenditionByKind(String kind) {
        for (RenditionDefinition def : this.getAvailableRenditionDefinitions()) {
            if (!def.getKind().equals(kind)) continue;
            return this.getRendition(def);
        }
        return null;
    }

    protected Rendition getRendition(RenditionDefinition def) {
        return ((RenditionService)Framework.getLocalService(RenditionService.class)).getRendition(this.doc, def.getName());
    }
}

