/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.rendition.lazy;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.core.transientstore.api.TransientStore;
import org.nuxeo.ecm.core.transientstore.api.TransientStoreService;
import org.nuxeo.ecm.core.transientstore.work.TransientStoreWork;
import org.nuxeo.ecm.platform.rendition.service.RenditionDefinition;
import org.nuxeo.ecm.platform.rendition.service.RenditionService;
import org.nuxeo.ecm.platform.rendition.service.RenditionServiceImpl;
import org.nuxeo.runtime.api.Framework;

public abstract class AbstractRenditionBuilderWork
extends TransientStoreWork {
    private static final long serialVersionUID = 1L;
    protected final String key;
    protected final DocumentRef docRef;
    protected final String repositoryName;
    protected final String renditionName;
    protected static Log log = LogFactory.getLog(AbstractRenditionBuilderWork.class);

    public AbstractRenditionBuilderWork(String key, DocumentModel doc, RenditionDefinition def) {
        this.key = key;
        this.docRef = doc.getRef();
        this.repositoryName = doc.getRepositoryName();
        this.renditionName = def.getName();
        this.setOriginatingUsername(doc.getCoreSession().getPrincipal().getName());
    }

    public String getId() {
        return "rendition:" + this.key;
    }

    public String getTitle() {
        return "Lazy Rendition for " + this.renditionName + " on " + this.docRef.toString();
    }

    protected String getTransientStoreName() {
        return "LazyRenditionCache";
    }

    public void work() {
        this.openUserSession();
        DocumentModel doc = this.session.getDocument(this.docRef);
        RenditionService rs = (RenditionService)Framework.getService(RenditionService.class);
        RenditionDefinition def = ((RenditionServiceImpl)rs).getRenditionDefinition(this.renditionName);
        List<Blob> blobs = this.doComputeRendition(this.session, doc, def);
        this.doStore(blobs);
    }

    public void cleanUp(boolean ok, Exception e) {
        super.cleanUp(ok, e);
        if (ok) {
            return;
        }
        ArrayList<Blob> blobs = new ArrayList<Blob>();
        StringBlob emptyBlob = new StringBlob("");
        emptyBlob.setFilename("error");
        emptyBlob.setMimeType("text/plain;error=true");
        blobs.add((Blob)emptyBlob);
        this.doStore(blobs);
    }

    void doStore(List<Blob> blobs) {
        TransientStoreService tss = (TransientStoreService)Framework.getService(TransientStoreService.class);
        TransientStore ts = tss.getStore(this.getTransientStoreName());
        if (!ts.exists(this.key)) {
            throw new NuxeoException("Rendition TransientStore entry can not be null");
        }
        ts.putBlobs(this.key, blobs);
        ts.setCompleted(this.key, true);
    }

    protected abstract List<Blob> doComputeRendition(CoreSession var1, DocumentModel var2, RenditionDefinition var3);
}

