/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.binary.metadata.internals;

import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.binary.metadata.api.BinaryMetadataException;
import org.nuxeo.binary.metadata.api.BinaryMetadataProcessor;
import org.nuxeo.binary.metadata.api.BinaryMetadataService;
import org.nuxeo.binary.metadata.internals.BinaryMetadataComponent;
import org.nuxeo.binary.metadata.internals.MetadataMappingDescriptor;
import org.nuxeo.binary.metadata.internals.MetadataRuleDescriptor;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.actions.ActionContext;
import org.nuxeo.ecm.platform.actions.ELActionContext;
import org.nuxeo.ecm.platform.actions.ejb.ActionManager;
import org.nuxeo.runtime.api.Framework;

public class BinaryMetadataServiceImpl
implements BinaryMetadataService {
    private static final Log log = LogFactory.getLog(BinaryMetadataServiceImpl.class);

    @Override
    public Map<String, Object> readMetadata(String processorName, Blob blob, List<String> metadataNames, boolean ignorePrefix) {
        try {
            BinaryMetadataProcessor processor = this.getProcessor(processorName);
            return processor.readMetadata(blob, metadataNames, ignorePrefix);
        }
        catch (NoSuchMethodException e) {
            throw new BinaryMetadataException(e);
        }
    }

    @Override
    public Map<String, Object> readMetadata(Blob blob, List<String> metadataNames, boolean ignorePrefix) {
        try {
            BinaryMetadataProcessor processor = this.getProcessor("exifTool");
            return processor.readMetadata(blob, metadataNames, ignorePrefix);
        }
        catch (NoSuchMethodException e) {
            throw new BinaryMetadataException(e);
        }
    }

    @Override
    public Map<String, Object> readMetadata(Blob blob, boolean ignorePrefix) {
        try {
            BinaryMetadataProcessor processor = this.getProcessor("exifTool");
            return processor.readMetadata(blob, ignorePrefix);
        }
        catch (NoSuchMethodException e) {
            throw new BinaryMetadataException(e);
        }
    }

    @Override
    public Map<String, Object> readMetadata(String processorName, Blob blob, boolean ignorePrefix) {
        try {
            BinaryMetadataProcessor processor = this.getProcessor(processorName);
            return processor.readMetadata(blob, ignorePrefix);
        }
        catch (NoSuchMethodException e) {
            throw new BinaryMetadataException(e);
        }
    }

    @Override
    public Blob writeMetadata(String processorName, Blob blob, Map<String, Object> metadata, boolean ignorePrefix) {
        try {
            BinaryMetadataProcessor processor = this.getProcessor(processorName);
            return processor.writeMetadata(blob, metadata, ignorePrefix);
        }
        catch (NoSuchMethodException e) {
            throw new BinaryMetadataException(e);
        }
    }

    @Override
    public Blob writeMetadata(Blob blob, Map<String, Object> metadata, boolean ignorePrefix) {
        try {
            BinaryMetadataProcessor processor = this.getProcessor("exifTool");
            return processor.writeMetadata(blob, metadata, ignorePrefix);
        }
        catch (NoSuchMethodException e) {
            throw new BinaryMetadataException(e);
        }
    }

    @Override
    public Blob writeMetadata(String processorName, Blob blob, String mappingDescriptorId, DocumentModel doc) {
        try {
            HashMap<String, Object> metadataMapping = new HashMap<String, Object>();
            MetadataMappingDescriptor mappingDescriptor = BinaryMetadataComponent.self.mappingRegistry.getMappingDescriptorMap().get(mappingDescriptorId);
            for (MetadataMappingDescriptor.MetadataDescriptor metadataDescriptor : mappingDescriptor.getMetadataDescriptors()) {
                metadataMapping.put(metadataDescriptor.getName(), doc.getPropertyValue(metadataDescriptor.getXpath()));
            }
            BinaryMetadataProcessor processor = this.getProcessor(processorName);
            return processor.writeMetadata(blob, metadataMapping, mappingDescriptor.getIgnorePrefix());
        }
        catch (NoSuchMethodException e) {
            throw new BinaryMetadataException(e);
        }
    }

    @Override
    public Blob writeMetadata(Blob blob, String mappingDescriptorId, DocumentModel doc) {
        return this.writeMetadata("exifTool", blob, mappingDescriptorId, doc);
    }

    @Override
    public void writeMetadata(DocumentModel doc, CoreSession session) {
        ActionContext actionContext = this.createActionContext(doc);
        Set<MetadataRuleDescriptor> ruleDescriptors = this.checkFilter(actionContext);
        ArrayList<String> mappingDescriptorIds = new ArrayList<String>();
        for (MetadataRuleDescriptor ruleDescriptor : ruleDescriptors) {
            mappingDescriptorIds.addAll(ruleDescriptor.getMetadataMappingIdDescriptors());
        }
        if (mappingDescriptorIds.isEmpty()) {
            return;
        }
        for (String mappingDescriptorId : mappingDescriptorIds) {
            if (!BinaryMetadataComponent.self.mappingRegistry.getMappingDescriptorMap().containsKey(mappingDescriptorId)) {
                log.warn((Object)("Missing binary metadata descriptor with id '" + mappingDescriptorId + "'. Or check your rule contribution with proper metadataMapping-id."));
                continue;
            }
            this.writeMetadata(doc, session, mappingDescriptorId);
        }
    }

    @Override
    public void writeMetadata(DocumentModel doc, CoreSession session, String mappingDescriptorId) {
        HashMap<String, String> metadataMapping = new HashMap<String, String>();
        ArrayList<String> blobMetadata = new ArrayList<String>();
        MetadataMappingDescriptor mappingDescriptor = BinaryMetadataComponent.self.mappingRegistry.getMappingDescriptorMap().get(mappingDescriptorId);
        boolean ignorePrefix = mappingDescriptor.getIgnorePrefix();
        Blob blob = (Blob)doc.getProperty(mappingDescriptor.getBlobXPath()).getValue(Blob.class);
        if (blob != null && mappingDescriptor.getMetadataDescriptors() != null && !mappingDescriptor.getMetadataDescriptors().isEmpty()) {
            for (MetadataMappingDescriptor.MetadataDescriptor metadataDescriptor : mappingDescriptor.getMetadataDescriptors()) {
                metadataMapping.put(metadataDescriptor.getName(), metadataDescriptor.getXpath());
                blobMetadata.add(metadataDescriptor.getName());
            }
            String processorId = mappingDescriptor.getProcessor();
            Map<String, Object> blobMetadataOutput = processorId != null ? this.readMetadata(processorId, blob, blobMetadata, ignorePrefix) : this.readMetadata(blob, blobMetadata, ignorePrefix);
            for (String metadata : blobMetadataOutput.keySet()) {
                Object metadataValue = blobMetadataOutput.get(metadata);
                if (!(metadataValue instanceof Date || metadataValue instanceof Collection || metadataValue.getClass().isArray())) {
                    metadataValue = metadataValue.toString();
                }
                doc.setPropertyValue((String)metadataMapping.get(metadata), (Serializable)metadataValue);
            }
            if (doc.getId() != null && session.exists(doc.getRef())) {
                session.saveDocument(doc);
            }
        }
    }

    @Override
    public void handleSyncUpdate(DocumentModel doc, DocumentEventContext docCtx) {
        LinkedList<MetadataMappingDescriptor> syncMappingDescriptors = this.getSyncMapping(doc, docCtx);
        if (syncMappingDescriptors != null) {
            this.handleUpdate(syncMappingDescriptors, doc, docCtx);
        }
    }

    @Override
    public void handleUpdate(List<MetadataMappingDescriptor> mappingDescriptors, DocumentModel doc, DocumentEventContext docCtx) {
        for (MetadataMappingDescriptor mappingDescriptor : mappingDescriptors) {
            Blob newBlob;
            Property fileProp = doc.getProperty(mappingDescriptor.getBlobXPath());
            boolean isDirtyMapping = this.isDirtyMapping(mappingDescriptor, doc);
            Blob blob = (Blob)fileProp.getValue(Blob.class);
            if (blob == null) continue;
            if (fileProp.isDirty()) {
                if (isDirtyMapping) {
                    newBlob = this.writeMetadata(mappingDescriptor.getProcessor(), (Blob)fileProp.getValue(Blob.class), mappingDescriptor.getId(), doc);
                    fileProp.setValue((Object)newBlob);
                    continue;
                }
                this.writeMetadata(doc, docCtx.getCoreSession());
                continue;
            }
            if (!isDirtyMapping) continue;
            newBlob = this.writeMetadata(mappingDescriptor.getProcessor(), (Blob)fileProp.getValue(Blob.class), mappingDescriptor.getId(), doc);
            fileProp.setValue((Object)newBlob);
        }
    }

    protected Set<MetadataRuleDescriptor> checkFilter(final ActionContext actionContext) {
        final ActionManager actionService = (ActionManager)Framework.getLocalService(ActionManager.class);
        Set filtered = Sets.filter(BinaryMetadataComponent.self.ruleRegistry.contribs, (Predicate)new Predicate<MetadataRuleDescriptor>(){

            public boolean apply(MetadataRuleDescriptor input) {
                if (!input.getEnabled().booleanValue()) {
                    return false;
                }
                for (String filterId : input.getFilterIds()) {
                    if (actionService.checkFilter(filterId, actionContext)) continue;
                    return false;
                }
                return true;
            }
        });
        return filtered;
    }

    protected ActionContext createActionContext(DocumentModel doc) {
        ELActionContext actionContext = new ELActionContext();
        actionContext.setCurrentDocument(doc);
        return actionContext;
    }

    protected BinaryMetadataProcessor getProcessor(String processorId) throws NoSuchMethodException {
        return BinaryMetadataComponent.self.processorRegistry.getProcessor(processorId);
    }

    public LinkedList<MetadataMappingDescriptor> getSyncMapping(DocumentModel doc, DocumentEventContext docCtx) {
        ActionContext actionContext = this.createActionContext(doc);
        Set<MetadataRuleDescriptor> ruleDescriptors = this.checkFilter(actionContext);
        HashSet<String> syncMappingDescriptorIds = new HashSet<String>();
        HashSet<String> asyncMappingDescriptorIds = new HashSet<String>();
        for (MetadataRuleDescriptor ruleDescriptor : ruleDescriptors) {
            if (ruleDescriptor.getIsAsync().booleanValue()) {
                asyncMappingDescriptorIds.addAll(ruleDescriptor.getMetadataMappingIdDescriptors());
                continue;
            }
            syncMappingDescriptorIds.addAll(ruleDescriptor.getMetadataMappingIdDescriptors());
        }
        if (!asyncMappingDescriptorIds.isEmpty()) {
            docCtx.setProperty("asyncMappingResult", this.getMapping(asyncMappingDescriptorIds));
            docCtx.setProperty("asyncExecute", (Serializable)Boolean.TRUE);
        }
        if (syncMappingDescriptorIds.isEmpty()) {
            return null;
        }
        return this.getMapping(syncMappingDescriptorIds);
    }

    protected LinkedList<MetadataMappingDescriptor> getMapping(Set<String> mappingDescriptorIds) {
        LinkedList<MetadataMappingDescriptor> mappingResult = new LinkedList<MetadataMappingDescriptor>();
        for (String mappingDescriptorId : mappingDescriptorIds) {
            if (!BinaryMetadataComponent.self.mappingRegistry.getMappingDescriptorMap().containsKey(mappingDescriptorId)) {
                log.warn((Object)("Missing binary metadata descriptor with id '" + mappingDescriptorId + "'. Or check your rule contribution with proper metadataMapping-id."));
                continue;
            }
            mappingResult.add(BinaryMetadataComponent.self.mappingRegistry.getMappingDescriptorMap().get(mappingDescriptorId));
        }
        return mappingResult;
    }

    protected boolean isDirtyMapping(MetadataMappingDescriptor mappingDescriptor, DocumentModel doc) {
        HashMap<String, String> mappingResult = new HashMap<String, String>();
        for (MetadataMappingDescriptor.MetadataDescriptor metadataDescriptor : mappingDescriptor.getMetadataDescriptors()) {
            mappingResult.put(metadataDescriptor.getXpath(), metadataDescriptor.getName());
        }
        HashMap resultDirtyMapping = new HashMap();
        for (String metadata : mappingResult.keySet()) {
            Property property = doc.getProperty(metadata);
            if (!property.isDirty()) continue;
            resultDirtyMapping.put(mappingResult.get(metadata), doc.getPropertyValue(metadata));
        }
        return !resultDirtyMapping.isEmpty();
    }
}

