/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.event.test;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.nuxeo.ecm.core.api.ConcurrentUpdateException;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.PostCommitEventListener;

public class DummyPostCommitEventListener
implements PostCommitEventListener {
    private static AtomicInteger handledCount = new AtomicInteger(0);
    private static AtomicInteger eventCount = new AtomicInteger(0);
    private static AtomicInteger interruptCount = new AtomicInteger(0);
    public static volatile Map<String, Serializable> properties;

    public void handleEvent(EventBundle events) {
        handledCount.incrementAndGet();
        eventCount.addAndGet(events.size());
        properties = events.peek().getContext().getProperties();
        if (properties.get("throw") != null) {
            throw new NuxeoException("testing error case");
        }
        if (properties.get("sleep") != null) {
            try {
                Thread.sleep(1500L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                interruptCount.incrementAndGet();
            }
        }
        if (properties.get("concurrentexception") != null && DummyPostCommitEventListener.handledCount() == 1) {
            throw new ConcurrentUpdateException();
        }
    }

    public static int handledCount() {
        return handledCount.get();
    }

    public static int eventCount() {
        return eventCount.get();
    }

    public static int interruptCount() {
        return interruptCount.get();
    }

    public static void handledCountReset() {
        handledCount.set(0);
    }

    public static void eventCountReset() {
        eventCount.set(0);
    }

    public static void interruptCountReset() {
        interruptCount.set(0);
    }
}

