/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.event.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.rmi.dgc.VMID;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.impl.EventContextImpl;
import org.nuxeo.ecm.core.event.impl.EventImpl;
import org.nuxeo.ecm.core.event.impl.EventServiceImpl;
import org.nuxeo.ecm.core.event.test.FakeEventBundle;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.RuntimeContext;
import org.nuxeo.runtime.test.NXRuntimeTestCase;
import org.nuxeo.runtime.test.runner.ConditionalIgnoreRule;

public class EventListenerTest
extends NXRuntimeTestCase {
    public static int SCRIPT_CNT = 0;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.deployBundle("org.nuxeo.ecm.core.event");
        this.fireFrameworkStarted();
    }

    @Test
    public void testFlags() {
        EventImpl event = new EventImpl("test", null);
        Assert.assertTrue((boolean)event.isPublic());
        Assert.assertEquals((long)0L, (long)event.getFlags());
        event.setLocal(true);
        event.setInline(true);
        Assert.assertEquals((long)24L, (long)event.getFlags());
        Assert.assertTrue((boolean)event.isInline());
        Assert.assertTrue((boolean)event.isLocal());
        event.setLocal(false);
        Assert.assertEquals((long)16L, (long)event.getFlags());
        Assert.assertTrue((boolean)event.isInline());
        Assert.assertFalse((boolean)event.isLocal());
        event.setInline(false);
        Assert.assertEquals((long)0L, (long)event.getFlags());
        Assert.assertTrue((boolean)event.isPublic());
        Assert.assertFalse((boolean)event.isLocal());
        event.setPublic(false);
        Assert.assertFalse((boolean)event.isPublic());
        Assert.assertTrue((boolean)event.isLocal());
        Assert.assertFalse((boolean)event.isInline());
        Assert.assertFalse((boolean)event.isCommitEvent());
        event.setPublic(true);
        Assert.assertTrue((boolean)event.isPublic());
        Assert.assertFalse((boolean)event.isLocal());
        Assert.assertFalse((boolean)event.isInline());
        Assert.assertFalse((boolean)event.isCommitEvent());
        event.setInline(true);
        Assert.assertTrue((boolean)event.isPublic());
        Assert.assertFalse((boolean)event.isLocal());
        Assert.assertTrue((boolean)event.isInline());
        Assert.assertFalse((boolean)event.isCommitEvent());
        event.setIsCommitEvent(true);
        Assert.assertTrue((boolean)event.isPublic());
        Assert.assertFalse((boolean)event.isLocal());
        Assert.assertTrue((boolean)event.isInline());
        Assert.assertTrue((boolean)event.isCommitEvent());
        event.setIsCommitEvent(false);
        Assert.assertTrue((boolean)event.isPublic());
        Assert.assertFalse((boolean)event.isLocal());
        Assert.assertTrue((boolean)event.isInline());
        Assert.assertFalse((boolean)event.isCommitEvent());
        event.setInline(false);
        Assert.assertTrue((boolean)event.isPublic());
        Assert.assertFalse((boolean)event.isLocal());
        Assert.assertFalse((boolean)event.isInline());
        Assert.assertFalse((boolean)event.isCommitEvent());
        event.setPublic(false);
        Assert.assertFalse((boolean)event.isPublic());
        Assert.assertTrue((boolean)event.isLocal());
        Assert.assertFalse((boolean)event.isInline());
        Assert.assertFalse((boolean)event.isCommitEvent());
    }

    @Test
    public void testEventCreation() {
        EventContextImpl ctx = new EventContextImpl(new Object[0]);
        Event event = ctx.newEvent("test");
        Assert.assertEquals((Object)"test", (Object)event.getName());
        Assert.assertEquals((Object)ctx, (Object)event.getContext());
        Assert.assertEquals((long)0L, (long)event.getFlags());
        event = ctx.newEvent("test2", 20);
        Assert.assertEquals((Object)"test2", (Object)event.getName());
        Assert.assertEquals((Object)ctx, (Object)event.getContext());
        Assert.assertEquals((long)20L, (long)event.getFlags());
    }

    @Test
    public void testTimestamp() {
        EventContextImpl ctx;
        Event event;
        long tm = System.currentTimeMillis();
        Assert.assertTrue((tm <= (event = (ctx = new EventContextImpl(new Object[0])).newEvent("test")).getTime() ? 1 : 0) != 0);
    }

    @Test
    @ConditionalIgnoreRule.Ignore(condition=ConditionalIgnoreRule.IgnoreIsolated.class)
    public void testScripts() throws Exception {
        URL url = EventListenerTest.class.getClassLoader().getResource("test-listeners.xml");
        RuntimeContext rc = this.deployTestContrib("org.nuxeo.ecm.core.event", url);
        Assert.assertEquals((long)0L, (long)SCRIPT_CNT);
        EventService service = (EventService)Framework.getService(EventService.class);
        service.fireEvent("test", (EventContext)new EventContextImpl(null, null));
        Assert.assertEquals((long)1L, (long)SCRIPT_CNT);
        rc.undeploy(url);
        Assert.assertEquals((long)1L, (long)SCRIPT_CNT);
        service.fireEvent("test", (EventContext)new EventContextImpl(null, null));
        Assert.assertEquals((long)1L, (long)SCRIPT_CNT);
        rc = this.deployTestContrib("org.nuxeo.ecm.core.event", url);
        service.fireEvent("test1", (EventContext)new EventContextImpl(null, null));
        Assert.assertEquals((long)2L, (long)SCRIPT_CNT);
        service.fireEvent("some-event", (EventContext)new EventContextImpl(null, null));
        Assert.assertEquals((long)2L, (long)SCRIPT_CNT);
    }

    @Test
    public void testRemoteForwarding() throws Exception {
        VMID vmid1 = EventServiceImpl.VMID;
        VMID vmid2 = new VMID();
        int cnt = 0;
        while (vmid2.equals(vmid1)) {
            Thread.sleep(1000L);
            vmid2 = new VMID();
            if (cnt++ <= 10) continue;
            Assert.fail((String)"Unable to complete test - unable to generate a target vmid");
        }
        FakeEventBundle event = new FakeEventBundle();
        Assert.assertFalse((boolean)event.hasRemoteSource());
        event.setVMID(vmid2);
        Assert.assertTrue((boolean)event.hasRemoteSource());
        event = (FakeEventBundle)((Object)EventListenerTest.serialize((Object)event));
        Assert.assertTrue((boolean)event.hasRemoteSource());
        event = new FakeEventBundle();
        Assert.assertFalse((boolean)event.hasRemoteSource());
        event = (FakeEventBundle)((Object)EventListenerTest.serialize((Object)event));
        Assert.assertFalse((boolean)event.hasRemoteSource());
    }

    public static Object serialize(Object obj) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(baos);
        out.writeObject(obj);
        out.flush();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream in = new ObjectInputStream(bais);
        return in.readObject();
    }
}

