/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.event.test;

import java.io.Serializable;
import java.net.URL;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.EventServiceAdmin;
import org.nuxeo.ecm.core.event.impl.EventContextImpl;
import org.nuxeo.ecm.core.event.impl.EventImpl;
import org.nuxeo.ecm.core.event.impl.EventListenerDescriptor;
import org.nuxeo.ecm.core.event.impl.EventServiceImpl;
import org.nuxeo.ecm.core.event.test.DummyPostCommitEventListener;
import org.nuxeo.ecm.core.event.test.EventListenerTest;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.test.NXRuntimeTestCase;

public class TestEventServiceComponent
extends NXRuntimeTestCase {
    protected int initialThreadCount;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        Framework.getProperties().setProperty("org.nuxeo.ecm.core.event.tx.PostCommitExecutor.timeoutMs", "300");
        this.deployBundle("org.nuxeo.runtime.jtajca");
        this.deployBundle("org.nuxeo.ecm.core.event");
        this.fireFrameworkStarted();
        Thread.sleep(100L);
        this.initialThreadCount = Thread.activeCount();
        DummyPostCommitEventListener.handledCountReset();
        DummyPostCommitEventListener.eventCountReset();
    }

    @After
    public void tearDown() throws Exception {
        EventImpl commit = new EventImpl("commit", (EventContext)new EventContextImpl(new Object[0]));
        commit.setIsCommitEvent(true);
        EventService service = (EventService)Framework.getService(EventService.class);
        service.fireEvent((Event)commit);
        service.waitForAsyncCompletion();
        super.tearDown();
    }

    @Test
    public void testDisablingListener() throws Exception {
        URL url = EventListenerTest.class.getClassLoader().getResource("test-disabling-listeners1.xml");
        this.deployTestContrib("org.nuxeo.ecm.core.event", url);
        EventService service = (EventService)Framework.getService(EventService.class);
        EventServiceImpl serviceImpl = (EventServiceImpl)service;
        List eventListenerDescriptors = serviceImpl.getEventListenerList().getSyncPostCommitListenersDescriptors();
        Assert.assertEquals((long)1L, (long)eventListenerDescriptors.size());
        EventListenerDescriptor eventListenerDescriptor = (EventListenerDescriptor)eventListenerDescriptors.get(0);
        Assert.assertTrue((boolean)eventListenerDescriptor.isEnabled());
        url = EventListenerTest.class.getClassLoader().getResource("test-disabling-listeners2.xml");
        this.deployTestContrib("org.nuxeo.ecm.core.event", url);
        eventListenerDescriptors = serviceImpl.getEventListenerList().getSyncPostCommitListenersDescriptors();
        Assert.assertEquals((long)1L, (long)eventListenerDescriptors.size());
        eventListenerDescriptor = (EventListenerDescriptor)eventListenerDescriptors.get(0);
        Assert.assertFalse((boolean)eventListenerDescriptor.isEnabled());
    }

    @Test
    public void testAsync() throws Exception {
        URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource("test-async-listeners.xml");
        this.deployTestContrib("org.nuxeo.ecm.core.event", url);
        EventService service = (EventService)Framework.getService(EventService.class);
        EventImpl test1 = new EventImpl("testasync", (EventContext)new EventContextImpl(new Object[0]));
        service.fireEvent((Event)test1);
        Assert.assertEquals((long)DummyPostCommitEventListener.handledCount(), (long)0L);
        EventImpl test2 = new EventImpl("testnotmached", (EventContext)new EventContextImpl(new Object[0]));
        test2.setIsCommitEvent(true);
        service.fireEvent((Event)test2);
        service.waitForAsyncCompletion();
        Thread.sleep(100L);
        Assert.assertEquals((long)DummyPostCommitEventListener.handledCount(), (long)1L);
        Assert.assertEquals((long)1L, (long)DummyPostCommitEventListener.eventCount());
        Assert.assertEquals((Object)"bar", (Object)DummyPostCommitEventListener.properties.get("foo"));
    }

    @Test
    public void testAsyncRetry() throws Exception {
        URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource("test-async-listeners.xml");
        this.deployTestContrib("org.nuxeo.ecm.core.event", url);
        EventService service = (EventService)Framework.getLocalService(EventService.class);
        EventContextImpl context = new EventContextImpl(new Object[0]);
        context.setProperty("concurrentexception", (Serializable)Boolean.TRUE);
        EventImpl test1 = new EventImpl("testasync", (EventContext)context);
        test1.setIsCommitEvent(true);
        service.fireEvent((Event)test1);
        service.waitForAsyncCompletion();
        Assert.assertEquals((long)2L, (long)DummyPostCommitEventListener.handledCount());
    }

    @Test
    public void testSyncPostCommit() throws Exception {
        this.doTestSyncPostCommit(false, false, false, 2, 4);
    }

    @Test
    public void testSyncPostCommitError() throws Exception {
        this.doTestSyncPostCommit(false, true, false, 2, 4);
    }

    @Test
    public void testSyncPostCommitTimeout() throws Exception {
        this.doTestSyncPostCommit(false, false, true, 1, 2);
        Thread.sleep(3000L);
        Assert.assertEquals((long)2L, (long)DummyPostCommitEventListener.handledCount());
        Assert.assertEquals((long)4L, (long)DummyPostCommitEventListener.eventCount());
    }

    @Test
    public void testSyncPostCommitBulk() throws Exception {
        this.doTestSyncPostCommit(true, false, false, 2, 4);
    }

    @Test
    public void testSyncPostCommitErrorBulk() throws Exception {
        this.doTestSyncPostCommit(true, true, false, 1, 2);
    }

    @Test
    public void testSyncPostCommitTimeoutBulk() throws Exception {
        this.doTestSyncPostCommit(true, false, true, 1, 2);
        Thread.sleep(3000L);
        Assert.assertEquals((long)1L, (long)DummyPostCommitEventListener.handledCount());
        Assert.assertEquals((long)2L, (long)DummyPostCommitEventListener.eventCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doTestSyncPostCommit(boolean bulk, boolean error, boolean timeout, int expectedHandled, int expectedEvents) throws Exception {
        EventServiceAdmin eventServiceAdmin = (EventServiceAdmin)Framework.getLocalService(EventServiceAdmin.class);
        try {
            eventServiceAdmin.setBulkModeEnabled(bulk);
            if (timeout) {
                Framework.getProperties().setProperty("org.nuxeo.ecm.core.event.tx.BulkExecutor.timeout", "1");
            }
            this.doTestSyncPostCommit(error, timeout, expectedHandled, expectedEvents);
        }
        finally {
            eventServiceAdmin.setBulkModeEnabled(false);
            Framework.getProperties().remove("org.nuxeo.ecm.core.event.tx.BulkExecutor.timeout");
        }
    }

    protected void doTestSyncPostCommit(boolean error, boolean timeout, int expectedHandled, int expectedEvents) throws Exception {
        URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource("test-sync-postcommit-listeners.xml");
        this.deployTestContrib("org.nuxeo.ecm.core.event", url);
        EventService service = (EventService)Framework.getService(EventService.class);
        EventImpl event1 = new EventImpl("testnotmached", (EventContext)new EventContextImpl(new Object[0]));
        service.fireEvent((Event)event1);
        EventContextImpl context = new EventContextImpl(new Object[0]);
        if (error) {
            context.setProperty("throw", (Serializable)Boolean.TRUE);
        }
        if (timeout) {
            context.setProperty("sleep", (Serializable)Boolean.TRUE);
        }
        EventImpl event2 = new EventImpl("testsyncpostcommit", (EventContext)context);
        service.fireEvent((Event)event2);
        EventImpl event3 = new EventImpl("testsyncpostcommit", (EventContext)new EventContextImpl(new Object[0]));
        service.fireEvent((Event)event3);
        EventImpl event4 = new EventImpl("testnotmached", (EventContext)new EventContextImpl(new Object[0]));
        event4.setIsCommitEvent(true);
        Assert.assertEquals((long)0L, (long)DummyPostCommitEventListener.handledCount());
        service.fireEvent((Event)event4);
        service.waitForAsyncCompletion();
        Assert.assertEquals((long)expectedHandled, (long)DummyPostCommitEventListener.handledCount());
        Assert.assertEquals((long)expectedEvents, (long)DummyPostCommitEventListener.eventCount());
        if (timeout) {
            Thread.sleep(2000L);
        }
    }

    @Test
    @Ignore
    public void testAsyncEventExecutorShutdown() throws Exception {
        URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource("test-PostCommitListeners3.xml");
        this.deployTestContrib("org.nuxeo.ecm.core.event", url);
        EventService service = (EventService)Framework.getService(EventService.class);
        EventImpl test1 = new EventImpl("test1", (EventContext)new EventContextImpl(new Object[0]));
        test1.setIsCommitEvent(true);
        service.fireEvent((Event)test1);
        service.waitForAsyncCompletion(2000L);
        Assert.assertEquals((long)1L, (long)DummyPostCommitEventListener.handledCount());
        EventImpl test2 = new EventImpl("test1", (EventContext)new EventContextImpl(new Object[0]));
        test2.setIsCommitEvent(true);
        service.fireEvent((Event)test2);
        ((EventServiceImpl)service).shutdown(2000L);
        ((EventServiceImpl)service).init();
        Assert.assertEquals((long)2L, (long)DummyPostCommitEventListener.handledCount());
        Thread.sleep(2000L);
        Assert.assertEquals((String)"Threads not dead", (long)0L, (long)(Thread.activeCount() - this.initialThreadCount));
    }
}

