/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.work;

import java.io.Serializable;
import org.apache.commons.lang3.SerializationException;
import org.apache.commons.lang3.SerializationUtils;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.work.MemoryBlockingQueue;
import org.nuxeo.ecm.core.work.MemoryWorkQueuing;
import org.nuxeo.ecm.core.work.WorkHolder;
import org.nuxeo.ecm.core.work.WorkQueuing;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkQueueDescriptor;

public class TestWorkQueuing
extends MemoryWorkQueuing {
    public TestWorkQueuing(WorkQueuing.Listener listener) {
        super(listener);
    }

    public MemoryBlockingQueue init(WorkQueueDescriptor config) {
        MemoryBlockingQueue queue = new MemoryBlockingQueue(config.id, this, config.getCapacity()){

            public void putElement(Runnable r) throws InterruptedException {
                super.putElement(this.clone(r));
            }

            Runnable clone(Runnable r) {
                Work original = WorkHolder.getWork((Runnable)r);
                try {
                    return new WorkHolder((Work)SerializationUtils.clone((Serializable)original));
                }
                catch (SerializationException cause) {
                    throw new NuxeoException("Cannot serialize work of type " + original.getClass().getName(), (Throwable)cause);
                }
            }
        };
        this.allQueued.put(queue.queueId, queue);
        return queue;
    }
}

