/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.work;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.nuxeo.ecm.core.work.SleepWork;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.ecm.core.work.api.WorkQueueMetrics;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.test.NXRuntimeTestCase;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class WorkManagerTXTest
extends NXRuntimeTestCase {
    protected static final String CATEGORY = "SleepWork";
    protected static final String QUEUE = "SleepWork";
    protected WorkManager service;

    void assertMetrics(long scheduled, long running, long completed, long cancelled) {
        Assert.assertEquals((Object)new WorkQueueMetrics("SleepWork", (Number)scheduled, (Number)running, (Number)completed, (Number)cancelled), (Object)this.service.getMetrics("SleepWork"));
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.deployBundle("org.nuxeo.runtime.jtajca");
        this.deployBundle("org.nuxeo.ecm.core.event");
        this.deployContrib("org.nuxeo.ecm.core.event.test", "test-workmanager-config.xml");
        this.fireFrameworkStarted();
        this.service = (WorkManager)Framework.getLocalService(WorkManager.class);
        Assert.assertNotNull((Object)this.service);
        this.assertMetrics(0L, 0L, 0L, 0L);
        TransactionHelper.startTransaction();
    }

    @After
    public void tearDown() throws Exception {
        if (TransactionHelper.isTransactionActiveOrMarkedRollback()) {
            TransactionHelper.setTransactionRollbackOnly();
            TransactionHelper.commitOrRollbackTransaction();
        }
        super.tearDown();
    }

    @Test
    public void testWorkManagerPostCommit() throws Exception {
        int duration = 1000;
        SleepWork work = new SleepWork((long)duration, false);
        this.service.schedule((Work)work, true);
        this.assertMetrics(0L, 0L, 0L, 0L);
        TransactionHelper.commitOrRollbackTransaction();
        Thread.sleep(duration + 1000);
        this.assertMetrics(0L, 0L, 1L, 0L);
    }

    @Test
    public void testWorkManagerRollback() throws Exception {
        Assert.assertTrue((boolean)TransactionHelper.isTransactionActive());
        int duration = 1000;
        SleepWork work = new SleepWork((long)duration, false);
        this.service.schedule((Work)work, true);
        this.assertMetrics(0L, 0L, 0L, 0L);
        TransactionHelper.setTransactionRollbackOnly();
        TransactionHelper.commitOrRollbackTransaction();
        this.assertMetrics(0L, 0L, 0L, 0L);
    }
}

