/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.work;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.nuxeo.common.logging.SequenceTracer;
import org.nuxeo.ecm.core.work.AbstractWork;
import org.nuxeo.ecm.core.work.SleepWork;
import org.nuxeo.ecm.core.work.WorkManagerImpl;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.ecm.core.work.api.WorkQueueDescriptor;
import org.nuxeo.ecm.core.work.api.WorkQueueMetrics;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.test.NXRuntimeTestCase;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.FileEventsTrackingFeature;
import org.nuxeo.runtime.trackers.files.FileEvent;

@Features(value={FileEventsTrackingFeature.class})
public class WorkManagerTest
extends NXRuntimeTestCase {
    protected static final String CATEGORY = "SleepWork";
    protected static final String QUEUE = "SleepWork";
    protected WorkManagerImpl service;
    protected boolean dontClearCompletedWork;
    @Inject
    public FeaturesRunner runner;
    protected FileEventsTrackingFeature feature;

    void assertSetEquals(List<String> expected, List<String> actual) {
        Assert.assertEquals(new HashSet<String>(expected), new HashSet<String>(actual));
    }

    void assertMetrics(long scheduled, long running, long completed, long cancelled) {
        Assert.assertEquals((Object)new WorkQueueMetrics("SleepWork", (Number)scheduled, (Number)running, (Number)completed, (Number)cancelled), (Object)this.service.getMetrics("SleepWork"));
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.deployBundle("org.nuxeo.ecm.core.event");
        this.service = (WorkManagerImpl)Framework.getLocalService(WorkManager.class);
    }

    protected void doDeploy() throws Exception {
        this.deployContrib("org.nuxeo.ecm.core.event.test", "test-workmanager-config.xml");
    }

    protected void deployAndStart() throws Exception {
        this.doDeploy();
        this.fireFrameworkStarted();
        this.assertMetrics(0L, 0L, 0L, 0L);
    }

    public boolean persistent() {
        return false;
    }

    @Test
    public void testBasics() throws Exception {
        this.deployAndStart();
        Assert.assertNotNull((Object)this.service);
        this.assertMetrics(0L, 0L, 0L, 0L);
    }

    @Test
    public void testWorkManagerConfig() throws Exception {
        this.deployAndStart();
        SleepWork work = new SleepWork(1L);
        Assert.assertEquals((Object)"SleepWork", (Object)work.getCategory());
        Assert.assertEquals((Object)"SleepWork", (Object)this.service.getCategoryQueueId("SleepWork"));
        WorkQueueDescriptor qd = this.service.getWorkQueueDescriptor("SleepWork");
        Assert.assertEquals((Object)"SleepWork", (Object)qd.id);
        Assert.assertEquals((Object)"Sleep Work Queue", (Object)qd.name);
        Assert.assertEquals((long)2L, (long)qd.getMaxThreads());
        Assert.assertEquals(Collections.singleton("SleepWork"), (Object)qd.categories);
    }

    @Test
    public void testWorkManagerWork() throws Exception {
        this.deployAndStart();
        int duration = 3000;
        SleepWork work = new SleepWork((long)duration, false);
        this.service.schedule((Work)work);
        Assert.assertTrue((work.getSchedulingTime() != 0L ? 1 : 0) != 0);
        Thread.sleep(duration / 3);
        Assert.assertEquals((Object)Work.State.RUNNING, (Object)this.service.getWorkState(work.getId()));
        this.assertMetrics(0L, 1L, 0L, 0L);
        Thread.sleep(duration);
        this.assertMetrics(0L, 0L, 1L, 0L);
    }

    @Test
    public void testWorkManagerScheduling() throws Exception {
        this.deployAndStart();
        int duration = 5000;
        SleepWork work1 = new SleepWork((long)duration, false, "1");
        SleepWork work2 = new SleepWork((long)duration, false, "2");
        SleepWork work3 = new SleepWork((long)duration, false, "3");
        this.service.schedule((Work)work1);
        this.service.schedule((Work)work2);
        this.service.schedule((Work)work3);
        Thread.sleep(duration / 2);
        this.assertMetrics(1L, 2L, 0L, 0L);
        Assert.assertEquals((Object)Work.State.RUNNING, (Object)this.service.getWorkState("1"));
        Assert.assertEquals((Object)Work.State.RUNNING, (Object)this.service.getWorkState("2"));
        Assert.assertEquals((Object)Work.State.SCHEDULED, (Object)this.service.getWorkState("3"));
        Assert.assertEquals(Arrays.asList("3"), (Object)this.service.listWorkIds("SleepWork", Work.State.SCHEDULED));
        this.assertSetEquals(Arrays.asList("1", "2"), this.service.listWorkIds("SleepWork", Work.State.RUNNING));
        this.assertSetEquals(Arrays.asList("1", "2", "3"), this.service.listWorkIds("SleepWork", null));
        if (Boolean.FALSE.booleanValue()) {
            SleepWork work4 = new SleepWork((long)duration, false, "3");
            this.service.schedule((Work)work4, WorkManager.Scheduling.IF_NOT_SCHEDULED);
            Assert.assertEquals((Object)Work.State.UNKNOWN, (Object)work4.getWorkInstanceState());
            SleepWork work5 = new SleepWork((long)duration, false, "1");
            this.service.schedule((Work)work5, WorkManager.Scheduling.IF_NOT_RUNNING);
            Assert.assertEquals((Object)Work.State.UNKNOWN, (Object)work5.getWorkInstanceState());
            SleepWork work6 = new SleepWork((long)duration, false, "1");
            this.service.schedule((Work)work6, WorkManager.Scheduling.IF_NOT_RUNNING_OR_SCHEDULED);
            Assert.assertEquals((Object)Work.State.UNKNOWN, (Object)work6.getWorkInstanceState());
        }
        SleepWork work7 = new SleepWork((long)duration, false, "3");
        this.service.schedule((Work)work7, WorkManager.Scheduling.CANCEL_SCHEDULED);
        Assert.assertEquals((Object)Work.State.SCHEDULED, (Object)work7.getWorkInstanceState());
        this.assertMetrics(1L, 2L, 0L, 1L);
        SleepAndFailWork work8 = new SleepAndFailWork(0L, false, "4");
        this.service.schedule((Work)work8);
        this.assertMetrics(2L, 2L, 0L, 1L);
        Assert.assertTrue((boolean)this.service.awaitCompletion((long)(duration * 3), TimeUnit.MILLISECONDS));
        this.assertMetrics(0L, 0L, 4L, 1L);
        Assert.assertEquals(Collections.emptyList(), (Object)this.service.listWorkIds("SleepWork", Work.State.SCHEDULED));
        Assert.assertEquals(Collections.emptyList(), (Object)this.service.listWorkIds("SleepWork", Work.State.RUNNING));
        Assert.assertEquals(Collections.emptyList(), (Object)this.service.listWorkIds("SleepWork", null));
    }

    @Test
    public void testDuplicatedWorks() throws Exception {
        this.deployAndStart();
        int duration = 2000;
        this.service.enableProcessing("SleepWork", false);
        SleepWork work1 = new SleepWork((long)duration, false, "1");
        SleepWork work2 = new SleepWork((long)duration, false, "1");
        this.service.schedule((Work)work1);
        this.service.schedule((Work)work2);
        this.assertMetrics(1L, 0L, 0L, 0L);
        this.service.enableProcessing("SleepWork", true);
        Assert.assertTrue((boolean)this.service.awaitCompletion("SleepWork", (long)(duration * 2), TimeUnit.MILLISECONDS));
        this.assertMetrics(0L, 0L, 1L, 0L);
    }

    @Test
    @Ignore
    public void testWorkManagerShutdown() throws Exception {
        this.deployAndStart();
        int duration = 2000;
        SleepWork work1 = new SleepWork((long)duration, false, "1");
        SleepWork work2 = new SleepWork((long)duration, false, "2");
        SleepWork work3 = new SleepWork((long)duration, false, "3");
        this.service.schedule((Work)work1);
        this.service.schedule((Work)work2);
        this.service.schedule((Work)work3);
        Thread.sleep(duration / 2);
        Assert.assertEquals((Object)Work.State.RUNNING, (Object)this.service.getWorkState("1"));
        Assert.assertEquals((Object)Work.State.RUNNING, (Object)this.service.getWorkState("2"));
        Assert.assertEquals((Object)Work.State.SCHEDULED, (Object)this.service.getWorkState("3"));
        this.dontClearCompletedWork = true;
        boolean terminated = this.service.shutdown((long)(duration * 2), TimeUnit.MILLISECONDS);
        Assert.assertTrue((boolean)terminated);
        Assert.assertEquals((Object)Work.State.SCHEDULED, (Object)work1.getWorkInstanceState());
        Assert.assertEquals((Object)Work.State.SCHEDULED, (Object)work2.getWorkInstanceState());
        Assert.assertEquals((Object)(this.persistent() ? Work.State.SCHEDULED : Work.State.UNKNOWN), (Object)work3.getWorkInstanceState());
        long remaining1 = work1.durationMillis;
        long remaining2 = work2.durationMillis;
        long remaining3 = work3.durationMillis;
        Assert.assertTrue((String)("remaining1 " + remaining1), (remaining1 < (long)duration ? 1 : 0) != 0);
        Assert.assertTrue((String)("remaining2 " + remaining2), (remaining2 < (long)duration ? 1 : 0) != 0);
        Assert.assertEquals((long)duration, (long)remaining3);
    }

    @Test
    public void testWorkManagerConfigDisableOneBeforeStart() throws Exception {
        this.doDeploy();
        this.deployContrib("org.nuxeo.ecm.core.event.test", "test-workmanager-disablequeue.xml");
        this.fireFrameworkStarted();
        Assert.assertTrue((boolean)this.service.isProcessingEnabled("default"));
        Assert.assertFalse((boolean)this.service.isProcessingEnabled("SleepWork"));
    }

    @Test
    public void testWorkManagerConfigDisableOneAfterStart() throws Exception {
        this.deployAndStart();
        this.service.enableProcessing("SleepWork", false);
        Assert.assertTrue((boolean)this.service.isProcessingEnabled("default"));
        Assert.assertFalse((boolean)this.service.isProcessingEnabled("SleepWork"));
    }

    @Test
    public void testWorkManagerConfigDisableAllBeforeStart() throws Exception {
        this.doDeploy();
        this.deployContrib("org.nuxeo.ecm.core.event.test", "test-workmanager-disablequeue1.xml");
        this.fireFrameworkStarted();
        Assert.assertFalse((boolean)this.service.isProcessingEnabled("default"));
        Assert.assertTrue((boolean)this.service.isProcessingEnabled("SleepWork"));
    }

    @Test
    public void testWorkManagerConfigDisableAllAfterStart() throws Exception {
        this.deployAndStart();
        this.service.enableProcessing(false);
        Assert.assertFalse((boolean)this.service.isProcessingEnabled());
        this.service.enableProcessing("SleepWork", true);
        Assert.assertTrue((boolean)this.service.isProcessingEnabled());
    }

    @Ignore(value="NXP-15680")
    @Test
    public void testWorkManagerDisableProcessing() throws Exception {
        this.deployAndStart();
        Assume.assumeTrue((boolean)this.persistent());
        this.deployContrib("org.nuxeo.ecm.core.event.test", "test-workmanager-disablequeue.xml");
        int duration = 2000;
        SleepWork work1 = new SleepWork((long)duration, false);
        this.service.schedule((Work)work1);
        Thread.sleep(duration / 2);
        this.assertMetrics(1L, 0L, 0L, 0L);
        Thread.sleep(2 * duration);
        this.assertMetrics(1L, 0L, 0L, 0L);
        WorkQueueDescriptor descr = new WorkQueueDescriptor();
        descr.id = "SleepWork";
        descr.processing = Boolean.TRUE;
        descr.categories = Collections.emptySet();
        this.service.activateQueue(descr);
        Thread.sleep(duration / 2);
        this.assertMetrics(0L, 1L, 0L, 0L);
        Thread.sleep(duration);
        this.assertMetrics(0L, 0L, 1L, 0L);
    }

    @Ignore(value="NXP-15680")
    @Test
    public void testWorkManagerDisableProcessing2() throws Exception {
        this.deployAndStart();
        Assume.assumeTrue((boolean)this.persistent());
        this.deployContrib("org.nuxeo.ecm.core.event.test", "test-workmanager-disablequeue2.xml");
        int duration = 2000;
        SleepWork work1 = new SleepWork((long)duration, false);
        this.service.schedule((Work)work1);
        Thread.sleep(duration / 2);
        this.assertMetrics(1L, 0L, 0L, 0L);
        Thread.sleep(2 * duration);
        this.assertMetrics(1L, 0L, 0L, 0L);
        WorkQueueDescriptor descr = new WorkQueueDescriptor();
        descr.id = "SleepWork";
        descr.processing = Boolean.TRUE;
        descr.categories = Collections.emptySet();
        this.service.activateQueue(descr);
        Thread.sleep(duration / 2);
        this.assertMetrics(0L, 1L, 0L, 0L);
        Thread.sleep(duration);
        this.assertMetrics(0L, 0L, 1L, 0L);
    }

    @Before
    public void injectFeature() {
        this.feature = (FileEventsTrackingFeature)this.runner.getFeature(FileEventsTrackingFeature.class);
    }

    @Test
    public void transientFilesWorkAreCleaned() throws Exception {
        this.deployAndStart();
        File file = this.feature.resolveAndCreate(new File("pfouh"));
        this.service.schedule((Work)new CreateFile(file));
        this.service.awaitCompletion(5L, TimeUnit.SECONDS);
    }

    protected static class SleepAndFailWork
    extends SleepWork {
        private static final long serialVersionUID = 1L;

        public SleepAndFailWork(long durationMillis, boolean debug, String id) {
            super(durationMillis, debug, id);
        }

        public void work() {
            super.work();
            throw new RuntimeException(this.getTitle());
        }
    }

    protected static class CreateFile
    extends AbstractWork
    implements Serializable {
        private final File file;
        private static final long serialVersionUID = 1L;

        protected CreateFile(File file) {
            this.file = file;
        }

        public String getTitle() {
            return "pfouh";
        }

        public void work() {
            FileEvent.onFile((Object)this, (File)this.file, (Object)this).send();
            SequenceTracer.mark((String)"send event");
        }
    }
}

