/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.commands;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.elasticsearch.commands.IndexingCommand;

public class IndexingCommands {
    protected final List<IndexingCommand> commands = new ArrayList<IndexingCommand>();
    protected final Set<IndexingCommand.Type> commandTypes = new HashSet<IndexingCommand.Type>();
    protected DocumentModel targetDocument;
    protected static final Log log = LogFactory.getLog(IndexingCommands.class);

    protected IndexingCommands() {
    }

    public IndexingCommands(DocumentModel targetDocument) {
        this.targetDocument = targetDocument;
    }

    public void add(IndexingCommand.Type type, boolean sync, boolean recurse) {
        IndexingCommand cmd = new IndexingCommand(this.targetDocument, type, sync, recurse);
        this.add(cmd);
    }

    protected IndexingCommand find(IndexingCommand.Type command) {
        for (IndexingCommand cmd : this.commands) {
            if (cmd.type != command) continue;
            return cmd;
        }
        return null;
    }

    protected void add(IndexingCommand command) {
        if (command == null) {
            return;
        }
        if (this.commandTypes.contains((Object)command.type)) {
            IndexingCommand existing = this.find(command.type);
            if (existing.merge(command)) {
                return;
            }
        } else {
            if (this.commandTypes.contains((Object)IndexingCommand.Type.INSERT)) {
                if (command.type == IndexingCommand.Type.DELETE) {
                    this.clear();
                } else if (command.isSync()) {
                    this.find(IndexingCommand.Type.INSERT).makeSync();
                }
                return;
            }
            if (command.type == IndexingCommand.Type.INSERT && this.commandTypes.contains((Object)IndexingCommand.Type.UPDATE)) {
                this.clear();
            }
        }
        if (command.type == IndexingCommand.Type.DELETE) {
            this.clear();
        }
        this.commands.add(command);
        this.commandTypes.add(command.type);
    }

    protected void clear() {
        this.commands.clear();
        this.commandTypes.clear();
    }

    public DocumentModel getTargetDocument() {
        return this.targetDocument;
    }

    public boolean contains(IndexingCommand.Type command) {
        return this.commandTypes.contains((Object)command);
    }

    public List<IndexingCommand> getCommands() {
        return this.commands;
    }
}

