/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.core;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import com.codahale.metrics.Timer;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequestBuilder;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.filter.InternalFilter;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.platform.query.api.Aggregate;
import org.nuxeo.ecm.platform.query.api.Bucket;
import org.nuxeo.elasticsearch.aggregate.AggregateEsBase;
import org.nuxeo.elasticsearch.api.ElasticSearchService;
import org.nuxeo.elasticsearch.api.EsResult;
import org.nuxeo.elasticsearch.api.EsScrollResult;
import org.nuxeo.elasticsearch.core.ElasticSearchAdminImpl;
import org.nuxeo.elasticsearch.core.EsResultSetImpl;
import org.nuxeo.elasticsearch.fetcher.Fetcher;
import org.nuxeo.elasticsearch.query.NxQueryBuilder;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.metrics.MetricsService;

public class ElasticSearchServiceImpl
implements ElasticSearchService {
    private static final Log log = LogFactory.getLog(ElasticSearchServiceImpl.class);
    private static final String LOG_MIN_DURATION_FETCH_KEY = "org.nuxeo.elasticsearch.core.log_min_duration_fetch_ms";
    private static final long LOG_MIN_DURATION_FETCH_NS = Long.parseLong(Framework.getProperty((String)"org.nuxeo.elasticsearch.core.log_min_duration_fetch_ms", (String)"200")) * 1000000L;
    protected final MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)MetricsService.class.getName());
    protected final Timer searchTimer;
    protected final Timer scrollTimer;
    protected final Timer fetchTimer;
    private final ElasticSearchAdminImpl esa;

    public ElasticSearchServiceImpl(ElasticSearchAdminImpl esa) {
        this.esa = esa;
        this.searchTimer = this.registry.timer(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"elasticsearch", "service", "search"}));
        this.scrollTimer = this.registry.timer(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"elasticsearch", "service", "scroll"}));
        this.fetchTimer = this.registry.timer(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"elasticsearch", "service", "fetch"}));
    }

    @Override
    @Deprecated
    public DocumentModelList query(CoreSession session, String nxql, int limit, int offset, SortInfo ... sortInfos) {
        NxQueryBuilder query = new NxQueryBuilder(session).nxql(nxql).limit(limit).offset(offset).addSort(sortInfos);
        return this.query(query);
    }

    @Override
    @Deprecated
    public DocumentModelList query(CoreSession session, QueryBuilder queryBuilder, int limit, int offset, SortInfo ... sortInfos) {
        NxQueryBuilder query = new NxQueryBuilder(session).esQuery(queryBuilder).limit(limit).offset(offset).addSort(sortInfos);
        return this.query(query);
    }

    @Override
    public DocumentModelList query(NxQueryBuilder queryBuilder) {
        return this.queryAndAggregate(queryBuilder).getDocuments();
    }

    @Override
    public EsResult queryAndAggregate(NxQueryBuilder queryBuilder) {
        SearchResponse response = this.search(queryBuilder);
        List<Aggregate> aggs = this.getAggregates(queryBuilder, response);
        if (queryBuilder.returnsDocuments()) {
            DocumentModelListImpl docs = this.getDocumentModels(queryBuilder, response);
            return new EsResult((DocumentModelList)docs, aggs, response);
        }
        if (queryBuilder.returnsRows()) {
            IterableQueryResult rows = this.getRows(queryBuilder, response);
            return new EsResult(rows, aggs, response);
        }
        return new EsResult(response);
    }

    @Override
    public EsScrollResult scroll(NxQueryBuilder queryBuilder, long keepAlive) {
        return this.scroll(queryBuilder, SearchType.DFS_QUERY_THEN_FETCH, keepAlive);
    }

    @Override
    public EsScrollResult scanAndScroll(NxQueryBuilder queryBuilder, long keepAlive) {
        return this.scroll(queryBuilder, SearchType.SCAN, keepAlive);
    }

    protected EsScrollResult scroll(NxQueryBuilder queryBuilder, SearchType searchType, long keepAlive) {
        SearchResponse response = this.searchScroll(queryBuilder, searchType, keepAlive);
        return this.getScrollResults(queryBuilder, response, response.getScrollId(), keepAlive);
    }

    @Override
    public EsScrollResult scroll(EsScrollResult scrollResult) {
        SearchResponse response = this.nextScroll(scrollResult.getScrollId(), scrollResult.getKeepAlive());
        return this.getScrollResults(scrollResult.getQueryBuilder(), response, response.getScrollId(), scrollResult.getKeepAlive());
    }

    protected EsScrollResult getScrollResults(NxQueryBuilder queryBuilder, SearchResponse response, String scrollId, long keepAlive) {
        if (queryBuilder.returnsDocuments()) {
            DocumentModelListImpl docs = this.getDocumentModels(queryBuilder, response);
            return new EsScrollResult((DocumentModelList)docs, response, queryBuilder, scrollId, keepAlive);
        }
        if (queryBuilder.returnsRows()) {
            IterableQueryResult rows = this.getRows(queryBuilder, response);
            return new EsScrollResult(rows, response, queryBuilder, scrollId, keepAlive);
        }
        return new EsScrollResult(response, queryBuilder, scrollId, keepAlive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DocumentModelListImpl getDocumentModels(NxQueryBuilder queryBuilder, SearchResponse response) {
        DocumentModelListImpl ret;
        long totalSize = response.getHits().getTotalHits();
        if (!queryBuilder.returnsDocuments() || response.getHits().getHits().length == 0) {
            DocumentModelListImpl ret2 = new DocumentModelListImpl(0);
            ret2.setTotalSize(totalSize);
            return ret2;
        }
        Timer.Context stopWatch = this.fetchTimer.time();
        Fetcher fetcher = queryBuilder.getFetcher(response, this.esa.getRepositoryMap());
        try {
            ret = fetcher.fetchDocuments();
        }
        finally {
            this.logMinDurationFetch(stopWatch.stop(), totalSize);
        }
        ret.setTotalSize(totalSize);
        return ret;
    }

    private void logMinDurationFetch(long duration, long totalSize) {
        if (log.isDebugEnabled() && duration > LOG_MIN_DURATION_FETCH_NS) {
            String msg = String.format("Slow fetch duration_ms:\t%.2f\treturning:\t%d documents", (double)duration / 1000000.0, totalSize);
            if (log.isTraceEnabled()) {
                log.trace((Object)msg, new Throwable("Slow fetch document stack trace"));
            } else {
                log.debug((Object)msg);
            }
        }
    }

    protected List<Aggregate> getAggregates(NxQueryBuilder queryBuilder, SearchResponse response) {
        for (AggregateEsBase<? extends Bucket> agg : queryBuilder.getAggregates()) {
            MultiBucketsAggregation mba;
            InternalFilter filter = (InternalFilter)response.getAggregations().get(NxQueryBuilder.getAggregateFilterId(agg));
            if (filter == null || (mba = (MultiBucketsAggregation)filter.getAggregations().get(agg.getId())) == null) continue;
            agg.parseEsBuckets(mba.getBuckets());
        }
        List<AggregateEsBase<? extends Bucket>> ret = queryBuilder.getAggregates();
        return ret;
    }

    private IterableQueryResult getRows(NxQueryBuilder queryBuilder, SearchResponse response) {
        return new EsResultSetImpl(response, queryBuilder.getSelectFieldsAndTypes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SearchResponse search(NxQueryBuilder query) {
        Timer.Context stopWatch = this.searchTimer.time();
        try {
            SearchType searchType = SearchType.DFS_QUERY_THEN_FETCH;
            SearchRequestBuilder request = this.buildEsSearchRequest(query, searchType);
            this.logSearchRequest(request, query, searchType);
            SearchResponse response = (SearchResponse)request.execute().actionGet();
            this.logSearchResponse(response);
            SearchResponse searchResponse = response;
            return searchResponse;
        }
        finally {
            stopWatch.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SearchResponse searchScroll(NxQueryBuilder query, SearchType searchType, long keepAlive) {
        Timer.Context stopWatch = this.searchTimer.time();
        try {
            SearchRequestBuilder request = this.buildEsSearchScrollRequest(query, searchType, keepAlive);
            this.logSearchRequest(request, query, searchType, keepAlive);
            SearchResponse response = (SearchResponse)request.execute().actionGet();
            this.logSearchResponse(response);
            SearchResponse searchResponse = response;
            return searchResponse;
        }
        finally {
            stopWatch.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SearchResponse nextScroll(String scrollId, long keepAlive) {
        Timer.Context stopWatch = this.scrollTimer.time();
        try {
            SearchScrollRequestBuilder request = this.buildEsScrollRequest(scrollId, keepAlive);
            this.logScrollRequest(scrollId, keepAlive);
            SearchResponse response = (SearchResponse)request.execute().actionGet();
            this.logSearchResponse(response);
            SearchResponse searchResponse = response;
            return searchResponse;
        }
        finally {
            stopWatch.stop();
        }
    }

    protected SearchRequestBuilder buildEsSearchRequest(NxQueryBuilder query, SearchType searchType) {
        SearchRequestBuilder request = this.esa.getClient().prepareSearch(this.esa.getSearchIndexes(query.getSearchRepositories())).setTypes(new String[]{"doc"}).setSearchType(searchType);
        query.updateRequest(request);
        if (query.isFetchFromElasticsearch()) {
            request.setFetchSource(this.esa.getIncludeSourceFields(), this.esa.getExcludeSourceFields());
        }
        return request;
    }

    protected SearchRequestBuilder buildEsSearchScrollRequest(NxQueryBuilder query, SearchType searchType, long keepAlive) {
        return this.buildEsSearchRequest(query, searchType).setScroll(new TimeValue(keepAlive)).setSize(query.getLimit());
    }

    protected SearchScrollRequestBuilder buildEsScrollRequest(String scrollId, long keepAlive) {
        return this.esa.getClient().prepareSearchScroll(scrollId).setScroll(new TimeValue(keepAlive));
    }

    protected void logSearchResponse(SearchResponse response) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Response: " + response.toString()));
        }
    }

    protected void logSearchRequest(SearchRequestBuilder request, NxQueryBuilder query, SearchType searchType) {
        this.logSearchRequest(request, query, searchType, null);
    }

    protected void logSearchRequest(SearchRequestBuilder request, NxQueryBuilder query, SearchType searchType, Long keepAlive) {
        if (log.isDebugEnabled()) {
            String scroll = keepAlive != null ? "&scroll=" + keepAlive : "";
            log.debug((Object)String.format("Search query: curl -XGET 'http://localhost:9200/%s/%s/_search?pretty&search_type=%s%s' -d '%s'", this.getSearchIndexesAsString(query), "doc", searchType.toString().toLowerCase(), scroll, request.toString()));
        }
    }

    protected void logScrollRequest(String scrollId, long keepAlive) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Scroll search: curl -XGET 'http://localhost:9200/_search/scroll?pretty' -d '{\"scroll\" : \"%d\", \"scroll_id\" : \"%s\"}'", keepAlive, scrollId));
        }
    }

    protected String getSearchIndexesAsString(NxQueryBuilder query) {
        return StringUtils.join((Object[])this.esa.getSearchIndexes(query.getSearchRepositories()), (char)',');
    }
}

