/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.opencmis.impl.client;

import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.ObjectId;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.Policy;
import org.apache.chemistry.opencmis.client.api.SecondaryType;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.runtime.util.AppendOutputStream;
import org.apache.chemistry.opencmis.commons.data.Ace;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.ContentStreamHash;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConstraintException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisNotSupportedException;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ContentStreamHashImpl;
import org.apache.chemistry.opencmis.commons.spi.Holder;
import org.nuxeo.ecm.core.opencmis.impl.client.NuxeoFileableObject;
import org.nuxeo.ecm.core.opencmis.impl.client.NuxeoSession;
import org.nuxeo.ecm.core.opencmis.impl.server.NuxeoObjectData;

public class NuxeoDocument
extends NuxeoFileableObject
implements Document {
    public NuxeoDocument(NuxeoSession session, NuxeoObjectData data, ObjectType type, List<SecondaryType> secondaryTypes) {
        super(session, data, type, secondaryTypes);
    }

    public void cancelCheckOut() {
        this.service.cancelCheckOut(this.getRepositoryId(), this.getId(), null);
    }

    public ObjectId checkIn(boolean major, Map<String, ?> properties, ContentStream contentStream, String checkinComment) {
        return this.checkIn(major, properties, contentStream, checkinComment, null, null, null);
    }

    public ObjectId checkIn(boolean major, Map<String, ?> properties, ContentStream contentStream, String checkinComment, List<Policy> policies, List<Ace> addAces, List<Ace> removeAces) {
        Holder idHolder = new Holder((Object)this.getId());
        this.service.checkIn(this.getRepositoryId(), idHolder, Boolean.valueOf(major), this.objectFactory.convertProperties(properties, this.type, null, UPDATABILITY_READWRITE), this.objectFactory.convertContentStream(contentStream), checkinComment, this.objectFactory.convertPolicies(policies), this.objectFactory.convertAces(addAces), this.objectFactory.convertAces(removeAces), null);
        return this.session.createObjectId((String)idHolder.getValue());
    }

    public ObjectId checkOut() {
        Holder idHolder = new Holder((Object)this.getId());
        this.service.checkOut(this.getRepositoryId(), idHolder, null, null);
        return this.session.createObjectId((String)idHolder.getValue());
    }

    public NuxeoDocument copy(ObjectId target) {
        return this.copy(target, (Map)null, (VersioningState)null, (List)null, (List)null, (List)null, this.session.getDefaultContext());
    }

    public NuxeoDocument copy(ObjectId target, Map<String, ?> properties, VersioningState versioningState, List<Policy> policies, List<Ace> addACEs, List<Ace> removeACEs, OperationContext context) {
        if (target == null || target.getId() == null) {
            throw new CmisInvalidArgumentException("Invalid target: " + target);
        }
        if (context == null) {
            context = this.session.getDefaultContext();
        }
        NuxeoObjectData newData = this.nuxeoCmisService.copy(this.getId(), target.getId(), properties, (TypeDefinition)this.type, versioningState, policies, addACEs, removeACEs, context);
        return (NuxeoDocument)this.session.getObjectFactory().convertObject(newData, context);
    }

    public void deleteAllVersions() {
        throw new UnsupportedOperationException();
    }

    public NuxeoDocument deleteContentStream() {
        ObjectId objectId = this.deleteContentStream(true);
        return (NuxeoDocument)this.session.getObject(objectId);
    }

    public ObjectId deleteContentStream(boolean refresh) {
        Holder objectIdHolder = new Holder((Object)this.getId());
        String changeToken = (String)this.getPropertyValue("cmis:changeToken");
        Holder changeTokenHolder = new Holder((Object)changeToken);
        this.service.deleteContentStream(this.getRepositoryId(), objectIdHolder, changeTokenHolder, null);
        String objectId = (String)objectIdHolder.getValue();
        return this.session.createObjectId(objectId);
    }

    public List<Document> getAllVersions() {
        throw new UnsupportedOperationException();
    }

    public List<Document> getAllVersions(OperationContext context) {
        throw new UnsupportedOperationException();
    }

    public String getCheckinComment() {
        return (String)this.getPropertyValue("cmis:checkinComment");
    }

    public ContentStream getContentStream() {
        return this.getContentStream(null, null, null);
    }

    public ContentStream getContentStream(String streamId) {
        return this.getContentStream(streamId, null, null);
    }

    public ContentStream getContentStream(BigInteger offset, BigInteger length) {
        return this.getContentStream(null, offset, length);
    }

    public ContentStream getContentStream(String streamId, BigInteger offset, BigInteger length) {
        try {
            return this.service.getContentStream(this.getRepositoryId(), this.getId(), streamId, offset, length, null);
        }
        catch (CmisConstraintException e) {
            return null;
        }
    }

    public String getContentStreamFileName() {
        return (String)this.getPropertyValue("cmis:contentStreamFileName");
    }

    public String getContentStreamId() {
        return (String)this.getPropertyValue("cmis:contentStreamId");
    }

    public long getContentStreamLength() {
        Long length = (Long)this.getPropertyValue("cmis:contentStreamLength");
        return length == null ? -1L : length;
    }

    public String getContentStreamMimeType() {
        return (String)this.getPropertyValue("cmis:contentStreamMimeType");
    }

    public Document getObjectOfLatestVersion(boolean major) {
        throw new UnsupportedOperationException();
    }

    public Document getObjectOfLatestVersion(boolean major, OperationContext context) {
        throw new UnsupportedOperationException();
    }

    public String getVersionLabel() {
        return (String)this.getPropertyValue("cmis:versionLabel");
    }

    public String getVersionSeriesCheckedOutBy() {
        return (String)this.getPropertyValue("cmis:versionSeriesCheckedOutBy");
    }

    public String getVersionSeriesCheckedOutId() {
        return (String)this.getPropertyValue("cmis:versionSeriesCheckedOutId");
    }

    public String getVersionSeriesId() {
        return (String)this.getPropertyValue("cmis:versionSeriesId");
    }

    public Boolean isImmutable() {
        return (Boolean)this.getPropertyValue("cmis:isImmutable");
    }

    public Boolean isLatestMajorVersion() {
        return (Boolean)this.getPropertyValue("cmis:isLatestMajorVersion");
    }

    public Boolean isLatestVersion() {
        return (Boolean)this.getPropertyValue("cmis:isLatestVersion");
    }

    public Boolean isMajorVersion() {
        return (Boolean)this.getPropertyValue("cmis:isMajorVersion");
    }

    public Boolean isVersionSeriesCheckedOut() {
        return (Boolean)this.getPropertyValue("cmis:isVersionSeriesCheckedOut");
    }

    public Boolean isPrivateWorkingCopy() {
        return (Boolean)this.getPropertyValue("cmis:isPrivateWorkingCopy");
    }

    public String getLatestAccessibleStateId() {
        return (String)this.getPropertyValue("cmis:latestAccessibleStateId");
    }

    public Document setContentStream(ContentStream contentStream, boolean overwrite) {
        ObjectId objectId = this.setContentStream(contentStream, overwrite, true);
        return (Document)this.session.getObject(objectId);
    }

    public ObjectId setContentStream(ContentStream contentStream, boolean overwrite, boolean refresh) {
        Holder objectIdHolder = new Holder((Object)this.getId());
        String changeToken = (String)this.getPropertyValue("cmis:changeToken");
        Holder changeTokenHolder = new Holder((Object)changeToken);
        this.service.setContentStream(this.getRepositoryId(), objectIdHolder, Boolean.valueOf(overwrite), changeTokenHolder, contentStream, null);
        String objectId = (String)objectIdHolder.getValue();
        return this.session.createObjectId(objectId);
    }

    public Document appendContentStream(ContentStream contentStream, boolean isLastChunk) {
        ObjectId objectId = this.appendContentStream(contentStream, isLastChunk, true);
        return (Document)this.session.getObject(objectId);
    }

    public ObjectId appendContentStream(ContentStream contentStream, boolean isLastChunk, boolean refresh) {
        throw new CmisNotSupportedException();
    }

    public List<ContentStreamHash> getContentStreamHashes() {
        List hashes = (List)this.getPropertyValue("cmis:contentStreamHash");
        if (hashes == null || hashes.size() == 0) {
            return null;
        }
        ArrayList<ContentStreamHash> result = new ArrayList<ContentStreamHash>(hashes.size());
        for (String hash : hashes) {
            result.add((ContentStreamHash)new ContentStreamHashImpl(hash));
        }
        return result;
    }

    public String getContentUrl() {
        throw new UnsupportedOperationException();
    }

    public String getContentUrl(String streamId) {
        throw new UnsupportedOperationException();
    }

    public OutputStream createOverwriteOutputStream(String filename, String mimeType) {
        if (this.session.getRepositoryInfo().getCmisVersion() == CmisVersion.CMIS_1_0) {
            throw new CmisNotSupportedException("This method is not supported for CMIS 1.0 repositories");
        }
        return new AppendOutputStream((Session)this.session, (Document)this, true, filename, mimeType);
    }

    public OutputStream createOverwriteOutputStream(String filename, String mimeType, int bufferSize) {
        if (this.session.getRepositoryInfo().getCmisVersion() == CmisVersion.CMIS_1_0) {
            throw new CmisNotSupportedException("This method is not supported for CMIS 1.0 repositories");
        }
        return new AppendOutputStream((Session)this.session, (Document)this, true, filename, mimeType, bufferSize);
    }

    public OutputStream createAppendOutputStream() {
        if (this.session.getRepositoryInfo().getCmisVersion() == CmisVersion.CMIS_1_0) {
            throw new CmisNotSupportedException("This method is not supported for CMIS 1.0 repositories");
        }
        return new AppendOutputStream((Session)this.session, (Document)this, false, null, null);
    }

    public OutputStream createAppendOutputStream(int bufferSize) {
        if (this.session.getRepositoryInfo().getCmisVersion() == CmisVersion.CMIS_1_0) {
            throw new CmisNotSupportedException("This method is not supported for CMIS 1.0 repositories");
        }
        return new AppendOutputStream((Session)this.session, (Document)this, false, null, null, bufferSize);
    }
}

