/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.query.core;

import java.util.Locale;
import org.nuxeo.ecm.platform.query.api.Bucket;

public final class BucketRange
implements Bucket {
    private final String key;
    private final long docCount;
    private final Double from;
    private final Double to;

    public BucketRange(String key, Number from, Number to, long docCount) {
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        this.key = key;
        this.from = from != null ? Double.valueOf(from.doubleValue()) : null;
        this.to = to != null ? Double.valueOf(to.doubleValue()) : null;
        this.docCount = docCount;
    }

    public String getKey() {
        return this.key;
    }

    public long getDocCount() {
        return this.docCount;
    }

    public Double getFrom() {
        return this.from;
    }

    public Double getTo() {
        return this.to;
    }

    public String toString() {
        return String.format(Locale.ENGLISH, "BucketRange(%s, %d, %.2f, %.2f)", this.key, this.docCount, this.from, this.to);
    }
}

