/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.audit;

import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.work.AbstractWork;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.platform.audit.api.AuditLogger;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.ecm.platform.audit.service.AuditBackend;
import org.nuxeo.ecm.platform.audit.service.NXAuditEventsService;
import org.nuxeo.ecm.platform.audit.service.extension.AuditBackendDescriptor;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class ESAuditMigrationWork
extends AbstractWork {
    private static final long serialVersionUID = 3764830939638449534L;
    private static final Log log = LogFactory.getLog(ESAuditMigrationWork.class);
    protected int batchSize;

    public ESAuditMigrationWork(String id, int batchSize) {
        super(id);
        this.batchSize = batchSize;
    }

    public String getTitle() {
        return "Audit migration worker";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void work() {
        NXAuditEventsService auditService = (NXAuditEventsService)Framework.getRuntime().getComponent(NXAuditEventsService.NAME);
        AuditBackendDescriptor config = new AuditBackendDescriptor();
        AuditBackend sourceBackend = config.newInstance(auditService);
        sourceBackend.onApplicationStarted();
        try {
            List res = sourceBackend.nativeQuery("select count(*) from LogEntry", 1, 20);
            long nbEntriesToMigrate = (Long)res.get(0);
            AuditBackend destBackend = auditService.getBackend();
            TransactionHelper.commitOrRollbackTransaction();
            long t0 = System.currentTimeMillis();
            long nbEntriesMigrated = 0L;
            int pageIdx = 1;
            while (nbEntriesMigrated < nbEntriesToMigrate) {
                List entries = sourceBackend.nativeQuery("from LogEntry log order by log.id asc", pageIdx, this.batchSize);
                if (entries.size() == 0) {
                    log.warn((Object)("Migration ending after " + nbEntriesMigrated + " entries"));
                    break;
                }
                this.setProgress(new Work.Progress(nbEntriesMigrated, nbEntriesToMigrate));
                destBackend.addLogEntries(entries);
                ++pageIdx;
                log.info((Object)("Migrated " + (nbEntriesMigrated += (long)entries.size()) + " log entries on " + nbEntriesToMigrate));
                double dt = (double)(System.currentTimeMillis() - t0) / 1000.0;
                if (dt == 0.0) continue;
                log.info((Object)("Migration speed: " + (double)nbEntriesMigrated / dt + " entries/s"));
            }
            log.info((Object)("Audit migration from SQL to Elasticsearch done: " + nbEntriesMigrated + " entries migrated"));
            AuditLogger logger = (AuditLogger)Framework.getService(AuditLogger.class);
            LogEntry entry = logger.newLogEntry();
            entry.setCategory("NuxeoTechnicalEvent");
            entry.setEventId("sqlToElasticsearchMigrationDone");
            entry.setPrincipalName("system");
            entry.setEventDate(Calendar.getInstance(TimeZone.getTimeZone("UTC")).getTime());
            destBackend.addLogEntries(Collections.singletonList(entry));
        }
        finally {
            sourceBackend.onShutdown();
        }
    }
}

