/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.seqgen;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.core.uidgen.UIDGeneratorService;
import org.nuxeo.ecm.core.uidgen.UIDSequencer;
import org.nuxeo.elasticsearch.seqgen.ESUIDSequencer;
import org.nuxeo.elasticsearch.test.RepositoryElasticSearchFeature;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.LocalDeploy;

@RunWith(value=FeaturesRunner.class)
@Features(value={RepositoryElasticSearchFeature.class})
@Deploy(value={"org.nuxeo.ecm.platform.uidgen.core", "org.nuxeo.elasticsearch.seqgen"})
@LocalDeploy(value={"org.nuxeo.elasticsearch.seqgen:elasticsearch-seqgen-test-contrib.xml", "org.nuxeo.elasticsearch.seqgen:elasticsearch-seqgen-index-test-contrib.xml"})
public class TestSequenceGeneratorWithElasticSearch {
    @Inject
    protected UIDGeneratorService uidGeneratorService;

    @Test
    public void testIncrement() throws Exception {
        UIDSequencer seq = this.uidGeneratorService.getSequencer();
        Assert.assertNotNull((Object)seq);
        Assert.assertTrue((boolean)seq.getClass().isAssignableFrom(ESUIDSequencer.class));
        Assert.assertEquals((long)1L, (long)seq.getNext("myseq"));
        Assert.assertEquals((long)2L, (long)seq.getNext("myseq"));
        Assert.assertEquals((long)3L, (long)seq.getNextLong("myseq"));
        Assert.assertEquals((long)1L, (long)seq.getNext("myseq2"));
        Assert.assertEquals((long)4L, (long)seq.getNext("myseq"));
        Assert.assertEquals((long)2L, (long)seq.getNext("myseq2"));
    }

    @Test
    public void testInitSequence() {
        UIDSequencer seq = this.uidGeneratorService.getSequencer();
        seq.getNext("mySequence");
        seq.getNext("mySequence");
        seq.initSequence("mySequence", 1);
        Assert.assertTrue((seq.getNext("mySequence") > 1 ? 1 : 0) != 0);
        seq.initSequence("mySequence", 10);
        Assert.assertTrue((seq.getNext("mySequence") > 10 ? 1 : 0) != 0);
        Assert.assertTrue((seq.getNextLong("mySequence") > 10L ? 1 : 0) != 0);
    }

    @Test
    public void testConcurrency() throws Exception {
        String seqName = "mt";
        int nbCalls = 5000;
        final UIDSequencer seq = this.uidGeneratorService.getSequencer();
        ThreadPoolExecutor tpe = new ThreadPoolExecutor(5, 5, 500L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(nbCalls + 1));
        for (int i = 0; i < nbCalls; ++i) {
            tpe.submit(new Runnable(){

                @Override
                public void run() {
                    seq.getNext("mt");
                }
            });
        }
        tpe.shutdown();
        boolean finish = tpe.awaitTermination(20L, TimeUnit.SECONDS);
        Assert.assertTrue((String)"timeout", (boolean)finish);
        Assert.assertEquals((long)(nbCalls + 1), (long)seq.getNext("mt"));
    }
}

