/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.redis.embedded;

import com.lordofthejars.nosqlunit.redis.embedded.EmbeddedJedis;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import redis.clients.jedis.BinaryClient;
import redis.clients.jedis.Builder;
import redis.clients.jedis.BuilderFactory;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Response;
import redis.clients.jedis.SortingParams;
import redis.clients.jedis.Tuple;
import redis.clients.jedis.ZParams;
import redis.clients.jedis.exceptions.JedisDataException;

public class EmbeddedPipeline
extends Pipeline {
    private EmbeddedJedis jedis;
    private MultiResponseBuilder currentMulti;

    public EmbeddedPipeline(EmbeddedJedis jedis) {
        this.jedis = jedis;
    }

    public Response<Long> append(String key, String value) {
        Response response = this.getResponse(BuilderFactory.LONG);
        response.set((Object)this.jedis.append(key, value));
        return response;
    }

    public Response<Long> append(byte[] key, byte[] value) {
        Response response = this.getResponse(BuilderFactory.LONG);
        response.set((Object)this.jedis.append(key, value));
        return response;
    }

    public Response<List<String>> blpop(String ... args) {
        throw new UnsupportedOperationException();
    }

    public Response<List<byte[]>> blpop(byte[] ... args) {
        throw new UnsupportedOperationException();
    }

    public Response<List<String>> brpop(String ... args) {
        throw new UnsupportedOperationException();
    }

    public Response<List<byte[]>> brpop(byte[] ... args) {
        throw new UnsupportedOperationException();
    }

    public Response<Long> decr(String key) {
        Response response = this.getResponse(BuilderFactory.LONG);
        response.set((Object)this.jedis.decr(key));
        return response;
    }

    public Response<Long> decr(byte[] key) {
        Response response = this.getResponse(BuilderFactory.LONG);
        response.set((Object)this.jedis.decr(key));
        return response;
    }

    public Response<Long> decrBy(String key, long integer) {
        Response response = this.getResponse(BuilderFactory.LONG);
        response.set((Object)this.jedis.decrBy(key, integer));
        return response;
    }

    public Response<Long> decrBy(byte[] key, long integer) {
        Response response = this.getResponse(BuilderFactory.LONG);
        response.set((Object)this.jedis.decrBy(key, integer));
        return response;
    }

    public Response<Long> del(String ... keys) {
        Response response = this.getResponse(BuilderFactory.LONG);
        response.set((Object)this.jedis.del(keys));
        return response;
    }

    public Response<Long> del(byte[] ... keys) {
        Response response = this.getResponse(BuilderFactory.LONG);
        response.set((Object)this.jedis.del(keys));
        return response;
    }

    public Response<String> echo(String string) {
        Response response = this.getResponse(BuilderFactory.STRING);
        response.set((Object)this.jedis.echo(string));
        return response;
    }

    public Response<byte[]> echo(byte[] string) {
        Response response = this.getResponse(BuilderFactory.BYTE_ARRAY);
        response.set((Object)this.jedis.echo(string));
        return response;
    }

    public Response<Boolean> exists(String key) {
        Response response = this.getResponse(BuilderFactory.BOOLEAN);
        response.set((Object)this.jedis.exists(key));
        return response;
    }

    public Response<Boolean> exists(byte[] key) {
        Response response = this.getResponse(BuilderFactory.BOOLEAN);
        response.set((Object)this.jedis.exists(key));
        return response;
    }

    public Response<Long> expire(String key, int seconds) {
        Response response = this.getResponse(BuilderFactory.LONG);
        response.set((Object)this.jedis.expire(key, seconds));
        return response;
    }

    public Response<Long> expire(byte[] key, int seconds) {
        Response response = this.getResponse(BuilderFactory.LONG);
        response.set((Object)this.jedis.expire(key, seconds));
        return response;
    }

    public Response<Long> expireAt(String key, long unixTime) {
        Response response = this.getResponse(BuilderFactory.LONG);
        response.set((Object)this.jedis.expireAt(key, unixTime));
        return response;
    }

    public Response<Long> expireAt(byte[] key, long unixTime) {
        Response response = this.getResponse(BuilderFactory.LONG);
        response.set((Object)this.jedis.expireAt(key, unixTime));
        return response;
    }

    public Response<String> get(String key) {
        Response response = this.getResponse(BuilderFactory.STRING);
        response.set((Object)this.jedis.get(key));
        return response;
    }

    public Response<byte[]> get(byte[] key) {
        Response response = this.getResponse(BuilderFactory.BYTE_ARRAY);
        response.set((Object)this.jedis.get(key));
        return response;
    }

    public Response<Boolean> getbit(String key, long offset) {
        Response response = this.getResponse(BuilderFactory.BOOLEAN);
        response.set((Object)this.jedis.getbit(key, offset));
        return response;
    }

    public Response<String> getrange(String key, long startOffset, long endOffset) {
        Response response = this.getResponse(BuilderFactory.STRING);
        response.set((Object)this.jedis.getrange(key, startOffset, endOffset));
        return response;
    }

    public Response<String> getSet(String key, String value) {
        Response response = this.getResponse(BuilderFactory.STRING);
        response.set((Object)this.jedis.getSet(key, value));
        return response;
    }

    public Response<byte[]> getSet(byte[] key, byte[] value) {
        Response response = this.getResponse(BuilderFactory.BYTE_ARRAY);
        response.set((Object)this.jedis.getSet(key, value));
        return response;
    }

    public Response<Long> hdel(String key, String field) {
        Response response = this.getResponse(BuilderFactory.LONG);
        response.set((Object)this.jedis.hdel(key, field));
        return response;
    }

    public Response<Long> hdel(byte[] key, byte[] field) {
        Response response = this.getResponse(BuilderFactory.LONG);
        response.set((Object)this.jedis.hdel(key, new byte[][]{field}));
        return response;
    }

    public Response<Boolean> hexists(String key, String field) {
        Response response = this.getResponse(BuilderFactory.BOOLEAN);
        response.set((Object)this.jedis.hexists(key, field));
        return response;
    }

    public Response<Boolean> hexists(byte[] key, byte[] field) {
        Response response = this.getResponse(BuilderFactory.BOOLEAN);
        response.set((Object)this.jedis.hexists(key, field));
        return response;
    }

    public Response<String> hget(String key, String field) {
        Response response = this.getResponse(BuilderFactory.STRING);
        response.set((Object)this.jedis.hget(key, field));
        return response;
    }

    public Response<byte[]> hget(byte[] key, byte[] field) {
        Response response = this.getResponse(BuilderFactory.BYTE_ARRAY);
        response.set((Object)this.jedis.hget(key, field));
        return response;
    }

    public Response<Map<String, String>> hgetAll(String key) {
        Response response = this.getResponse(BuilderFactory.STRING_MAP);
        response.set(this.jedis.hgetAll(key));
        return response;
    }

    public Response<Map<byte[], byte[]>> hgetAll(byte[] key) {
        Response response = this.getResponse(BuilderFactory.BYTE_ARRAY_MAP);
        response.set(this.jedis.hgetAll(key));
        return response;
    }

    public Response<Long> hincrBy(String key, String field, long value) {
        Response response = this.getResponse(BuilderFactory.LONG);
        response.set((Object)this.jedis.hincrBy(key, field, value));
        return response;
    }

    public Response<Long> hincrBy(byte[] key, byte[] field, long value) {
        Response response = this.getResponse(BuilderFactory.LONG);
        response.set((Object)this.jedis.hincrBy(key, field, value));
        return response;
    }

    public Response<Set<String>> hkeys(String key) {
        Response response = this.getResponse(BuilderFactory.STRING_SET);
        response.set(this.jedis.hkeys(key));
        return response;
    }

    public Response<Set<byte[]>> hkeys(byte[] key) {
        Response response = this.getResponse(BuilderFactory.BYTE_ARRAY_ZSET);
        response.set(this.jedis.hkeys(key));
        return response;
    }

    public Response<Long> hlen(String key) {
        Response response = this.getResponse(BuilderFactory.LONG);
        response.set((Object)this.jedis.hlen(key));
        return response;
    }

    public Response<Long> hlen(byte[] key) {
        Response response = this.getResponse(BuilderFactory.LONG);
        response.set((Object)this.jedis.hlen(key));
        return response;
    }

    public Response<List<String>> hmget(String key, String ... fields) {
        Response response = this.getResponse(BuilderFactory.STRING_LIST);
        response.set(this.jedis.hmget(key, fields));
        return response;
    }

    public Response<List<byte[]>> hmget(byte[] key, byte[] ... fields) {
        Response response = this.getResponse(BuilderFactory.BYTE_ARRAY_LIST);
        response.set(this.jedis.hmget(key, fields));
        return response;
    }

    public Response<String> hmset(String key, Map<String, String> hash) {
        Response response = this.getResponse(BuilderFactory.STRING);
        response.set((Object)this.jedis.hmset(key, hash));
        return response;
    }

    public Response<String> hmset(byte[] key, Map<byte[], byte[]> hash) {
        Response response = this.getResponse(BuilderFactory.STRING);
        response.set((Object)this.jedis.hmset(key, hash));
        return response;
    }

    public Response<Long> hset(String key, String field, String value) {
        Response response = this.getResponse(BuilderFactory.LONG);
        response.set((Object)this.jedis.hset(key, field, value));
        return response;
    }

    public Response<Long> hset(byte[] key, byte[] field, byte[] value) {
        Response response = this.getResponse(BuilderFactory.LONG);
        response.set((Object)this.jedis.hset(key, field, value));
        return response;
    }

    public Response<Long> hsetnx(String key, String field, String value) {
        Response response = this.getResponse(BuilderFactory.LONG);
        response.set((Object)this.jedis.hsetnx(key, field, value));
        return response;
    }

    public Response<Long> hsetnx(byte[] key, byte[] field, byte[] value) {
        Response response = this.getResponse(BuilderFactory.LONG);
        response.set((Object)this.jedis.hsetnx(key, field, value));
        return response;
    }

    public Response<List<String>> hvals(String key) {
        Response response = this.getResponse(BuilderFactory.STRING_LIST);
        response.set(this.jedis.hvals(key));
        return response;
    }

    public Response<List<byte[]>> hvals(byte[] key) {
        Response response = this.getResponse(BuilderFactory.BYTE_ARRAY_LIST);
        response.set(this.jedis.hvals(key));
        return response;
    }

    public Response<Long> incr(String key) {
        Response response = this.getResponse(BuilderFactory.LONG);
        response.set((Object)this.jedis.incr(key));
        return response;
    }

    public Response<Long> incr(byte[] key) {
        Response response = this.getResponse(BuilderFactory.LONG);
        response.set((Object)this.jedis.incr(key));
        return response;
    }

    public Response<Long> incrBy(String key, long integer) {
        Response response = this.getResponse(BuilderFactory.LONG);
        response.set((Object)this.jedis.incrBy(key, integer));
        return response;
    }

    public Response<Long> incrBy(byte[] key, long integer) {
        Response response = this.getResponse(BuilderFactory.LONG);
        response.set((Object)this.jedis.incrBy(key, integer));
        return response;
    }

    public Response<Set<String>> keys(String pattern) {
        Response response = this.getResponse(BuilderFactory.STRING_SET);
        response.set(this.jedis.keys(pattern));
        return response;
    }

    public Response<Set<byte[]>> keys(byte[] pattern) {
        Response response = this.getResponse(BuilderFactory.BYTE_ARRAY_ZSET);
        response.set(this.jedis.keys(pattern));
        return response;
    }

    public Response<String> lindex(String key, int index) {
        Response response = this.getResponse(BuilderFactory.STRING);
        response.set((Object)this.jedis.lindex(key, (long)index));
        return response;
    }

    public Response<String> lindex(byte[] key, int index) {
        Response response = this.getResponse(BuilderFactory.STRING);
        response.set((Object)this.jedis.lindex(key, (long)index));
        return response;
    }

    public Response<Long> linsert(String key, BinaryClient.LIST_POSITION where, String pivot, String value) {
        Response response = this.getResponse(BuilderFactory.LONG);
        response.set((Object)this.jedis.linsert(key, where, pivot, value));
        return response;
    }

    public Response<Long> linsert(byte[] key, BinaryClient.LIST_POSITION where, byte[] pivot, byte[] value) {
        Response response = this.getResponse(BuilderFactory.LONG);
        response.set((Object)this.jedis.linsert(key, where, pivot, value));
        return response;
    }

    public Response<Long> llen(String key) {
        Response response = this.getResponse(BuilderFactory.LONG);
        response.set((Object)this.jedis.llen(key));
        return response;
    }

    public Response<Long> llen(byte[] key) {
        Response response = this.getResponse(BuilderFactory.LONG);
        response.set((Object)this.jedis.llen(key));
        return response;
    }

    public Response<String> lpop(String key) {
        Response response = this.getResponse(BuilderFactory.STRING);
        response.set((Object)this.jedis.lpop(key));
        return response;
    }

    public Response<byte[]> lpop(byte[] key) {
        Response response = this.getResponse(BuilderFactory.BYTE_ARRAY);
        response.set((Object)this.jedis.lpop(key));
        return response;
    }

    public Response<Long> lpush(String key, String string) {
        Response response = this.getResponse(BuilderFactory.LONG);
        response.set((Object)this.jedis.lpush(key, string));
        return response;
    }

    public Response<Long> lpush(byte[] key, byte[] string) {
        Response response = this.getResponse(BuilderFactory.LONG);
        response.set((Object)this.jedis.lpush(key, new byte[][]{string}));
        return response;
    }

    public Response<Long> lpushx(String key, String string) {
        Response response = this.getResponse(BuilderFactory.LONG);
        response.set((Object)this.jedis.lpushx(key, string));
        return response;
    }

    public Response<Long> lpushx(byte[] key, byte[] bytes) {
        Response response = this.getResponse(BuilderFactory.LONG);
        response.set((Object)this.jedis.lpushx(key, bytes));
        return response;
    }

    public Response<List<String>> lrange(String key, long start, long end) {
        Response response = this.getResponse(BuilderFactory.STRING_LIST);
        response.set(this.jedis.lrange(key, start, end));
        return response;
    }

    public Response<List<byte[]>> lrange(byte[] key, long start, long end) {
        Response response = this.getResponse(BuilderFactory.BYTE_ARRAY_LIST);
        response.set(this.jedis.lrange(key, (long)((int)start), (long)((int)end)));
        return response;
    }

    public Response<Long> lrem(String key, long count, String value) {
        Response response = this.getResponse(BuilderFactory.LONG);
        response.set((Object)this.jedis.lrem(key, count, value));
        return response;
    }

    public Response<Long> lrem(byte[] key, long count, byte[] value) {
        Response response = this.getResponse(BuilderFactory.LONG);
        response.set((Object)this.jedis.lrem(key, (long)((int)count), value));
        return response;
    }

    public Response<String> lset(String key, long index, String value) {
        Response response = this.getResponse(BuilderFactory.STRING);
        response.set((Object)this.jedis.lset(key, index, value));
        return response;
    }

    public Response<String> lset(byte[] key, long index, byte[] value) {
        Response response = this.getResponse(BuilderFactory.STRING);
        response.set((Object)this.jedis.lset(key, (long)((int)index), value));
        return response;
    }

    public Response<String> ltrim(String key, long start, long end) {
        Response response = this.getResponse(BuilderFactory.STRING);
        response.set((Object)this.jedis.ltrim(key, start, end));
        return response;
    }

    public Response<String> ltrim(byte[] key, long start, long end) {
        Response response = this.getResponse(BuilderFactory.STRING);
        response.set((Object)this.jedis.ltrim(key, (long)((int)start), (long)((int)end)));
        return response;
    }

    public Response<List<String>> mget(String ... keys) {
        throw new UnsupportedOperationException();
    }

    public Response<List<byte[]>> mget(byte[] ... keys) {
        throw new UnsupportedOperationException();
    }

    public Response<Long> move(String key, int dbIndex) {
        throw new UnsupportedOperationException();
    }

    public Response<Long> move(byte[] key, int dbIndex) {
        Response response = this.getResponse(BuilderFactory.LONG);
        response.set((Object)this.jedis.move(key, dbIndex));
        return response;
    }

    public Response<String> mset(String ... keysvalues) {
        throw new UnsupportedOperationException();
    }

    public Response<String> mset(byte[] ... keysvalues) {
        throw new UnsupportedOperationException();
    }

    public Response<Long> msetnx(String ... keysvalues) {
        throw new UnsupportedOperationException();
    }

    public Response<Long> msetnx(byte[] ... keysvalues) {
        throw new UnsupportedOperationException();
    }

    public Response<Long> persist(String key) {
        Response response = this.getResponse(BuilderFactory.LONG);
        response.set((Object)this.jedis.persist(key));
        return response;
    }

    public Response<Long> persist(byte[] key) {
        Response response = this.getResponse(BuilderFactory.LONG);
        response.set((Object)this.jedis.persist(key));
        return response;
    }

    public Response<String> rename(String oldkey, String newkey) {
        Response response = this.getResponse(BuilderFactory.STRING);
        response.set((Object)this.jedis.rename(oldkey, newkey));
        return response;
    }

    public Response<String> rename(byte[] oldkey, byte[] newkey) {
        Response response = this.getResponse(BuilderFactory.STRING);
        response.set((Object)this.jedis.rename(oldkey, newkey));
        return response;
    }

    public Response<Long> renamenx(String oldkey, String newkey) {
        Response response = this.getResponse(BuilderFactory.LONG);
        response.set((Object)this.jedis.renamenx(oldkey, newkey));
        return response;
    }

    public Response<Long> renamenx(byte[] oldkey, byte[] newkey) {
        Response response = this.getResponse(BuilderFactory.LONG);
        response.set((Object)this.jedis.renamenx(oldkey, newkey));
        return response;
    }

    public Response<String> rpop(String key) {
        Response response = this.getResponse(BuilderFactory.STRING);
        response.set((Object)this.jedis.rpop(key));
        return response;
    }

    public Response<byte[]> rpop(byte[] key) {
        Response response = this.getResponse(BuilderFactory.BYTE_ARRAY);
        response.set((Object)this.jedis.rpop(key));
        return response;
    }

    public Response<String> rpoplpush(String srckey, String dstkey) {
        throw new UnsupportedOperationException();
    }

    public Response<byte[]> rpoplpush(byte[] srckey, byte[] dstkey) {
        throw new UnsupportedOperationException();
    }

    public Response<Long> rpush(String key, String string) {
        Response response = this.getResponse(BuilderFactory.LONG);
        response.set((Object)this.jedis.rpush(key, string));
        return response;
    }

    public Response<Long> rpush(byte[] key, byte[] string) {
        Response response = this.getResponse(BuilderFactory.LONG);
        response.set((Object)this.jedis.rpush(key, new byte[][]{string}));
        return response;
    }

    public Response<Long> rpushx(String key, String string) {
        Response response = this.getResponse(BuilderFactory.LONG);
        response.set((Object)this.jedis.rpushx(key, string));
        return response;
    }

    public Response<Long> rpushx(byte[] key, byte[] string) {
        Response response = this.getResponse(BuilderFactory.LONG);
        response.set((Object)this.jedis.rpushx(key, string));
        return response;
    }

    public Response<Long> sadd(String key, String member) {
        Response response = this.getResponse(BuilderFactory.LONG);
        response.set((Object)this.jedis.sadd(key, member));
        return response;
    }

    public Response<Long> sadd(byte[] key, byte[] member) {
        Response response = this.getResponse(BuilderFactory.LONG);
        response.set((Object)this.jedis.sadd(key, new byte[][]{member}));
        return response;
    }

    public Response<Long> scard(String key) {
        Response response = this.getResponse(BuilderFactory.LONG);
        response.set((Object)this.jedis.scard(key));
        return response;
    }

    public Response<Long> scard(byte[] key) {
        Response response = this.getResponse(BuilderFactory.LONG);
        response.set((Object)this.jedis.scard(key));
        return response;
    }

    public Response<Set<String>> sdiff(String ... keys) {
        throw new UnsupportedOperationException();
    }

    public Response<Set<byte[]>> sdiff(byte[] ... keys) {
        throw new UnsupportedOperationException();
    }

    public Response<Long> sdiffstore(String dstkey, String ... keys) {
        throw new UnsupportedOperationException();
    }

    public Response<Long> sdiffstore(byte[] dstkey, byte[] ... keys) {
        throw new UnsupportedOperationException();
    }

    public Response<String> set(String key, String value) {
        Response response = this.getResponse(BuilderFactory.STRING);
        response.set((Object)this.jedis.set(key, value));
        return response;
    }

    public Response<String> set(byte[] key, byte[] value) {
        Response response = this.getResponse(BuilderFactory.STRING);
        response.set((Object)this.jedis.set(key, value));
        return response;
    }

    public Response<Boolean> setbit(String key, long offset, boolean value) {
        Response response = this.getResponse(BuilderFactory.BOOLEAN);
        response.set((Object)this.jedis.setbit(key, offset, value));
        return response;
    }

    public Response<String> setex(String key, int seconds, String value) {
        Response response = this.getResponse(BuilderFactory.STRING);
        response.set((Object)this.jedis.setex(key, seconds, value));
        return response;
    }

    public Response<String> setex(byte[] key, int seconds, byte[] value) {
        Response response = this.getResponse(BuilderFactory.STRING);
        response.set((Object)this.jedis.setex(key, seconds, value));
        return response;
    }

    public Response<Long> setnx(String key, String value) {
        Response response = this.getResponse(BuilderFactory.LONG);
        response.set((Object)this.jedis.setnx(key, value));
        return response;
    }

    public Response<Long> setnx(byte[] key, byte[] value) {
        Response response = this.getResponse(BuilderFactory.LONG);
        response.set((Object)this.jedis.setnx(key, value));
        return response;
    }

    public Response<Long> setrange(String key, long offset, String value) {
        Response response = this.getResponse(BuilderFactory.LONG);
        response.set((Object)this.jedis.setrange(key, offset, value));
        return response;
    }

    public Response<Set<String>> sinter(String ... keys) {
        throw new UnsupportedOperationException();
    }

    public Response<Set<byte[]>> sinter(byte[] ... keys) {
        throw new UnsupportedOperationException();
    }

    public Response<Long> sinterstore(String dstkey, String ... keys) {
        throw new UnsupportedOperationException();
    }

    public Response<Long> sinterstore(byte[] dstkey, byte[] ... keys) {
        throw new UnsupportedOperationException();
    }

    public Response<Boolean> sismember(String key, String member) {
        Response response = this.getResponse(BuilderFactory.BOOLEAN);
        response.set((Object)this.jedis.sismember(key, member));
        return response;
    }

    public Response<Boolean> sismember(byte[] key, byte[] member) {
        Response response = this.getResponse(BuilderFactory.BOOLEAN);
        response.set((Object)this.jedis.sismember(key, member));
        return response;
    }

    public Response<Set<String>> smembers(String key) {
        Response response = this.getResponse(BuilderFactory.STRING_SET);
        response.set(this.jedis.smembers(key));
        return response;
    }

    public Response<Set<byte[]>> smembers(byte[] key) {
        Response response = this.getResponse(BuilderFactory.BYTE_ARRAY_ZSET);
        response.set(this.jedis.smembers(key));
        return response;
    }

    public Response<Long> smove(String srckey, String dstkey, String member) {
        throw new UnsupportedOperationException();
    }

    public Response<Long> smove(byte[] srckey, byte[] dstkey, byte[] member) {
        throw new UnsupportedOperationException();
    }

    public Response<List<String>> sort(String key) {
        Response response = this.getResponse(BuilderFactory.STRING_LIST);
        response.set(this.jedis.sort(key));
        return response;
    }

    public Response<List<byte[]>> sort(byte[] key) {
        Response response = this.getResponse(BuilderFactory.BYTE_ARRAY_LIST);
        response.set(this.jedis.sort(key));
        return response;
    }

    public Response<List<String>> sort(String key, SortingParams sortingParameters) {
        Response response = this.getResponse(BuilderFactory.STRING_LIST);
        response.set(this.jedis.sort(key, sortingParameters));
        return response;
    }

    public Response<List<byte[]>> sort(byte[] key, SortingParams sortingParameters) {
        Response response = this.getResponse(BuilderFactory.BYTE_ARRAY_LIST);
        response.set(this.jedis.sort(key, sortingParameters));
        return response;
    }

    public Response<Long> sort(String key, SortingParams sortingParameters, String dstkey) {
        throw new UnsupportedOperationException();
    }

    public Response<Long> sort(byte[] key, SortingParams sortingParameters, byte[] dstkey) {
        throw new UnsupportedOperationException();
    }

    public Response<Long> sort(String key, String dstkey) {
        throw new UnsupportedOperationException();
    }

    public Response<Long> sort(byte[] key, byte[] dstkey) {
        throw new UnsupportedOperationException();
    }

    public Response<String> spop(String key) {
        Response response = this.getResponse(BuilderFactory.STRING);
        response.set((Object)this.jedis.spop(key));
        return response;
    }

    public Response<byte[]> spop(byte[] key) {
        Response response = this.getResponse(BuilderFactory.BYTE_ARRAY);
        response.set((Object)this.jedis.spop(key));
        return response;
    }

    public Response<String> srandmember(String key) {
        Response response = this.getResponse(BuilderFactory.STRING);
        response.set((Object)this.jedis.srandmember(key));
        return response;
    }

    public Response<byte[]> srandmember(byte[] key) {
        Response response = this.getResponse(BuilderFactory.BYTE_ARRAY);
        response.set((Object)this.jedis.srandmember(key));
        return response;
    }

    public Response<Long> srem(String key, String member) {
        Response response = this.getResponse(BuilderFactory.LONG);
        response.set((Object)this.jedis.srem(key, member));
        return response;
    }

    public Response<Long> srem(byte[] key, byte[] member) {
        Response response = this.getResponse(BuilderFactory.LONG);
        response.set((Object)this.jedis.srem(key, new byte[][]{member}));
        return response;
    }

    public Response<Long> strlen(String key) {
        throw new UnsupportedOperationException();
    }

    public Response<Long> strlen(byte[] key) {
        throw new UnsupportedOperationException();
    }

    public Response<String> substr(String key, int start, int end) {
        Response response = this.getResponse(BuilderFactory.STRING);
        response.set((Object)this.jedis.substr(key, start, end));
        return response;
    }

    public Response<String> substr(byte[] key, int start, int end) {
        Response response = this.getResponse(BuilderFactory.STRING);
        response.set((Object)this.jedis.substr(key, start, end));
        return response;
    }

    public Response<Set<String>> sunion(String ... keys) {
        throw new UnsupportedOperationException();
    }

    public Response<Set<byte[]>> sunion(byte[] ... keys) {
        throw new UnsupportedOperationException();
    }

    public Response<Long> sunionstore(String dstkey, String ... keys) {
        throw new UnsupportedOperationException();
    }

    public Response<Long> sunionstore(byte[] dstkey, byte[] ... keys) {
        throw new UnsupportedOperationException();
    }

    public Response<Long> ttl(String key) {
        Response response = this.getResponse(BuilderFactory.LONG);
        response.set((Object)this.jedis.ttl(key));
        return response;
    }

    public Response<Long> ttl(byte[] key) {
        Response response = this.getResponse(BuilderFactory.LONG);
        response.set((Object)this.jedis.ttl(key));
        return response;
    }

    public Response<String> type(String key) {
        Response response = this.getResponse(BuilderFactory.STRING);
        response.set((Object)this.jedis.type(key));
        return response;
    }

    public Response<String> type(byte[] key) {
        Response response = this.getResponse(BuilderFactory.STRING);
        response.set((Object)this.jedis.type(key));
        return response;
    }

    public Response<String> watch(String ... keys) {
        Response response = this.getResponse(BuilderFactory.STRING);
        response.set((Object)this.jedis.watch(keys));
        return response;
    }

    public Response<String> watch(byte[] ... keys) {
        Response response = this.getResponse(BuilderFactory.STRING);
        response.set((Object)this.jedis.watch(keys));
        return response;
    }

    public Response<Long> zadd(String key, double score, String member) {
        Response response = this.getResponse(BuilderFactory.LONG);
        response.set((Object)this.jedis.zadd(key, score, member));
        return response;
    }

    public Response<Long> zadd(byte[] key, double score, byte[] member) {
        Response response = this.getResponse(BuilderFactory.LONG);
        response.set((Object)this.jedis.zadd(key, score, member));
        return response;
    }

    public Response<Long> zcard(String key) {
        Response response = this.getResponse(BuilderFactory.LONG);
        response.set((Object)this.jedis.zcard(key));
        return response;
    }

    public Response<Long> zcard(byte[] key) {
        Response response = this.getResponse(BuilderFactory.LONG);
        response.set((Object)this.jedis.zcard(key));
        return response;
    }

    public Response<Long> zcount(String key, double min, double max) {
        Response response = this.getResponse(BuilderFactory.LONG);
        response.set((Object)this.jedis.zcount(key, min, max));
        return response;
    }

    public Response<Long> zcount(byte[] key, double min, double max) {
        Response response = this.getResponse(BuilderFactory.LONG);
        response.set((Object)this.jedis.zcount(key, min, max));
        return response;
    }

    public Response<Double> zincrby(String key, double score, String member) {
        Response response = this.getResponse(BuilderFactory.DOUBLE);
        response.set((Object)this.jedis.zincrby(key, score, member));
        return response;
    }

    public Response<Double> zincrby(byte[] key, double score, byte[] member) {
        Response response = this.getResponse(BuilderFactory.DOUBLE);
        response.set((Object)this.jedis.zincrby(key, score, member));
        return response;
    }

    public Response<Long> zinterstore(String dstkey, String ... sets) {
        throw new UnsupportedOperationException();
    }

    public Response<Long> zinterstore(byte[] dstkey, byte[] ... sets) {
        throw new UnsupportedOperationException();
    }

    public Response<Long> zinterstore(String dstkey, ZParams params, String ... sets) {
        throw new UnsupportedOperationException();
    }

    public Response<Long> zinterstore(byte[] dstkey, ZParams params, byte[] ... sets) {
        throw new UnsupportedOperationException();
    }

    public Response<Set<String>> zrange(String key, int start, int end) {
        Response response = this.getResponse(BuilderFactory.STRING_SET);
        response.set(this.jedis.zrange(key, (long)start, (long)end));
        return response;
    }

    public Response<Set<String>> zrange(byte[] key, int start, int end) {
        Response response = this.getResponse(BuilderFactory.STRING_SET);
        response.set(this.jedis.zrange(key, (long)start, (long)end));
        return response;
    }

    public Response<Set<String>> zrangeByScore(String key, double min, double max) {
        Response response = this.getResponse(BuilderFactory.STRING_SET);
        response.set(this.jedis.zrangeByScore(key, min, max));
        return response;
    }

    public Response<Set<byte[]>> zrangeByScore(byte[] key, double min, double max) {
        Response response = this.getResponse(BuilderFactory.BYTE_ARRAY_ZSET);
        response.set(this.jedis.zrangeByScore(key, min, max));
        return response;
    }

    public Response<Set<String>> zrangeByScore(String key, String min, String max) {
        Response response = this.getResponse(BuilderFactory.STRING_SET);
        response.set(this.jedis.zrangeByScore(key, min, max));
        return response;
    }

    public Response<Set<byte[]>> zrangeByScore(byte[] key, byte[] min, byte[] max) {
        Response response = this.getResponse(BuilderFactory.BYTE_ARRAY_ZSET);
        response.set(this.jedis.zrangeByScore(key, min, max));
        return response;
    }

    public Response<Set<String>> zrangeByScore(String key, double min, double max, int offset, int count) {
        Response response = this.getResponse(BuilderFactory.STRING_SET);
        response.set(this.jedis.zrangeByScore(key, min, max, offset, count));
        return response;
    }

    public Response<Set<byte[]>> zrangeByScore(byte[] key, double min, double max, int offset, int count) {
        Response response = this.getResponse(BuilderFactory.BYTE_ARRAY_ZSET);
        response.set(this.jedis.zrangeByScore(key, min, max, offset, count));
        return response;
    }

    public Response<Set<byte[]>> zrangeByScore(byte[] key, byte[] min, byte[] max, int offset, int count) {
        Response response = this.getResponse(BuilderFactory.BYTE_ARRAY_ZSET);
        response.set(this.jedis.zrangeByScore(key, min, max, offset, count));
        return response;
    }

    public Response<Set<Tuple>> zrangeByScoreWithScores(String key, double min, double max) {
        Response response = this.getResponse(BuilderFactory.TUPLE_ZSET);
        response.set(this.jedis.zrangeByScoreWithScores(key, min, max));
        return response;
    }

    public Response<Set<Tuple>> zrangeByScoreWithScores(byte[] key, double min, double max) {
        Response response = this.getResponse(BuilderFactory.TUPLE_ZSET);
        response.set(this.jedis.zrangeByScoreWithScores(key, min, max));
        return response;
    }

    public Response<Set<Tuple>> zrangeByScoreWithScores(byte[] key, byte[] min, byte[] max) {
        Response response = this.getResponse(BuilderFactory.TUPLE_ZSET);
        response.set(this.jedis.zrangeByScoreWithScores(key, min, max));
        return response;
    }

    public Response<Set<Tuple>> zrangeByScoreWithScores(String key, double min, double max, int offset, int count) {
        Response response = this.getResponse(BuilderFactory.TUPLE_ZSET);
        response.set(this.jedis.zrangeByScoreWithScores(key, min, max, offset, count));
        return response;
    }

    public Response<Set<Tuple>> zrangeByScoreWithScores(byte[] key, double min, double max, int offset, int count) {
        Response response = this.getResponse(BuilderFactory.TUPLE_ZSET);
        response.set(this.jedis.zrangeByScoreWithScores(key, min, max, offset, count));
        return response;
    }

    public Response<Set<Tuple>> zrangeByScoreWithScores(byte[] key, byte[] min, byte[] max, int offset, int count) {
        Response response = this.getResponse(BuilderFactory.TUPLE_ZSET);
        response.set(this.jedis.zrangeByScoreWithScores(key, min, max, offset, count));
        return response;
    }

    public Response<Set<String>> zrevrangeByScore(String key, double max, double min) {
        Response response = this.getResponse(BuilderFactory.STRING_SET);
        response.set(this.jedis.zrevrange(key, (long)max, (long)min));
        return response;
    }

    public Response<Set<byte[]>> zrevrangeByScore(byte[] key, double max, double min) {
        Response response = this.getResponse(BuilderFactory.BYTE_ARRAY_ZSET);
        response.set(this.jedis.zrevrange(key, (long)((int)max), (long)((int)min)));
        return response;
    }

    public Response<Set<String>> zrevrangeByScore(String key, String max, String min) {
        throw new UnsupportedOperationException();
    }

    public Response<Set<byte[]>> zrevrangeByScore(byte[] key, byte[] max, byte[] min) {
        throw new UnsupportedOperationException();
    }

    public Response<Set<String>> zrevrangeByScore(String key, double max, double min, int offset, int count) {
        throw new UnsupportedOperationException();
    }

    public Response<Set<byte[]>> zrevrangeByScore(byte[] key, double max, double min, int offset, int count) {
        throw new UnsupportedOperationException();
    }

    public Response<Set<byte[]>> zrevrangeByScore(byte[] key, byte[] max, byte[] min, int offset, int count) {
        throw new UnsupportedOperationException();
    }

    public Response<Set<Tuple>> zrevrangeByScoreWithScores(String key, double max, double min) {
        Response response = this.getResponse(BuilderFactory.TUPLE_ZSET);
        response.set(this.jedis.zrevrangeByScoreWithScores(key, max, min));
        return response;
    }

    public Response<Set<Tuple>> zrevrangeByScoreWithScores(byte[] key, double max, double min) {
        Response response = this.getResponse(BuilderFactory.TUPLE_ZSET);
        response.set(this.jedis.zrevrangeByScoreWithScores(key, max, min));
        return response;
    }

    public Response<Set<Tuple>> zrevrangeByScoreWithScores(byte[] key, byte[] max, byte[] min) {
        Response response = this.getResponse(BuilderFactory.TUPLE_ZSET);
        response.set(this.jedis.zrevrangeByScoreWithScores(key, max, min));
        return response;
    }

    public Response<Set<Tuple>> zrevrangeByScoreWithScores(String key, double max, double min, int offset, int count) {
        Response response = this.getResponse(BuilderFactory.TUPLE_ZSET);
        response.set(this.jedis.zrevrangeByScoreWithScores(key, max, min, offset, count));
        return response;
    }

    public Response<Set<Tuple>> zrevrangeByScoreWithScores(byte[] key, double max, double min, int offset, int count) {
        Response response = this.getResponse(BuilderFactory.TUPLE_ZSET);
        response.set(this.jedis.zrevrangeByScoreWithScores(key, max, min, offset, count));
        return response;
    }

    public Response<Set<Tuple>> zrevrangeByScoreWithScores(byte[] key, byte[] max, byte[] min, int offset, int count) {
        Response response = this.getResponse(BuilderFactory.TUPLE_ZSET);
        response.set(this.jedis.zrevrangeByScoreWithScores(key, max, min, offset, count));
        return response;
    }

    public Response<Set<Tuple>> zrangeWithScores(String key, int start, int end) {
        Response response = this.getResponse(BuilderFactory.TUPLE_ZSET);
        response.set(this.jedis.zrangeWithScores(key, (long)start, (long)end));
        return response;
    }

    public Response<Set<Tuple>> zrangeWithScores(byte[] key, int start, int end) {
        Response response = this.getResponse(BuilderFactory.TUPLE_ZSET);
        response.set(this.jedis.zrangeWithScores(key, (long)start, (long)end));
        return response;
    }

    public Response<Long> zrank(String key, String member) {
        Response response = this.getResponse(BuilderFactory.LONG);
        response.set((Object)this.jedis.zrank(key, member));
        return response;
    }

    public Response<Long> zrank(byte[] key, byte[] member) {
        Response response = this.getResponse(BuilderFactory.LONG);
        response.set((Object)this.jedis.zrank(key, member));
        return response;
    }

    public Response<Long> zrem(String key, String member) {
        Response response = this.getResponse(BuilderFactory.LONG);
        response.set((Object)this.jedis.zrem(key, member));
        return response;
    }

    public Response<Long> zrem(byte[] key, byte[] member) {
        Response response = this.getResponse(BuilderFactory.LONG);
        response.set((Object)this.jedis.zrem(key, new byte[][]{member}));
        return response;
    }

    public Response<Long> zremrangeByRank(String key, int start, int end) {
        Response response = this.getResponse(BuilderFactory.LONG);
        response.set((Object)this.jedis.zremrangeByRank(key, (long)start, (long)end));
        return response;
    }

    public Response<Long> zremrangeByRank(byte[] key, int start, int end) {
        Response response = this.getResponse(BuilderFactory.LONG);
        response.set((Object)this.jedis.zremrangeByRank(key, (long)start, (long)end));
        return response;
    }

    public Response<Long> zremrangeByScore(String key, double start, double end) {
        Response response = this.getResponse(BuilderFactory.LONG);
        response.set((Object)this.jedis.zremrangeByScore(key, start, end));
        return response;
    }

    public Response<Long> zremrangeByScore(byte[] key, double start, double end) {
        Response response = this.getResponse(BuilderFactory.LONG);
        response.set((Object)this.jedis.zremrangeByScore(key, start, end));
        return response;
    }

    public Response<Long> zremrangeByScore(byte[] key, byte[] start, byte[] end) {
        Response response = this.getResponse(BuilderFactory.LONG);
        response.set((Object)this.jedis.zremrangeByScore(key, start, end));
        return response;
    }

    public Response<Set<String>> zrevrange(String key, int start, int end) {
        Response response = this.getResponse(BuilderFactory.STRING_SET);
        response.set(this.jedis.zrevrange(key, (long)start, (long)end));
        return response;
    }

    public Response<Set<String>> zrevrange(byte[] key, int start, int end) {
        Response response = this.getResponse(BuilderFactory.STRING_SET);
        response.set(this.jedis.zrevrange(key, (long)start, (long)end));
        return response;
    }

    public Response<Set<Tuple>> zrevrangeWithScores(String key, int start, int end) {
        Response response = this.getResponse(BuilderFactory.TUPLE_ZSET);
        response.set(this.jedis.zrevrangeWithScores(key, (long)start, (long)end));
        return response;
    }

    public Response<Set<Tuple>> zrevrangeWithScores(byte[] key, int start, int end) {
        Response response = this.getResponse(BuilderFactory.TUPLE_ZSET);
        response.set(this.jedis.zrevrangeWithScores(key, (long)start, (long)end));
        return response;
    }

    public Response<Long> zrevrank(String key, String member) {
        Response response = this.getResponse(BuilderFactory.LONG);
        response.set((Object)this.jedis.zrevrank(key, member));
        return response;
    }

    public Response<Long> zrevrank(byte[] key, byte[] member) {
        Response response = this.getResponse(BuilderFactory.LONG);
        response.set((Object)this.jedis.zrevrank(key, member));
        return response;
    }

    public Response<Double> zscore(String key, String member) {
        Response response = this.getResponse(BuilderFactory.DOUBLE);
        response.set((Object)this.jedis.zscore(key, member));
        return response;
    }

    public Response<Double> zscore(byte[] key, byte[] member) {
        Response response = this.getResponse(BuilderFactory.DOUBLE);
        response.set((Object)this.jedis.zscore(key, member));
        return response;
    }

    public Response<Long> zunionstore(String dstkey, String ... sets) {
        throw new UnsupportedOperationException();
    }

    public Response<Long> zunionstore(byte[] dstkey, byte[] ... sets) {
        throw new UnsupportedOperationException();
    }

    public Response<Long> zunionstore(String dstkey, ZParams params, String ... sets) {
        throw new UnsupportedOperationException();
    }

    public Response<Long> zunionstore(byte[] dstkey, ZParams params, byte[] ... sets) {
        throw new UnsupportedOperationException();
    }

    public Response<String> bgrewriteaof() {
        Response response = this.getResponse(BuilderFactory.STRING);
        response.set((Object)this.jedis.bgrewriteaof());
        return response;
    }

    public Response<String> bgsave() {
        Response response = this.getResponse(BuilderFactory.STRING);
        response.set((Object)this.jedis.bgsave());
        return response;
    }

    public Response<String> configGet(String pattern) {
        Response response = this.getResponse(BuilderFactory.STRING);
        response.set(this.jedis.configGet(pattern));
        return response;
    }

    public Response<String> configSet(String parameter, String value) {
        Response response = this.getResponse(BuilderFactory.STRING);
        response.set((Object)this.jedis.configSet(parameter, value));
        return response;
    }

    public Response<String> brpoplpush(String source, String destination, int timeout) {
        throw new UnsupportedOperationException();
    }

    public Response<byte[]> brpoplpush(byte[] source, byte[] destination, int timeout) {
        throw new UnsupportedOperationException();
    }

    public Response<String> configResetStat() {
        Response response = this.getResponse(BuilderFactory.STRING);
        response.set((Object)this.jedis.configResetStat());
        return response;
    }

    public Response<String> save() {
        Response response = this.getResponse(BuilderFactory.STRING);
        response.set((Object)this.jedis.save());
        return response;
    }

    public Response<Long> lastsave() {
        Response response = this.getResponse(BuilderFactory.LONG);
        response.set((Object)this.jedis.lastsave());
        return response;
    }

    public Response<String> discard() {
        throw new UnsupportedOperationException();
    }

    public Response<List<Object>> exec() {
        Response response = super.getResponse((Builder)this.currentMulti);
        this.currentMulti = null;
        return response;
    }

    public Response<String> multi() {
        Response response = this.getResponse(BuilderFactory.STRING);
        this.currentMulti = new MultiResponseBuilder();
        return response;
    }

    public Response<Long> publish(String channel, String message) {
        Response response = this.getResponse(BuilderFactory.LONG);
        response.set((Object)this.jedis.publish(channel, message));
        return response;
    }

    public Response<Long> publish(byte[] channel, byte[] message) {
        Response response = this.getResponse(BuilderFactory.LONG);
        response.set((Object)this.jedis.publish(channel, message));
        return response;
    }

    public Response<String> flushDB() {
        Response response = this.getResponse(BuilderFactory.STRING);
        response.set((Object)this.jedis.flushDB());
        return response;
    }

    public Response<String> flushAll() {
        Response response = this.getResponse(BuilderFactory.STRING);
        response.set((Object)this.jedis.flushAll());
        return response;
    }

    public Response<String> info() {
        Response response = this.getResponse(BuilderFactory.STRING);
        response.set((Object)this.jedis.info());
        return response;
    }

    public Response<Long> dbSize() {
        Response response = this.getResponse(BuilderFactory.LONG);
        response.set((Object)this.jedis.dbSize());
        return response;
    }

    public Response<String> shutdown() {
        Response response = this.getResponse(BuilderFactory.STRING);
        response.set((Object)this.jedis.shutdown());
        return response;
    }

    public Response<String> ping() {
        Response response = this.getResponse(BuilderFactory.STRING);
        response.set((Object)this.jedis.ping());
        return response;
    }

    public Response<String> randomKey() {
        throw new UnsupportedOperationException();
    }

    public Response<String> select(int index) {
        Response response = this.getResponse(BuilderFactory.STRING);
        response.set((Object)this.jedis.select(index));
        return response;
    }

    public void sync() {
    }

    public List<Object> syncAndReturnAll() {
        return Collections.EMPTY_LIST;
    }

    protected <T> Response<T> getResponse(Builder<T> builder) {
        if (this.currentMulti != null) {
            super.getResponse(BuilderFactory.STRING);
            Response lr = new Response(builder);
            this.currentMulti.addResponse(lr);
            return lr;
        }
        return super.getResponse(builder);
    }

    private class MultiResponseBuilder
    extends Builder<List<Object>> {
        private final List<Response<?>> responses = new ArrayList();

        private MultiResponseBuilder() {
        }

        public List<Object> build(Object data) {
            List list = (List)data;
            ArrayList<Object> values = new ArrayList<Object>();
            if (list.size() != this.responses.size()) {
                throw new JedisDataException("Expected data size " + this.responses.size() + " but was " + list.size());
            }
            int i = 0;
            while (i < list.size()) {
                Response<?> response = this.responses.get(i);
                response.set(list.get(i));
                values.add(response.get());
                ++i;
            }
            return values;
        }

        public void addResponse(Response<?> response) {
            this.responses.add(response);
        }
    }
}

