/*
 * Decompiled with CFR 0.152.
 */
package com.lordofthejars.nosqlunit.redis.embedded;

import ch.lambdaj.Lambda;
import ch.lambdaj.function.convert.Converter;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.lordofthejars.nosqlunit.redis.embedded.ByteArrayIncrement;
import com.lordofthejars.nosqlunit.redis.embedded.ByteBuffer2ByteArrayConverter;
import com.lordofthejars.nosqlunit.redis.embedded.ExpirationDatatypeOperations;
import com.lordofthejars.nosqlunit.redis.embedded.RedisDatatypeOperations;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import redis.clients.util.JedisByteHashMap;

public class HashDatatypeOperations
extends ExpirationDatatypeOperations
implements RedisDatatypeOperations {
    protected static final String HASH = "hash";
    protected Table<ByteBuffer, ByteBuffer, ByteBuffer> hashElements = HashBasedTable.create();

    public Long hset(byte[] key, byte[] field, byte[] value) {
        long result = 0L;
        if (this.hashElements.put((Object)ByteBuffer.wrap(key), (Object)ByteBuffer.wrap(field), (Object)ByteBuffer.wrap(value)) == null) {
            result = 1L;
        }
        return result;
    }

    public byte[] hget(byte[] key, byte[] field) {
        ByteBuffer result = (ByteBuffer)this.hashElements.get((Object)ByteBuffer.wrap(key), (Object)ByteBuffer.wrap(field));
        return this.arrayValueOrNull(result);
    }

    public Long hdel(byte[] key, byte[] ... fields) {
        long numberOfRemovedFields = 0L;
        for (byte[] field : fields) {
            if (this.hashElements.remove((Object)ByteBuffer.wrap(key), (Object)ByteBuffer.wrap(field)) == null) continue;
            ++numberOfRemovedFields;
        }
        return numberOfRemovedFields;
    }

    public Boolean hexists(byte[] key, byte[] field) {
        return this.hashElements.contains((Object)ByteBuffer.wrap(key), (Object)ByteBuffer.wrap(field));
    }

    public Map<byte[], byte[]> hgetAll(byte[] key) {
        Map row = this.hashElements.row((Object)ByteBuffer.wrap(key));
        return this.transformMapToByteArray(row);
    }

    public Long hincrBy(byte[] key, byte[] field, long value) {
        byte[] elementToUpdate = this.hget(key, field);
        if (elementToUpdate != null) {
            return this.incrementAndSetValue(key, field, value, elementToUpdate);
        }
        return this.setLongValue(key, field, value);
    }

    public Set<byte[]> hkeys(byte[] key) {
        Set<ByteBuffer> columnKeySet = this.getAllFieldsNameByKey(key);
        return new HashSet<byte[]>(Lambda.convert(columnKeySet, (Converter)ByteBuffer2ByteArrayConverter.createByteBufferConverter()));
    }

    public Long hlen(byte[] key) {
        return this.getAllFieldsNameByKey(key).size();
    }

    public List<byte[]> hmget(byte[] key, byte[] ... fields) {
        ArrayList<byte[]> fieldsValues = new ArrayList<byte[]>();
        for (byte[] field : fields) {
            fieldsValues.add(this.hget(key, field));
        }
        return fieldsValues;
    }

    public String hmset(byte[] key, Map<byte[], byte[]> hash) {
        Set<Map.Entry<byte[], byte[]>> fields = hash.entrySet();
        for (Map.Entry<byte[], byte[]> entry : fields) {
            this.hset(key, entry.getKey(), entry.getValue());
        }
        return "OK";
    }

    public Long hsetnx(byte[] key, byte[] field, byte[] value) {
        if (this.hexists(key, field).booleanValue()) {
            return 0L;
        }
        return this.hset(key, field, value);
    }

    public List<byte[]> hvals(byte[] key) {
        return new ArrayList<byte[]>(Lambda.convert(this.getAllFieldsValueByKey(key), (Converter)ByteBuffer2ByteArrayConverter.createByteBufferConverter()));
    }

    @Override
    public long getNumberOfKeys() {
        return this.hashElements.rowKeySet().size();
    }

    @Override
    public void flushAllKeys() {
        this.removeExpirations();
        this.hashElements.clear();
    }

    private void removeExpirations() {
        List<byte[]> keys = this.keys();
        for (byte[] key : keys) {
            this.removeExpiration(key);
        }
    }

    private Long setLongValue(byte[] key, byte[] field, long value) {
        try {
            this.hset(key, field, Long.toString(value).getBytes("UTF-8"));
            return value;
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedOperationException("ERR hash value is not an integer");
        }
    }

    private Long incrementAndSetValue(byte[] key, byte[] field, long value, byte[] elementToUpdate) {
        try {
            long longValue = ByteArrayIncrement.incrementValue(value, elementToUpdate);
            this.hset(key, field, Long.toString(longValue).getBytes("UTF-8"));
            return longValue;
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedOperationException("ERR value is not an integer");
        }
        catch (NumberFormatException e) {
            throw new UnsupportedOperationException("ERR value is not an integer");
        }
    }

    private Map<byte[], byte[]> transformMapToByteArray(Map<ByteBuffer, ByteBuffer> row) {
        Set<Map.Entry<ByteBuffer, ByteBuffer>> entrySet = row.entrySet();
        JedisByteHashMap hash = new JedisByteHashMap();
        for (Map.Entry<ByteBuffer, ByteBuffer> entry : entrySet) {
            hash.put(entry.getKey().array(), this.arrayValueOrNull(entry.getValue()));
        }
        return hash;
    }

    private byte[] arrayValueOrNull(ByteBuffer byteBuffer) {
        return byteBuffer == null ? null : byteBuffer.array();
    }

    private Collection<ByteBuffer> getAllFieldsValueByKey(byte[] key) {
        Map row = this.hashElements.row((Object)ByteBuffer.wrap(key));
        Collection<ByteBuffer> columnValueCollection = row.values();
        return columnValueCollection;
    }

    private Set<ByteBuffer> getAllFieldsNameByKey(byte[] key) {
        Map row = this.hashElements.row((Object)ByteBuffer.wrap(key));
        Set<ByteBuffer> columnKeySet = row.keySet();
        return columnKeySet;
    }

    @Override
    public String type() {
        return HASH;
    }

    @Override
    public List<byte[]> keys() {
        return new ArrayList<byte[]>(Lambda.convert((Object)this.hashElements.rowKeySet(), (Converter)ByteBuffer2ByteArrayConverter.createByteBufferConverter()));
    }

    @Override
    public Long del(byte[] ... keys) {
        long numberOfRemovedElements = 0L;
        for (byte[] key : keys) {
            ByteBuffer wrappedKey = ByteBuffer.wrap(key);
            if (!this.hashElements.containsRow((Object)wrappedKey)) continue;
            this.deleteAllFields(wrappedKey);
            this.removeExpiration(key);
            ++numberOfRemovedElements;
        }
        return numberOfRemovedElements;
    }

    private void deleteAllFields(ByteBuffer key) {
        Map fields = this.hashElements.row((Object)key);
        Set columns = fields.keySet();
        Iterator iterator = columns.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
    }

    @Override
    public boolean exists(byte[] key) {
        ByteBuffer rowKey = ByteBuffer.wrap(key);
        return this.hashElements.containsRow((Object)rowKey);
    }

    @Override
    public boolean renameKey(byte[] key, byte[] newKey) {
        ByteBuffer wrappedKey = ByteBuffer.wrap(key);
        if (this.hashElements.containsRow((Object)wrappedKey)) {
            Map row = this.hashElements.row((Object)wrappedKey);
            this.deleteAllFields(ByteBuffer.wrap(newKey));
            Set entries = row.entrySet();
            for (Map.Entry entry : entries) {
                this.hashElements.put((Object)ByteBuffer.wrap(newKey), entry.getKey(), entry.getValue());
            }
            this.deleteAllFields(wrappedKey);
            this.renameTtlKey(key, newKey);
            return true;
        }
        return false;
    }

    @Override
    public List<byte[]> sort(byte[] key) {
        throw new UnsupportedOperationException();
    }
}

