/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.annotations.repository;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.net.URI;
import java.util.List;
import javax.inject.Inject;
import org.h2.util.IOUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.test.CoreFeature;
import org.nuxeo.ecm.platform.annotations.api.Annotation;
import org.nuxeo.ecm.platform.annotations.api.AnnotationManager;
import org.nuxeo.ecm.platform.annotations.api.AnnotationsService;
import org.nuxeo.ecm.platform.annotations.repository.service.AnnotationFeature;
import org.nuxeo.ecm.platform.url.DocumentViewImpl;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.ecm.platform.url.api.DocumentViewCodecManager;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.transaction.TransactionHelper;

@RunWith(value=FeaturesRunner.class)
@Features(value={AnnotationFeature.class})
public abstract class AbstractRepositoryTestCase {
    protected final AnnotationManager manager = new AnnotationManager();
    protected URI uri;
    protected Annotation annotation;
    @Inject
    protected CoreFeature coreFeature;
    @Inject
    protected AnnotationsService service;
    @Inject
    protected DocumentViewCodecManager viewCodecManager;
    @Inject
    protected CoreSession session;
    @Inject
    protected EventService eventService;

    @Before
    public void setUp() throws Exception {
        Assert.assertNotNull((Object)this.viewCodecManager);
        Assert.assertNotNull((Object)this.manager);
        InputStream is = this.getClass().getResourceAsStream("/annotea-spec-post.xml");
        Assert.assertNotNull((Object)is);
        this.annotation = this.manager.getAnnotation(is);
    }

    protected void setUpRepository() throws Exception {
        this.uri = this.setUpRepository(this.session);
    }

    protected URI setUpRepository(CoreSession session) throws Exception {
        DocumentModel doc;
        PathRef rootRef = new PathRef("/");
        String file1Name = "1";
        if (session.hasChild((DocumentRef)rootRef, file1Name)) {
            doc = session.getChild((DocumentRef)rootRef, file1Name);
        } else {
            Assert.assertNotNull((Object)session);
            DocumentModel root = session.getRootDocument();
            Assert.assertNotNull((Object)root);
            DocumentModel model = session.createDocumentModel(root.getPathAsString(), file1Name, "File");
            DocumentModel sectionModel = session.createDocumentModel(root.getPathAsString(), "2", "Section");
            Assert.assertNotNull((Object)sectionModel);
            DocumentModel section = session.createDocument(sectionModel);
            Assert.assertNotNull((Object)section);
            DocumentModel section1Model = session.createDocumentModel(section.getPathAsString(), "3", "Folder");
            DocumentModel section1 = session.createDocument(section1Model);
            Assert.assertNotNull((Object)section1);
            DocumentModel section2Model = session.createDocumentModel(section.getPathAsString(), "3", "Folder");
            DocumentModel section2 = session.createDocument(section2Model);
            Assert.assertNotNull((Object)section2);
            DocumentModel section3Model = session.createDocumentModel(section.getPathAsString(), "3", "Folder");
            DocumentModel section3 = session.createDocument(section3Model);
            Assert.assertNotNull((Object)section3);
            doc = session.createDocument(model);
            Assert.assertNotNull((Object)doc);
            doc.setPropertyValue("dc:description", null);
            session.saveDocument(doc);
            session.publishDocument(doc, section1);
            doc.setPropertyValue("dc:description", (Serializable)((Object)""));
            session.saveDocument(doc);
            session.publishDocument(doc, section2);
            doc.setPropertyValue("dc:description", null);
            session.saveDocument(doc);
            session.publishDocument(doc, section3);
            session.save();
            List l = session.getVersions(doc.getRef());
            Assert.assertFalse((boolean)doc.isVersion());
            Assert.assertEquals((long)3L, (long)l.size());
            DocumentModelList proxies = session.getProxies(doc.getRef(), null);
            Assert.assertNotNull((Object)proxies);
            Assert.assertEquals((long)3L, (long)proxies.size());
        }
        String url = this.viewCodecManager.getUrlFromDocumentView((DocumentView)new DocumentViewImpl(doc), true, "http://localhost/nuxeo/");
        Assert.assertNotNull((Object)url);
        URI uri = new URI(url);
        this.nextTransaction();
        return uri;
    }

    protected Annotation getAnnotation(String url, int x) throws IOException {
        InputStream is = this.getClass().getResourceAsStream("/annotation" + x + ".xml");
        String template = IOUtils.readStringAndClose((Reader)new InputStreamReader(is), (int)-1);
        template = template.replaceAll("docUrl", url);
        is = new ByteArrayInputStream(template.getBytes("UTF-8"));
        return this.manager.getAnnotation(is);
    }

    protected void sleepForFulltext() {
        this.coreFeature.getStorageConfiguration().sleepForFulltext();
    }

    protected void nextTransaction() {
        TransactionHelper.commitOrRollbackTransaction();
        this.eventService.waitForAsyncCompletion();
        TransactionHelper.startTransaction();
    }
}

