/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.annotations.repository;

import java.net.URI;
import java.net.URISyntaxException;
import java.security.Principal;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.impl.DocumentLocationImpl;
import org.nuxeo.ecm.platform.annotations.repository.AbstractRepositoryTestCase;
import org.nuxeo.ecm.platform.annotations.repository.DefaultNuxeoUriResolver;
import org.nuxeo.ecm.platform.url.DocumentViewImpl;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.runtime.test.runner.LocalDeploy;

@LocalDeploy(value={"org.nuxeo.ecm.platform.repository.test:OSGI-INF/other-repo.xml"})
public class DefaultNuxeoUriResolverTest
extends AbstractRepositoryTestCase {
    private DefaultNuxeoUriResolver resolver;
    private CoreSession secondSession;
    private URI uriSecondRepo;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.setUpRepository();
        this.resolver = new DefaultNuxeoUriResolver();
        this.secondSession = CoreInstance.openCoreSession((String)"second", (Principal)this.session.getPrincipal());
        this.uriSecondRepo = this.setUpRepository(this.secondSession);
    }

    @After
    public void tearDown() {
        this.secondSession.close();
    }

    @Test
    public void testGetDocumentRefWithURI() {
        this.testGetDocumentRef(this.uri);
    }

    @Test
    public void testGetDocumentRefWithURN() {
        this.testGetDocumentRef(this.toURN(this.uri));
    }

    @Test
    public void testGetDocumentRefWithURIAndSecondRepo() {
        this.testGetDocumentRef(this.uriSecondRepo);
    }

    @Test
    public void testGetDocumentRefWithURNAndSecondRepo() {
        this.testGetDocumentRef(this.toURN(this.uriSecondRepo));
    }

    private void testGetDocumentRef(URI uri) {
        Assert.assertNotNull((Object)uri);
        DocumentRef ref = this.resolver.getDocumentRef(uri);
        Assert.assertNotNull((Object)ref);
        if (ref instanceof IdRef) {
            String uriString = uri.toString();
            int separator = uriString.startsWith("urn:") ? 58 : 47;
            Assert.assertEquals((Object)uriString.substring(uriString.lastIndexOf(separator) + 1), (Object)ref.reference());
        } else if (ref instanceof PathRef) {
            Assert.assertEquals((Object)"/1", (Object)ref.reference());
        }
    }

    @Test
    public void testTranslateToGraphURI() {
        this.testTranslateToGraphURI(this.uri);
    }

    @Test
    public void testTranslateToGraphURIWithSecondRepo() {
        this.testTranslateToGraphURI(this.uriSecondRepo);
    }

    private void testTranslateToGraphURI(URI uri) {
        Assert.assertNotNull((Object)uri);
        URI graphUri = this.resolver.translateToGraphURI(uri);
        this.assertGraphURI(uri, graphUri);
    }

    @Test
    public void testGetGraphURIFromDocumentView() {
        this.testGetGraphURIFromDocumentView(this.session, this.uri);
    }

    @Test
    public void testGetGraphURIFromDocumentViewWithSecondRepo() {
        this.testGetGraphURIFromDocumentView(this.secondSession, this.uriSecondRepo);
    }

    private void testGetGraphURIFromDocumentView(CoreSession session, URI uri) {
        Assert.assertNotNull((Object)uri);
        PathRef pathRef = new PathRef("/1");
        DocumentViewImpl docView = new DocumentViewImpl((DocumentLocation)new DocumentLocationImpl(session.getRepositoryName(), (DocumentRef)pathRef));
        URI graphUri = this.resolver.getGraphURIFromDocumentView((DocumentView)docView);
        this.assertGraphURI(uri, graphUri);
    }

    private void assertGraphURI(URI uri, URI graphUri) {
        Assert.assertNotNull((Object)graphUri);
        String[] uriSegments = uri.toString().split("/");
        int nbSegments = uriSegments.length;
        String ws = uriSegments[nbSegments - 2];
        String docId = uriSegments[nbSegments - 1];
        Assert.assertEquals((Object)String.format("urn:nuxeo:%s:%s", ws, docId), (Object)graphUri.toString());
    }

    private URI toURN(URI uri) {
        try {
            return new URI(this.toStringURN(uri));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private String toStringURN(URI uri) {
        String[] uriSegments = uri.toString().split("/");
        int nbSegments = uriSegments.length;
        String ws = uriSegments[nbSegments - 2];
        String docId = uriSegments[nbSegments - 1];
        return String.format("urn:nuxeo:%s:%s", ws, docId);
    }
}

