/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.annotations.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.impl.UserPrincipal;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.platform.annotations.api.Annotation;
import org.nuxeo.ecm.platform.annotations.repository.AbstractRepositoryTestCase;
import org.nuxeo.ecm.platform.annotations.service.DummyDocumentEventListener;
import org.nuxeo.ecm.platform.relations.api.Node;
import org.nuxeo.ecm.platform.relations.api.Statement;
import org.nuxeo.ecm.platform.relations.api.impl.LiteralImpl;
import org.nuxeo.ecm.platform.relations.api.impl.ResourceImpl;
import org.nuxeo.ecm.platform.relations.api.impl.StatementImpl;

public class AnnotatedEventListenerTest
extends AbstractRepositoryTestCase {
    private static final String HTTP_LOCALHOST_8080_NUXEO = "http://localhost:8080/nuxeo";
    @Inject
    protected EventService eventService;

    @Test
    public void testEventLister() throws Exception {
        DummyDocumentEventListener.resetTest();
        Assert.assertNotNull((Object)this.annotation);
        UserPrincipal user = new UserPrincipal("bob", new ArrayList(), false, false);
        Annotation createdAnnotation = this.service.addAnnotation(this.annotation, (NuxeoPrincipal)user, HTTP_LOCALHOST_8080_NUXEO);
        Assert.assertNotNull((Object)createdAnnotation);
        Set<String> set = DummyDocumentEventListener.getTest();
        Assert.assertEquals(new HashSet<String>(Arrays.asList("bc", "ac")), set);
        DummyDocumentEventListener.resetTest();
        StatementImpl statement = new StatementImpl((Node)createdAnnotation.getSubject(), (Node)new ResourceImpl("http://www.w3.org/2000/10/annotation-ns#body"), (Node)new LiteralImpl("My new body"));
        createdAnnotation.setBody((Statement)statement);
        this.service.updateAnnotation(createdAnnotation, (NuxeoPrincipal)user, HTTP_LOCALHOST_8080_NUXEO);
        set = DummyDocumentEventListener.getTest();
        Assert.assertEquals(new HashSet<String>(Arrays.asList("bu", "au")), set);
        this.nextTransaction();
        DummyDocumentEventListener.resetTest();
        createdAnnotation = this.service.getAnnotation(createdAnnotation.getId(), (NuxeoPrincipal)user, HTTP_LOCALHOST_8080_NUXEO);
        set = DummyDocumentEventListener.getTest();
        Assert.assertEquals(new HashSet<String>(Arrays.asList("br", "ar")), set);
        DummyDocumentEventListener.resetTest();
        this.service.deleteAnnotation(createdAnnotation, (NuxeoPrincipal)user);
        set = DummyDocumentEventListener.getTest();
        Assert.assertEquals(new HashSet<String>(Arrays.asList("bd", "ad")), set);
    }
}

