/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.cache;

import com.google.inject.Binder;
import com.google.inject.Provider;
import com.google.inject.name.Names;
import java.io.IOException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import org.junit.Assert;
import org.junit.Assume;
import org.nuxeo.ecm.core.cache.Cache;
import org.nuxeo.ecm.core.cache.CacheAttributesChecker;
import org.nuxeo.ecm.core.cache.CacheService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.RuntimeFeature;
import org.nuxeo.runtime.test.runner.SimpleFeature;

@Deploy(value={"org.nuxeo.ecm.core.cache"})
@Features(value={RuntimeFeature.class})
public class CacheFeature
extends SimpleFeature {
    public static final String DEFAULT_TEST_CACHE_NAME = "default-test-cache";
    public static final String KEY = "key1";
    public static final String VAL = "val1";
    boolean enabled = false;

    public void enable() {
        this.enabled = true;
    }

    public void start(FeaturesRunner runner) throws Exception {
        Assume.assumeTrue((boolean)this.enabled);
    }

    public void configure(FeaturesRunner runner, Binder binder) {
        this.bindCache(binder, DEFAULT_TEST_CACHE_NAME);
    }

    protected void bindCache(Binder binder, final String name) {
        binder.bind(Cache.class).annotatedWith((Annotation)Names.named((String)name)).toProvider((Provider)new Provider<Cache>(){

            public Cache get() {
                return ((CacheService)Framework.getService(CacheService.class)).getCache(name);
            }
        });
    }

    public void beforeSetup(FeaturesRunner runner) throws Exception {
        ((CacheService)Framework.getService(CacheService.class)).getCache(DEFAULT_TEST_CACHE_NAME).put(KEY, (Serializable)((Object)VAL));
    }

    public void afterTeardown(FeaturesRunner runner) throws IOException {
        this.clearCache(DEFAULT_TEST_CACHE_NAME);
    }

    protected void clearCache(String name) {
        ((CacheService)Framework.getService(CacheService.class)).getCache(name).invalidateAll();
    }

    public static <T extends Cache> T unwrapImpl(Class<T> type, Cache cache) {
        if (!(cache instanceof CacheAttributesChecker)) {
            Assert.fail((String)("Not an attribute checker " + cache.getClass()));
        }
        if (!type.isAssignableFrom((cache = ((CacheAttributesChecker)cache).cache).getClass())) {
            Assert.fail((String)("Not of requested type  " + type));
        }
        return (T)((Cache)type.cast(cache));
    }
}

