/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.cache;

import java.io.IOException;
import java.io.Serializable;
import javax.inject.Inject;
import javax.inject.Named;
import junit.framework.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.core.cache.Cache;
import org.nuxeo.ecm.core.cache.CacheFeature;
import org.nuxeo.ecm.core.cache.InMemoryCacheFeature;
import org.nuxeo.ecm.core.cache.InMemoryCacheImpl;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;

@RunWith(value=FeaturesRunner.class)
@Features(value={CacheFeature.class, InMemoryCacheFeature.class})
public class TestInMemoryCacheService {
    @Inject
    @Named(value="default-test-cache")
    Cache defaultCache;
    @Inject
    @Named(value="maxsize-test-cache")
    Cache maxSizeCache;

    @Test
    public void getGuavaCache() {
        InMemoryCacheImpl guavaCache = CacheFeature.unwrapImpl(InMemoryCacheImpl.class, this.defaultCache);
        Assert.assertNotNull((Object)guavaCache);
    }

    @Test
    public void maxSizeZero() throws IOException {
        this.maxSizeCache.put("key", (Serializable)((Object)"val"));
        Assert.assertNull((Object)this.maxSizeCache.get("key"));
    }

    @Test
    public void maxSizeExceeded() throws IOException {
        this.defaultCache.put("key2", (Serializable)((Object)"val2"));
        this.defaultCache.put("key3", (Serializable)((Object)"val3"));
        this.defaultCache.put("key4", (Serializable)((Object)"val4"));
        this.defaultCache.put("key5", (Serializable)((Object)"val5"));
        Assert.assertNotNull((Object)this.defaultCache.get("key4"));
        Assert.assertNotNull((Object)this.defaultCache.get("key5"));
        Assert.assertNull((Object)this.defaultCache.get("key1"));
        Assert.assertNull((Object)this.defaultCache.get("key2"));
    }
}

