/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.transientstore.test;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.impl.EventContextImpl;
import org.nuxeo.ecm.core.transientstore.AbstractTransientStore;
import org.nuxeo.ecm.core.transientstore.SimpleTransientStore;
import org.nuxeo.ecm.core.transientstore.api.MaximumTransientSpaceExceeded;
import org.nuxeo.ecm.core.transientstore.api.TransientStore;
import org.nuxeo.ecm.core.transientstore.api.TransientStoreService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.transientstore.test.TransientStoreFeature;

@RunWith(value=FeaturesRunner.class)
@Features(value={TransientStoreFeature.class})
@Deploy(value={"org.nuxeo.ecm.core.event"})
public class TransientStorageComplianceFixture {
    @Test
    public void verifyServiceDeclared() throws Exception {
        TransientStoreService tss = (TransientStoreService)Framework.getService(TransientStoreService.class);
        Assert.assertNotNull((Object)tss);
        TransientStore ts = tss.getStore("testStore");
        Assert.assertNotNull((Object)ts);
        TransientStore ts2 = tss.getStore("microStore");
        Assert.assertNotNull((Object)ts2);
        TransientStore ts3 = tss.getStore("miniStore");
        Assert.assertNotNull((Object)ts3);
    }

    protected void putEntry(TransientStore ts, String id) {
        ts.putParameter(id, "A", (Serializable)((Object)String.valueOf(1)));
        ts.putParameter(id, "B", (Serializable)((Object)"b"));
        String content = "FakeContent";
        StringBlob blob = new StringBlob(content);
        blob.setFilename("fake.txt");
        blob.setMimeType("text/plain");
        blob.setDigest(DigestUtils.md5Hex((String)content));
        ts.putBlobs(id, Collections.singletonList(blob));
    }

    @Test
    public void verifyStorage() throws Exception {
        TransientStoreService tss = (TransientStoreService)Framework.getService(TransientStoreService.class);
        TransientStore ts = tss.getStore("testStore");
        long size = ((AbstractTransientStore)ts).getStorageSize();
        Assert.assertEquals((long)0L, (long)size);
        this.putEntry(ts, "1");
        File cacheDir = ((AbstractTransientStore)ts).getCachingDirectory("1");
        Assert.assertTrue((boolean)cacheDir.exists());
        File[] cacheEntries = cacheDir.listFiles();
        Assert.assertTrue((cacheEntries.length > 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)ts.exists("1"));
        Assert.assertFalse((boolean)ts.isCompleted("1"));
        Assert.assertEquals((long)1L, (long)ts.keySet().size());
        Assert.assertTrue((boolean)ts.keySet().contains("1"));
        Assert.assertEquals((long)11L, (long)ts.getSize("1"));
        Assert.assertEquals((Object)"1", (Object)ts.getParameter("1", "A"));
        Assert.assertEquals((Object)"b", (Object)ts.getParameter("1", "B"));
        List blobs = ts.getBlobs("1");
        Assert.assertEquals((long)1L, (long)blobs.size());
        Blob blob = (Blob)blobs.get(0);
        Assert.assertEquals((Object)"fake.txt", (Object)blob.getFilename());
        Assert.assertEquals((Object)"text/plain", (Object)blob.getMimeType());
        Assert.assertEquals((Object)DigestUtils.md5Hex((String)"FakeContent"), (Object)blob.getDigest());
        Assert.assertEquals((Object)"FakeContent", (Object)IOUtils.toString((InputStream)blob.getStream()));
        size = ((AbstractTransientStore)ts).getStorageSize();
        Assert.assertEquals((long)11L, (long)size);
        StringBlob otherBlob = new StringBlob("FakeContent2");
        otherBlob.setFilename("fake2.txt");
        otherBlob.setMimeType("text/plain");
        blobs.add(otherBlob);
        ts.putBlobs("1", blobs);
        Assert.assertTrue((boolean)ts.exists("1"));
        Assert.assertEquals((long)1L, (long)ts.keySet().size());
        Assert.assertTrue((boolean)ts.keySet().contains("1"));
        Assert.assertEquals((long)23L, (long)ts.getSize("1"));
        blobs = ts.getBlobs("1");
        Assert.assertEquals((long)2L, (long)blobs.size());
        Assert.assertEquals((Object)"fake.txt", (Object)((Blob)blobs.get(0)).getFilename());
        Assert.assertEquals((Object)"fake2.txt", (Object)((Blob)blobs.get(1)).getFilename());
        size = ((AbstractTransientStore)ts).getStorageSize();
        Assert.assertEquals((long)23L, (long)size);
        ts.release("1");
        Assert.assertTrue((boolean)ts.exists("1"));
        Assert.assertEquals((long)1L, (long)ts.keySet().size());
        Assert.assertTrue((boolean)ts.keySet().contains("1"));
        ts.remove("1");
        Assert.assertFalse((boolean)ts.exists("1"));
        Assert.assertEquals((long)0L, (long)ts.keySet().size());
        size = ((AbstractTransientStore)ts).getStorageSize();
        Assert.assertEquals((long)0L, (long)size);
    }

    @Test
    public void verifyNullCases() throws Exception {
        TransientStoreService tss = (TransientStoreService)Framework.getService(TransientStoreService.class);
        TransientStore ts = tss.getStore("testStore");
        Assert.assertFalse((boolean)ts.exists("fakeEntry"));
        Assert.assertNull((Object)ts.getParameters("fakeEntry"));
        Assert.assertNull((Object)ts.getParameter("fakeEntry", "fakeParameter"));
        Assert.assertNull((Object)ts.getBlobs("fakeEntry"));
        Assert.assertEquals((long)-1L, (long)ts.getSize("fakeEntry"));
        Assert.assertFalse((boolean)ts.isCompleted("fakeEntry"));
        ts.putParameter("testEntry", "param1", (Serializable)((Object)"value"));
        Assert.assertTrue((boolean)ts.exists("testEntry"));
        Map params = ts.getParameters("testEntry");
        Assert.assertNotNull((Object)params);
        Assert.assertEquals((long)1L, (long)params.size());
        Assert.assertNotNull((Object)ts.getParameter("testEntry", "param1"));
        Assert.assertNull((Object)ts.getParameter("testEntry", "param2"));
        List blobs = ts.getBlobs("testEntry");
        Assert.assertNotNull((Object)blobs);
        Assert.assertTrue((boolean)blobs.isEmpty());
        ts.putBlobs("otherEntry", Collections.singletonList(new StringBlob("joe")));
        Assert.assertTrue((boolean)ts.exists("otherEntry"));
        params = ts.getParameters("otherEntry");
        Assert.assertNotNull((Object)params);
        Assert.assertTrue((boolean)params.isEmpty());
        blobs = ts.getBlobs("otherEntry");
        Assert.assertNotNull((Object)blobs);
        Assert.assertEquals((long)1L, (long)blobs.size());
    }

    @Test(expected=MaximumTransientSpaceExceeded.class)
    public void verifyMaxSizeException() throws Exception {
        TransientStoreService tss = (TransientStoreService)Framework.getService(TransientStoreService.class);
        TransientStore ts = tss.getStore("microStore");
        this.putEntry(ts, "A");
    }

    @Test
    public void verifyDeleteAfterUse() throws Exception {
        TransientStoreService tss = (TransientStoreService)Framework.getService(TransientStoreService.class);
        TransientStore ts = tss.getStore("miniStore");
        this.putEntry(ts, "1");
        Assert.assertTrue((boolean)ts.exists("1"));
        Assert.assertEquals((Object)"1", (Object)ts.getParameter("1", "A"));
        Assert.assertEquals((Object)"b", (Object)ts.getParameter("1", "B"));
        List blobs = ts.getBlobs("1");
        Assert.assertEquals((long)1L, (long)blobs.size());
        Blob blob = (Blob)blobs.get(0);
        Assert.assertEquals((Object)"fake.txt", (Object)blob.getFilename());
        Assert.assertEquals((Object)"text/plain", (Object)blob.getMimeType());
        Assert.assertEquals((Object)"FakeContent", (Object)IOUtils.toString((InputStream)blob.getStream()));
        ts.release("1");
        Assert.assertFalse((boolean)ts.exists("1"));
    }

    @Test
    public void verifyDeleteOnGC() throws Exception {
        TransientStoreService tss = (TransientStoreService)Framework.getService(TransientStoreService.class);
        TransientStore ts = tss.getStore("testStore");
        this.putEntry(ts, "X");
        Assert.assertTrue((boolean)ts.exists("X"));
        File cacheDir = ((AbstractTransientStore)ts).getCachingDirectory("X");
        Assert.assertTrue((boolean)cacheDir.exists());
        File[] cacheEntries = cacheDir.listFiles();
        Assert.assertTrue((cacheEntries.length > 0 ? 1 : 0) != 0);
        ts.doGC();
        Assert.assertTrue((boolean)ts.exists("X"));
        cacheEntries = cacheDir.listFiles();
        Assert.assertTrue((cacheEntries.length > 0 ? 1 : 0) != 0);
        ts.remove("X");
        ts.doGC();
        Assert.assertFalse((boolean)ts.exists("X"));
        Assert.assertFalse((boolean)cacheDir.exists());
    }

    @Test
    public void verifyDeleteOnGCEvent() throws Exception {
        TransientStoreService tss = (TransientStoreService)Framework.getService(TransientStoreService.class);
        TransientStore ts = tss.getStore("testStore");
        this.putEntry(ts, "X");
        Assert.assertTrue((boolean)ts.exists("X"));
        File cacheDir = ((AbstractTransientStore)ts).getCachingDirectory("X");
        Assert.assertTrue((boolean)cacheDir.exists());
        File[] cacheEntries = cacheDir.listFiles();
        Assert.assertTrue((cacheEntries.length > 0 ? 1 : 0) != 0);
        ts.remove("X");
        EventContextImpl evtCtx = new EventContextImpl(new Object[0]);
        ((EventService)Framework.getService(EventService.class)).fireEvent("transientStoreGCStart", (EventContext)evtCtx);
        Thread.sleep(100L);
        ((EventService)Framework.getService(EventService.class)).waitForAsyncCompletion();
        Assert.assertFalse((boolean)ts.exists("X"));
        Assert.assertFalse((boolean)cacheDir.exists());
    }

    @Test
    public void verifyDeleteAfterUseGC() throws Exception {
        TransientStoreService tss = (TransientStoreService)Framework.getService(TransientStoreService.class);
        TransientStore ts = tss.getStore("testStore");
        this.putEntry(ts, "XXX");
        Assert.assertTrue((boolean)ts.exists("XXX"));
        if (ts instanceof SimpleTransientStore) {
            Assert.assertNotNull((Object)((SimpleTransientStore)ts).getL1Cache().get("XXX"));
        }
        ts.release("XXX");
        Assert.assertTrue((boolean)ts.exists("XXX"));
        if (ts instanceof SimpleTransientStore) {
            Assert.assertNull((Object)((SimpleTransientStore)ts).getL1Cache().get("XXX"));
            Assert.assertNotNull((Object)((SimpleTransientStore)ts).getL2Cache().get("XXX"));
        }
        ts.doGC();
        Assert.assertTrue((boolean)ts.exists("XXX"));
        if (ts instanceof SimpleTransientStore) {
            ((SimpleTransientStore)ts).getL2Cache().invalidate("XXX");
        } else {
            ts.remove("XXX");
        }
        ts.doGC();
        Assert.assertFalse((boolean)ts.exists("XXX"));
    }
}

