/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.transientstore.test.work;

import com.google.inject.Inject;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.transientstore.api.TransientStoreService;
import org.nuxeo.ecm.core.transientstore.work.TransientStoreWork;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.RuntimeFeature;
import org.nuxeo.transientstore.test.InMemoryTransientStoreFeature;
import org.nuxeo.transientstore.test.work.DummyTransientStoreWork;

@RunWith(value=FeaturesRunner.class)
@Features(value={RuntimeFeature.class, InMemoryTransientStoreFeature.class})
@Deploy(value={"org.nuxeo.ecm.core.event"})
public class TestTransientStoreWork {
    @Inject
    protected EventService eventService;
    @Inject
    protected WorkManager workManager;
    @Inject
    protected TransientStoreService transientStoreService;

    @Test
    public void shouldStoreBlobAndParamsInTransientStore() throws IOException {
        DummyTransientStoreWork work = new DummyTransientStoreWork();
        this.workManager.schedule((Work)work);
        this.eventService.waitForAsyncCompletion();
        BlobHolder holder = TransientStoreWork.getBlobHolder((String)work.getEntryKey());
        Assert.assertNotNull((Object)holder);
        Map entryParams = holder.getProperties();
        Assert.assertEquals((long)2L, (long)entryParams.size());
        Serializable value = (Serializable)entryParams.get("firstparam");
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((Object)"firstvalue", (Object)value);
        value = (Serializable)entryParams.get("secondparam");
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((Object)"secondvalue", (Object)value);
        List blobs = holder.getBlobs();
        Assert.assertEquals((long)1L, (long)blobs.size());
        Blob blob = (Blob)blobs.get(0);
        Assert.assertEquals((Object)"a simple blob", (Object)blob.getString());
        Assert.assertEquals((Object)"text/plain", (Object)blob.getMimeType());
    }
}

