/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.convert.plugins.text.extractors;

import java.io.Serializable;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolder;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.core.convert.api.ConversionService;
import org.nuxeo.ecm.core.convert.extension.Converter;
import org.nuxeo.ecm.core.convert.extension.ConverterDescriptor;
import org.nuxeo.runtime.api.Framework;

public class FullTextConverter
implements Converter {
    private static final String TEXT_PLAIN_MT = "text/plain";
    private static final Log log = LogFactory.getLog(FullTextConverter.class);
    protected ConverterDescriptor descriptor;

    public BlobHolder convert(BlobHolder blobHolder, Map<String, Serializable> parameters) throws ConversionException {
        String srcMT = blobHolder.getBlob().getMimeType();
        if (TEXT_PLAIN_MT.equals(srcMT)) {
            return blobHolder;
        }
        ConversionService cs = (ConversionService)Framework.getLocalService(ConversionService.class);
        String converterName = cs.getConverterName(srcMT, TEXT_PLAIN_MT);
        if (converterName != null) {
            if (converterName.equals(this.descriptor.getConverterName())) {
                log.debug((Object)"Existing from converter to avoid a loop");
                return new SimpleBlobHolder(Blobs.createBlob((String)""));
            }
            return cs.convert(converterName, blobHolder, parameters);
        }
        log.debug((Object)("Unable to find full text extractor for source mime type" + srcMT));
        return new SimpleBlobHolder(Blobs.createBlob((String)""));
    }

    public void init(ConverterDescriptor descriptor) {
        this.descriptor = descriptor;
    }
}

