/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.test;

import java.security.Principal;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.Access;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.ecm.core.query.sql.model.Operand;
import org.nuxeo.ecm.core.query.sql.model.Operator;
import org.nuxeo.ecm.core.query.sql.model.Predicate;
import org.nuxeo.ecm.core.query.sql.model.Reference;
import org.nuxeo.ecm.core.query.sql.model.SQLQuery;
import org.nuxeo.ecm.core.query.sql.model.StringLiteral;
import org.nuxeo.ecm.core.query.sql.model.WhereClause;
import org.nuxeo.ecm.core.security.AbstractSecurityPolicy;
import org.nuxeo.ecm.core.security.SecurityPolicy;

public class NoFileSecurityPolicy
extends AbstractSecurityPolicy
implements SecurityPolicy {
    public static final SQLQuery.Transformer NO_FILE_TRANSFORMER = new NoFileTransformer();

    public Access checkPermission(Document doc, ACP mergedAcp, Principal principal, String permission, String[] resolvedPermissions, String[] additionalPrincipals) {
        if (doc.getType().getName().equals("File")) {
            return Access.DENY;
        }
        return Access.UNKNOWN;
    }

    public boolean isRestrictingPermission(String permission) {
        return true;
    }

    public SQLQuery.Transformer getQueryTransformer(String repositoryName) {
        return NO_FILE_TRANSFORMER;
    }

    public boolean isExpressibleInQuery(String repositoryName) {
        return true;
    }

    public static class NoFileTransformer
    implements SQLQuery.Transformer {
        private static final long serialVersionUID = 1L;
        public static final Predicate NO_FILE = new Predicate((Operand)new Reference("ecm:primaryType"), Operator.NOTEQ, (Operand)new StringLiteral("File"));

        public SQLQuery transform(Principal principal, SQLQuery query) {
            if (principal instanceof NuxeoPrincipal && ((NuxeoPrincipal)principal).isAdministrator()) {
                return query;
            }
            WhereClause where = query.where;
            Predicate predicate = where != null && where.predicate != null ? new Predicate((Operand)NO_FILE, Operator.AND, (Operand)where.predicate) : NO_FILE;
            SQLQuery newQuery = new SQLQuery(query.select, query.from, new WhereClause(predicate), query.groupBy, query.having, query.orderBy, query.limit, query.offset);
            return newQuery;
        }
    }
}

