/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.test;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.automation.core.util.DocumentHelper;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.VersioningOption;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.impl.DocumentModelImpl;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.impl.ACPImpl;
import org.nuxeo.ecm.core.test.CoreFeature;
import org.nuxeo.ecm.core.trash.TrashService;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.ecm.platform.tag.TagService;
import org.nuxeo.elasticsearch.api.ElasticSearchAdmin;
import org.nuxeo.elasticsearch.api.ElasticSearchService;
import org.nuxeo.elasticsearch.listener.ElasticSearchInlineListener;
import org.nuxeo.elasticsearch.query.NxQueryBuilder;
import org.nuxeo.elasticsearch.test.RepositoryElasticSearchFeature;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.test.runner.Deploy;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.LocalDeploy;
import org.nuxeo.runtime.transaction.TransactionHelper;

@RunWith(value=FeaturesRunner.class)
@Features(value={RepositoryElasticSearchFeature.class})
@Deploy(value={"org.nuxeo.ecm.platform.tag"})
@LocalDeploy(value={"org.nuxeo.elasticsearch.core:elasticsearch-test-contrib.xml"})
public class TestAutomaticIndexing {
    private static final String IDX_NAME = "nxutest";
    private static final String TYPE_NAME = "doc";
    @Inject
    protected CoreFeature coreFeature;
    @Inject
    protected CoreSession session;
    @Inject
    protected ElasticSearchService ess;
    @Inject
    protected TrashService trashService;
    @Inject
    ElasticSearchAdmin esa;
    @Inject
    protected TagService tagService;
    @Inject
    protected WorkManager workManager;
    private boolean syncMode = false;
    private Priority consoleThresold;
    private int commandProcessed;

    public void assertNumberOfCommandProcessed(int processed) throws Exception {
        Assert.assertEquals((long)processed, (long)(this.esa.getTotalCommandProcessed() - this.commandProcessed));
    }

    public void waitForCompletion() throws Exception {
        this.workManager.awaitCompletion(20L, TimeUnit.SECONDS);
        this.esa.prepareWaitForIndexing().get(20L, TimeUnit.SECONDS);
        this.esa.refresh();
    }

    public void activateSynchronousMode() throws Exception {
        ElasticSearchInlineListener.useSyncIndexing.set(true);
        this.syncMode = true;
    }

    @After
    public void restoreAsyncAndConsoleLog() {
        ElasticSearchInlineListener.useSyncIndexing.set(false);
        this.syncMode = false;
        this.restoreConsoleLog();
    }

    protected void startTransaction() {
        if (this.syncMode) {
            ElasticSearchInlineListener.useSyncIndexing.set(true);
        }
        if (!TransactionHelper.isTransactionActive()) {
            TransactionHelper.startTransaction();
        }
        Assert.assertEquals((long)0L, (long)this.esa.getPendingWorkerCount());
        this.commandProcessed = this.esa.getTotalCommandProcessed();
    }

    protected void hideWarningFromConsoleLog() {
        Logger rootLogger = Logger.getRootLogger();
        ConsoleAppender consoleAppender = (ConsoleAppender)rootLogger.getAppender("CONSOLE");
        this.consoleThresold = consoleAppender.getThreshold();
        consoleAppender.setThreshold((Priority)Level.ERROR);
    }

    protected void restoreConsoleLog() {
        if (this.consoleThresold == null) {
            return;
        }
        Logger rootLogger = Logger.getRootLogger();
        ConsoleAppender consoleAppender = (ConsoleAppender)rootLogger.getAppender("CONSOLE");
        consoleAppender.setThreshold(this.consoleThresold);
        this.consoleThresold = null;
    }

    @Before
    public void setupIndex() throws Exception {
        this.esa.initIndexes(true);
    }

    @Test
    public void shouldIndexDocument() throws Exception {
        DocumentModel doc;
        int i;
        this.startTransaction();
        for (i = 0; i < 10; ++i) {
            doc = this.session.createDocumentModel("/", "testDoc" + i, "File");
            doc.setPropertyValue("dc:title", (Serializable)((Object)("TestMe" + i)));
            doc = this.session.createDocument(doc);
        }
        for (i = 0; i < 5; ++i) {
            doc = this.session.getDocument((DocumentRef)new PathRef("/testDoc" + i));
            doc.setPropertyValue("dc:description", (Serializable)((Object)("Description TestMe" + i)));
            DocumentModel documentModel = this.session.saveDocument(doc);
        }
        TransactionHelper.commitOrRollbackTransaction();
        this.waitForCompletion();
        this.assertNumberOfCommandProcessed(10);
        this.startTransaction();
        SearchResponse searchResponse = (SearchResponse)this.esa.getClient().prepareSearch(new String[]{IDX_NAME}).setTypes(new String[]{TYPE_NAME}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).setFrom(0).setSize(60).execute().actionGet();
        Assert.assertEquals((long)10L, (long)searchResponse.getHits().getTotalHits());
    }

    @Test
    public void shouldNotIndexDocumentBecauseOfRollback() throws Exception {
        this.startTransaction();
        this.activateSynchronousMode();
        for (int i = 0; i < 10; ++i) {
            DocumentModel doc = this.session.createDocumentModel("/", "testDoc" + i, "File");
            doc.setPropertyValue("dc:title", (Serializable)((Object)("TestMe" + i)));
            DocumentModel documentModel = this.session.createDocument(doc);
        }
        this.session.save();
        TransactionHelper.setTransactionRollbackOnly();
        TransactionHelper.commitOrRollbackTransaction();
        this.waitForCompletion();
        this.assertNumberOfCommandProcessed(0);
        this.startTransaction();
        SearchResponse searchResponse = (SearchResponse)this.esa.getClient().prepareSearch(new String[]{IDX_NAME}).setTypes(new String[]{TYPE_NAME}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).setFrom(0).setSize(60).execute().actionGet();
        Assert.assertEquals((long)0L, (long)searchResponse.getHits().getTotalHits());
        Assert.assertFalse((boolean)this.esa.isIndexingInProgress());
    }

    @Test
    public void shouldUnIndexDocument() throws Exception {
        this.startTransaction();
        DocumentModel doc = this.session.createDocumentModel("/", "testDoc", "File");
        doc.setPropertyValue("dc:title", (Serializable)((Object)"TestMe"));
        doc = this.session.createDocument(doc);
        TransactionHelper.commitOrRollbackTransaction();
        this.waitForCompletion();
        this.assertNumberOfCommandProcessed(1);
        this.startTransaction();
        SearchResponse searchResponse = (SearchResponse)this.esa.getClient().prepareSearch(new String[]{IDX_NAME}).setTypes(new String[]{TYPE_NAME}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).setFrom(0).setSize(60).execute().actionGet();
        Assert.assertEquals((long)1L, (long)searchResponse.getHits().getTotalHits());
        this.session.removeDocument(doc.getRef());
        TransactionHelper.commitOrRollbackTransaction();
        this.waitForCompletion();
        this.assertNumberOfCommandProcessed(1);
        this.startTransaction();
        searchResponse = (SearchResponse)this.esa.getClient().prepareSearch(new String[]{IDX_NAME}).setTypes(new String[]{TYPE_NAME}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).setFrom(0).setSize(60).execute().actionGet();
        Assert.assertEquals((long)0L, (long)searchResponse.getHits().getTotalHits());
    }

    @Test
    public void shouldReIndexDocument() throws Exception {
        this.startTransaction();
        for (int i = 0; i < 10; ++i) {
            DocumentModel doc = this.session.createDocumentModel("/", "testDoc" + i, "File");
            doc.setPropertyValue("dc:title", (Serializable)((Object)("TestMe" + i)));
            doc.setPropertyValue("dc:nature", (Serializable)((Object)"A"));
            doc = this.session.createDocument(doc);
        }
        TransactionHelper.commitOrRollbackTransaction();
        this.waitForCompletion();
        this.assertNumberOfCommandProcessed(10);
        this.startTransaction();
        SearchResponse searchResponse = (SearchResponse)this.esa.getClient().prepareSearch(new String[]{IDX_NAME}).setTypes(new String[]{TYPE_NAME}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).setQuery((QueryBuilder)QueryBuilders.matchQuery((String)"dc:nature", (Object)"A")).setFrom(0).setSize(60).execute().actionGet();
        Assert.assertEquals((long)10L, (long)searchResponse.getHits().getTotalHits());
        int i = 0;
        for (SearchHit hit : searchResponse.getHits()) {
            if (++i > 8) break;
            DocumentModel doc = this.session.getDocument((DocumentRef)new IdRef(hit.getId()));
            doc.setPropertyValue("dc:nature", (Serializable)((Object)"B"));
            this.session.saveDocument(doc);
        }
        TransactionHelper.commitOrRollbackTransaction();
        this.waitForCompletion();
        this.assertNumberOfCommandProcessed(8);
        this.startTransaction();
        searchResponse = (SearchResponse)this.esa.getClient().prepareSearch(new String[]{IDX_NAME}).setTypes(new String[]{TYPE_NAME}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).setQuery((QueryBuilder)QueryBuilders.matchQuery((String)"dc:nature", (Object)"A")).setFrom(0).setSize(60).execute().actionGet();
        Assert.assertEquals((long)2L, (long)searchResponse.getHits().getTotalHits());
        searchResponse = (SearchResponse)this.esa.getClient().prepareSearch(new String[]{IDX_NAME}).setTypes(new String[]{TYPE_NAME}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).setQuery((QueryBuilder)QueryBuilders.matchQuery((String)"dc:nature", (Object)"B")).setFrom(0).setSize(60).execute().actionGet();
        Assert.assertEquals((long)8L, (long)searchResponse.getHits().getTotalHits());
    }

    @Test
    public void shouldIndexBinaryFulltext() throws Exception {
        this.startTransaction();
        this.activateSynchronousMode();
        DocumentModel doc = this.session.createDocumentModel("/", "myFile", "File");
        BlobHolder holder = (BlobHolder)doc.getAdapter(BlobHolder.class);
        holder.setBlob((Blob)new StringBlob("You know for search"));
        doc = this.session.createDocument(doc);
        this.session.save();
        TransactionHelper.commitOrRollbackTransaction();
        WorkManager wm = (WorkManager)Framework.getLocalService(WorkManager.class);
        this.waitForCompletion();
        this.startTransaction();
        DocumentModelList ret = this.ess.query(new NxQueryBuilder(this.session).nxql("SELECT * FROM Document"));
        Assert.assertEquals((long)1L, (long)ret.totalSize());
        ret = this.ess.query(new NxQueryBuilder(this.session).nxql("SELECT * FROM Document WHERE ecm:fulltext='search'"));
        Assert.assertEquals((long)1L, (long)ret.totalSize());
    }

    @Test
    public void shouldIndexLargeBinaryFulltext() throws Exception {
        this.startTransaction();
        this.activateSynchronousMode();
        DocumentModel doc = this.session.createDocumentModel("/", "myFile", "File");
        BlobHolder holder = (BlobHolder)doc.getAdapter(BlobHolder.class);
        holder.setBlob((Blob)new StringBlob(new String(new char[33000]).replace('\u0000', 'a') + " search"));
        doc = this.session.createDocument(doc);
        this.session.save();
        TransactionHelper.commitOrRollbackTransaction();
        WorkManager wm = (WorkManager)Framework.getLocalService(WorkManager.class);
        this.waitForCompletion();
        this.startTransaction();
        DocumentModelList ret = this.ess.query(new NxQueryBuilder(this.session).nxql("SELECT * FROM Document WHERE ecm:fulltext='search'"));
        Assert.assertEquals((long)1L, (long)ret.totalSize());
    }

    @Test
    public void shouldIndexLargeToken() throws Exception {
        Assume.assumeTrue((String)"DB backend needs to support fields bigger than 32k", (boolean)this.coreFeature.getStorageConfiguration().isVCSH2());
        this.startTransaction();
        DocumentModel doc = this.session.createDocumentModel("/", "myFile", "File");
        doc.setPropertyValue("dc:source", (Serializable)((Object)("search foo" + new String(new char[33000]).replace('\u0000', 'a'))));
        doc = this.session.createDocument(doc);
        this.session.save();
        TransactionHelper.commitOrRollbackTransaction();
        WorkManager wm = (WorkManager)Framework.getLocalService(WorkManager.class);
        this.waitForCompletion();
        this.startTransaction();
        DocumentModelList ret = this.ess.query(new NxQueryBuilder(this.session).nxql("SELECT * FROM Document WHERE dc:source LIKE 'search*'"));
        Assert.assertEquals((long)1L, (long)ret.totalSize());
    }

    @Test
    public void shouldIndexOnPublishing() throws Exception {
        this.startTransaction();
        DocumentModel folder = this.session.createDocumentModel("/", "folder", "Folder");
        folder = this.session.createDocument(folder);
        DocumentModel doc = this.session.createDocumentModel("/", "file", "File");
        doc = this.session.createDocument(doc);
        DocumentModel proxy = this.session.publishDocument(doc, folder);
        TransactionHelper.commitOrRollbackTransaction();
        this.waitForCompletion();
        this.assertNumberOfCommandProcessed(4);
        this.startTransaction();
        SearchResponse searchResponse = (SearchResponse)this.esa.getClient().prepareSearch(new String[]{IDX_NAME}).setTypes(new String[]{TYPE_NAME}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).setFrom(0).setSize(60).execute().actionGet();
        Assert.assertEquals((long)4L, (long)searchResponse.getHits().getTotalHits());
        this.session.removeDocument(proxy.getRef());
        DocumentModelList docs = this.ess.query(new NxQueryBuilder(this.session).nxql("SELECT * FROM Document"));
        Assert.assertEquals((long)4L, (long)docs.totalSize());
        TransactionHelper.commitOrRollbackTransaction();
        this.waitForCompletion();
        this.assertNumberOfCommandProcessed(1);
        this.startTransaction();
        searchResponse = (SearchResponse)this.esa.getClient().prepareSearch(new String[]{IDX_NAME}).setTypes(new String[]{TYPE_NAME}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).setFrom(0).setSize(60).execute().actionGet();
        Assert.assertEquals((long)3L, (long)searchResponse.getHits().getTotalHits());
    }

    @Test
    public void shouldIndexOnRePublishing() throws Exception {
        this.startTransaction();
        DocumentModel folder = this.session.createDocumentModel("/", "folder", "Folder");
        folder = this.session.createDocument(folder);
        DocumentModel doc = this.session.createDocumentModel("/", "file", "File");
        doc.setPropertyValue("dc:description", (Serializable)((Object)"foo"));
        doc = this.session.createDocument(doc);
        this.session.publishDocument(doc, folder);
        TransactionHelper.commitOrRollbackTransaction();
        this.waitForCompletion();
        this.startTransaction();
        DocumentModelList docs = this.ess.query(new NxQueryBuilder(this.session).nxql("SELECT * FROM Document WHERE ecm:fulltext = 'foo' AND ecm:isVersion = 0"));
        Assert.assertEquals((long)2L, (long)docs.totalSize());
        doc.setPropertyValue("dc:description", (Serializable)((Object)"bar"));
        this.session.saveDocument(doc);
        this.session.publishDocument(doc, folder);
        TransactionHelper.commitOrRollbackTransaction();
        this.waitForCompletion();
        this.startTransaction();
        docs = this.ess.query(new NxQueryBuilder(this.session).nxql("SELECT * FROM Document WHERE ecm:fulltext = 'bar' AND ecm:isVersion = 0"));
        Assert.assertEquals((long)2L, (long)docs.totalSize());
    }

    @Test
    public void shouldUnIndexUsingTrashService() throws Exception {
        this.startTransaction();
        DocumentModel folder = this.session.createDocumentModel("/", "folder", "Folder");
        folder = this.session.createDocument(folder);
        DocumentModel doc = this.session.createDocumentModel("/", "file", "File");
        doc = this.session.createDocument(doc);
        this.trashService.trashDocuments(Arrays.asList(doc));
        TransactionHelper.commitOrRollbackTransaction();
        this.waitForCompletion();
        this.assertNumberOfCommandProcessed(2);
        this.startTransaction();
        DocumentModelList ret = this.ess.query(new NxQueryBuilder(this.session).nxql("SELECT * FROM Document WHERE ecm:currentLifeCycleState != 'deleted'"));
        Assert.assertEquals((long)1L, (long)ret.totalSize());
        this.trashService.undeleteDocuments(Arrays.asList(doc));
        TransactionHelper.commitOrRollbackTransaction();
        this.waitForCompletion();
        this.assertNumberOfCommandProcessed(1);
        this.startTransaction();
        ret = this.ess.query(new NxQueryBuilder(this.session).nxql("SELECT * FROM Document WHERE ecm:currentLifeCycleState != 'deleted'"));
        Assert.assertEquals((long)2L, (long)ret.totalSize());
        SearchResponse searchResponse = (SearchResponse)this.esa.getClient().prepareSearch(new String[]{IDX_NAME}).setTypes(new String[]{TYPE_NAME}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).setFrom(0).setSize(60).execute().actionGet();
        Assert.assertEquals((long)2L, (long)searchResponse.getHits().getTotalHits());
        this.trashService.purgeDocuments(this.session, Collections.singletonList(doc.getRef()));
        TransactionHelper.commitOrRollbackTransaction();
        this.waitForCompletion();
        this.assertNumberOfCommandProcessed(1);
        this.startTransaction();
        searchResponse = (SearchResponse)this.esa.getClient().prepareSearch(new String[]{IDX_NAME}).setTypes(new String[]{TYPE_NAME}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).setFrom(0).setSize(60).execute().actionGet();
        Assert.assertEquals((long)1L, (long)searchResponse.getHits().getTotalHits());
    }

    @Test
    public void shouldIndexOnCopy() throws Exception {
        this.startTransaction();
        DocumentModel folder = this.session.createDocumentModel("/", "folder", "Folder");
        folder = this.session.createDocument(folder);
        DocumentModel doc = this.session.createDocumentModel("/", "file", "File");
        doc = this.session.createDocument(doc);
        TransactionHelper.commitOrRollbackTransaction();
        this.waitForCompletion();
        this.assertNumberOfCommandProcessed(2);
        this.startTransaction();
        DocumentRef src = doc.getRef();
        PathRef dst = new PathRef("/");
        this.session.copy(src, (DocumentRef)dst, "file2", new CoreSession.CopyOption[0]);
        ElasticSearchInlineListener.useSyncIndexing.set(true);
        TransactionHelper.commitOrRollbackTransaction();
        this.waitForCompletion();
        this.startTransaction();
        SearchResponse searchResponse = (SearchResponse)this.esa.getClient().prepareSearch(new String[]{IDX_NAME}).setTypes(new String[]{TYPE_NAME}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).setFrom(0).setSize(60).execute().actionGet();
        Assert.assertEquals((long)3L, (long)searchResponse.getHits().getTotalHits());
    }

    @Test
    public void shouldIndexTag() throws Exception {
        Assume.assumeTrue((String)"DBS does not support tags", (!this.coreFeature.getStorageConfiguration().isDBS() ? 1 : 0) != 0);
        this.startTransaction();
        DocumentModel doc = this.session.createDocumentModel("/", "file", "File");
        doc = this.session.createDocument(doc);
        this.tagService.tag(this.session, doc.getId(), "mytag", "Administrator");
        TransactionHelper.commitOrRollbackTransaction();
        this.waitForCompletion();
        ElasticSearchInlineListener.useSyncIndexing.set(true);
        this.assertNumberOfCommandProcessed(3);
        this.startTransaction();
        SearchResponse searchResponse = (SearchResponse)this.esa.getClient().prepareSearch(new String[]{IDX_NAME}).setTypes(new String[]{TYPE_NAME}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).setFrom(0).setSize(60).setQuery((QueryBuilder)QueryBuilders.termQuery((String)"ecm:tag", (String)"mytag")).execute().actionGet();
        Assert.assertEquals((long)1L, (long)searchResponse.getHits().getTotalHits());
        this.tagService.tag(this.session, doc.getId(), "mytagbis", "Administrator");
        this.session.save();
        TransactionHelper.commitOrRollbackTransaction();
        this.waitForCompletion();
        this.assertNumberOfCommandProcessed(3);
        this.startTransaction();
        searchResponse = (SearchResponse)this.esa.getClient().prepareSearch(new String[]{IDX_NAME}).setTypes(new String[]{TYPE_NAME}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).setFrom(0).setSize(60).setQuery((QueryBuilder)QueryBuilders.termQuery((String)"ecm:tag", (String)"mytagbis")).execute().actionGet();
        Assert.assertEquals((long)1L, (long)searchResponse.getHits().getTotalHits());
        this.tagService.untag(this.session, doc.getId(), "mytag", "Administrator");
        this.session.save();
        TransactionHelper.commitOrRollbackTransaction();
        this.waitForCompletion();
        this.assertNumberOfCommandProcessed(2);
        this.startTransaction();
        searchResponse = (SearchResponse)this.esa.getClient().prepareSearch(new String[]{IDX_NAME}).setTypes(new String[]{TYPE_NAME}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).setFrom(0).setSize(60).setQuery((QueryBuilder)QueryBuilders.termQuery((String)"ecm:tag", (String)"mytagbis")).execute().actionGet();
        Assert.assertEquals((long)1L, (long)searchResponse.getHits().getTotalHits());
        searchResponse = (SearchResponse)this.esa.getClient().prepareSearch(new String[]{IDX_NAME}).setTypes(new String[]{TYPE_NAME}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).setFrom(0).setSize(60).setQuery((QueryBuilder)QueryBuilders.termQuery((String)"ecm:tag", (String)"mytag")).execute().actionGet();
        Assert.assertEquals((long)0L, (long)searchResponse.getHits().getTotalHits());
    }

    @Test
    public void shouldHandleCreateDelete() throws Exception {
        this.startTransaction();
        DocumentModel folder = this.session.createDocumentModel("/", "folder", "Folder");
        folder = this.session.createDocument(folder);
        DocumentModel doc = this.session.createDocumentModel("/folder", "note", "Note");
        doc = this.session.createDocument(doc);
        TransactionHelper.commitOrRollbackTransaction();
        TransactionHelper.startTransaction();
        this.session.removeDocument(folder.getRef());
        TransactionHelper.commitOrRollbackTransaction();
        this.waitForCompletion();
        this.startTransaction();
    }

    @Test
    public void shouldHandleUpdateOnTransientDoc() throws Exception {
        this.startTransaction();
        DocumentModel tmpDoc = this.session.createDocumentModel("/", "file", "File");
        tmpDoc.setPropertyValue("dc:title", (Serializable)((Object)"TestMe"));
        DocumentModel doc = this.session.createDocument(tmpDoc);
        this.session.saveDocument(doc);
        TransactionHelper.commitOrRollbackTransaction();
        this.waitForCompletion();
        this.assertNumberOfCommandProcessed(1);
        this.startTransaction();
        Assert.assertNull((Object)tmpDoc.getId());
        tmpDoc.setPropertyValue("dc:title", (Serializable)((Object)"NewTitle"));
        this.hideWarningFromConsoleLog();
        this.session.saveDocument(tmpDoc);
        this.restoreConsoleLog();
        TransactionHelper.commitOrRollbackTransaction();
        this.waitForCompletion();
        this.assertNumberOfCommandProcessed(1);
        this.startTransaction();
        DocumentModelList docs = this.ess.query(new NxQueryBuilder(this.session).nxql("SELECT * FROM Document Where dc:title='NewTitle'"));
        Assert.assertEquals((long)1L, (long)docs.totalSize());
    }

    @Test
    public void shouldHandleUpdateOnTransientDocBis() throws Exception {
        this.startTransaction();
        DocumentModel tmpDoc = this.session.createDocumentModel("/", "file", "File");
        tmpDoc.setPropertyValue("dc:title", (Serializable)((Object)"TestMe"));
        DocumentModel doc = this.session.createDocument(tmpDoc);
        this.hideWarningFromConsoleLog();
        this.session.saveDocument(doc);
        tmpDoc.setPropertyValue("dc:title", (Serializable)((Object)"NewTitle"));
        this.session.saveDocument(tmpDoc);
        this.restoreConsoleLog();
        TransactionHelper.commitOrRollbackTransaction();
        this.waitForCompletion();
        this.assertNumberOfCommandProcessed(2);
        this.startTransaction();
        DocumentModelList docs = this.ess.query(new NxQueryBuilder(this.session).nxql("SELECT * FROM Document Where dc:title='NewTitle'"));
        Assert.assertEquals((long)1L, (long)docs.totalSize());
    }

    @Test
    public void shouldHandleUpdateBeforeInsertOnTransientDoc() throws Exception {
        this.startTransaction();
        DocumentModel folder = this.session.createDocumentModel("/", "section", "Folder");
        this.session.createDocument(folder);
        this.hideWarningFromConsoleLog();
        folder = this.session.saveDocument(folder);
        this.restoreConsoleLog();
        TransactionHelper.commitOrRollbackTransaction();
        this.waitForCompletion();
        this.assertNumberOfCommandProcessed(2);
        this.startTransaction();
    }

    @Test
    public void shouldIndexOrderedFolder() throws Exception {
        this.startTransaction();
        DocumentModel ofolder = this.session.createDocumentModel("/", "ofolder", "OrderedFolder");
        ofolder = this.session.createDocument(ofolder);
        DocumentModelImpl file1 = new DocumentModelImpl("/ofolder", "testfile1", "File");
        file1 = this.session.createDocument((DocumentModel)file1);
        DocumentModelImpl file2 = new DocumentModelImpl("/ofolder", "testfile2", "File");
        file2 = this.session.createDocument((DocumentModel)file2);
        DocumentModelImpl file3 = new DocumentModelImpl("/ofolder", "testfile3", "File");
        file3 = this.session.createDocument((DocumentModel)file3);
        DocumentModelImpl folder4 = new DocumentModelImpl("/ofolder", "folder4", "Folder");
        folder4 = this.session.createDocument((DocumentModel)folder4);
        DocumentModelImpl file = new DocumentModelImpl("/ofolder/folder4", "testfile", "File");
        file = this.session.createDocument((DocumentModel)file);
        TransactionHelper.commitOrRollbackTransaction();
        this.waitForCompletion();
        this.assertNumberOfCommandProcessed(6);
        this.startTransaction();
        DocumentModelList ret = this.ess.query(new NxQueryBuilder(this.session).nxql(String.format("SELECT * FROM Document WHERE ecm:parentId='%s' ORDER BY ecm:pos", ofolder.getId())));
        Assert.assertEquals((long)4L, (long)ret.totalSize());
        Assert.assertEquals((Object)file1.getId(), (Object)((DocumentModel)ret.get(0)).getId());
        Assert.assertEquals((Object)file2.getId(), (Object)((DocumentModel)ret.get(1)).getId());
        Assert.assertEquals((Object)file3.getId(), (Object)((DocumentModel)ret.get(2)).getId());
        this.session.orderBefore(ofolder.getRef(), "testfile3", "testfile2");
        TransactionHelper.commitOrRollbackTransaction();
        this.waitForCompletion();
        this.assertNumberOfCommandProcessed(4);
        this.startTransaction();
        ret = this.ess.query(new NxQueryBuilder(this.session).nxql(String.format("SELECT * FROM Document WHERE ecm:parentId='%s' ORDER BY ecm:pos", ofolder.getId())));
        Assert.assertEquals((long)4L, (long)ret.totalSize());
        Assert.assertEquals((Object)file1.getId(), (Object)((DocumentModel)ret.get(0)).getId());
        Assert.assertEquals((Object)file3.getId(), (Object)((DocumentModel)ret.get(1)).getId());
        Assert.assertEquals((Object)file2.getId(), (Object)((DocumentModel)ret.get(2)).getId());
    }

    @Test
    public void shouldNotIndexRecursivelyVersionFolder() throws Exception {
        this.startTransaction();
        DocumentModel folder = this.session.createDocumentModel("/", "folder", "Folder");
        folder = this.session.createDocument(folder);
        DocumentModelImpl file1 = new DocumentModelImpl("/folder", "testfile1", "File");
        file1 = this.session.createDocument((DocumentModel)file1);
        DocumentModelImpl file2 = new DocumentModelImpl("/folder", "testfile2", "File");
        file2 = this.session.createDocument((DocumentModel)file2);
        folder.setPropertyValue("dc:title", (Serializable)((Object)"v1"));
        folder = this.session.saveDocument(folder);
        DocumentRef v1 = folder.checkIn(VersioningOption.MAJOR, "init");
        folder.setPropertyValue("dc:title", (Serializable)((Object)"v2"));
        folder = this.session.saveDocument(folder);
        DocumentRef v2 = folder.checkIn(VersioningOption.MAJOR, "update");
        TransactionHelper.commitOrRollbackTransaction();
        this.waitForCompletion();
        this.assertNumberOfCommandProcessed(5);
        this.startTransaction();
        DocumentModelList ret = this.ess.query(new NxQueryBuilder(this.session).nxql("SELECT * FROM Document"));
        Assert.assertEquals((long)5L, (long)ret.totalSize());
        this.session.removeDocument(v1);
        TransactionHelper.commitOrRollbackTransaction();
        this.waitForCompletion();
        this.assertNumberOfCommandProcessed(1);
        this.startTransaction();
        ret = this.ess.query(new NxQueryBuilder(this.session).nxql("SELECT * FROM Document"));
        Assert.assertEquals((long)4L, (long)ret.totalSize());
    }

    @Test
    public void shouldIndexComplexCase() throws Exception {
        this.startTransaction();
        DocumentModel folder = this.session.createDocumentModel("/", "folder", "Folder");
        folder = this.session.createDocument(folder);
        ACPImpl acp = new ACPImpl();
        ACL acl = ACPImpl.newACL((String)"local");
        acl.add(new ACE("bob", "Read", true));
        acp.addACL(acl);
        folder.setACP((ACP)acp, true);
        DocumentModel doc = this.session.createDocumentModel("/folder", "file", "File");
        doc.setPropertyValue("dc:title", (Serializable)((Object)"File"));
        File fieldAsJsonFile = FileUtils.getResourceFileFromContext((String)"blob.json");
        try {
            Blob fb = Blobs.createBlob((File)fieldAsJsonFile, (String)"image/jpeg");
            DocumentHelper.addBlob((Property)doc.getProperty("file:content"), (Blob)fb);
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
        doc = this.session.createDocument(doc);
        TransactionHelper.commitOrRollbackTransaction();
        this.waitForCompletion();
        this.assertNumberOfCommandProcessed(3);
        this.startTransaction();
    }
}

