/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.test;

import java.io.Serializable;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.elasticsearch.api.ElasticSearchAdmin;
import org.nuxeo.elasticsearch.api.ElasticSearchService;
import org.nuxeo.elasticsearch.query.NxQueryBuilder;
import org.nuxeo.elasticsearch.test.RepositoryElasticSearchFeature;
import org.nuxeo.elasticsearch.test.TestMapping;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.LocalDeploy;
import org.nuxeo.runtime.transaction.TransactionHelper;

@RunWith(value=FeaturesRunner.class)
@Features(value={RepositoryElasticSearchFeature.class})
@LocalDeploy(value={"org.nuxeo.elasticsearch.core:elasticsearch-test-dynamic-mapping-contrib.xml"})
public class TestDynamicMapping
extends TestMapping {
    @Inject
    protected CoreSession session;
    @Inject
    protected ElasticSearchService ess;
    @Inject
    ElasticSearchAdmin esa;

    @Test
    public void testShouldIndexDocUsingCustomWriter() throws Exception {
        this.startTransaction();
        DocumentModel doc = this.session.createDocumentModel("/", "note", "Note");
        doc = this.session.createDocument(doc);
        doc.setPropertyValue("note:note", (Serializable)((Object)String.format("{\"type1\":[{\"type1:id_int\":10},{\"type1:name_string\":\"test\"},{\"type1:creation_date\":\"%s\"}]}", "2015-01-01T12:30:00")));
        doc = this.session.saveDocument(doc);
        TransactionHelper.commitOrRollbackTransaction();
        this.waitForIndexing();
        this.assertNumberOfCommandProcessed(1);
        this.startTransaction();
        DocumentModelList ret = this.ess.query(new NxQueryBuilder(this.session).nxql("SELECT * FROM Document WHERE type1:id_int = 11"));
        Assert.assertEquals((long)0L, (long)ret.totalSize());
        ret = this.ess.query(new NxQueryBuilder(this.session).nxql("SELECT * FROM Document WHERE type1:id_int = 10"));
        Assert.assertEquals((long)1L, (long)ret.totalSize());
        ret = this.ess.query(new NxQueryBuilder(this.session).nxql("SELECT * FROM Document WHERE type1:name_string LIKE 'test'"));
        Assert.assertEquals((long)1L, (long)ret.totalSize());
        ret = this.ess.query(new NxQueryBuilder(this.session).nxql("SELECT * FROM Document WHERE type1:creation_date BETWEEN DATE '2015-01-01' AND DATE '2015-01-02'"));
        Assert.assertEquals((long)1L, (long)ret.totalSize());
    }
}

